/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.model;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.topo.model.GraphEntity;
import org.eclipse.aperi.gui.topo.model.GraphGroupKey;
import org.eclipse.aperi.gui.topo.model.GraphGroupingUtilities;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.model.GraphModelConstant;
import org.eclipse.aperi.gui.topo.model.GraphModelUtilities;
import org.eclipse.aperi.gui.topo.model.GraphScopedType;
import org.eclipse.aperi.gui.topo.model.bean.GraphOther;
import org.eclipse.aperi.gui.topo.model.bean.GraphOther2Volume;
import org.eclipse.aperi.gui.topo.model.bean.GraphOtherGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphOtherGroup2Other;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubviewOtherL1Connectivity;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubviewOtherL1Device;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch2Other;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitchGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitchGroup2Switch;
import org.eclipse.aperi.gui.topo.model.bean.GraphVolume;
import org.eclipse.aperi.gui.topo.model.bean.GraphVolumeGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphVolumeGroup2Volume;

public class GraphModelOtherL1
extends GraphModel {
    public static final GraphScopedType SWGROUP = new GraphScopedType(GraphSwitchGroup.TYPE, GraphModelConstant.SCOPE_NULL);
    public static final GraphScopedType VOLUMEGROUP = new GraphScopedType(GraphVolumeGroup.TYPE, GraphModelConstant.SCOPE_NULL);

    public GraphModelOtherL1(ID modelID) {
        super(modelID);
    }

    protected void initGroupByCapabilities() {
        int bitmap = GraphGroupingUtilities.GROUPBY_HEALTH + GraphGroupingUtilities.GROUPBY_UDP1 + GraphGroupingUtilities.GROUPBY_UDP2 + GraphGroupingUtilities.GROUPBY_UDP3 + GraphGroupingUtilities.GROUPBY_SWBYFABRIC;
        Integer groupByBitmap = new Integer(bitmap);
        this.groupByCapabilitiesH.put(SWGROUP, groupByBitmap);
        bitmap = GraphGroupingUtilities.GROUPBY_HEALTH + GraphGroupingUtilities.GROUPBY_VOLUMEBYSUBSYSTEM;
        groupByBitmap = new Integer(bitmap);
        this.groupByCapabilitiesH.put(VOLUMEGROUP, groupByBitmap);
    }

    public void applyGrouping(Hashtable groupBySet) {
        this.groupFocus();
        this.groupSubviewConnectivitySwitch(groupBySet);
        this.groupSubviewConnectivity();
        this.groupSubviewDeviceVolume(groupBySet);
        this.groupSubviewDevice();
        GraphGroupingUtilities.groupOrphanZone(this);
    }

    private void groupFocus() {
        ID multiEntityID = (ID)this.modelID;
        GraphEntity srcGroupEntity = multiEntityID.getSrcGroupEntity();
        Vector childFocusEntityIDV = multiEntityID.getChildFocusEntityIDs();
        Vector<GraphEntity> childFocusEntityV = new Vector<GraphEntity>();
        for (int i = 0; i < childFocusEntityIDV.size(); ++i) {
            GraphEntity.ID entityID = (GraphEntity.ID)childFocusEntityIDV.elementAt(i);
            GraphEntity entity = this.get(entityID);
            childFocusEntityV.add(entity);
        }
        String otherGroupIDStr = "Focus";
        GraphOtherGroup otherGroup = new GraphOtherGroup(otherGroupIDStr);
        GraphOtherGroup.ID otherGroupID = (GraphOtherGroup.ID)otherGroup.getEntityID();
        otherGroup.setDisplayName(srcGroupEntity.getDisplayName());
        otherGroup.setHealthStatus(GraphModelUtilities.aggregateHealthStatus(childFocusEntityV));
        otherGroup.setSortingValue(srcGroupEntity.getSortingValue());
        otherGroup.setGroupKey(srcGroupEntity.getGroupKey());
        this.put(otherGroup);
        multiEntityID.setFocusEntityID(otherGroupID);
        for (int i = 0; i < childFocusEntityIDV.size(); ++i) {
            GraphOther.ID otherID = (GraphOther.ID)childFocusEntityIDV.elementAt(i);
            GraphOtherGroup2Other assoc = new GraphOtherGroup2Other(otherGroupID.getID() + "+" + otherID.getID());
            assoc.setOtherGroupID(otherGroupID);
            assoc.setOtherID(otherID);
            this.put(assoc);
        }
    }

    private void groupSubviewConnectivitySwitch(Hashtable groupBySet) {
        this.removeAll(GraphSwitchGroup.TYPE);
        this.removeAll(GraphSwitchGroup2Switch.TYPE);
        Vector entityV = new Vector();
        Enumeration swEnu = this.enumerate(GraphSwitch.TYPE);
        while (swEnu.hasMoreElements()) {
            GraphSwitch sw = (GraphSwitch)swEnu.nextElement();
            entityV.add(sw);
        }
        Integer groupByBitmap = (Integer)groupBySet.get(SWGROUP);
        Hashtable groupH = GraphGroupingUtilities.applyGrouping(entityV, groupByBitmap, this);
        Enumeration swGroupKeyEnu = groupH.keys();
        while (swGroupKeyEnu.hasMoreElements()) {
            GraphGroupKey key = (GraphGroupKey)swGroupKeyEnu.nextElement();
            entityV = (Vector)groupH.get(key);
            String idStr = key.getID();
            GraphSwitchGroup swGroup = new GraphSwitchGroup(idStr);
            GraphSwitchGroup.ID swGroupID = (GraphSwitchGroup.ID)swGroup.getEntityID();
            swGroup.setDisplayName(key.getLabel());
            swGroup.setHealthStatus(GraphModelUtilities.aggregateHealthStatus(entityV));
            swGroup.setSortingValue(key);
            swGroup.setGroupKey(key);
            this.put(swGroup);
            for (int i = 0; i < entityV.size(); ++i) {
                GraphSwitch sw = (GraphSwitch)entityV.elementAt(i);
                GraphSwitch.ID swID = (GraphSwitch.ID)sw.getEntityID();
                GraphSwitchGroup2Switch assoc = new GraphSwitchGroup2Switch(swGroupID.getID() + "+" + swID.getID());
                assoc.setSwitchGroupID(swGroupID);
                assoc.setSwitchID(swID);
                this.put(assoc);
            }
        }
    }

    private void groupSubviewConnectivity() {
        GraphSubviewOtherL1Connectivity connectivity = new GraphSubviewOtherL1Connectivity("Connectivity");
        GraphSubviewOtherL1Connectivity.ID connectivityID = (GraphSubviewOtherL1Connectivity.ID)connectivity.getEntityID();
        connectivity.setDisplayName(GuiUtil.getString("TOPO_LABEL_TASK_CONNECTIVITY"));
        this.put(connectivity);
        Enumeration swGroupEnu = this.enumerate(GraphSwitchGroup.TYPE);
        while (swGroupEnu.hasMoreElements()) {
            GraphSwitchGroup swGroup = (GraphSwitchGroup)swGroupEnu.nextElement();
            connectivity.setHealthStatus(GraphModelUtilities.aggregateStatus(connectivity.getHealthStatus(), swGroup.getHealthStatus()));
        }
    }

    private void groupSubviewDeviceVolume(Hashtable groupBySet) {
        this.removeAll(GraphVolumeGroup.TYPE);
        this.removeAll(GraphVolumeGroup2Volume.TYPE);
        Vector entityV = new Vector();
        Enumeration volumeEnu = this.enumerate(GraphVolume.TYPE);
        while (volumeEnu.hasMoreElements()) {
            GraphVolume volume = (GraphVolume)volumeEnu.nextElement();
            entityV.add(volume);
        }
        Integer groupByBitmap = (Integer)groupBySet.get(VOLUMEGROUP);
        Hashtable groupH = GraphGroupingUtilities.applyGrouping(entityV, groupByBitmap, this);
        Enumeration volumeGroupKeyEnu = groupH.keys();
        while (volumeGroupKeyEnu.hasMoreElements()) {
            GraphGroupKey key = (GraphGroupKey)volumeGroupKeyEnu.nextElement();
            entityV = (Vector)groupH.get(key);
            String idStr = key.getID();
            GraphVolumeGroup volumeGroup = new GraphVolumeGroup(idStr);
            GraphVolumeGroup.ID volumeGroupID = (GraphVolumeGroup.ID)volumeGroup.getEntityID();
            volumeGroup.setDisplayName(key.getLabel());
            volumeGroup.setHealthStatus(GraphModelUtilities.aggregateHealthStatus(entityV));
            volumeGroup.setSortingValue(key);
            volumeGroup.setGroupKey(key);
            this.put(volumeGroup);
            for (int i = 0; i < entityV.size(); ++i) {
                GraphVolume volume = (GraphVolume)entityV.elementAt(i);
                GraphVolume.ID volumeID = (GraphVolume.ID)volume.getEntityID();
                GraphVolumeGroup2Volume assoc = new GraphVolumeGroup2Volume(volumeGroupID.getID() + "+" + volumeID.getID());
                assoc.setVolumeGroupID(volumeGroupID);
                assoc.setVolumeID(volumeID);
                this.put(assoc);
            }
        }
    }

    private void groupSubviewDevice() {
        GraphSubviewOtherL1Device device = new GraphSubviewOtherL1Device("Device");
        GraphSubviewOtherL1Device.ID deviceID = (GraphSubviewOtherL1Device.ID)device.getEntityID();
        device.setDisplayName(GuiUtil.getString("TOPO_LABEL_TASK_DEVICE"));
        this.put(device);
        Enumeration volumeGroupEnu = this.enumerate(GraphVolumeGroup.TYPE);
        while (volumeGroupEnu.hasMoreElements()) {
            GraphVolumeGroup volumeGroup = (GraphVolumeGroup)volumeGroupEnu.nextElement();
            device.setHealthStatus(GraphModelUtilities.aggregateStatus(device.getHealthStatus(), volumeGroup.getHealthStatus()));
        }
    }

    public void applyFiltering(int filteringLevel) {
        int unfilteredCount;
        GraphOther other;
        GraphOther.ID otherID;
        GraphSwitch2Other sw2other;
        Enumeration sw2otherEnu;
        Boolean filterable;
        int unfilteredCount2;
        int totalCount;
        Enumeration otherGroupEnu = this.enumerate(GraphOtherGroup.TYPE);
        while (otherGroupEnu.hasMoreElements()) {
            GraphOtherGroup otherGroup = (GraphOtherGroup)otherGroupEnu.nextElement();
            GraphOtherGroup.ID otherGroupID = (GraphOtherGroup.ID)otherGroup.getEntityID();
            totalCount = 0;
            unfilteredCount2 = 0;
            Enumeration otherEnu = this.associator(GraphOtherGroup2Other.TYPE, otherGroupID);
            while (otherEnu.hasMoreElements()) {
                GraphOther other2 = (GraphOther)otherEnu.nextElement();
                GraphOther.ID otherID2 = (GraphOther.ID)other2.getEntityID();
                ++totalCount;
                if (filteringLevel == 0) {
                    filterable = Boolean.FALSE;
                } else if (GraphModelUtilities.isAbnormal(other2)) {
                    filterable = Boolean.FALSE;
                } else {
                    filterable = Boolean.TRUE;
                    if (filteringLevel == 1) {
                        sw2otherEnu = this.reference(GraphSwitch2Other.TYPE, otherID2);
                        while (sw2otherEnu.hasMoreElements()) {
                            sw2other = (GraphSwitch2Other)sw2otherEnu.nextElement();
                            if (GraphModelUtilities.isAbnormal(sw2other)) {
                                filterable = Boolean.FALSE;
                                break;
                            }
                            GraphSwitch.ID swID = sw2other.getSwitchID();
                            GraphSwitch sw = (GraphSwitch)this.get(swID);
                            if (!GraphModelUtilities.isAbnormal(sw)) continue;
                            filterable = Boolean.FALSE;
                            break;
                        }
                    }
                }
                other2.setIsFilterable(filterable);
                if (filterable.booleanValue()) continue;
                ++unfilteredCount2;
            }
            otherGroup.setNumOfOthers(new Integer(totalCount));
            otherGroup.setNumOfAbnormalOthers(new Integer(unfilteredCount2));
            otherGroup.setIsFilterable(unfilteredCount2 == 0 ? Boolean.TRUE : Boolean.FALSE);
        }
        Enumeration swGroupEnu = this.enumerate(GraphSwitchGroup.TYPE);
        while (swGroupEnu.hasMoreElements()) {
            GraphSwitchGroup swGroup = (GraphSwitchGroup)swGroupEnu.nextElement();
            GraphSwitchGroup.ID swGroupID = (GraphSwitchGroup.ID)swGroup.getEntityID();
            totalCount = 0;
            unfilteredCount2 = 0;
            Enumeration swEnu = this.associator(GraphSwitchGroup2Switch.TYPE, swGroupID);
            while (swEnu.hasMoreElements()) {
                GraphSwitch sw = (GraphSwitch)swEnu.nextElement();
                GraphSwitch.ID swID = (GraphSwitch.ID)sw.getEntityID();
                ++totalCount;
                if (filteringLevel == 0) {
                    filterable = Boolean.FALSE;
                } else if (GraphModelUtilities.isAbnormal(sw)) {
                    filterable = Boolean.FALSE;
                } else {
                    filterable = Boolean.TRUE;
                    if (filteringLevel == 1) {
                        sw2otherEnu = this.reference(GraphSwitch2Other.TYPE, swID);
                        while (sw2otherEnu.hasMoreElements()) {
                            sw2other = (GraphSwitch2Other)sw2otherEnu.nextElement();
                            if (GraphModelUtilities.isAbnormal(sw2other)) {
                                filterable = Boolean.FALSE;
                                break;
                            }
                            otherID = sw2other.getOtherID();
                            other = (GraphOther)this.get(otherID);
                            if (!GraphModelUtilities.isAbnormal(other)) continue;
                            filterable = Boolean.FALSE;
                            break;
                        }
                    }
                }
                sw.setIsFilterable(filterable);
                if (filterable.booleanValue()) continue;
                ++unfilteredCount2;
            }
            swGroup.setNumOfSwitches(new Integer(totalCount));
            swGroup.setNumOfAbnormalSwitches(new Integer(unfilteredCount2));
            swGroup.setIsFilterable(unfilteredCount2 == 0 ? Boolean.TRUE : Boolean.FALSE);
        }
        Enumeration volumeGroupEnu = this.enumerate(GraphVolumeGroup.TYPE);
        while (volumeGroupEnu.hasMoreElements()) {
            GraphVolumeGroup volumeGroup = (GraphVolumeGroup)volumeGroupEnu.nextElement();
            GraphVolumeGroup.ID volumeGroupID = (GraphVolumeGroup.ID)volumeGroup.getEntityID();
            totalCount = 0;
            unfilteredCount2 = 0;
            Enumeration volumeEnu = this.associator(GraphVolumeGroup2Volume.TYPE, volumeGroupID);
            while (volumeEnu.hasMoreElements()) {
                GraphVolume volume = (GraphVolume)volumeEnu.nextElement();
                GraphVolume.ID volumeID = (GraphVolume.ID)volume.getEntityID();
                ++totalCount;
                if (filteringLevel == 0) {
                    filterable = Boolean.FALSE;
                } else if (GraphModelUtilities.isAbnormal(volume)) {
                    filterable = Boolean.FALSE;
                } else {
                    filterable = Boolean.TRUE;
                    if (filteringLevel == 1) {
                        Enumeration other2volumeEnu = this.reference(GraphOther2Volume.TYPE, volumeID);
                        while (other2volumeEnu.hasMoreElements()) {
                            GraphOther2Volume other2volume = (GraphOther2Volume)other2volumeEnu.nextElement();
                            if (GraphModelUtilities.isAbnormal(other2volume)) {
                                filterable = Boolean.FALSE;
                                break;
                            }
                            otherID = other2volume.getOtherID();
                            other = (GraphOther)this.get(otherID);
                            if (!GraphModelUtilities.isAbnormal(other)) continue;
                            filterable = Boolean.FALSE;
                            break;
                        }
                    }
                }
                volume.setIsFilterable(filterable);
                if (filterable.booleanValue()) continue;
                ++unfilteredCount2;
            }
            volumeGroup.setNumOfVolumes(new Integer(totalCount));
            volumeGroup.setNumOfAbnormalVolumes(new Integer(unfilteredCount2));
            volumeGroup.setIsFilterable(unfilteredCount2 == 0 ? Boolean.TRUE : Boolean.FALSE);
        }
        Enumeration connectivityEnu = this.enumerate(GraphSubviewOtherL1Connectivity.TYPE);
        while (connectivityEnu.hasMoreElements()) {
            GraphSubviewOtherL1Connectivity connectivity = (GraphSubviewOtherL1Connectivity)connectivityEnu.nextElement();
            int totalCount2 = 0;
            unfilteredCount = 0;
            Enumeration swGroupEnu2 = this.enumerate(GraphSwitchGroup.TYPE);
            while (swGroupEnu2.hasMoreElements()) {
                GraphSwitchGroup swGroup = (GraphSwitchGroup)swGroupEnu2.nextElement();
                totalCount2 += swGroup.getNumOfSwitches().intValue();
                unfilteredCount += swGroup.getNumOfAbnormalSwitches().intValue();
            }
            connectivity.setNumOfSwitches(new Integer(totalCount2));
            connectivity.setNumOfAbnormalSwitches(new Integer(unfilteredCount));
            connectivity.setIsFilterable(Boolean.FALSE);
        }
        Enumeration deviceEnu = this.enumerate(GraphSubviewOtherL1Device.TYPE);
        while (deviceEnu.hasMoreElements()) {
            GraphSubviewOtherL1Device device = (GraphSubviewOtherL1Device)deviceEnu.nextElement();
            int totalCount3 = 0;
            unfilteredCount = 0;
            Enumeration volumeGroupEnu2 = this.enumerate(GraphVolumeGroup.TYPE);
            while (volumeGroupEnu2.hasMoreElements()) {
                GraphVolumeGroup volumeGroup = (GraphVolumeGroup)volumeGroupEnu2.nextElement();
                totalCount3 += volumeGroup.getNumOfVolumes().intValue();
                unfilteredCount += volumeGroup.getNumOfAbnormalVolumes().intValue();
            }
            device.setNumOfVolumes(new Integer(totalCount3));
            device.setNumOfAbnormalVolumes(new Integer(unfilteredCount));
            device.setIsFilterable(Boolean.FALSE);
        }
    }

    public static class ID
    extends GraphModel.MultiEntityID {
        public ID(GraphOtherGroup srcGroupEntity, Vector childFocusEntityIDV) {
            super("OtherL1", srcGroupEntity, childFocusEntityIDV);
        }
    }
}

