/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.model;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.gui.topo.model.GraphGroupKey;
import org.eclipse.aperi.gui.topo.model.GraphGroupingUtilities;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.model.GraphModelConstant;
import org.eclipse.aperi.gui.topo.model.GraphModelUtilities;
import org.eclipse.aperi.gui.topo.model.GraphScopedType;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystemGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystemGroup2Subsystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeLibrary;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeLibraryGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeLibraryGroup2TapeLibrary;

public class GraphModelStorageL0
extends GraphModel {
    public static final GraphScopedType SUBSYSTEMGROUP = new GraphScopedType(GraphSubsystemGroup.TYPE, GraphModelConstant.SCOPE_NULL);
    public static final GraphScopedType TAPELIBRARYGROUP = new GraphScopedType(GraphTapeLibraryGroup.TYPE, GraphModelConstant.SCOPE_NULL);

    public GraphModelStorageL0(ID modelID) {
        super(modelID);
    }

    protected void initGroupByCapabilities() {
        int bitmap = GraphGroupingUtilities.GROUPBY_HEALTH + GraphGroupingUtilities.GROUPBY_UDP1 + GraphGroupingUtilities.GROUPBY_UDP2 + GraphGroupingUtilities.GROUPBY_UDP3 + GraphGroupingUtilities.GROUPBY_SUBSYSTEMBYMODEL;
        Integer groupByBitmap = new Integer(bitmap);
        this.groupByCapabilitiesH.put(SUBSYSTEMGROUP, groupByBitmap);
        bitmap = GraphGroupingUtilities.GROUPBY_HEALTH + GraphGroupingUtilities.GROUPBY_UDP1 + GraphGroupingUtilities.GROUPBY_UDP2 + GraphGroupingUtilities.GROUPBY_UDP3;
        groupByBitmap = new Integer(bitmap);
        this.groupByCapabilitiesH.put(TAPELIBRARYGROUP, groupByBitmap);
    }

    public void applyGrouping(Hashtable groupBySet) {
        this.groupFocusSubsystem(groupBySet);
        this.groupFocusTapeLibrary(groupBySet);
    }

    private void groupFocusSubsystem(Hashtable groupBySet) {
        this.removeAll(GraphSubsystemGroup.TYPE);
        this.removeAll(GraphSubsystemGroup2Subsystem.TYPE);
        Vector entityV = new Vector();
        Enumeration subsystemEnu = this.enumerate(GraphSubsystem.TYPE);
        while (subsystemEnu.hasMoreElements()) {
            GraphSubsystem subsystem = (GraphSubsystem)subsystemEnu.nextElement();
            entityV.add(subsystem);
        }
        Integer groupByBitmap = (Integer)groupBySet.get(SUBSYSTEMGROUP);
        Hashtable groupH = GraphGroupingUtilities.applyGrouping(entityV, groupByBitmap, this);
        Enumeration subsystemGroupKeyEnu = groupH.keys();
        while (subsystemGroupKeyEnu.hasMoreElements()) {
            GraphGroupKey key = (GraphGroupKey)subsystemGroupKeyEnu.nextElement();
            entityV = (Vector)groupH.get(key);
            String idStr = key.getID();
            GraphSubsystemGroup subsystemGroup = new GraphSubsystemGroup(idStr);
            GraphSubsystemGroup.ID subsystemGroupID = (GraphSubsystemGroup.ID)subsystemGroup.getEntityID();
            subsystemGroup.setDisplayName(key.getLabel());
            subsystemGroup.setHealthStatus(GraphModelUtilities.aggregateHealthStatus(entityV));
            subsystemGroup.setSortingValue(key);
            subsystemGroup.setGroupKey(key);
            this.put(subsystemGroup);
            for (int i = 0; i < entityV.size(); ++i) {
                GraphSubsystem subsystem = (GraphSubsystem)entityV.elementAt(i);
                GraphSubsystem.ID subsystemID = (GraphSubsystem.ID)subsystem.getEntityID();
                GraphSubsystemGroup2Subsystem assoc = new GraphSubsystemGroup2Subsystem(subsystemGroupID.getID() + "+" + subsystemID.getID());
                assoc.setSubsystemGroupID(subsystemGroupID);
                assoc.setSubsystemID(subsystemID);
                this.put(assoc);
            }
        }
    }

    private void groupFocusTapeLibrary(Hashtable groupBySet) {
        this.removeAll(GraphTapeLibraryGroup.TYPE);
        this.removeAll(GraphTapeLibraryGroup2TapeLibrary.TYPE);
        Vector entityV = new Vector();
        Enumeration tapeLibraryEnu = this.enumerate(GraphTapeLibrary.TYPE);
        while (tapeLibraryEnu.hasMoreElements()) {
            GraphTapeLibrary tapeLibrary = (GraphTapeLibrary)tapeLibraryEnu.nextElement();
            entityV.add(tapeLibrary);
        }
        Integer groupByBitmap = (Integer)groupBySet.get(TAPELIBRARYGROUP);
        Hashtable groupH = GraphGroupingUtilities.applyGrouping(entityV, groupByBitmap, this);
        Enumeration tapeLibraryGroupKeyEnu = groupH.keys();
        while (tapeLibraryGroupKeyEnu.hasMoreElements()) {
            GraphGroupKey key = (GraphGroupKey)tapeLibraryGroupKeyEnu.nextElement();
            entityV = (Vector)groupH.get(key);
            String idStr = key.getID();
            GraphTapeLibraryGroup tapeLibraryGroup = new GraphTapeLibraryGroup(idStr);
            GraphTapeLibraryGroup.ID tapeLibraryGroupID = (GraphTapeLibraryGroup.ID)tapeLibraryGroup.getEntityID();
            tapeLibraryGroup.setDisplayName(key.getLabel());
            tapeLibraryGroup.setHealthStatus(GraphModelUtilities.aggregateHealthStatus(entityV));
            tapeLibraryGroup.setSortingValue(key);
            tapeLibraryGroup.setGroupKey(key);
            this.put(tapeLibraryGroup);
            for (int i = 0; i < entityV.size(); ++i) {
                GraphTapeLibrary tapeLibrary = (GraphTapeLibrary)entityV.elementAt(i);
                GraphTapeLibrary.ID tapeLibraryID = (GraphTapeLibrary.ID)tapeLibrary.getEntityID();
                GraphTapeLibraryGroup2TapeLibrary assoc = new GraphTapeLibraryGroup2TapeLibrary(tapeLibraryGroupID.getID() + "+" + tapeLibraryID.getID());
                assoc.setTapeLibraryGroupID(tapeLibraryGroupID);
                assoc.setTapeLibraryID(tapeLibraryID);
                this.put(assoc);
            }
        }
    }

    public void applyFiltering(int filteringLevel) {
        Boolean filterable;
        int unfilteredCount;
        int totalCount;
        Enumeration subsystemGroupEnu = this.enumerate(GraphSubsystemGroup.TYPE);
        while (subsystemGroupEnu.hasMoreElements()) {
            GraphSubsystemGroup subsystemGroup = (GraphSubsystemGroup)subsystemGroupEnu.nextElement();
            GraphSubsystemGroup.ID subsystemGroupID = (GraphSubsystemGroup.ID)subsystemGroup.getEntityID();
            totalCount = 0;
            unfilteredCount = 0;
            Enumeration subsystemEnu = this.associator(GraphSubsystemGroup2Subsystem.TYPE, subsystemGroupID);
            while (subsystemEnu.hasMoreElements()) {
                GraphSubsystem subsystem = (GraphSubsystem)subsystemEnu.nextElement();
                ++totalCount;
                filterable = filteringLevel == 0 ? Boolean.FALSE : (GraphModelUtilities.isAbnormal(subsystem) ? Boolean.FALSE : Boolean.TRUE);
                subsystem.setIsFilterable(filterable);
                if (filterable.booleanValue()) continue;
                ++unfilteredCount;
            }
            subsystemGroup.setNumOfSubsystems(new Integer(totalCount));
            subsystemGroup.setNumOfAbnormalSubsystems(new Integer(unfilteredCount));
            subsystemGroup.setIsFilterable(unfilteredCount == 0 ? Boolean.TRUE : Boolean.FALSE);
        }
        Enumeration tapeLibraryGroupEnu = this.enumerate(GraphTapeLibraryGroup.TYPE);
        while (tapeLibraryGroupEnu.hasMoreElements()) {
            GraphTapeLibraryGroup tapeLibraryGroup = (GraphTapeLibraryGroup)tapeLibraryGroupEnu.nextElement();
            GraphTapeLibraryGroup.ID tapeLibraryGroupID = (GraphTapeLibraryGroup.ID)tapeLibraryGroup.getEntityID();
            totalCount = 0;
            unfilteredCount = 0;
            Enumeration tapeLibraryEnu = this.associator(GraphTapeLibraryGroup2TapeLibrary.TYPE, tapeLibraryGroupID);
            while (tapeLibraryEnu.hasMoreElements()) {
                GraphTapeLibrary tapeLibrary = (GraphTapeLibrary)tapeLibraryEnu.nextElement();
                ++totalCount;
                filterable = filteringLevel == 0 ? Boolean.FALSE : (GraphModelUtilities.isAbnormal(tapeLibrary) ? Boolean.FALSE : Boolean.TRUE);
                tapeLibrary.setIsFilterable(filterable);
                if (filterable.booleanValue()) continue;
                ++unfilteredCount;
            }
            tapeLibraryGroup.setNumOfTapeLibraries(new Integer(totalCount));
            tapeLibraryGroup.setNumOfAbnormalTapeLibraries(new Integer(unfilteredCount));
            tapeLibraryGroup.setIsFilterable(unfilteredCount == 0 ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public static class ID
    extends GraphModel.ID {
        public ID() {
            super("StorageL0", null);
        }
    }
}

