/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.model;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.topo.model.GraphEntity;
import org.eclipse.aperi.gui.topo.model.GraphGroupKey;
import org.eclipse.aperi.gui.topo.model.GraphGroupingUtilities;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.model.GraphModelConstant;
import org.eclipse.aperi.gui.topo.model.GraphModelUtilities;
import org.eclipse.aperi.gui.topo.model.GraphScopedType;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubviewTapeLibraryL1Connectivity;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch2TapeLibrary;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitchGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitchGroup2Switch;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeLibrary;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeLibraryGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeLibraryGroup2TapeLibrary;

public class GraphModelTapeLibraryL1
extends GraphModel {
    public static final GraphScopedType SWGROUP = new GraphScopedType(GraphSwitchGroup.TYPE, GraphModelConstant.SCOPE_NULL);

    public GraphModelTapeLibraryL1(ID modelID) {
        super(modelID);
    }

    protected void initGroupByCapabilities() {
        int bitmap = GraphGroupingUtilities.GROUPBY_HEALTH + GraphGroupingUtilities.GROUPBY_UDP1 + GraphGroupingUtilities.GROUPBY_UDP2 + GraphGroupingUtilities.GROUPBY_UDP3 + GraphGroupingUtilities.GROUPBY_SWBYFABRIC;
        Integer groupByBitmap = new Integer(bitmap);
        this.groupByCapabilitiesH.put(SWGROUP, groupByBitmap);
    }

    public void applyGrouping(Hashtable groupBySet) {
        this.groupFocus();
        this.groupSubviewConnectivitySwitch(groupBySet);
        this.groupSubviewConnectivity();
        GraphGroupingUtilities.groupOrphanZone(this);
    }

    private void groupFocus() {
        ID multiEntityID = (ID)this.modelID;
        GraphEntity srcGroupEntity = multiEntityID.getSrcGroupEntity();
        Vector childFocusEntityIDV = multiEntityID.getChildFocusEntityIDs();
        Vector<GraphEntity> childFocusEntityV = new Vector<GraphEntity>();
        for (int i = 0; i < childFocusEntityIDV.size(); ++i) {
            GraphEntity.ID entityID = (GraphEntity.ID)childFocusEntityIDV.elementAt(i);
            GraphEntity entity = this.get(entityID);
            childFocusEntityV.add(entity);
        }
        String tapeLibraryGroupIDStr = "Focus";
        GraphTapeLibraryGroup tapeLibraryGroup = new GraphTapeLibraryGroup(tapeLibraryGroupIDStr);
        GraphTapeLibraryGroup.ID tapeLibraryGroupID = (GraphTapeLibraryGroup.ID)tapeLibraryGroup.getEntityID();
        tapeLibraryGroup.setDisplayName(srcGroupEntity.getDisplayName());
        tapeLibraryGroup.setHealthStatus(GraphModelUtilities.aggregateHealthStatus(childFocusEntityV));
        tapeLibraryGroup.setSortingValue(srcGroupEntity.getSortingValue());
        tapeLibraryGroup.setGroupKey(srcGroupEntity.getGroupKey());
        this.put(tapeLibraryGroup);
        multiEntityID.setFocusEntityID(tapeLibraryGroupID);
        for (int i = 0; i < childFocusEntityIDV.size(); ++i) {
            GraphTapeLibrary.ID tapeID = (GraphTapeLibrary.ID)childFocusEntityIDV.elementAt(i);
            GraphTapeLibraryGroup2TapeLibrary assoc = new GraphTapeLibraryGroup2TapeLibrary(tapeLibraryGroupID.getID() + "+" + tapeID.getID());
            assoc.setTapeLibraryGroupID(tapeLibraryGroupID);
            assoc.setTapeLibraryID(tapeID);
            this.put(assoc);
        }
    }

    private void groupSubviewConnectivitySwitch(Hashtable groupBySet) {
        this.removeAll(GraphSwitchGroup.TYPE);
        this.removeAll(GraphSwitchGroup2Switch.TYPE);
        Vector entityV = new Vector();
        Enumeration swEnu = this.enumerate(GraphSwitch.TYPE);
        while (swEnu.hasMoreElements()) {
            GraphSwitch sw = (GraphSwitch)swEnu.nextElement();
            entityV.add(sw);
        }
        Integer groupByBitmap = (Integer)groupBySet.get(SWGROUP);
        Hashtable groupH = GraphGroupingUtilities.applyGrouping(entityV, groupByBitmap, this);
        Enumeration swGroupKeyEnu = groupH.keys();
        while (swGroupKeyEnu.hasMoreElements()) {
            GraphGroupKey key = (GraphGroupKey)swGroupKeyEnu.nextElement();
            entityV = (Vector)groupH.get(key);
            String idStr = key.getID();
            GraphSwitchGroup swGroup = new GraphSwitchGroup(idStr);
            GraphSwitchGroup.ID swGroupID = (GraphSwitchGroup.ID)swGroup.getEntityID();
            swGroup.setDisplayName(key.getLabel());
            swGroup.setHealthStatus(GraphModelUtilities.aggregateHealthStatus(entityV));
            swGroup.setSortingValue(key);
            swGroup.setGroupKey(key);
            this.put(swGroup);
            for (int i = 0; i < entityV.size(); ++i) {
                GraphSwitch sw = (GraphSwitch)entityV.elementAt(i);
                GraphSwitch.ID swID = (GraphSwitch.ID)sw.getEntityID();
                GraphSwitchGroup2Switch assoc = new GraphSwitchGroup2Switch(swGroupID.getID() + "+" + swID.getID());
                assoc.setSwitchGroupID(swGroupID);
                assoc.setSwitchID(swID);
                this.put(assoc);
            }
        }
    }

    private void groupSubviewConnectivity() {
        GraphSubviewTapeLibraryL1Connectivity connectivity = new GraphSubviewTapeLibraryL1Connectivity("Connectivity");
        GraphSubviewTapeLibraryL1Connectivity.ID connectivityID = (GraphSubviewTapeLibraryL1Connectivity.ID)connectivity.getEntityID();
        connectivity.setDisplayName(GuiUtil.getString("TOPO_LABEL_TASK_CONNECTIVITY"));
        this.put(connectivity);
        Enumeration swGroupEnu = this.enumerate(GraphSwitchGroup.TYPE);
        while (swGroupEnu.hasMoreElements()) {
            GraphSwitchGroup swGroup = (GraphSwitchGroup)swGroupEnu.nextElement();
            connectivity.setHealthStatus(GraphModelUtilities.aggregateStatus(connectivity.getHealthStatus(), swGroup.getHealthStatus()));
        }
    }

    public void applyFiltering(int filteringLevel) {
        GraphSwitch2TapeLibrary sw2tapeLibrary;
        Enumeration sw2tapeLibraryEnu;
        Boolean filterable;
        int unfilteredCount;
        int totalCount;
        Enumeration tapeLibraryGroupEnu = this.enumerate(GraphTapeLibraryGroup.TYPE);
        while (tapeLibraryGroupEnu.hasMoreElements()) {
            GraphTapeLibraryGroup tapeLibraryGroup = (GraphTapeLibraryGroup)tapeLibraryGroupEnu.nextElement();
            GraphTapeLibraryGroup.ID tapeLibraryGroupID = (GraphTapeLibraryGroup.ID)tapeLibraryGroup.getEntityID();
            totalCount = 0;
            unfilteredCount = 0;
            Enumeration tapeEnu = this.associator(GraphTapeLibraryGroup2TapeLibrary.TYPE, tapeLibraryGroupID);
            while (tapeEnu.hasMoreElements()) {
                GraphTapeLibrary tapeLibrary = (GraphTapeLibrary)tapeEnu.nextElement();
                GraphTapeLibrary.ID tapeLibraryID = (GraphTapeLibrary.ID)tapeLibrary.getEntityID();
                ++totalCount;
                if (filteringLevel == 0) {
                    filterable = Boolean.FALSE;
                } else if (GraphModelUtilities.isAbnormal(tapeLibrary)) {
                    filterable = Boolean.FALSE;
                } else {
                    filterable = Boolean.TRUE;
                    if (filteringLevel == 1) {
                        sw2tapeLibraryEnu = this.reference(GraphSwitch2TapeLibrary.TYPE, tapeLibraryID);
                        while (sw2tapeLibraryEnu.hasMoreElements()) {
                            sw2tapeLibrary = (GraphSwitch2TapeLibrary)sw2tapeLibraryEnu.nextElement();
                            if (GraphModelUtilities.isAbnormal(sw2tapeLibrary)) {
                                filterable = Boolean.FALSE;
                                break;
                            }
                            GraphSwitch.ID swID = sw2tapeLibrary.getSwitchID();
                            GraphSwitch sw = (GraphSwitch)this.get(swID);
                            if (!GraphModelUtilities.isAbnormal(sw)) continue;
                            filterable = Boolean.FALSE;
                            break;
                        }
                    }
                }
                tapeLibrary.setIsFilterable(filterable);
                if (filterable.booleanValue()) continue;
                ++unfilteredCount;
            }
            tapeLibraryGroup.setNumOfTapeLibraries(new Integer(totalCount));
            tapeLibraryGroup.setNumOfAbnormalTapeLibraries(new Integer(unfilteredCount));
            tapeLibraryGroup.setIsFilterable(unfilteredCount == 0 ? Boolean.TRUE : Boolean.FALSE);
        }
        Enumeration swGroupEnu = this.enumerate(GraphSwitchGroup.TYPE);
        while (swGroupEnu.hasMoreElements()) {
            GraphSwitchGroup swGroup = (GraphSwitchGroup)swGroupEnu.nextElement();
            GraphSwitchGroup.ID swGroupID = (GraphSwitchGroup.ID)swGroup.getEntityID();
            totalCount = 0;
            unfilteredCount = 0;
            Enumeration swEnu = this.associator(GraphSwitchGroup2Switch.TYPE, swGroupID);
            while (swEnu.hasMoreElements()) {
                GraphSwitch sw = (GraphSwitch)swEnu.nextElement();
                GraphSwitch.ID swID = (GraphSwitch.ID)sw.getEntityID();
                ++totalCount;
                if (filteringLevel == 0) {
                    filterable = Boolean.FALSE;
                } else if (GraphModelUtilities.isAbnormal(sw)) {
                    filterable = Boolean.FALSE;
                } else {
                    filterable = Boolean.TRUE;
                    if (filteringLevel == 1) {
                        sw2tapeLibraryEnu = this.reference(GraphSwitch2TapeLibrary.TYPE, swID);
                        while (sw2tapeLibraryEnu.hasMoreElements()) {
                            sw2tapeLibrary = (GraphSwitch2TapeLibrary)sw2tapeLibraryEnu.nextElement();
                            if (GraphModelUtilities.isAbnormal(sw2tapeLibrary)) {
                                filterable = Boolean.FALSE;
                                break;
                            }
                            GraphTapeLibrary.ID tapeLibraryID = sw2tapeLibrary.getTapeLibraryID();
                            GraphTapeLibrary tapeLibrary = (GraphTapeLibrary)this.get(tapeLibraryID);
                            if (!GraphModelUtilities.isAbnormal(tapeLibrary)) continue;
                            filterable = Boolean.FALSE;
                            break;
                        }
                    }
                }
                sw.setIsFilterable(filterable);
                if (filterable.booleanValue()) continue;
                ++unfilteredCount;
            }
            swGroup.setNumOfSwitches(new Integer(totalCount));
            swGroup.setNumOfAbnormalSwitches(new Integer(unfilteredCount));
            swGroup.setIsFilterable(unfilteredCount == 0 ? Boolean.TRUE : Boolean.FALSE);
        }
        Enumeration connectivityEnu = this.enumerate(GraphSubviewTapeLibraryL1Connectivity.TYPE);
        while (connectivityEnu.hasMoreElements()) {
            GraphSubviewTapeLibraryL1Connectivity connectivity = (GraphSubviewTapeLibraryL1Connectivity)connectivityEnu.nextElement();
            int totalCount2 = 0;
            int unfilteredCount2 = 0;
            Enumeration swGroupEnu2 = this.enumerate(GraphSwitchGroup.TYPE);
            while (swGroupEnu2.hasMoreElements()) {
                GraphSwitchGroup swGroup = (GraphSwitchGroup)swGroupEnu2.nextElement();
                totalCount2 += swGroup.getNumOfSwitches().intValue();
                unfilteredCount2 += swGroup.getNumOfAbnormalSwitches().intValue();
            }
            connectivity.setNumOfSwitches(new Integer(totalCount2));
            connectivity.setNumOfAbnormalSwitches(new Integer(unfilteredCount2));
            connectivity.setIsFilterable(Boolean.FALSE);
        }
    }

    public static class ID
    extends GraphModel.MultiEntityID {
        public ID(GraphTapeLibraryGroup srcGroupEntity, Vector childFocusEntityIDV) {
            super("TapeLibraryL1", srcGroupEntity, childFocusEntityIDV);
        }
    }
}

