/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.model;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.topo.model.GraphGroupKey;
import org.eclipse.aperi.gui.topo.model.GraphGroupingUtilities;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.model.GraphModelConstant;
import org.eclipse.aperi.gui.topo.model.GraphModelUtilities;
import org.eclipse.aperi.gui.topo.model.GraphScopedType;
import org.eclipse.aperi.gui.topo.model.bean.GraphFCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphFCPort2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphFCPortGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphFCPortGroup2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphMediaChanger;
import org.eclipse.aperi.gui.topo.model.bean.GraphMediaChangerGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphMediaChangerGroup2MediaChanger;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubviewTapeLibraryL2Connectivity;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubviewTapeLibraryL2Device;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitchGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitchGroup2Switch;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeDrive;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeDrive2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeDriveGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeDriveGroup2TapeDrive;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeLibrary;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeLibrary2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeLibraryGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeLibraryGroup2TapeLibrary;

public class GraphModelTapeLibraryL2
extends GraphModel {
    public static final GraphScopedType SWGROUP = new GraphScopedType(GraphSwitchGroup.TYPE, GraphModelConstant.SCOPE_NULL);
    public static final GraphScopedType TAPEDRIVEGROUP = new GraphScopedType(GraphTapeDriveGroup.TYPE, GraphModelConstant.SCOPE_NULL);

    public GraphModelTapeLibraryL2(ID modelID) {
        super(modelID);
    }

    protected void initGroupByCapabilities() {
        int bitmap = GraphGroupingUtilities.GROUPBY_HEALTH + GraphGroupingUtilities.GROUPBY_UDP1 + GraphGroupingUtilities.GROUPBY_UDP2 + GraphGroupingUtilities.GROUPBY_UDP3 + GraphGroupingUtilities.GROUPBY_SWBYFABRIC;
        Integer groupByBitmap = new Integer(bitmap);
        this.groupByCapabilitiesH.put(SWGROUP, groupByBitmap);
        bitmap = GraphGroupingUtilities.GROUPBY_HEALTH;
        groupByBitmap = new Integer(bitmap);
        this.groupByCapabilitiesH.put(TAPEDRIVEGROUP, groupByBitmap);
    }

    public void applyScope() {
        Enumeration tapeLibraryEnu = this.enumerate(GraphTapeLibrary.TYPE);
        while (tapeLibraryEnu.hasMoreElements()) {
            GraphTapeLibrary tapeLibrary = (GraphTapeLibrary)tapeLibraryEnu.nextElement();
            GraphTapeLibrary.ID tapeLibraryID = (GraphTapeLibrary.ID)tapeLibrary.getEntityID();
            Enumeration fcportEnu = this.associator(GraphTapeLibrary2FCPort.TYPE, tapeLibraryID);
            while (fcportEnu.hasMoreElements()) {
                GraphFCPort fcport = (GraphFCPort)fcportEnu.nextElement();
                GraphFCPort.ID fcportID = (GraphFCPort.ID)fcport.getEntityID();
                fcport.addScope("Focus");
                Enumeration tapeDriveEnu = this.associator(GraphTapeDrive2FCPort.TYPE, fcportID);
                if (tapeDriveEnu.hasMoreElements()) continue;
                fcport.addScope("Orphan");
            }
        }
    }

    public void applyGrouping(Hashtable groupBySet) {
        this.groupFocus();
        this.groupSubviewConnectivityFCPortBySingleGroup();
        this.groupSubviewConnectivityTapeDrive(groupBySet);
        this.groupSubviewConnectivitySwitch(groupBySet);
        this.groupSubviewConnectivity();
        this.groupSubviewDeviceMediaChangerBySingleGroup();
        this.groupSubviewDevice();
        GraphGroupingUtilities.groupOrphanZone(this);
    }

    private void groupFocus() {
        GraphTapeLibrary.ID tapeID = (GraphTapeLibrary.ID)((ID)this.modelID).getFocusEntityID();
        String tapeLibraryGroupIDStr = "Focus";
        GraphTapeLibraryGroup tapeLibraryGroup = new GraphTapeLibraryGroup(tapeLibraryGroupIDStr);
        GraphTapeLibraryGroup.ID tapeLibraryGroupID = (GraphTapeLibraryGroup.ID)tapeLibraryGroup.getEntityID();
        tapeLibraryGroup.setIsHelper(Boolean.TRUE);
        this.put(tapeLibraryGroup);
        GraphTapeLibraryGroup2TapeLibrary assoc = new GraphTapeLibraryGroup2TapeLibrary(tapeLibraryGroupID.getID() + "+" + tapeID.getID());
        assoc.setTapeLibraryGroupID(tapeLibraryGroupID);
        assoc.setTapeLibraryID(tapeID);
        this.put(assoc);
    }

    private void groupSubviewConnectivityFCPortBySingleGroup() {
        this.removeAll(GraphFCPortGroup.TYPE);
        this.removeAll(GraphFCPortGroup2FCPort.TYPE);
        Vector entityV = new Vector();
        Enumeration fcportEnu = this.enumerate(GraphFCPort.TYPE);
        while (fcportEnu.hasMoreElements()) {
            GraphFCPort fcport = (GraphFCPort)fcportEnu.nextElement();
            if (!fcport.containScope("Focus") || !fcport.containScope("Orphan")) continue;
            entityV.add(fcport);
        }
        Integer groupByBitmap = GraphGroupingUtilities.GROUPBY_ALL;
        Hashtable groupH = GraphGroupingUtilities.applyGrouping(entityV, groupByBitmap, this);
        Enumeration fcportGroupKeyEnu = groupH.keys();
        while (fcportGroupKeyEnu.hasMoreElements()) {
            GraphGroupKey key = (GraphGroupKey)fcportGroupKeyEnu.nextElement();
            entityV = (Vector)groupH.get(key);
            String idStr = key.getID();
            GraphFCPortGroup fcportGroup = new GraphFCPortGroup(idStr);
            GraphFCPortGroup.ID fcportGroupID = (GraphFCPortGroup.ID)fcportGroup.getEntityID();
            fcportGroup.setDisplayName(key.getLabel());
            fcportGroup.setHealthStatus(GraphModelUtilities.aggregateHealthStatus(entityV));
            fcportGroup.setSortingValue(key);
            fcportGroup.setGroupKey(key);
            this.put(fcportGroup);
            for (int i = 0; i < entityV.size(); ++i) {
                GraphFCPort fcport = (GraphFCPort)entityV.elementAt(i);
                GraphFCPort.ID fcportID = (GraphFCPort.ID)fcport.getEntityID();
                GraphFCPortGroup2FCPort assoc = new GraphFCPortGroup2FCPort(fcportGroupID.getID() + "+" + fcportID.getID());
                assoc.setFCPortGroupID(fcportGroupID);
                assoc.setFCPortID(fcportID);
                this.put(assoc);
            }
        }
    }

    private void groupSubviewConnectivityTapeDrive(Hashtable groupBySet) {
        this.removeAll(GraphTapeDriveGroup.TYPE);
        this.removeAll(GraphTapeDriveGroup2TapeDrive.TYPE);
        Vector entityV = new Vector();
        Enumeration tapeDriveEnu = this.enumerate(GraphTapeDrive.TYPE);
        while (tapeDriveEnu.hasMoreElements()) {
            GraphTapeDrive tapeDrive = (GraphTapeDrive)tapeDriveEnu.nextElement();
            entityV.add(tapeDrive);
        }
        Integer groupByBitmap = (Integer)groupBySet.get(TAPEDRIVEGROUP);
        Hashtable groupH = GraphGroupingUtilities.applyGrouping(entityV, groupByBitmap, this);
        Enumeration tapeDriveGroupKeyEnu = groupH.keys();
        while (tapeDriveGroupKeyEnu.hasMoreElements()) {
            GraphGroupKey key = (GraphGroupKey)tapeDriveGroupKeyEnu.nextElement();
            entityV = (Vector)groupH.get(key);
            String idStr = key.getID();
            GraphTapeDriveGroup tapeDriveGroup = new GraphTapeDriveGroup(idStr);
            GraphTapeDriveGroup.ID tapeDriveGroupID = (GraphTapeDriveGroup.ID)tapeDriveGroup.getEntityID();
            tapeDriveGroup.setDisplayName(key.getLabel());
            tapeDriveGroup.setHealthStatus(GraphModelUtilities.aggregateHealthStatus(entityV));
            tapeDriveGroup.setSortingValue(key);
            tapeDriveGroup.setGroupKey(key);
            this.put(tapeDriveGroup);
            for (int i = 0; i < entityV.size(); ++i) {
                GraphTapeDrive tapeDrive = (GraphTapeDrive)entityV.elementAt(i);
                GraphTapeDrive.ID tapeDriveID = (GraphTapeDrive.ID)tapeDrive.getEntityID();
                GraphTapeDriveGroup2TapeDrive assoc = new GraphTapeDriveGroup2TapeDrive(tapeDriveGroupID.getID() + "+" + tapeDriveID.getID());
                assoc.setTapeDriveGroupID(tapeDriveGroupID);
                assoc.setTapeDriveID(tapeDriveID);
                this.put(assoc);
            }
        }
    }

    private void groupSubviewConnectivitySwitch(Hashtable groupBySet) {
        this.removeAll(GraphSwitchGroup.TYPE);
        this.removeAll(GraphSwitchGroup2Switch.TYPE);
        Vector entityV = new Vector();
        Enumeration swEnu = this.enumerate(GraphSwitch.TYPE);
        while (swEnu.hasMoreElements()) {
            GraphSwitch sw = (GraphSwitch)swEnu.nextElement();
            entityV.add(sw);
        }
        Integer groupByBitmap = (Integer)groupBySet.get(SWGROUP);
        Hashtable groupH = GraphGroupingUtilities.applyGrouping(entityV, groupByBitmap, this);
        Enumeration swGroupKeyEnu = groupH.keys();
        while (swGroupKeyEnu.hasMoreElements()) {
            GraphGroupKey key = (GraphGroupKey)swGroupKeyEnu.nextElement();
            entityV = (Vector)groupH.get(key);
            String idStr = key.getID();
            GraphSwitchGroup swGroup = new GraphSwitchGroup(idStr);
            GraphSwitchGroup.ID swGroupID = (GraphSwitchGroup.ID)swGroup.getEntityID();
            swGroup.setDisplayName(key.getLabel());
            swGroup.setHealthStatus(GraphModelUtilities.aggregateHealthStatus(entityV));
            swGroup.setSortingValue(key);
            swGroup.setGroupKey(key);
            this.put(swGroup);
            for (int i = 0; i < entityV.size(); ++i) {
                GraphSwitch sw = (GraphSwitch)entityV.elementAt(i);
                GraphSwitch.ID swID = (GraphSwitch.ID)sw.getEntityID();
                GraphSwitchGroup2Switch assoc = new GraphSwitchGroup2Switch(swGroupID.getID() + "+" + swID.getID());
                assoc.setSwitchGroupID(swGroupID);
                assoc.setSwitchID(swID);
                this.put(assoc);
            }
        }
    }

    private void groupSubviewConnectivity() {
        GraphSubviewTapeLibraryL2Connectivity connectivity = new GraphSubviewTapeLibraryL2Connectivity("Connectivity");
        GraphSubviewTapeLibraryL2Connectivity.ID connectivityID = (GraphSubviewTapeLibraryL2Connectivity.ID)connectivity.getEntityID();
        connectivity.setDisplayName(GuiUtil.getString("TOPO_LABEL_TASK_CONNECTIVITY"));
        this.put(connectivity);
        Enumeration tapeDriveGroupEnu = this.enumerate(GraphTapeDriveGroup.TYPE);
        while (tapeDriveGroupEnu.hasMoreElements()) {
            GraphTapeDriveGroup tapeDriveGroup = (GraphTapeDriveGroup)tapeDriveGroupEnu.nextElement();
            connectivity.setHealthStatus(GraphModelUtilities.aggregateStatus(connectivity.getHealthStatus(), tapeDriveGroup.getHealthStatus()));
        }
        Enumeration fcportGroupEnu = this.enumerate(GraphFCPortGroup.TYPE);
        while (fcportGroupEnu.hasMoreElements()) {
            GraphFCPortGroup fcportGroup = (GraphFCPortGroup)fcportGroupEnu.nextElement();
            connectivity.setHealthStatus(GraphModelUtilities.aggregateStatus(connectivity.getHealthStatus(), fcportGroup.getHealthStatus()));
        }
        Enumeration swGroupEnu = this.enumerate(GraphSwitchGroup.TYPE);
        while (swGroupEnu.hasMoreElements()) {
            GraphSwitchGroup swGroup = (GraphSwitchGroup)swGroupEnu.nextElement();
            connectivity.setHealthStatus(GraphModelUtilities.aggregateStatus(connectivity.getHealthStatus(), swGroup.getHealthStatus()));
        }
    }

    private void groupSubviewDeviceMediaChangerBySingleGroup() {
        this.removeAll(GraphMediaChangerGroup.TYPE);
        this.removeAll(GraphMediaChangerGroup2MediaChanger.TYPE);
        Vector entityV = new Vector();
        Enumeration mediaChangerEnu = this.enumerate(GraphMediaChanger.TYPE);
        while (mediaChangerEnu.hasMoreElements()) {
            GraphMediaChanger mediaChanger = (GraphMediaChanger)mediaChangerEnu.nextElement();
            entityV.add(mediaChanger);
        }
        Integer groupByBitmap = GraphGroupingUtilities.GROUPBY_ALL;
        Hashtable groupH = GraphGroupingUtilities.applyGrouping(entityV, groupByBitmap, this);
        Enumeration mediaChangerGroupKeyEnu = groupH.keys();
        while (mediaChangerGroupKeyEnu.hasMoreElements()) {
            GraphGroupKey key = (GraphGroupKey)mediaChangerGroupKeyEnu.nextElement();
            entityV = (Vector)groupH.get(key);
            String idStr = key.getID();
            GraphMediaChangerGroup mediaChangerGroup = new GraphMediaChangerGroup(idStr);
            GraphMediaChangerGroup.ID mediaChangerGroupID = (GraphMediaChangerGroup.ID)mediaChangerGroup.getEntityID();
            mediaChangerGroup.setDisplayName(key.getLabel());
            mediaChangerGroup.setHealthStatus(GraphModelUtilities.aggregateHealthStatus(entityV));
            mediaChangerGroup.setSortingValue(key);
            mediaChangerGroup.setGroupKey(key);
            this.put(mediaChangerGroup);
            for (int i = 0; i < entityV.size(); ++i) {
                GraphMediaChanger mediaChanger = (GraphMediaChanger)entityV.elementAt(i);
                GraphMediaChanger.ID mediaChangerID = (GraphMediaChanger.ID)mediaChanger.getEntityID();
                GraphMediaChangerGroup2MediaChanger assoc = new GraphMediaChangerGroup2MediaChanger(mediaChangerGroupID.getID() + "+" + mediaChangerID.getID());
                assoc.setMediaChangerGroupID(mediaChangerGroupID);
                assoc.setMediaChangerID(mediaChangerID);
                this.put(assoc);
            }
        }
    }

    private void groupSubviewDevice() {
        GraphSubviewTapeLibraryL2Device device = new GraphSubviewTapeLibraryL2Device("Device");
        GraphSubviewTapeLibraryL2Device.ID deviceID = (GraphSubviewTapeLibraryL2Device.ID)device.getEntityID();
        device.setDisplayName(GuiUtil.getString("TOPO_LABEL_TASK_DEVICE"));
        this.put(device);
        Enumeration mediaChangerGroupEnu = this.enumerate(GraphMediaChangerGroup.TYPE);
        while (mediaChangerGroupEnu.hasMoreElements()) {
            GraphMediaChangerGroup mediaChangerGroup = (GraphMediaChangerGroup)mediaChangerGroupEnu.nextElement();
            device.setHealthStatus(GraphModelUtilities.aggregateStatus(device.getHealthStatus(), mediaChangerGroup.getHealthStatus()));
        }
    }

    public void applyFiltering(int filteringLevel) {
        GraphSwitch sw;
        Enumeration swEnu;
        GraphFCPort.ID fcpID;
        GraphFCPort2FCPort fcp2fcport;
        Boolean filterable;
        Enumeration fcport2fcportEnu;
        GraphFCPort.ID fcportID;
        GraphFCPort fcport;
        int unfilteredCountEmpty;
        int totalCountEmpty;
        Enumeration tapeLibraryGroupEnu = this.enumerate(GraphTapeLibraryGroup.TYPE);
        while (tapeLibraryGroupEnu.hasMoreElements()) {
            GraphTapeLibraryGroup tapeLibraryGroup = (GraphTapeLibraryGroup)tapeLibraryGroupEnu.nextElement();
            GraphTapeLibraryGroup.ID tapeLibraryGroupID = (GraphTapeLibraryGroup.ID)tapeLibraryGroup.getEntityID();
            Enumeration otherEnu = this.associator(GraphTapeLibraryGroup2TapeLibrary.TYPE, tapeLibraryGroupID);
            while (otherEnu.hasMoreElements()) {
                GraphTapeLibrary tapeLibrary = (GraphTapeLibrary)otherEnu.nextElement();
                tapeLibrary.setIsFilterable(Boolean.FALSE);
            }
            tapeLibraryGroup.setIsFilterable(Boolean.FALSE);
        }
        Enumeration tapeDriveEnu = this.enumerate(GraphTapeDrive.TYPE);
        while (tapeDriveEnu.hasMoreElements()) {
            GraphTapeDrive tapeDrive = (GraphTapeDrive)tapeDriveEnu.nextElement();
            GraphTapeDrive.ID tapeDriveID = (GraphTapeDrive.ID)tapeDrive.getEntityID();
            int totalCountUsed = 0;
            int unfilteredCountUsed = 0;
            totalCountEmpty = 0;
            unfilteredCountEmpty = 0;
            Enumeration fcportEnu = this.associator(GraphTapeDrive2FCPort.TYPE, tapeDriveID);
            while (fcportEnu.hasMoreElements()) {
                fcport = (GraphFCPort)fcportEnu.nextElement();
                fcportID = (GraphFCPort.ID)fcport.getEntityID();
                fcport2fcportEnu = this.reference(GraphFCPort2FCPort.TYPE, fcportID);
                if (fcport2fcportEnu.hasMoreElements()) {
                    ++totalCountUsed;
                    if (filteringLevel == 0) {
                        filterable = Boolean.FALSE;
                    } else if (GraphModelUtilities.isAbnormal(fcport)) {
                        filterable = Boolean.FALSE;
                    } else {
                        filterable = Boolean.TRUE;
                        if (filteringLevel == 1) {
                            fcp2fcport = (GraphFCPort2FCPort)fcport2fcportEnu.nextElement();
                            if (GraphModelUtilities.isAbnormal(fcp2fcport)) {
                                filterable = Boolean.FALSE;
                            }
                            if ((fcpID = fcp2fcport.getFCPort1ID()).equals(fcportID)) {
                                fcpID = fcp2fcport.getFCPort2ID();
                            }
                            if ((swEnu = this.associator(GraphSwitch2FCPort.TYPE, fcpID)).hasMoreElements() && GraphModelUtilities.isAbnormal(sw = (GraphSwitch)swEnu.nextElement())) {
                                filterable = Boolean.FALSE;
                            }
                        }
                    }
                    if (!filterable.booleanValue()) {
                        ++unfilteredCountUsed;
                    }
                } else {
                    ++totalCountEmpty;
                    filterable = filteringLevel == 0 ? Boolean.FALSE : (GraphModelUtilities.isAbnormal(fcport) ? Boolean.FALSE : Boolean.TRUE);
                    if (!filterable.booleanValue()) {
                        ++unfilteredCountEmpty;
                    }
                }
                fcport.setIsFilterable(filterable);
            }
            tapeDrive.setNumOfFCPortsInUse(new Integer(totalCountUsed));
            tapeDrive.setNumOfAbnormalFCPortsInUse(new Integer(unfilteredCountUsed));
            tapeDrive.setNumOfFCPortsEmpty(new Integer(totalCountEmpty));
            tapeDrive.setNumOfAbnormalFCPortsEmpty(new Integer(unfilteredCountEmpty));
            tapeDrive.setIsFilterable(unfilteredCountUsed + unfilteredCountEmpty == 0 ? Boolean.TRUE : Boolean.FALSE);
        }
        Enumeration tapeDriveGroupEnu = this.enumerate(GraphTapeDriveGroup.TYPE);
        while (tapeDriveGroupEnu.hasMoreElements()) {
            GraphTapeDriveGroup tapeDriveGroup = (GraphTapeDriveGroup)tapeDriveGroupEnu.nextElement();
            GraphTapeDriveGroup.ID tapeDriveGroupID = (GraphTapeDriveGroup.ID)tapeDriveGroup.getEntityID();
            int totalCountTapeDrive = 0;
            int unfilteredCountTapeDrive = 0;
            int totalCountFCPort = 0;
            int unfilteredCountFCPort = 0;
            Enumeration swEnu2 = this.associator(GraphTapeDriveGroup2TapeDrive.TYPE, tapeDriveGroupID);
            while (swEnu2.hasMoreElements()) {
                GraphTapeDrive tapeDrive = (GraphTapeDrive)swEnu2.nextElement();
                totalCountFCPort += tapeDrive.getNumOfFCPortsInUse() + tapeDrive.getNumOfFCPortsEmpty();
                unfilteredCountFCPort += tapeDrive.getNumOfAbnormalFCPortsInUse() + tapeDrive.getNumOfAbnormalFCPortsEmpty();
                ++totalCountTapeDrive;
                if (Boolean.TRUE.equals(tapeDrive.getIsFilterable())) continue;
                ++unfilteredCountTapeDrive;
            }
            tapeDriveGroup.setNumOfFCPorts(new Integer(totalCountFCPort));
            tapeDriveGroup.setNumOfAbnormalFCPorts(new Integer(unfilteredCountFCPort));
            tapeDriveGroup.setNumOfTapeDrives(new Integer(totalCountTapeDrive));
            tapeDriveGroup.setNumOfAbnormalTapeDrives(new Integer(unfilteredCountTapeDrive));
            tapeDriveGroup.setIsFilterable(unfilteredCountTapeDrive == 0 ? Boolean.TRUE : Boolean.FALSE);
        }
        Enumeration fcportGroupEnu = this.enumerate(GraphFCPortGroup.TYPE);
        while (fcportGroupEnu.hasMoreElements()) {
            GraphFCPortGroup fcportGroup = (GraphFCPortGroup)fcportGroupEnu.nextElement();
            GraphFCPortGroup.ID fcportGroupID = (GraphFCPortGroup.ID)fcportGroup.getEntityID();
            int totalCountUsed = 0;
            int unfilteredCountUsed = 0;
            totalCountEmpty = 0;
            unfilteredCountEmpty = 0;
            Enumeration fcportEnu = this.associator(GraphFCPortGroup2FCPort.TYPE, fcportGroupID);
            while (fcportEnu.hasMoreElements()) {
                fcport = (GraphFCPort)fcportEnu.nextElement();
                fcportID = (GraphFCPort.ID)fcport.getEntityID();
                fcport2fcportEnu = this.reference(GraphFCPort2FCPort.TYPE, fcportID);
                if (fcport2fcportEnu.hasMoreElements()) {
                    ++totalCountUsed;
                    if (filteringLevel == 0) {
                        filterable = Boolean.FALSE;
                    } else if (GraphModelUtilities.isAbnormal(fcport)) {
                        filterable = Boolean.FALSE;
                    } else {
                        filterable = Boolean.TRUE;
                        if (filteringLevel == 1) {
                            fcp2fcport = (GraphFCPort2FCPort)fcport2fcportEnu.nextElement();
                            if (GraphModelUtilities.isAbnormal(fcp2fcport)) {
                                filterable = Boolean.FALSE;
                            }
                            if ((fcpID = fcp2fcport.getFCPort1ID()).equals(fcportID)) {
                                fcpID = fcp2fcport.getFCPort2ID();
                            }
                            if ((swEnu = this.associator(GraphSwitch2FCPort.TYPE, fcpID)).hasMoreElements() && GraphModelUtilities.isAbnormal(sw = (GraphSwitch)swEnu.nextElement())) {
                                filterable = Boolean.FALSE;
                            }
                        }
                    }
                    if (!filterable.booleanValue()) {
                        ++unfilteredCountUsed;
                    }
                } else {
                    ++totalCountEmpty;
                    filterable = filteringLevel == 0 ? Boolean.FALSE : (GraphModelUtilities.isAbnormal(fcport) ? Boolean.FALSE : Boolean.TRUE);
                    if (!filterable.booleanValue()) {
                        ++unfilteredCountEmpty;
                    }
                }
                fcport.setIsFilterable(filterable);
            }
            fcportGroup.setNumOfFCPortsInUse(new Integer(totalCountUsed));
            fcportGroup.setNumOfAbnormalFCPortsInUse(new Integer(unfilteredCountUsed));
            fcportGroup.setNumOfFCPortsEmpty(new Integer(totalCountEmpty));
            fcportGroup.setNumOfAbnormalFCPortsEmpty(new Integer(unfilteredCountEmpty));
            fcportGroup.setIsFilterable(unfilteredCountUsed + unfilteredCountEmpty == 0 ? Boolean.TRUE : Boolean.FALSE);
        }
        Enumeration swGroupEnu = this.enumerate(GraphSwitchGroup.TYPE);
        while (swGroupEnu.hasMoreElements()) {
            GraphSwitchGroup swGroup = (GraphSwitchGroup)swGroupEnu.nextElement();
            GraphSwitchGroup.ID swGroupID = (GraphSwitchGroup.ID)swGroup.getEntityID();
            int totalCount = 0;
            int unfilteredCount = 0;
            Enumeration swEnu3 = this.associator(GraphSwitchGroup2Switch.TYPE, swGroupID);
            while (swEnu3.hasMoreElements()) {
                Boolean filterable2;
                GraphSwitch sw2 = (GraphSwitch)swEnu3.nextElement();
                GraphSwitch.ID swID = (GraphSwitch.ID)sw2.getEntityID();
                ++totalCount;
                if (filteringLevel == 0) {
                    filterable2 = Boolean.FALSE;
                } else if (GraphModelUtilities.isAbnormal(sw2)) {
                    filterable2 = Boolean.FALSE;
                } else {
                    filterable2 = Boolean.TRUE;
                    if (filteringLevel == 1) {
                        Enumeration fcpIDEnu = this.associatorID(GraphSwitch2FCPort.TYPE, swID);
                        while (fcpIDEnu.hasMoreElements()) {
                            GraphFCPort fcport2;
                            GraphFCPort.ID fcpID2 = (GraphFCPort.ID)fcpIDEnu.nextElement();
                            Enumeration fcp2fcportEnu = this.reference(GraphFCPort2FCPort.TYPE, fcpID2);
                            if (!fcp2fcportEnu.hasMoreElements()) continue;
                            fcp2fcport = (GraphFCPort2FCPort)fcp2fcportEnu.nextElement();
                            if (GraphModelUtilities.isAbnormal(fcp2fcport)) {
                                filterable2 = Boolean.FALSE;
                                break;
                            }
                            GraphFCPort.ID fcportID2 = fcp2fcport.getFCPort1ID();
                            if (fcportID2.equals(fcpID2)) {
                                fcportID2 = fcp2fcport.getFCPort2ID();
                            }
                            if (!GraphModelUtilities.isAbnormal(fcport2 = (GraphFCPort)this.get(fcportID2))) continue;
                            filterable2 = Boolean.FALSE;
                            break;
                        }
                    }
                }
                sw2.setIsFilterable(filterable2);
                if (filterable2.booleanValue()) continue;
                ++unfilteredCount;
            }
            swGroup.setNumOfSwitches(new Integer(totalCount));
            swGroup.setNumOfAbnormalSwitches(new Integer(unfilteredCount));
            swGroup.setIsFilterable(unfilteredCount == 0 ? Boolean.TRUE : Boolean.FALSE);
        }
        Enumeration mediaChangerGroupEnu = this.enumerate(GraphMediaChangerGroup.TYPE);
        while (mediaChangerGroupEnu.hasMoreElements()) {
            GraphMediaChangerGroup mediaChangerGroup = (GraphMediaChangerGroup)mediaChangerGroupEnu.nextElement();
            GraphMediaChangerGroup.ID mediaChangerGroupID = (GraphMediaChangerGroup.ID)mediaChangerGroup.getEntityID();
            int totalCount = 0;
            int unfilteredCount = 0;
            Enumeration mediaChangerEnu = this.associator(GraphMediaChangerGroup2MediaChanger.TYPE, mediaChangerGroupID);
            while (mediaChangerEnu.hasMoreElements()) {
                GraphMediaChanger mediaChanger = (GraphMediaChanger)mediaChangerEnu.nextElement();
                ++totalCount;
                Boolean filterable3 = filteringLevel == 0 ? Boolean.FALSE : (GraphModelUtilities.isAbnormal(mediaChanger) ? Boolean.FALSE : Boolean.TRUE);
                mediaChanger.setIsFilterable(filterable3);
                if (filterable3.booleanValue()) continue;
                ++unfilteredCount;
            }
            mediaChangerGroup.setNumOfMediaChangers(new Integer(totalCount));
            mediaChangerGroup.setNumOfAbnormalMediaChangers(new Integer(unfilteredCount));
            mediaChangerGroup.setIsFilterable(unfilteredCount == 0 ? Boolean.TRUE : Boolean.FALSE);
        }
        Enumeration connectivityEnu = this.enumerate(GraphSubviewTapeLibraryL2Connectivity.TYPE);
        while (connectivityEnu.hasMoreElements()) {
            GraphSubviewTapeLibraryL2Connectivity connectivity = (GraphSubviewTapeLibraryL2Connectivity)connectivityEnu.nextElement();
            int totalCountTapeDrive = 0;
            int unfilteredCountTapeDrive = 0;
            int totalCountFCPort = 0;
            int unfilteredCountFCPort = 0;
            Vector tapeDriveGroupV = new Vector();
            Enumeration tapeDriveGroupEnu2 = this.enumerate(GraphTapeDriveGroup.TYPE);
            while (tapeDriveGroupEnu2.hasMoreElements()) {
                GraphTapeDriveGroup tapeDriveGroup = (GraphTapeDriveGroup)tapeDriveGroupEnu2.nextElement();
                totalCountTapeDrive += tapeDriveGroup.getNumOfTapeDrives().intValue();
                unfilteredCountTapeDrive += tapeDriveGroup.getNumOfAbnormalTapeDrives().intValue();
                totalCountFCPort += tapeDriveGroup.getNumOfFCPorts().intValue();
                unfilteredCountFCPort += tapeDriveGroup.getNumOfAbnormalFCPorts().intValue();
            }
            connectivity.setNumOfTapeDrives(new Integer(totalCountTapeDrive));
            connectivity.setNumOfAbnormalTapeDrives(new Integer(unfilteredCountTapeDrive));
            Enumeration fcportGroupEnu2 = this.enumerate(GraphFCPortGroup.TYPE);
            while (fcportGroupEnu2.hasMoreElements()) {
                GraphFCPortGroup fcportGroup = (GraphFCPortGroup)fcportGroupEnu2.nextElement();
                totalCountFCPort += fcportGroup.getNumOfFCPortsInUse() + fcportGroup.getNumOfFCPortsEmpty();
                unfilteredCountFCPort += fcportGroup.getNumOfAbnormalFCPortsInUse() + fcportGroup.getNumOfAbnormalFCPortsEmpty();
            }
            connectivity.setNumOfFCPorts(new Integer(totalCountFCPort));
            connectivity.setNumOfAbnormalFCPorts(new Integer(unfilteredCountFCPort));
            int totalCount = 0;
            int abnormalCount = 0;
            Enumeration swGroupEnu2 = this.enumerate(GraphSwitchGroup.TYPE);
            while (swGroupEnu2.hasMoreElements()) {
                GraphSwitchGroup swGroup = (GraphSwitchGroup)swGroupEnu2.nextElement();
                totalCount += swGroup.getNumOfSwitches().intValue();
                abnormalCount += swGroup.getNumOfAbnormalSwitches().intValue();
            }
            connectivity.setNumOfSwitches(new Integer(totalCount));
            connectivity.setNumOfAbnormalSwitches(new Integer(abnormalCount));
            connectivity.setIsFilterable(Boolean.FALSE);
        }
        Enumeration deviceEnu = this.enumerate(GraphSubviewTapeLibraryL2Device.TYPE);
        while (deviceEnu.hasMoreElements()) {
            GraphSubviewTapeLibraryL2Device device = (GraphSubviewTapeLibraryL2Device)deviceEnu.nextElement();
            int totalCount = 0;
            int unfilteredCount = 0;
            Enumeration mediaChangerGroupEnu2 = this.enumerate(GraphMediaChangerGroup.TYPE);
            while (mediaChangerGroupEnu2.hasMoreElements()) {
                GraphMediaChangerGroup mediaChangerGroup = (GraphMediaChangerGroup)mediaChangerGroupEnu2.nextElement();
                totalCount += mediaChangerGroup.getNumOfMediaChangers().intValue();
                unfilteredCount += mediaChangerGroup.getNumOfAbnormalMediaChangers().intValue();
            }
            device.setNumOfMediaChangers(new Integer(totalCount));
            device.setNumOfAbnormalMediaChangers(new Integer(unfilteredCount));
            device.setIsFilterable(Boolean.FALSE);
        }
    }

    public static class ID
    extends GraphModel.ID {
        public ID(GraphTapeLibrary focusEntity) {
            super("TapeLibraryL2", focusEntity.getEntityID());
        }
    }
}

