/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.topo.model.GraphAssociation;
import org.eclipse.aperi.gui.topo.model.GraphEntity;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.model.GraphModelConstant;
import org.eclipse.aperi.gui.topo.model.GraphModelUtilities;
import org.eclipse.aperi.gui.topo.model.GraphScopedType;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputer;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputerGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphFCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphFCPort2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric;
import org.eclipse.aperi.gui.topo.model.bean.GraphOther;
import org.eclipse.aperi.gui.topo.model.bean.GraphOtherGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystemGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitchGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeLibrary;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeLibraryGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphZoneMember;
import org.eclipse.aperi.gui.topo.util.GraphDebug;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoBase;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoEntity;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoGroup;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoIcon;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoLine;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoPin;
import org.eclipse.aperi.gui.topo.widget.ControllerApp;
import org.eclipse.aperi.gui.topo.widget.ControllerView;
import org.eclipse.aperi.gui.topo.widget.ITopoAssociationModel;
import org.eclipse.aperi.gui.topo.widget.ITopoPinContainerWidget;
import org.eclipse.aperi.gui.topo.widget.JTopoApp;
import org.eclipse.aperi.gui.topo.widget.JTopoCanvasOverview;
import org.eclipse.aperi.gui.topo.widget.JTopoPinComputer;
import org.eclipse.aperi.gui.topo.widget.JTopoPinOther;
import org.eclipse.aperi.gui.topo.widget.JTopoPinSubsystem;
import org.eclipse.aperi.gui.topo.widget.JTopoPinSwitch;
import org.eclipse.aperi.gui.topo.widget.JTopoPinTapeLibrary;
import org.eclipse.aperi.gui.topo.widget.JTopoPrint;
import org.eclipse.aperi.gui.topo.widget.JTopoViewGroup;
import org.eclipse.aperi.gui.topo.widget.PinList;
import org.eclipse.aperi.gui.topo.widget.TopoConstant;
import org.eclipse.aperi.gui.topo.widget.TopoEventSource;
import org.eclipse.aperi.gui.topo.widget.TopoResource;
import org.eclipse.aperi.gui.topo.widget.TopoSetting;
import org.eclipse.aperi.gui.topo.widget.TopoUtilities;
import org.eclipse.aperi.gui.topo.widget.WidgetPool;

public abstract class AbstractJTopoCanvas
extends AbstractJTopoBase {
    protected ControllerView controllerView;
    protected TopoSetting setting;
    protected GraphModel dataModel;
    protected JViewport viewport;
    protected CanvasPanelContainer canvasPanelContainer;
    protected CanvasPanel canvasPanel;
    protected ML_Click ml_click;
    protected ML_Drag ml_viewportDrag;
    protected ArrangeRecord arrangeRecord;
    protected JTopoPrint print;
    protected Action_CloseView actionCloseView;
    protected Action_CloseAllViews actionCloseAllViews;
    protected Action_RefreshView actionRefreshView;
    protected Action_RefreshAllViews actionRefreshAllViews;
    protected Action_ClearHighlights actionClearHighlights;
    protected Action_GlobalSetting actionGlobalSetting;
    protected Action_RefreshSetting actionRefreshSetting;
    protected Action_Print actionPrint;
    protected Action_PrintPreview actionPrintPreview;
    protected Hashtable widgetH;

    protected AbstractJTopoCanvas() {
        this.setBackground(TopoResource.COLOR_BACKGROUND);
        this.setLayout(new BorderLayout());
        this.viewport = new JViewport();
        this.viewport.setBackground(TopoResource.COLOR_BACKGROUND);
        this.add((Component)this.viewport, "Center");
        this.canvasPanelContainer = new CanvasPanelContainer();
        this.canvasPanelContainer.setPanelLabel(this.getViewName());
        this.viewport.setView(this.canvasPanelContainer);
        this.canvasPanel = new CanvasPanel();
        this.canvasPanel.setLayout(this.createDefaultLayout());
        this.canvasPanelContainer.add(this.canvasPanel);
        this.ml_click = new ML_Click();
        this.viewport.addMouseListener(this.ml_click);
        this.ml_viewportDrag = new ML_Drag();
        this.viewport.addMouseListener(this.ml_viewportDrag);
        this.viewport.addMouseMotionListener(this.ml_viewportDrag);
        this.print = new JTopoPrint(this);
        this.arrangeRecord = new ArrangeRecord();
        ActionMap actionMap = this.getActionMap();
        this.actionCloseView = new Action_CloseView();
        actionMap.put(this.actionCloseView.getValue("Name"), this.actionCloseView);
        this.actionCloseAllViews = new Action_CloseAllViews();
        actionMap.put(this.actionCloseAllViews.getValue("Name"), this.actionCloseAllViews);
        this.actionRefreshView = new Action_RefreshView();
        actionMap.put(this.actionRefreshView.getValue("Name"), this.actionRefreshView);
        this.actionRefreshAllViews = new Action_RefreshAllViews();
        actionMap.put(this.actionRefreshAllViews.getValue("Name"), this.actionRefreshAllViews);
        this.actionClearHighlights = new Action_ClearHighlights();
        actionMap.put(this.actionClearHighlights.getValue("Name"), this.actionClearHighlights);
        this.actionGlobalSetting = new Action_GlobalSetting();
        actionMap.put(this.actionGlobalSetting.getValue("Name"), this.actionGlobalSetting);
        this.actionRefreshSetting = new Action_RefreshSetting();
        actionMap.put(this.actionRefreshSetting.getValue("Name"), this.actionRefreshSetting);
        this.actionPrint = new Action_Print();
        actionMap.put(this.actionPrint.getValue("Name"), this.actionPrint);
        this.actionPrintPreview = new Action_PrintPreview();
        actionMap.put(this.actionPrintPreview.getValue("Name"), this.actionPrintPreview);
        this.widgetH = new Hashtable();
        this.initState();
    }

    public abstract String getViewName();

    private void initState() {
        this.controllerView = null;
        this.setting = null;
        this.dataModel = null;
        this.viewport.setViewPosition(new Point(0, 0));
        this.arrangeRecord.setProp(TopoConstant.ARRANGE_DISPLAYNAME);
        this.arrangeRecord.setAsc(true);
        WidgetPool widgetPool = WidgetPool.getInstance();
        Enumeration enu = this.widgetH.elements();
        while (enu.hasMoreElements()) {
            Hashtable h = (Hashtable)enu.nextElement();
            h.clear();
        }
    }

    public void resetState() {
        WidgetPool widgetPool = WidgetPool.getInstance();
        Enumeration enu = this.widgetH.elements();
        while (enu.hasMoreElements()) {
            Hashtable h = (Hashtable)enu.nextElement();
            Enumeration enu2 = h.elements();
            while (enu2.hasMoreElements()) {
                AbstractJTopoBase widget = (AbstractJTopoBase)enu2.nextElement();
                widgetPool.recycleWidget(widget);
            }
        }
        this.initState();
    }

    public ControllerView getControllerView() {
        return this.controllerView;
    }

    public void setSessionModel(ControllerView controllerView) {
        this.controllerView = controllerView;
        this.setting = controllerView.getControllerApp().getTopoSetting();
    }

    public GraphModel getDataModel() {
        return this.dataModel;
    }

    public void setDataModel(GraphModel dataModel) {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("AbstractJTopoCanvas, setDataModel()");
        }
        if (dataModel == null) {
            if (GraphDebug.isErrorVisible()) {
                GraphDebug.error("AbstractJTopoCanvas.setModel(), dataModel=null");
            }
            return;
        }
        this.dataModel = dataModel;
        this.updateContainer();
    }

    public void updateContainer() {
        this.reattach();
        this.postProcessing();
        this.revalidate();
        this.repaint();
    }

    protected void postProcessing() {
        this.canvasPanelContainer.setFilteringLevel(this.setting.getFilteringLevel());
    }

    public JViewport getViewport() {
        return this.viewport;
    }

    public CanvasPanelContainer getCanvasPanelContainer() {
        return this.canvasPanelContainer;
    }

    public CanvasPanel getCanvasPanel() {
        return this.canvasPanel;
    }

    public void setShowConnectionEnabled(boolean b) {
        this.clearAllLines();
        if (b) {
            boolean isAutoExpand = false;
            HashSet selectionHS = this.controllerView.getSelection();
            for (GraphEntity.ID entityD : selectionHS) {
                Vector v = this.getWidgets(entityD);
                for (int i = 0; i < v.size(); ++i) {
                    AbstractJTopoEntity widget = (AbstractJTopoEntity)v.elementAt(i);
                    this.addLine(widget, isAutoExpand);
                }
            }
        }
    }

    public void setShowZoneEnabled(boolean b) {
    }

    public void setOverlayHealthEnabled(boolean b) {
        Enumeration enu2 = this.widgetH.elements();
        while (enu2.hasMoreElements()) {
            Hashtable h = (Hashtable)enu2.nextElement();
            Enumeration enu = h.elements();
            while (enu.hasMoreElements()) {
                AbstractJTopoEntity widget = (AbstractJTopoEntity)enu.nextElement();
                widget.setOverlayHealthEnabled(b);
            }
        }
    }

    public void setOverlayPerfEnabled(boolean b) {
        Enumeration enu2 = this.widgetH.elements();
        while (enu2.hasMoreElements()) {
            Hashtable h = (Hashtable)enu2.nextElement();
            Enumeration enu = h.elements();
            while (enu.hasMoreElements()) {
                AbstractJTopoEntity widget = (AbstractJTopoEntity)enu.nextElement();
                widget.setOverlayPerfEnabled(b);
            }
        }
    }

    public void setFilteringLevel(int filteringLevel) {
        this.updateContainer();
        if (filteringLevel != 0) {
            ControllerView.SelectionDelta delta = new ControllerView.SelectionDelta(this.controllerView.getSelection());
            delta.setFromCanvas(true);
            Iterator it = delta.iteratorSrc();
            while (it.hasNext()) {
                GraphEntity.ID entityID = (GraphEntity.ID)it.next();
                GraphEntity entity = this.dataModel.get(entityID);
                if (!Boolean.TRUE.equals(entity.getIsFilterable())) continue;
                delta.remove(entityID);
            }
            this.controllerView.updateSelection(delta);
        }
        this.setShowConnectionEnabled(this.setting.isShowConnectionEnabled());
    }

    public void setPinList(PinList pinList) {
        ITopoPinContainerWidget pinContainer;
        AbstractJTopoEntity widget;
        Enumeration enu;
        Enumeration enu2 = this.widgetH.elements();
        while (enu2.hasMoreElements()) {
            Hashtable h = (Hashtable)enu2.nextElement();
            Enumeration enu3 = h.elements();
            while (enu3.hasMoreElements()) {
                AbstractJTopoEntity widget2 = (AbstractJTopoEntity)enu3.nextElement();
                widget2.setChecked(false);
                if (!(widget2 instanceof ITopoPinContainerWidget)) continue;
                ITopoPinContainerWidget pinContainer2 = (ITopoPinContainerWidget)((Object)widget2);
                Vector pinWidgetV = pinContainer2.getPinWidgets();
                for (int i = 0; i < pinWidgetV.size(); ++i) {
                    AbstractJTopoPin pin = (AbstractJTopoPin)pinWidgetV.elementAt(i);
                    pin.setChecked(false);
                }
            }
        }
        Vector pinEntityIDV = pinList.getPins();
        for (int i = 0; i < pinEntityIDV.size(); ++i) {
            GraphEntity.ID entityID = (GraphEntity.ID)pinEntityIDV.elementAt(i);
            Vector widgetsV = this.getWidgets(entityID);
            for (int j = 0; j < widgetsV.size(); ++j) {
                AbstractJTopoEntity widget3 = (AbstractJTopoEntity)widgetsV.elementAt(j);
                widget3.setPinned(true);
                widget3.pinChanged();
                widget3.setChecked(true);
            }
            Vector pinContainerV = this.getPinContainers(entityID);
            for (int k = 0; k < pinContainerV.size(); ++k) {
                ITopoPinContainerWidget pinContainer3 = (ITopoPinContainerWidget)pinContainerV.elementAt(k);
                AbstractJTopoPin pin = pinContainer3.getPinWidget(entityID);
                if (pin == null) {
                    pin = this.setPinList_createPin(entityID);
                    pin.setSessionModel(this, pinList);
                    pinContainer3.addPinWidget(pin);
                }
                pin.setDataModel(entityID);
                pin.setChecked(true);
            }
        }
        enu2 = this.widgetH.elements();
        while (enu2.hasMoreElements()) {
            Hashtable h = (Hashtable)enu2.nextElement();
            enu = h.elements();
            while (enu.hasMoreElements()) {
                AbstractJTopoPin pin;
                int i;
                widget = (AbstractJTopoEntity)enu.nextElement();
                if (!widget.isChecked()) {
                    widget.setPinned(false);
                    widget.pinChanged();
                }
                if (!(widget instanceof ITopoPinContainerWidget)) continue;
                pinContainer = (ITopoPinContainerWidget)((Object)widget);
                Vector<AbstractJTopoPin> toBeRemovedV = new Vector<AbstractJTopoPin>();
                Vector pinWidgetV = pinContainer.getPinWidgets();
                for (i = 0; i < pinWidgetV.size(); ++i) {
                    pin = (AbstractJTopoPin)pinWidgetV.elementAt(i);
                    if (!pin.isChecked()) {
                        toBeRemovedV.add(pin);
                    }
                    pin.setChecked(false);
                }
                for (i = 0; i < toBeRemovedV.size(); ++i) {
                    pin = (AbstractJTopoPin)toBeRemovedV.elementAt(i);
                    pinContainer.removePinWidget(pin);
                }
            }
        }
        enu2 = this.widgetH.elements();
        while (enu2.hasMoreElements()) {
            Hashtable h = (Hashtable)enu2.nextElement();
            enu = h.elements();
            while (enu.hasMoreElements()) {
                widget = (AbstractJTopoEntity)enu.nextElement();
                if (!(widget instanceof ITopoPinContainerWidget)) continue;
                pinContainer = (ITopoPinContainerWidget)((Object)widget);
                pinContainer.updatePinPanel();
            }
        }
    }

    protected AbstractJTopoPin setPinList_createPin(GraphEntity.ID entityID) {
        WidgetPool widgetPool = WidgetPool.getInstance();
        AbstractJTopoPin pin = null;
        if (entityID instanceof GraphComputer.ID) {
            pin = (JTopoPinComputer)widgetPool.getWidget(JTopoPinComputer.class);
        } else if (entityID instanceof GraphSwitch.ID) {
            pin = (JTopoPinSwitch)widgetPool.getWidget(JTopoPinSwitch.class);
        } else if (entityID instanceof GraphSubsystem.ID) {
            pin = (JTopoPinSubsystem)widgetPool.getWidget(JTopoPinSubsystem.class);
        } else if (entityID instanceof GraphTapeLibrary.ID) {
            pin = (JTopoPinTapeLibrary)widgetPool.getWidget(JTopoPinTapeLibrary.class);
        } else if (entityID instanceof GraphOther.ID) {
            pin = (JTopoPinOther)widgetPool.getWidget(JTopoPinOther.class);
        }
        return pin;
    }

    public Hashtable getWidgetTable(AbstractJTopoEntity widget) {
        Hashtable resultH = null;
        if (widget != null) {
            Enumeration enu = this.widgetH.elements();
            while (enu.hasMoreElements()) {
                Hashtable h = (Hashtable)enu.nextElement();
                Enumeration enu2 = h.elements();
                boolean firstTime = true;
                while (enu2.hasMoreElements()) {
                    AbstractJTopoEntity w = (AbstractJTopoEntity)enu2.nextElement();
                    if (firstTime) {
                        if (!w.getClass().equals(widget.getClass())) break;
                        firstTime = false;
                    }
                    if (!w.equals(widget)) continue;
                    resultH = h;
                    break;
                }
                if (resultH == null) continue;
                break;
            }
        }
        return resultH;
    }

    public Vector getWidgets(GraphEntity.ID entityID) {
        Vector<AbstractJTopoEntity> v = new Vector<AbstractJTopoEntity>();
        if (entityID != null) {
            Enumeration enu = this.widgetH.elements();
            while (enu.hasMoreElements()) {
                Hashtable h = (Hashtable)enu.nextElement();
                AbstractJTopoEntity widget = (AbstractJTopoEntity)h.get(entityID);
                if (widget == null) continue;
                v.add(widget);
            }
        }
        return v;
    }

    public Vector getPinContainers(GraphEntity.ID entityID) {
        Vector<AbstractJTopoEntity> v = new Vector<AbstractJTopoEntity>();
        Vector widgetV = this.getWidgets(entityID);
        for (int i = 0; i < widgetV.size(); ++i) {
            AbstractJTopoEntity widget;
            for (AbstractJTopoEntity w = widget = (AbstractJTopoEntity)widgetV.elementAt(i); w != null; w = w.getLogicalParent()) {
                if (!(w instanceof ITopoPinContainerWidget)) continue;
                v.add(w);
            }
        }
        return v;
    }

    public Vector getPins(GraphEntity.ID entityID) {
        Vector<AbstractJTopoPin> v = new Vector<AbstractJTopoPin>();
        Vector pinContainerV = this.getPinContainers(entityID);
        for (int i = 0; i < pinContainerV.size(); ++i) {
            ITopoPinContainerWidget pinContainer = (ITopoPinContainerWidget)pinContainerV.elementAt(i);
            AbstractJTopoPin pin = pinContainer.getPinWidget(entityID);
            if (pin == null) continue;
            v.add(pin);
        }
        return v;
    }

    protected void handleMouseClick(MouseEvent e) {
        boolean recursive = true;
        TopoEventSource eventSource = (TopoEventSource)e.getSource();
        eventSource.setHandler(this);
        this.handleUnitClick(e, recursive);
    }

    protected void handleUnitClick(MouseEvent e, boolean recursive) {
        TopoEventSource eventSource;
        Object handler;
        if (e.getClickCount() == 1) {
            ControllerView.SelectionDelta delta = new ControllerView.SelectionDelta(this.controllerView.getSelection());
            delta.setAltDown(e.isAltDown());
            delta.setFromCanvas(true);
            TopoEventSource eventSource2 = (TopoEventSource)e.getSource();
            Object handler2 = eventSource2.getHandler();
            delta.setClickedWidget(handler2);
            if (handler2 instanceof AbstractJTopoCanvas) {
                if (!e.isMetaDown()) {
                    this.clearAllSelections(delta);
                }
            } else if (handler2 instanceof AbstractJTopoEntity) {
                AbstractJTopoEntity widget = (AbstractJTopoEntity)handler2;
                GraphEntity.ID nodeID = widget.getFocusEntityID();
                delta.setClickedEntityID(nodeID);
                if (e.isMetaDown()) {
                    if (!delta.isInSrc(nodeID)) {
                        this.clearAllSelections(delta);
                        this.addSelection(delta, widget, recursive);
                    }
                } else if (!e.isShiftDown()) {
                    if (e.isControlDown()) {
                        if (delta.isInSrc(nodeID)) {
                            this.removeSelection(delta, widget, recursive);
                        } else {
                            this.addSelection(delta, widget, recursive);
                        }
                    } else {
                        this.clearAllSelections(delta);
                        this.addSelection(delta, widget, recursive);
                    }
                }
            }
            this.controllerView.updateSelection(delta);
            if (e.isMetaDown()) {
                this.handleUnitRightClick(e);
            }
        } else if (e.getModifiers() == 16 && e.getClickCount() == 2 && (handler = (eventSource = (TopoEventSource)e.getSource()).getHandler()) instanceof AbstractJTopoEntity) {
            AbstractJTopoEntity widget = (AbstractJTopoEntity)handler;
            this.openView(widget);
        }
    }

    protected void clearAllSelections(ControllerView.SelectionDelta delta) {
        delta.removeAll();
    }

    protected void addSelection(ControllerView.SelectionDelta delta, AbstractJTopoEntity widget, boolean recursive) {
        delta.add(widget.getFocusEntityID());
        if (recursive && widget instanceof AbstractJTopoGroup) {
            AbstractJTopoGroup group = (AbstractJTopoGroup)widget;
            Vector memberWidgetV = group.getLogicalChilds();
            for (int i = 0; i < memberWidgetV.size(); ++i) {
                AbstractJTopoEntity w = (AbstractJTopoEntity)memberWidgetV.elementAt(i);
                this.addSelection(delta, w, recursive);
            }
        }
    }

    protected void removeSelection(ControllerView.SelectionDelta delta, AbstractJTopoEntity widget, boolean recursive) {
        delta.remove(widget.getFocusEntityID());
        if (recursive && widget instanceof AbstractJTopoGroup) {
            AbstractJTopoGroup group = (AbstractJTopoGroup)widget;
            Vector memberWidgetV = group.getLogicalChilds();
            for (int i = 0; i < memberWidgetV.size(); ++i) {
                AbstractJTopoEntity w = (AbstractJTopoEntity)memberWidgetV.elementAt(i);
                this.removeSelection(delta, w, recursive);
            }
        }
    }

    public void applySelection(ControllerView.SelectionDelta delta) {
        GraphEntity.ID entityID;
        Iterator it = delta.iteratorRemove();
        while (it.hasNext()) {
            GraphEntity.ID entityID2 = (GraphEntity.ID)it.next();
            Vector widgetV = this.getWidgets(entityID2);
            for (int i = 0; i < widgetV.size(); ++i) {
                AbstractJTopoEntity widget = (AbstractJTopoEntity)widgetV.elementAt(i);
                widget.setSelected(false);
                widget.selectionChanged();
                if (!this.setting.isShowConnectionEnabled()) continue;
                this.removeLine(widget);
            }
            Vector pinV = this.getPins(entityID2);
            for (int i = 0; i < pinV.size(); ++i) {
                AbstractJTopoPin pin = (AbstractJTopoPin)pinV.elementAt(i);
                pin.setSelected(false);
                pin.selectionChanged();
            }
        }
        boolean isAutoExpand = delta.isAltDown();
        HashSet toWidgetHS = new HashSet();
        it = delta.iteratorAdd();
        while (it.hasNext()) {
            entityID = (GraphEntity.ID)it.next();
            Vector widgetV = this.getWidgets(entityID);
            for (int i = 0; i < widgetV.size(); ++i) {
                AbstractJTopoEntity widget = (AbstractJTopoEntity)widgetV.elementAt(i);
                widget.setSelected(true);
                widget.selectionChanged();
                if (!this.setting.isShowConnectionEnabled()) continue;
                HashSet hashSet = this.addLine(widget, isAutoExpand);
                toWidgetHS.addAll(hashSet);
            }
            Vector pinV = this.getPins(entityID);
            for (int i = 0; i < pinV.size(); ++i) {
                AbstractJTopoPin abstractJTopoPin = (AbstractJTopoPin)pinV.elementAt(i);
                abstractJTopoPin.setSelected(true);
                abstractJTopoPin.selectionChanged();
            }
        }
        if (this.setting.isShowConnectionEnabled() && isAutoExpand) {
            HashSet<AbstractJTopoEntity> toGroupWidgetHS = new HashSet<AbstractJTopoEntity>();
            for (AbstractJTopoEntity toWidget : toWidgetHS) {
                AbstractJTopoEntity toGroupWidget = toWidget.getLogicalParent();
                if (!(toGroupWidget instanceof AbstractJTopoGroup)) continue;
                toGroupWidgetHS.add(toGroupWidget);
            }
            HashSet<Hashtable> hs = new HashSet<Hashtable>();
            for (AbstractJTopoGroup abstractJTopoGroup : toGroupWidgetHS) {
                Hashtable h = this.getWidgetTable(abstractJTopoGroup);
                if (hs.contains(h)) continue;
                hs.add(h);
                Enumeration enu = h.elements();
                while (enu.hasMoreElements()) {
                    AbstractJTopoGroup g = (AbstractJTopoGroup)enu.nextElement();
                    if (toGroupWidgetHS.contains(g) || !g.isExpanded()) continue;
                    g.setExpanded(false);
                    g.revalidate();
                    g.repaint();
                }
            }
        }
        if (!delta.isFromCanvas()) {
            entityID = delta.getClickedEntityID();
            Vector widgetV = this.getWidgets(entityID);
            for (int i = 0; i < widgetV.size(); ++i) {
                AbstractJTopoEntity widget = (AbstractJTopoEntity)widgetV.elementAt(i);
                boolean bl = TopoUtilities.expand(widget);
                if (bl) {
                    SwingUtilities.invokeLater(new DelayFocus(widget, this));
                    continue;
                }
                TopoUtilities.focus(widget, this);
            }
        }
    }

    protected abstract void clearAllLines();

    protected void clearAllLines_helper(String widgetTypeStr) {
        Hashtable h = (Hashtable)this.widgetH.get(widgetTypeStr);
        Enumeration enu = h.elements();
        while (enu.hasMoreElements()) {
            AbstractJTopoLine widget = (AbstractJTopoLine)enu.nextElement();
            this.canvasPanel.remove(widget);
            WidgetPool.getInstance().recycleWidget(widget);
        }
        h.clear();
    }

    protected abstract HashSet addLine(AbstractJTopoEntity var1, boolean var2);

    protected HashSet addLine_helper(AbstractJTopoEntity fromWidget, GraphEntity.Type associationType, String lineWidgetHashtableID, Class lineWidgetClass, String toWidgetHashtableID, boolean isAutoExpand) {
        HashSet<AbstractJTopoEntity> toWidgetHS = new HashSet<AbstractJTopoEntity>();
        GraphEntity.ID fromEntityID = fromWidget.getFocusEntityID();
        Enumeration enu = this.dataModel.reference(associationType, fromEntityID);
        while (enu.hasMoreElements()) {
            AbstractJTopoLine widget;
            Hashtable h;
            AbstractJTopoEntity toWidget;
            GraphAssociation association = (GraphAssociation)enu.nextElement();
            GraphEntity.ID associationID = association.getEntityID();
            GraphEntity.ID toEntityID = association.getFromID();
            if (toEntityID.equals(fromEntityID)) {
                toEntityID = association.getToID();
            }
            if ((toWidget = (AbstractJTopoEntity)(h = (Hashtable)this.widgetH.get(toWidgetHashtableID)).get(toEntityID)) == null) continue;
            toWidgetHS.add(toWidget);
            if (isAutoExpand) {
                boolean isExpanded = TopoUtilities.expand(toWidget);
            }
            if ((widget = (AbstractJTopoLine)(h = (Hashtable)this.widgetH.get(lineWidgetHashtableID)).get(associationID)) == null) {
                widget = (AbstractJTopoLine)WidgetPool.getInstance().getWidget(lineWidgetClass);
                widget.setSessionModel(this, GraphModelConstant.SCOPE_NULL);
                ITopoAssociationModel associationModel = (ITopoAssociationModel)widget.getWidgetModel();
                associationModel.setFromWidget(fromWidget);
                associationModel.setToWidget(toWidget);
                h.put(associationID, widget);
                this.canvasPanel.add((Component)widget, 0);
            }
            widget.setDataModel(association);
        }
        return toWidgetHS;
    }

    protected HashSet addLine_helper_fromFCP(AbstractJTopoEntity fromWidget, GraphEntity.Type associationType, Class lineEntityClass, String lineWidgetHashtableID, Class lineWidgetClass, String toWidgetHashtableID, boolean isAutoExpand) {
        HashSet<AbstractJTopoEntity> toWidgetHS = new HashSet<AbstractJTopoEntity>();
        GraphEntity.ID fromEntityID = fromWidget.getFocusEntityID();
        GraphFCPort.ID fromfcpID = (GraphFCPort.ID)fromEntityID;
        Enumeration enu = this.dataModel.reference(GraphFCPort2FCPort.TYPE, fromfcpID);
        while (enu.hasMoreElements()) {
            GraphFCPort2FCPort fcp2fcp = (GraphFCPort2FCPort)enu.nextElement();
            GraphFCPort2FCPort.ID fcp2fcpID = (GraphFCPort2FCPort.ID)fcp2fcp.getEntityID();
            GraphEntity.ID tofcpID = fcp2fcp.getFromID();
            if (tofcpID.equals(fromfcpID)) {
                tofcpID = fcp2fcp.getToID();
            }
            Enumeration enu2 = this.dataModel.associatorID(associationType, tofcpID);
            while (enu2.hasMoreElements()) {
                GraphEntity.ID toEntityID = (GraphEntity.ID)enu2.nextElement();
                Hashtable h = (Hashtable)this.widgetH.get(toWidgetHashtableID);
                AbstractJTopoEntity toWidget = (AbstractJTopoEntity)h.get(toEntityID);
                if (toWidget == null) continue;
                toWidgetHS.add(toWidget);
                if (isAutoExpand) {
                    boolean isExpanded = TopoUtilities.expand(toWidget);
                }
                GraphAssociation association = null;
                try {
                    association = (GraphAssociation)lineEntityClass.newInstance();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                association.getEntityID().setID(fromEntityID.getID() + "+" + toEntityID.getID());
                association.setFromID(fromEntityID);
                association.setToID(toEntityID);
                association.setHealthStatus(fcp2fcp.getHealthStatus());
                h = (Hashtable)this.widgetH.get(lineWidgetHashtableID);
                AbstractJTopoLine widget = (AbstractJTopoLine)h.get(fcp2fcpID);
                if (widget == null) {
                    widget = (AbstractJTopoLine)WidgetPool.getInstance().getWidget(lineWidgetClass);
                    widget.setSessionModel(this, GraphModelConstant.SCOPE_NULL);
                    ITopoAssociationModel associationModel = (ITopoAssociationModel)widget.getWidgetModel();
                    associationModel.setFromWidget(fromWidget);
                    associationModel.setToWidget(toWidget);
                    h.put(fcp2fcpID, widget);
                    this.canvasPanel.add((Component)widget, 0);
                }
                widget.setDataModel(association);
            }
        }
        return toWidgetHS;
    }

    protected HashSet addLine_helper_toFCP(AbstractJTopoEntity fromWidget, GraphEntity.Type lineEntityType, Class lineEntityClass, String lineWidgetHashtableID, Class lineWidgetClass, String toUnitHashtableID, boolean isAutoExpand) {
        HashSet<AbstractJTopoEntity> toWidgetHS = new HashSet<AbstractJTopoEntity>();
        GraphEntity.ID fromEntityID = fromWidget.getFocusEntityID();
        Enumeration enu = this.dataModel.associatorID(lineEntityType, fromEntityID);
        while (enu.hasMoreElements()) {
            GraphFCPort.ID fromfcpID = (GraphFCPort.ID)enu.nextElement();
            Enumeration enu2 = this.dataModel.reference(GraphFCPort2FCPort.TYPE, fromfcpID);
            while (enu2.hasMoreElements()) {
                GraphFCPort2FCPort fcp2fcp = (GraphFCPort2FCPort)enu2.nextElement();
                GraphFCPort2FCPort.ID fcp2fcpID = (GraphFCPort2FCPort.ID)fcp2fcp.getEntityID();
                GraphEntity.ID tofcpID = fcp2fcp.getFromID();
                if (tofcpID.equals(fromfcpID)) {
                    tofcpID = fcp2fcp.getToID();
                }
                GraphEntity.ID toEntityID = tofcpID;
                Hashtable h = (Hashtable)this.widgetH.get(toUnitHashtableID);
                AbstractJTopoEntity toWidget = (AbstractJTopoEntity)h.get(toEntityID);
                if (toWidget == null) continue;
                toWidgetHS.add(toWidget);
                if (isAutoExpand) {
                    boolean isExpanded = TopoUtilities.expand(toWidget);
                }
                GraphAssociation association = null;
                try {
                    association = (GraphAssociation)lineEntityClass.newInstance();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                association.getEntityID().setID(fromEntityID.getID() + "+" + tofcpID.getID());
                association.setFromID(fromEntityID);
                association.setToID(toEntityID);
                association.setHealthStatus(fcp2fcp.getHealthStatus());
                h = (Hashtable)this.widgetH.get(lineWidgetHashtableID);
                AbstractJTopoLine widget = (AbstractJTopoLine)h.get(fcp2fcpID);
                if (widget == null) {
                    widget = (AbstractJTopoLine)WidgetPool.getInstance().getWidget(lineWidgetClass);
                    widget.setSessionModel(this, GraphModelConstant.SCOPE_NULL);
                    ITopoAssociationModel associationModel = (ITopoAssociationModel)widget.getWidgetModel();
                    associationModel.setFromWidget(fromWidget);
                    associationModel.setToWidget(toWidget);
                    h.put(fcp2fcpID, widget);
                    this.canvasPanel.add((Component)widget, 0);
                }
                widget.setDataModel(association);
            }
        }
        return toWidgetHS;
    }

    protected abstract void removeLine(AbstractJTopoEntity var1);

    protected void removeLine_helper(GraphEntity.ID srcEntityID, GraphEntity.Type associationType, String widgetTypeStr) {
        Enumeration enu = this.dataModel.referenceID(associationType, srcEntityID);
        while (enu.hasMoreElements()) {
            GraphEntity.ID associationID = (GraphEntity.ID)enu.nextElement();
            Hashtable h = (Hashtable)this.widgetH.get(widgetTypeStr);
            AbstractJTopoLine widget = (AbstractJTopoLine)h.remove(associationID);
            if (widget == null) continue;
            this.canvasPanel.remove(widget);
            WidgetPool.getInstance().recycleWidget(widget);
        }
    }

    protected void removeLine_helper_fromFCP(GraphEntity.ID srcEntityID, String widgetTypeStr) {
        Enumeration enu = this.dataModel.reference(GraphFCPort2FCPort.TYPE, srcEntityID);
        while (enu.hasMoreElements()) {
            GraphFCPort2FCPort fcp2fcp = (GraphFCPort2FCPort)enu.nextElement();
            GraphFCPort2FCPort.ID fcp2fcpID = (GraphFCPort2FCPort.ID)fcp2fcp.getEntityID();
            Hashtable h = (Hashtable)this.widgetH.get(widgetTypeStr);
            AbstractJTopoLine widget = (AbstractJTopoLine)h.remove(fcp2fcpID);
            if (widget == null) continue;
            this.canvasPanel.remove(widget);
            WidgetPool.getInstance().recycleWidget(widget);
        }
    }

    protected void removeLine_helper_toFCP(GraphEntity.ID srcEntityID, GraphEntity.Type referenceEntityType, String widgetTypeStr) {
        Enumeration enu = this.dataModel.associatorID(referenceEntityType, srcEntityID);
        while (enu.hasMoreElements()) {
            GraphFCPort.ID srcfcpID = (GraphFCPort.ID)enu.nextElement();
            Enumeration enu2 = this.dataModel.reference(GraphFCPort2FCPort.TYPE, srcfcpID);
            while (enu2.hasMoreElements()) {
                GraphFCPort2FCPort fcp2fcp = (GraphFCPort2FCPort)enu2.nextElement();
                GraphFCPort2FCPort.ID fcp2fcpID = (GraphFCPort2FCPort.ID)fcp2fcp.getEntityID();
                Hashtable h = (Hashtable)this.widgetH.get(widgetTypeStr);
                AbstractJTopoLine widget = (AbstractJTopoLine)h.remove(fcp2fcpID);
                if (widget == null) continue;
                this.canvasPanel.remove(widget);
                WidgetPool.getInstance().recycleWidget(widget);
            }
        }
    }

    public void applyHighlight(ControllerView.HighlightDelta delta) {
        AbstractJTopoEntity widget;
        int i;
        Vector widgetV;
        GraphEntity.ID entityID;
        ControllerApp topoControllerApp = this.controllerView.getControllerApp();
        Iterator it = delta.iteratorRemove();
        while (it.hasNext()) {
            entityID = (GraphEntity.ID)it.next();
            widgetV = this.getWidgets(entityID);
            for (i = 0; i < widgetV.size(); ++i) {
                widget = (AbstractJTopoEntity)widgetV.elementAt(i);
                widget.setHighlighted(false);
                widget.highlightChanged();
            }
        }
        it = delta.iteratorAdd();
        while (it.hasNext()) {
            entityID = (GraphEntity.ID)it.next();
            widgetV = this.getWidgets(entityID);
            for (i = 0; i < widgetV.size(); ++i) {
                widget = (AbstractJTopoEntity)widgetV.elementAt(i);
                widget.setHighlighted(true);
                widget.highlightChanged();
            }
        }
        GraphZoneMember.ID zmemID = (GraphZoneMember.ID)delta.getClickedEntityID();
        if (zmemID != null) {
            GraphZoneMember zmem = (GraphZoneMember)this.dataModel.get(zmemID);
            GraphFCPort.ID fcportID = zmem.getFCPortID();
            Vector v = this.getWidgets(fcportID);
            if (v.size() == 0) {
                GraphEntity.ID parentID = zmem.getParentID();
                v = this.getWidgets(parentID);
            }
            for (int i2 = 0; i2 < v.size(); ++i2) {
                AbstractJTopoEntity widget2 = (AbstractJTopoEntity)v.elementAt(i2);
                boolean isExpanded = TopoUtilities.expand(widget2);
                if (isExpanded) {
                    SwingUtilities.invokeLater(new DelayFocus(widget2, this));
                    continue;
                }
                TopoUtilities.focus(widget2, this);
            }
        }
    }

    public void applyLocate(ControllerView.LocateDelta delta) {
        AbstractJTopoEntity widget;
        int i;
        Vector widgetV;
        GraphEntity.ID entityID;
        ControllerApp topoControllerApp = this.controllerView.getControllerApp();
        Iterator it = delta.iteratorRemove();
        while (it.hasNext()) {
            entityID = (GraphEntity.ID)it.next();
            widgetV = this.getWidgets(entityID);
            for (i = 0; i < widgetV.size(); ++i) {
                widget = (AbstractJTopoEntity)widgetV.elementAt(i);
                widget.setHighlighted(false);
                widget.highlightChanged();
            }
        }
        it = delta.iteratorAdd();
        while (it.hasNext()) {
            entityID = (GraphEntity.ID)it.next();
            widgetV = this.getWidgets(entityID);
            for (i = 0; i < widgetV.size(); ++i) {
                widget = (AbstractJTopoEntity)widgetV.elementAt(i);
                widget.setHighlighted(true);
                widget.highlightChanged();
            }
        }
        GraphEntity.ID nodeID = delta.getClickedEntityID();
        Vector v = this.getWidgets(nodeID);
        for (i = 0; i < v.size(); ++i) {
            widget = (AbstractJTopoEntity)v.elementAt(i);
            boolean isExpanded = TopoUtilities.expand(widget);
            if (isExpanded) {
                SwingUtilities.invokeLater(new DelayFocus(widget, this));
                continue;
            }
            TopoUtilities.focus(widget, this);
        }
    }

    protected void expandGroup(AbstractJTopoGroup group, boolean toBeExpanded, boolean recursive) {
        if (group.isExpansible()) {
            group.setExpanded(toBeExpanded);
            if (recursive) {
                Vector memberWidgetV = group.getLogicalChilds();
                for (int i = 0; i < memberWidgetV.size(); ++i) {
                    AbstractJTopoEntity w = (AbstractJTopoEntity)memberWidgetV.elementAt(i);
                    if (!(w instanceof AbstractJTopoGroup)) continue;
                    this.expandGroup((AbstractJTopoGroup)w, toBeExpanded, recursive);
                }
            }
        }
    }

    protected abstract Vector getFirstLevelGroup();

    protected void handleUnitRightClick(MouseEvent e) {
        Vector<AbstractJTopoEntity> groupWidgetV;
        JPopupMenu popup = new JPopupMenu();
        boolean flagDeepExpand = false;
        TopoEventSource eventSource = (TopoEventSource)e.getSource();
        Object handler = eventSource.getHandler();
        if (handler != null) {
            GraphEntity entity;
            Vector<GraphEntity> entityV;
            GraphEntity entity2;
            AbstractJTopoEntity widget;
            if (handler instanceof AbstractJTopoIcon) {
                Vector<AbstractJTopoEntity> iconWidgetV = new Vector<AbstractJTopoEntity>();
                HashSet selectionHS = this.controllerView.getSelection();
                for (GraphEntity.ID entityID : selectionHS) {
                    Vector widgetV = this.getWidgets(entityID);
                    if (widgetV.size() > 0) {
                        widget = (AbstractJTopoEntity)widgetV.elementAt(0);
                        if (!(widget instanceof AbstractJTopoIcon)) continue;
                        iconWidgetV.add(widget);
                        continue;
                    }
                    Vector pinV = this.getPins(entityID);
                    if (pinV.size() <= 0) continue;
                    AbstractJTopoPin pin = (AbstractJTopoPin)pinV.elementAt(0);
                    iconWidgetV.add(pin);
                }
                if (iconWidgetV.size() == 1) {
                    JMenuItem mi;
                    GraphEntity.ID entityID;
                    AbstractJTopoIcon iconWidget = (AbstractJTopoIcon)iconWidgetV.elementAt(0);
                    entity2 = iconWidget.getFocusEntity();
                    entityID = entity2.getEntityID();
                    if (entity2 instanceof GraphSwitch || entity2 instanceof GraphSubsystem || entity2 instanceof GraphTapeLibrary || entity2 instanceof GraphComputer || entity2 instanceof GraphOther) {
                        mi = new JMenuItem(new Action_OpenDetailView(iconWidget));
                        popup.add(mi);
                        popup.addSeparator();
                    }
                    if (entity2 instanceof GraphSwitch || entity2 instanceof GraphSubsystem || entity2 instanceof GraphTapeLibrary || entity2 instanceof GraphComputer || entity2 instanceof GraphOther) {
                        mi = new JMenuItem(new Action_LaunchDetailPanel(entityID));
                        popup.add(mi);
                        popup.addSeparator();
                    }
                    if (entity2 instanceof GraphSwitch || entity2 instanceof GraphSubsystem || entity2 instanceof GraphTapeLibrary) {
                        mi = new JMenuItem(new Action_LaunchElementManager(entity2));
                        popup.add(mi);
                        popup.addSeparator();
                    }
                }
                if (iconWidgetV.size() > 0) {
                    boolean doPin = true;
                    boolean doIt = true;
                    Vector<GraphEntity.ID> entityIDV = new Vector<GraphEntity.ID>();
                    for (int i = 0; i < iconWidgetV.size(); ++i) {
                        AbstractJTopoIcon iconWidget = (AbstractJTopoIcon)iconWidgetV.elementAt(i);
                        GraphEntity entity3 = iconWidget.getFocusEntity();
                        GraphEntity.ID entityID = entity3.getEntityID();
                        if (!(entity3 instanceof GraphSwitch || entity3 instanceof GraphSubsystem || entity3 instanceof GraphTapeLibrary || entity3 instanceof GraphComputer || entity3 instanceof GraphOther)) {
                            doIt = false;
                            break;
                        }
                        entityIDV.add(entityID);
                        if (!iconWidget.isPinned()) continue;
                        doPin = false;
                    }
                    if (doIt && entityIDV.size() > 0) {
                        JMenuItem mi = new JMenuItem(new Action_Pin(entityIDV, doPin));
                        popup.add(mi);
                        popup.addSeparator();
                    }
                    boolean doIt2 = true;
                    entityV = new Vector<GraphEntity>();
                    for (int i = 0; i < iconWidgetV.size(); ++i) {
                        AbstractJTopoIcon iconWidget = (AbstractJTopoIcon)iconWidgetV.elementAt(i);
                        entity = iconWidget.getFocusEntity();
                        if (!((entity instanceof GraphSwitch || entity instanceof GraphSubsystem || entity instanceof GraphTapeLibrary || entity instanceof GraphComputer || entity instanceof GraphOther) && GraphModelConstant.STATUS_MISSING.equals(entity.getHealthStatus()))) {
                            doIt2 = false;
                            break;
                        }
                        entityV.add(entity);
                    }
                    if (doIt2 && entityV.size() > 0) {
                        JMenuItem mi = new JMenuItem(new Action_RemoveMissingEntity(entityV));
                        popup.add(mi);
                        popup.addSeparator();
                    }
                }
            } else if (handler instanceof AbstractJTopoGroup) {
                JMenuItem mi;
                groupWidgetV = new Vector<AbstractJTopoEntity>();
                HashSet selectionHS = this.controllerView.getSelection();
                for (GraphEntity.ID entityID : selectionHS) {
                    AbstractJTopoGroup group;
                    Vector widgetV = this.getWidgets(entityID);
                    if (widgetV.size() <= 0 || !((widget = (AbstractJTopoEntity)widgetV.elementAt(0)) instanceof AbstractJTopoGroup)) continue;
                    AbstractJTopoEntity parent = widget.getLogicalParent();
                    if (parent == null) {
                        groupWidgetV.add(widget);
                        continue;
                    }
                    if (!(parent instanceof AbstractJTopoGroup) || !(group = (AbstractJTopoGroup)parent).isExpanded()) continue;
                    groupWidgetV.add(widget);
                }
                if (groupWidgetV.size() == 1) {
                    GraphEntity.ID entityID;
                    AbstractJTopoGroup groupWidget = (AbstractJTopoGroup)groupWidgetV.elementAt(0);
                    entity2 = groupWidget.getFocusEntity();
                    entityID = entity2.getEntityID();
                    if (this instanceof JTopoCanvasOverview || entity2 instanceof GraphFabric || entity2 instanceof GraphComputerGroup || entity2 instanceof GraphSwitchGroup || entity2 instanceof GraphSubsystemGroup || entity2 instanceof GraphTapeLibraryGroup || entity2 instanceof GraphOtherGroup) {
                        mi = new JMenuItem(new Action_OpenDetailView(groupWidget));
                        popup.add(mi);
                        popup.addSeparator();
                    }
                    if (entity2 instanceof GraphFabric) {
                        mi = new JMenuItem(new Action_LaunchDetailPanel(entityID));
                        popup.add(mi);
                        popup.addSeparator();
                    }
                }
                if (groupWidgetV.size() > 0) {
                    int i;
                    int state = -1;
                    for (i = 0; i < groupWidgetV.size(); ++i) {
                        AbstractJTopoGroup groupWidget = (AbstractJTopoGroup)groupWidgetV.elementAt(i);
                        if (!groupWidget.isExpansible()) continue;
                        if (groupWidget.isExpanded()) {
                            if (state == 1) {
                                state = 2;
                                break;
                            }
                            state = 0;
                            continue;
                        }
                        if (state == 0) {
                            state = 2;
                            break;
                        }
                        state = 1;
                    }
                    if (state != -1) {
                        boolean toBeExpanded = false;
                        if (state == 1) {
                            toBeExpanded = true;
                        }
                        boolean recursive = false;
                        mi = new JMenuItem(new Action_GroupExpandCollapse(groupWidgetV, toBeExpanded, recursive));
                        popup.add(mi);
                    }
                    boolean recursive = true;
                    JMenuItem miDeepExpand = new JMenuItem(new Action_GroupExpandCollapse(groupWidgetV, true, recursive));
                    popup.add(miDeepExpand);
                    JMenuItem miDeepCollapse = new JMenuItem(new Action_GroupExpandCollapse(groupWidgetV, false, recursive));
                    popup.add(miDeepCollapse);
                    popup.addSeparator();
                    flagDeepExpand = true;
                    HashSet<GraphScopedType> scopedTypeHS = new HashSet<GraphScopedType>();
                    for (i = 0; i < groupWidgetV.size(); ++i) {
                        GraphScopedType scopedType;
                        Integer cap;
                        AbstractJTopoGroup groupWidget = (AbstractJTopoGroup)groupWidgetV.elementAt(i);
                        if (!groupWidget.isGroupByEnabled() || (cap = this.dataModel.getGroupByCapabilities(scopedType = groupWidget.getScopedID().getScopedType())) == null) continue;
                        scopedTypeHS.add(scopedType);
                    }
                    if (scopedTypeHS.size() > 0) {
                        JMenuItem mi2 = new JMenuItem(new Action_GroupBy(scopedTypeHS));
                        popup.add(mi2);
                    }
                    boolean doIt = true;
                    entityV = new Vector();
                    for (int i2 = 0; i2 < groupWidgetV.size(); ++i2) {
                        AbstractJTopoGroup groupWidget = (AbstractJTopoGroup)groupWidgetV.elementAt(i2);
                        entity = groupWidget.getFocusEntity();
                        if (!(entity instanceof GraphFabric) || !GraphModelConstant.STATUS_MISSING.equals(entity.getHealthStatus())) {
                            doIt = false;
                            break;
                        }
                        entityV.add(entity);
                    }
                    if (doIt && entityV.size() > 0) {
                        JMenuItem mi3 = new JMenuItem(new Action_RemoveMissingEntity(entityV));
                        popup.add(mi3);
                        popup.addSeparator();
                    }
                }
            }
        }
        if (popup.getComponentCount() > 0) {
            popup.addSeparator();
        }
        if (!flagDeepExpand && (groupWidgetV = this.getFirstLevelGroup()).size() > 0) {
            boolean recursive = true;
            JMenuItem miDeepExpand = new JMenuItem(new Action_GroupExpandCollapse(groupWidgetV, true, recursive));
            popup.add(miDeepExpand);
            JMenuItem miDeepCollapse = new JMenuItem(new Action_GroupExpandCollapse(groupWidgetV, false, recursive));
            popup.add(miDeepCollapse);
            popup.addSeparator();
        }
        JMenuItem miCloseView = new JMenuItem(this.actionCloseView);
        popup.add(miCloseView);
        if (this instanceof JTopoCanvasOverview) {
            miCloseView.setEnabled(false);
        } else {
            miCloseView.setEnabled(true);
        }
        JMenuItem miCloseAllViews = new JMenuItem(this.actionCloseAllViews);
        popup.add(miCloseAllViews);
        JTopoViewGroup topoViewGroup = this.controllerView.getControllerApp().getTopoApp().getTopoViewGroup();
        if (topoViewGroup.getTabCount() == 1) {
            miCloseAllViews.setEnabled(false);
        } else {
            miCloseAllViews.setEnabled(true);
        }
        JMenuItem miRefreshView = new JMenuItem(this.actionRefreshView);
        popup.add(miRefreshView);
        JMenuItem miRefreshAllViews = new JMenuItem(this.actionRefreshAllViews);
        popup.add(miRefreshAllViews);
        popup.addSeparator();
        JMenu m = new JMenu(GuiUtil.getString("TOPO_LABEL_MENU_CONTAINER_ARRANGEBY"));
        popup.add(m);
        popup.addSeparator();
        ButtonGroup bg = new ButtonGroup();
        JRadioButtonMenuItem miLabelAsc = new JRadioButtonMenuItem(new Action_ArrangeBy(TopoConstant.ARRANGE_DISPLAYNAME, true));
        bg.add(miLabelAsc);
        m.add(miLabelAsc);
        JRadioButtonMenuItem miLabelDsc = new JRadioButtonMenuItem(new Action_ArrangeBy(TopoConstant.ARRANGE_DISPLAYNAME, false));
        bg.add(miLabelDsc);
        m.add(miLabelDsc);
        JRadioButtonMenuItem miStatusAsc = new JRadioButtonMenuItem(new Action_ArrangeBy(TopoConstant.ARRANGE_STATUS, true));
        bg.add(miStatusAsc);
        m.add(miStatusAsc);
        JRadioButtonMenuItem miStatusDsc = new JRadioButtonMenuItem(new Action_ArrangeBy(TopoConstant.ARRANGE_STATUS, false));
        bg.add(miStatusDsc);
        m.add(miStatusDsc);
        if (this.arrangeRecord != null) {
            if (TopoConstant.ARRANGE_DISPLAYNAME.equals(this.arrangeRecord.getProp())) {
                if (this.arrangeRecord.isAsc()) {
                    miLabelAsc.setSelected(true);
                } else {
                    miLabelDsc.setSelected(true);
                }
            } else if (TopoConstant.ARRANGE_STATUS.equals(this.arrangeRecord.getProp())) {
                if (this.arrangeRecord.isAsc()) {
                    miStatusAsc.setSelected(true);
                } else {
                    miStatusDsc.setSelected(true);
                }
            }
        }
        JMenuItem miClearHighlights = new JMenuItem(this.actionClearHighlights);
        popup.add(miClearHighlights);
        HashSet highlightHS = this.controllerView.getHighlight();
        HashSet locateHS = this.controllerView.getLocate();
        boolean b = highlightHS.size() > 0 || locateHS.size() > 0;
        miClearHighlights.setEnabled(b);
        popup.addSeparator();
        JMenuItem miGlobalSetting = new JMenuItem(this.actionGlobalSetting);
        popup.add(miGlobalSetting);
        JMenuItem miRefreshSetting = new JMenuItem(this.actionRefreshSetting);
        popup.add(miRefreshSetting);
        popup.addSeparator();
        JMenuItem miPrint = new JMenuItem(this.actionPrint);
        popup.add(miPrint);
        JMenuItem miPrintPreview = new JMenuItem(this.actionPrintPreview);
        popup.add(miPrintPreview);
        Object source = eventSource.getSource();
        popup.show((Component)source, e.getX(), e.getY());
    }

    public Point getViewPosition() {
        return this.viewport == null ? null : this.viewport.getViewPosition();
    }

    public void setViewPosition(Point scrollTo) {
        if (this.viewport != null) {
            this.viewport.setViewPosition(scrollTo);
            this.repaint();
            this.controllerView.viewportPositionChanged();
        }
    }

    protected void handleUnitMouseDrag(Point offset) {
        Point viewPos = this.viewport.getViewPosition();
        Point scrollTo = new Point(viewPos.x - offset.x, viewPos.y - offset.y);
        this.setViewPosition(scrollTo);
    }

    public void openView(AbstractJTopoEntity widget) {
        GraphEntity focusEntity = widget.getFocusEntity();
        Vector<GraphEntity.ID> childFocusEntityIDV = null;
        if (widget instanceof AbstractJTopoGroup) {
            Vector memberWidgets = ((AbstractJTopoGroup)widget).getLogicalChilds();
            childFocusEntityIDV = new Vector<GraphEntity.ID>();
            for (int i = 0; i < memberWidgets.size(); ++i) {
                AbstractJTopoEntity w = (AbstractJTopoEntity)memberWidgets.elementAt(i);
                GraphEntity.ID childFocusEntityID = w.getFocusEntityID();
                childFocusEntityIDV.add(childFocusEntityID);
            }
        }
        this.controllerView.getControllerApp().openView(focusEntity, childFocusEntityIDV);
    }

    public void arrange() {
        Enumeration enu2 = this.widgetH.elements();
        while (enu2.hasMoreElements()) {
            Hashtable h = (Hashtable)enu2.nextElement();
            Enumeration enu = h.elements();
            while (enu.hasMoreElements()) {
                Object o = enu.nextElement();
                if (!(o instanceof AbstractJTopoGroup)) continue;
                AbstractJTopoGroup group = (AbstractJTopoGroup)o;
                group.setArrange(this.arrangeRecord);
            }
        }
    }

    public void printCanvas() {
        this.print.print();
    }

    protected void revalidateLine_helper(String lineWidgetHashtableID) {
        Enumeration lineEnu = ((Hashtable)this.widgetH.get(lineWidgetHashtableID)).elements();
        while (lineEnu.hasMoreElements()) {
            AbstractJTopoLine line = (AbstractJTopoLine)lineEnu.nextElement();
            line.setFirstPassOfLayout(false);
            line.revalidate();
        }
    }

    protected void adjustLine_helper(String lineWidgetHashtableID) {
        LineAggregator aggregator = new LineAggregator();
        Enumeration lineEnu = ((Hashtable)this.widgetH.get(lineWidgetHashtableID)).elements();
        while (lineEnu.hasMoreElements()) {
            AbstractJTopoLine line = (AbstractJTopoLine)lineEnu.nextElement();
            line.setFirstPassOfLayout(true);
            ITopoAssociationModel associationModel = (ITopoAssociationModel)line.getWidgetModel();
            AbstractJTopoEntity from = (AbstractJTopoEntity)associationModel.getFromWidget().getLastVisibleUnit();
            AbstractJTopoEntity to = (AbstractJTopoEntity)associationModel.getToWidget().getLastVisibleUnit();
            if (from == to) {
                line.setVisible(false);
                continue;
            }
            line.setVisible(true);
            aggregator.add(from, to, line);
        }
        aggregator.overwriteColorAndVisible();
    }

    protected abstract LayoutManager createDefaultLayout();

    protected class CanvasPanelContainer
    extends JPanel {
        private String panelLabel = "";
        private String filteringLabel = "";

        public CanvasPanelContainer() {
            this.setBorder(new EmptyBorder(0, 0, 2000, 2000));
            this.setBackground(TopoResource.COLOR_BACKGROUND);
            this.setLayout(new FlowLayout(0));
        }

        public void setPanelLabel(String panelLabel) {
            this.panelLabel = panelLabel;
        }

        public void setFilteringLevel(int filteringLevel) {
            this.filteringLabel = filteringLevel == 0 ? "" : " (" + GuiUtil.getString("TOPO_LABEL_COMMON_FILTERED") + ")";
        }

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2D = (Graphics2D)g;
            g2D.setPaint(TopoResource.COLOR_CANVAS_BACKGROUNDTEXT);
            g2D.setFont(TopoResource.FONT_CANVASPANELCONTAINER);
            g2D.drawString(this.panelLabel + this.filteringLabel, 0, 70);
        }
    }

    protected class CanvasPanel
    extends JPanel {
        public CanvasPanel() {
            this.setOpaque(false);
            this.setBorder(TopoResource.BORDER_CANVAS);
            this.setLayout(null);
        }
    }

    public class LineAggregator {
        private Hashtable h = new Hashtable();

        public void add(AbstractJTopoEntity from, AbstractJTopoEntity to, AbstractJTopoLine line) {
            LineRecord record = new LineRecord(from, to);
            Vector<AbstractJTopoLine> v = (Vector<AbstractJTopoLine>)this.h.get(record);
            if (v == null) {
                v = new Vector<AbstractJTopoLine>();
                this.h.put(record, v);
            }
            v.add(line);
        }

        public void overwriteColorAndVisible() {
            Enumeration enu = this.h.elements();
            while (enu.hasMoreElements()) {
                Vector<GraphEntity> entityV = new Vector<GraphEntity>();
                Vector widgetV = (Vector)enu.nextElement();
                for (int i = 0; i < widgetV.size(); ++i) {
                    AbstractJTopoLine line = (AbstractJTopoLine)widgetV.elementAt(i);
                    entityV.add(line.getFocusEntity());
                }
                Integer aggregatedStatus = GraphModelUtilities.aggregateHealthStatus(entityV);
                boolean isThick = widgetV.size() > 1;
                for (int i = 0; i < widgetV.size(); ++i) {
                    AbstractJTopoLine line = (AbstractJTopoLine)widgetV.elementAt(i);
                    if (i == 0) {
                        line.setVisible(true);
                        ITopoAssociationModel associationModel = (ITopoAssociationModel)line.getWidgetModel();
                        associationModel.setHealth(aggregatedStatus);
                        associationModel.setThick(isThick);
                        continue;
                    }
                    line.setVisible(false);
                }
            }
        }

        public class LineRecord {
            private AbstractJTopoEntity from;
            private AbstractJTopoEntity to;

            public LineRecord(AbstractJTopoEntity from, AbstractJTopoEntity to) {
                this.from = from;
                this.to = to;
            }

            public AbstractJTopoEntity getFrom() {
                return this.from;
            }

            public AbstractJTopoEntity getTo() {
                return this.to;
            }

            public boolean equals(Object o) {
                if (o == null) {
                    return false;
                }
                if (o == this) {
                    return true;
                }
                if (!(o instanceof LineRecord)) {
                    return false;
                }
                LineRecord a = (LineRecord)o;
                if (this.from != a.from) {
                    return false;
                }
                return this.to == a.to;
            }

            public int hashCode() {
                return this.from.hashCode() + this.to.hashCode();
            }
        }
    }

    protected class ArrangeRecord {
        private Integer prop;
        private boolean asc;

        public ArrangeRecord() {
        }

        public ArrangeRecord(Integer prop, boolean asc) {
            this.prop = prop;
            this.asc = asc;
        }

        public boolean isAsc() {
            return this.asc;
        }

        public void setAsc(boolean asc) {
            this.asc = asc;
        }

        public Integer getProp() {
            return this.prop;
        }

        public void setProp(Integer prop) {
            this.prop = prop;
        }
    }

    protected class Action_GroupBy
    extends AbstractAction {
        private HashSet scopedTypeHS;

        public Action_GroupBy(HashSet scopedTypeHS) {
            this.scopedTypeHS = scopedTypeHS;
            this.putValue("Name", GuiUtil.getString("TOPO_LABEL_MENU_CONTAINER_GROUPBY") + "...");
        }

        public void actionPerformed(ActionEvent e) {
            AbstractJTopoCanvas.this.controllerView.getControllerApp().getTopoApp().showGroupingDialog(AbstractJTopoCanvas.this.controllerView, this.scopedTypeHS);
        }
    }

    protected class Action_ArrangeBy
    extends AbstractAction {
        private Integer prop;
        private boolean asc;

        public Action_ArrangeBy(Integer prop, boolean asc) {
            this.prop = prop;
            this.asc = asc;
            if (TopoConstant.ARRANGE_DISPLAYNAME.equals(prop)) {
                if (asc) {
                    this.putValue("Name", GuiUtil.getString("TOPO_LABEL_ATTR_COMMON_LABEL") + " (" + GuiUtil.getString("TOPO_LABEL_COMMON_ASCEND") + ")");
                } else {
                    this.putValue("Name", GuiUtil.getString("TOPO_LABEL_ATTR_COMMON_LABEL") + " (" + GuiUtil.getString("TOPO_LABEL_COMMON_DESCEND") + ")");
                }
            } else if (TopoConstant.ARRANGE_STATUS.equals(prop)) {
                if (asc) {
                    this.putValue("Name", GuiUtil.getString("TOPO_LABEL_ATTR_COMMON_HEALTH") + " (" + GuiUtil.getString("TOPO_LABEL_COMMON_ASCEND") + ")");
                } else {
                    this.putValue("Name", GuiUtil.getString("TOPO_LABEL_ATTR_COMMON_HEALTH") + " (" + GuiUtil.getString("TOPO_LABEL_COMMON_DESCEND") + ")");
                }
            }
        }

        public void actionPerformed(ActionEvent e) {
            AbstractJTopoCanvas.this.arrangeRecord.setProp(this.prop);
            AbstractJTopoCanvas.this.arrangeRecord.setAsc(this.asc);
            AbstractJTopoCanvas.this.arrange();
        }
    }

    protected class Action_RemoveMissingEntity
    extends AbstractAction {
        private Vector entityV;

        public Action_RemoveMissingEntity(Vector entityV) {
            this.entityV = entityV;
            this.putValue("Name", GuiUtil.getString("TOPO_LABEL_MENU_UNIT_REMOVE"));
        }

        public void actionPerformed(ActionEvent e) {
            ControllerApp topoControllerApp = AbstractJTopoCanvas.this.controllerView.getControllerApp();
            topoControllerApp.removeMissingEntity(this.entityV);
        }
    }

    protected class Action_LaunchElementManager
    extends AbstractAction {
        private GraphEntity entity;

        public Action_LaunchElementManager(GraphEntity entity) {
            this.entity = entity;
            this.putValue("Name", GuiUtil.getString("TOPO_LABEL_MENU_UNIT_ELEMENTMANAGER"));
        }

        public void actionPerformed(ActionEvent e) {
            ControllerApp topoControllerApp = AbstractJTopoCanvas.this.controllerView.getControllerApp();
            topoControllerApp.launchElementManager(this.entity);
        }
    }

    protected class Action_LaunchDetailPanel
    extends AbstractAction {
        private GraphEntity.ID entityID;

        public Action_LaunchDetailPanel(GraphEntity.ID entityID) {
            this.entityID = entityID;
            this.putValue("Name", GuiUtil.getString("TOPO_LABEL_MENU_UNIT_DETAIL"));
        }

        public void actionPerformed(ActionEvent e) {
            ControllerApp topoControllerApp = AbstractJTopoCanvas.this.controllerView.getControllerApp();
            topoControllerApp.launchDetailPanel(this.entityID);
        }
    }

    protected class Action_Pin
    extends AbstractAction {
        private Vector entityIDV;
        private boolean doPin;

        public Action_Pin(Vector entityIDV, boolean doPin) {
            this.entityIDV = entityIDV;
            this.doPin = doPin;
            if (doPin) {
                this.putValue("Name", GuiUtil.getString("TOPO_LABEL_MENU_UNIT_PINNED"));
            } else {
                this.putValue("Name", GuiUtil.getString("TOPO_LABEL_MENU_UNIT_UNPINNED"));
            }
        }

        public void actionPerformed(ActionEvent e) {
            ControllerApp topoControllerApp = AbstractJTopoCanvas.this.controllerView.getControllerApp();
            PinList pinList = topoControllerApp.getPinList();
            if (this.doPin) {
                pinList.addPins(this.entityIDV);
            } else {
                pinList.removePins(this.entityIDV);
            }
        }
    }

    protected class Action_OpenDetailView
    extends AbstractAction {
        private AbstractJTopoEntity unit;

        public Action_OpenDetailView(AbstractJTopoEntity unit) {
            this.unit = unit;
            this.putValue("Name", GuiUtil.getString("TOPO_LABEL_MENU_UNIT_OPEN"));
        }

        public void actionPerformed(ActionEvent e) {
            AbstractJTopoCanvas.this.openView(this.unit);
        }
    }

    protected class Action_GroupExpandCollapse
    extends AbstractAction {
        private Vector groupWidgetV;
        private boolean toBeExpanded;
        private boolean recursive;

        public Action_GroupExpandCollapse(Vector containerV, boolean toBeExpanded, boolean recursive) {
            this.groupWidgetV = containerV;
            this.toBeExpanded = toBeExpanded;
            this.recursive = recursive;
            if (recursive) {
                if (toBeExpanded) {
                    this.putValue("Name", GuiUtil.getString("TOPO_LABEL_MENU_CANVAS_EXPANDALL"));
                } else {
                    this.putValue("Name", GuiUtil.getString("TOPO_LABEL_MENU_CANVAS_COLLAPSEALL"));
                }
            } else if (toBeExpanded) {
                this.putValue("Name", GuiUtil.getString("TOPO_LABEL_MENU_CONTAINER_EXPAND"));
            } else {
                this.putValue("Name", GuiUtil.getString("TOPO_LABEL_MENU_CONTAINER_COLLAPSE"));
            }
        }

        public void actionPerformed(ActionEvent e) {
            for (int i = 0; i < this.groupWidgetV.size(); ++i) {
                AbstractJTopoGroup group = (AbstractJTopoGroup)this.groupWidgetV.elementAt(i);
                AbstractJTopoCanvas.this.expandGroup(group, this.toBeExpanded, this.recursive);
            }
        }
    }

    protected class Action_PrintPreview
    extends AbstractAction {
        public Action_PrintPreview() {
            this.putValue("Name", GuiUtil.getString("TOPO_LABEL_MENU_CANVAS_PRINTPREVIEW"));
        }

        public void actionPerformed(ActionEvent e) {
            AbstractJTopoCanvas.this.print.preview();
        }
    }

    protected class Action_Print
    extends AbstractAction {
        public Action_Print() {
            this.putValue("Name", GuiUtil.getString("TOPO_LABEL_MENU_CANVAS_PRINT"));
        }

        public void actionPerformed(ActionEvent e) {
            AbstractJTopoCanvas.this.printCanvas();
        }
    }

    protected class Action_RefreshSetting
    extends AbstractAction {
        public Action_RefreshSetting() {
            this.putValue("Name", GuiUtil.getString("TOPO_LABEL_MENU_CANVAS_REFRESHSETTINGS"));
        }

        public void actionPerformed(ActionEvent e) {
            JTopoApp topoApp = AbstractJTopoCanvas.this.controllerView.getControllerApp().getTopoApp();
            topoApp.showRefreshSettingDialog();
        }
    }

    protected class Action_GlobalSetting
    extends AbstractAction {
        public Action_GlobalSetting() {
            this.putValue("Name", GuiUtil.getString("TOPO_LABEL_MENU_CANVAS_GLOBALSETTINGS"));
        }

        public void actionPerformed(ActionEvent e) {
            JTopoApp topoApp = AbstractJTopoCanvas.this.controllerView.getControllerApp().getTopoApp();
            topoApp.showGlobalSettingDialog();
        }
    }

    protected class Action_ClearHighlights
    extends AbstractAction {
        public Action_ClearHighlights() {
            this.putValue("Name", GuiUtil.getString("TOPO_LABEL_MENU_CANVAS_CLEARHIGHLIGHTS"));
        }

        public void actionPerformed(ActionEvent e) {
            ControllerView.HighlightDelta delta = new ControllerView.HighlightDelta(AbstractJTopoCanvas.this.controllerView.getHighlight());
            delta.removeAll();
            AbstractJTopoCanvas.this.controllerView.updateHighlight(delta);
            ControllerView.LocateDelta delta2 = new ControllerView.LocateDelta(null, AbstractJTopoCanvas.this.controllerView.getLocate());
            delta2.removeAll();
            AbstractJTopoCanvas.this.controllerView.updateLocate(delta2);
        }
    }

    protected class Action_CloseAllViews
    extends AbstractAction {
        public Action_CloseAllViews() {
            this.putValue("Name", GuiUtil.getString("TOPO_LABEL_MENU_CANVAS_CLOSEALLVIEWS"));
        }

        public void actionPerformed(ActionEvent e) {
            ControllerApp topoControllerApp = AbstractJTopoCanvas.this.controllerView.getControllerApp();
            topoControllerApp.closeAllViews();
        }
    }

    protected class Action_CloseView
    extends AbstractAction {
        public Action_CloseView() {
            this.putValue("Name", GuiUtil.getString("TOPO_LABEL_MENU_CANVAS_CLOSETHISVIEW"));
        }

        public void actionPerformed(ActionEvent e) {
            GraphModel.ID modelID = AbstractJTopoCanvas.this.dataModel.getModelID();
            ControllerApp topoControllerApp = AbstractJTopoCanvas.this.controllerView.getControllerApp();
            topoControllerApp.closeView(modelID);
        }
    }

    protected class Action_RefreshAllViews
    extends AbstractAction {
        public Action_RefreshAllViews() {
            this.putValue("Name", GuiUtil.getString("TOPO_LABEL_MENU_CANVAS_REFRESHALLVIEWS"));
        }

        public void actionPerformed(ActionEvent e) {
            ControllerApp topoControllerApp = AbstractJTopoCanvas.this.controllerView.getControllerApp();
            topoControllerApp.refreshAllViews();
        }
    }

    protected class Action_RefreshView
    extends AbstractAction {
        public Action_RefreshView() {
            this.putValue("Name", GuiUtil.getString("TOPO_LABEL_MENU_CANVAS_REFRESHTHISVIEW"));
        }

        public void actionPerformed(ActionEvent e) {
            GraphModel.ID modelID = AbstractJTopoCanvas.this.dataModel.getModelID();
            ControllerApp topoControllerApp = AbstractJTopoCanvas.this.controllerView.getControllerApp();
            topoControllerApp.refreshView(modelID);
        }
    }

    protected class ML_Drag
    extends MouseAdapter
    implements MouseMotionListener {
        protected Point last;
        protected boolean isCursorSet;

        protected ML_Drag() {
        }

        public void mousePressed(MouseEvent e) {
            if (e.isAltDown()) {
                this.last = e.getPoint();
            }
        }

        public void mouseDragged(MouseEvent e) {
            if (e.isAltDown()) {
                if (!this.isCursorSet) {
                    AbstractJTopoCanvas.this.setCursor(Cursor.getPredefinedCursor(13));
                    this.isCursorSet = true;
                }
                Point drag = e.getPoint();
                Point offset = new Point(drag.x - this.last.x, drag.y - this.last.y);
                this.last.setLocation(drag);
                JViewport viewport = (JViewport)e.getSource();
                if (viewport.contains(drag)) {
                    Point viewPos = viewport.getViewPosition();
                    Point scrollTo = new Point(viewPos.x - offset.x, viewPos.y - offset.y);
                    AbstractJTopoCanvas.this.setViewPosition(scrollTo);
                }
            }
        }

        public void mouseReleased(MouseEvent e) {
            this.last = null;
            if (this.isCursorSet) {
                AbstractJTopoCanvas.this.setCursor(Cursor.getPredefinedCursor(0));
                this.isCursorSet = false;
            }
        }

        public void mouseMoved(MouseEvent e) {
        }
    }

    private class DelayFocus
    implements Runnable {
        private AbstractJTopoEntity widget;
        private AbstractJTopoCanvas canvas;

        public DelayFocus(AbstractJTopoEntity widget, AbstractJTopoCanvas canvas) {
            this.widget = widget;
            this.canvas = canvas;
        }

        public void run() {
            TopoUtilities.focus(this.widget, this.canvas);
        }
    }

    protected class ML_Click
    extends MouseAdapter {
        protected ML_Click() {
        }

        public void mouseClicked(MouseEvent e) {
            e.setSource(new TopoEventSource(e));
            AbstractJTopoCanvas.this.handleMouseClick(e);
        }
    }
}

