/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.awt.LayoutManager;
import java.text.CollationKey;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import org.eclipse.aperi.gui.topo.model.GraphEntity;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoCanvas;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoEntity;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoUnit;
import org.eclipse.aperi.gui.topo.widget.DefaultTopoUnitModel;
import org.eclipse.aperi.gui.topo.widget.ITopoUnitModel;
import org.eclipse.aperi.gui.topo.widget.TopoConstant;
import org.eclipse.aperi.gui.topo.widget.TopoLayoutUtilities;

public abstract class AbstractJTopoContainer
extends AbstractJTopoUnit {
    protected Vector entityV = new Vector();

    protected AbstractJTopoContainer() {
        this((ITopoUnitModel)null, true);
    }

    protected AbstractJTopoContainer(ITopoUnitModel unitModel, boolean isWidgetModelListener) {
        super(unitModel, isWidgetModelListener);
        this.initState();
    }

    private void initState() {
        this.entityV.clear();
        this.removeAll();
    }

    public void resetState() {
        super.resetState();
        this.initState();
    }

    protected Object createWidgetModel() {
        return new DefaultTopoUnitModel();
    }

    public Vector getEntities() {
        return this.entityV;
    }

    public boolean isContainEntity(AbstractJTopoEntity entity) {
        return this.entityV.contains(entity);
    }

    public void addEntity(AbstractJTopoEntity entity) {
        this.entityV.add(entity);
        this.add(entity);
    }

    public void removeEntity(AbstractJTopoEntity entity) {
        this.entityV.remove(entity);
        this.remove(entity);
    }

    public void removeAllEntities() {
        this.entityV.clear();
        this.removeAll();
    }

    public void setOverlayHealthEnabled(boolean b) {
    }

    public void setOverlayPerfEnabled(boolean b) {
    }

    public void setArrange(AbstractJTopoCanvas.ArrangeRecord r) {
        Integer prop = r.getProp();
        boolean asc = r.isAsc();
        if (TopoConstant.ARRANGE_DISPLAYNAME.equals(prop)) {
            Collections.sort(this.entityV, new Arrange_ByDisplayName(asc));
        } else if (TopoConstant.ARRANGE_STATUS.equals(prop)) {
            Collections.sort(this.entityV, new Arrange_ByStatus(asc));
        } else {
            return;
        }
        this.removeAll();
        for (int i = 0; i < this.entityV.size(); ++i) {
            AbstractJTopoEntity entity = (AbstractJTopoEntity)this.entityV.elementAt(i);
            this.add(entity);
        }
        this.revalidate();
        this.repaint();
    }

    protected LayoutManager createDefaultLayout() {
        return new DefaultLayout();
    }

    protected class DefaultLayout
    extends TopoLayoutUtilities.SquareGridLayout {
    }

    protected class Arrange_ByStatus
    implements Comparator {
        protected boolean sort_asc;

        public Arrange_ByStatus(boolean sort_asc) {
            this.sort_asc = sort_asc;
        }

        public int compare(Object o1, Object o2) {
            AbstractJTopoEntity widget1 = (AbstractJTopoEntity)o1;
            AbstractJTopoEntity widget2 = (AbstractJTopoEntity)o2;
            GraphEntity entity1 = widget1.getFocusEntity();
            GraphEntity entity2 = widget2.getFocusEntity();
            if (entity1 == null && entity2 == null) {
                return 0;
            }
            if (entity1 == null) {
                return 1;
            }
            if (entity2 == null) {
                return -1;
            }
            Integer x1 = entity1.getHealthStatus();
            Integer x2 = entity2.getHealthStatus();
            int result = x1 != null && x2 != null ? x1.compareTo(x2) : (x1 != null ? -1 : (x2 != null ? 1 : 0));
            if (!this.sort_asc) {
                result = -result;
            }
            return result;
        }

        public boolean equals(Object obj) {
            return this.equals(obj);
        }
    }

    protected class Arrange_ByDisplayName
    implements Comparator {
        protected boolean sort_asc;

        public Arrange_ByDisplayName(boolean sort_asc) {
            this.sort_asc = sort_asc;
        }

        public int compare(Object o1, Object o2) {
            AbstractJTopoEntity widget1 = (AbstractJTopoEntity)o1;
            AbstractJTopoEntity widget2 = (AbstractJTopoEntity)o2;
            GraphEntity entity1 = widget1.getFocusEntity();
            GraphEntity entity2 = widget2.getFocusEntity();
            int result = 0;
            boolean done = true;
            if (entity1 == null && entity2 == null) {
                result = 0;
            } else if (entity1 == null) {
                result = 1;
            } else if (entity2 == null) {
                result = -1;
            } else {
                done = false;
            }
            if (!done) {
                done = true;
                Comparable c1 = entity1.getSortingValue();
                Comparable c2 = entity2.getSortingValue();
                if (c1 != null && c2 != null) {
                    result = c1.compareTo(c2);
                } else if (c1 != null) {
                    result = -1;
                } else if (c2 != null) {
                    result = 1;
                } else {
                    done = false;
                }
            }
            if (!done) {
                done = true;
                CollationKey k1 = entity1.getCollationKey();
                CollationKey k2 = entity2.getCollationKey();
                if (k1 != null && k2 != null) {
                    result = k1.compareTo(k2);
                } else if (k1 != null) {
                    result = -1;
                } else if (k2 != null) {
                    result = 1;
                } else {
                    done = false;
                }
            }
            if (!done) {
                result = 0;
            }
            if (!this.sort_asc) {
                result = -result;
            }
            return result;
        }

        public boolean equals(Object obj) {
            return this.equals(obj);
        }
    }
}

