/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.ImageIcon;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.topo.model.GraphEntity;
import org.eclipse.aperi.gui.topo.model.GraphGroupKey;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoTitle;
import org.eclipse.aperi.gui.topo.widget.ControllerApp;
import org.eclipse.aperi.gui.topo.widget.ITopoGroupModel;
import org.eclipse.aperi.gui.topo.widget.ITopoNodeModel;
import org.eclipse.aperi.gui.topo.widget.TopoResource;
import org.eclipse.aperi.gui.topo.widget.TopoSetting;

public abstract class AbstractJTopoGroupTitle
extends AbstractJTopoTitle {
    private static final String GAP_ICONJUMPING = "      ";
    protected String strType;
    protected ImageIcon[] iconJumping;
    protected ImageIcon iconRecursive;
    protected String strCounter;
    protected Point strTypeP;
    protected Rectangle strTypeR;
    protected String[] iconJumpingPositionStr;
    protected Rectangle[] iconJumpingR;
    protected Rectangle iconRecursiveR;
    protected Point strCounterP;
    protected Rectangle strCounterR;
    protected boolean isIconRecursiveEnabled;
    protected boolean isStrCounterEnabled;

    protected AbstractJTopoGroupTitle() {
        this((ITopoNodeModel)null, true);
    }

    protected AbstractJTopoGroupTitle(ITopoNodeModel nodeModel, boolean isWidgetModelListener) {
        super(nodeModel, isWidgetModelListener);
        this.setBorder(null);
        this.setBackground(TopoResource.COLOR_TITLE_BACKGROUND);
        this.iconRecursive = TopoResource.ICON_BOX_RECURSIVE_SELECTION;
        this.strTypeP = new Point();
        this.strTypeR = new Rectangle();
        this.iconRecursiveR = new Rectangle();
        this.strCounterP = new Point();
        this.strCounterR = new Rectangle();
        this.initState();
    }

    private void initState() {
        this.isIconRecursiveEnabled = true;
        this.isStrCounterEnabled = true;
        this.strType = null;
        this.iconJumping = null;
        this.strCounter = null;
        this.strTypeP.setLocation(0, 0);
        this.strTypeR.setBounds(0, 0, 0, 0);
        this.iconJumpingPositionStr = null;
        this.iconJumpingR = null;
        this.iconRecursiveR.setBounds(0, 0, 0, 0);
        this.strCounterP.setLocation(0, 0);
        this.strCounterR.setBounds(0, 0, 0, 0);
    }

    public void resetState() {
        super.resetState();
        this.initState();
    }

    public void modelChanged() {
        this.modelChanged_setCounter();
        super.modelChanged();
    }

    protected void modelChanged_setLabel() {
        GraphGroupKey.Key key;
        int i;
        ITopoGroupModel groupModel = (ITopoGroupModel)this.widgetModel;
        this.strType = groupModel.getType();
        GraphGroupKey groupKey = groupModel.getGroupKey();
        if (groupKey != null) {
            StringBuffer sb = new StringBuffer();
            sb.append(" (");
            Vector keyV = groupKey.getKeys();
            for (i = 0; i < keyV.size(); ++i) {
                if (i != 0) {
                    sb.append("+");
                }
                if ((key = (GraphGroupKey.Key)keyV.elementAt(i)).getJumpingEntity() != null) {
                    sb.append(GAP_ICONJUMPING);
                }
                sb.append(key.getMethodValueAlias());
            }
            sb.append(")");
            this.strLabel = sb.toString();
        } else {
            String s = groupModel.getLabel();
            this.strLabel = s.equals(this.strType) ? "" : " (" + s + ")";
        }
        if (groupKey != null) {
            Vector keyV = groupKey.getKeys();
            this.iconJumpingPositionStr = new String[keyV.size()];
            this.iconJumping = new ImageIcon[keyV.size()];
            this.iconJumpingR = new Rectangle[keyV.size()];
            StringBuffer sb = new StringBuffer();
            for (i = 0; i < keyV.size(); ++i) {
                if (i != 0) {
                    sb.append("+");
                }
                this.iconJumpingPositionStr[i] = " (" + sb.toString();
                this.iconJumping[i] = null;
                this.iconJumpingR[i] = new Rectangle();
                key = (GraphGroupKey.Key)keyV.elementAt(i);
                if (key.getJumpingEntity() != null) {
                    sb.append(GAP_ICONJUMPING);
                }
                sb.append(key.getMethodValueAlias());
            }
        } else {
            this.iconJumpingPositionStr = new String[0];
            this.iconJumping = new ImageIcon[0];
            this.iconJumpingR = new Rectangle[0];
        }
    }

    protected void modelChanged_setTooltip() {
        ITopoGroupModel groupModel = (ITopoGroupModel)this.widgetModel;
        String title = groupModel.getLabel();
        String type = groupModel.getType();
        GraphGroupKey groupKey = groupModel.getGroupKey();
        StringBuffer sb = new StringBuffer();
        sb.append(type);
        if (!title.equals(type)) {
            sb.append(" (");
            if (groupKey != null && !groupKey.isEmpty()) {
                sb.append(groupKey.getFullLabel());
            } else {
                sb.append(title);
            }
            sb.append(")");
        }
        this.tooltipLabel = sb.toString();
    }

    protected void modelChanged_setCounter() {
        ITopoGroupModel groupModel = (ITopoGroupModel)this.widgetModel;
        int totalCount = groupModel.getTotalCount();
        int unfileredCount = groupModel.getUnfilteredCount();
        TopoSetting setting = this.canvas.getControllerView().getControllerApp().getTopoSetting();
        int filteringLevel = setting.getFilteringLevel();
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        if (filteringLevel != 0) {
            sb.append(unfileredCount);
            sb.append(" / ");
        }
        sb.append(totalCount);
        sb.append("]");
        this.strCounter = sb.toString();
    }

    protected void modelChanged_setSelection() {
        super.modelChanged_setSelection();
        ITopoNodeModel nodeModel = (ITopoNodeModel)this.widgetModel;
        Color color = null;
        color = nodeModel.isSelected() ? TopoResource.COLOR_SELECTED : TopoResource.COLOR_TITLE_BACKGROUND;
        this.setBackground(color);
        ITopoGroupModel groupModel = (ITopoGroupModel)this.widgetModel;
        GraphGroupKey groupKey = groupModel.getGroupKey();
        if (groupKey != null) {
            Vector keyV = groupKey.getKeys();
            for (int i = 0; i < keyV.size(); ++i) {
                GraphGroupKey.Key key = (GraphGroupKey.Key)keyV.elementAt(i);
                if (key.getJumpingEntity() == null) continue;
                this.iconJumping[i] = nodeModel.isSelected() ? key.getIconSelected() : key.getIconUnselected();
            }
        }
    }

    protected void modelChanged_setHighlight() {
    }

    protected void handleMouseClick(MouseEvent e) {
        Point p = e.getPoint();
        if (e.getModifiers() == 16 && e.getClickCount() == 2) {
            for (int i = 0; i < this.iconJumpingR.length; ++i) {
                Rectangle r = this.iconJumpingR[i];
                if (!r.contains(p)) continue;
                ITopoGroupModel groupModel = (ITopoGroupModel)this.widgetModel;
                GraphGroupKey groupKey = groupModel.getGroupKey();
                GraphGroupKey.Key key = groupKey.getKey(i);
                GraphEntity entity = key.getJumpingEntity();
                ControllerApp controllerApp = this.canvas.getControllerView().getControllerApp();
                controllerApp.openView(entity, null);
                return;
            }
        }
        if (this.iconRecursiveR.contains(p)) {
            this.handleMouseClick_recursive(e);
        } else {
            this.handleMouseClick_background(e);
        }
    }

    public String getToolTipText(MouseEvent e) {
        Point p = e.getPoint();
        String s = null;
        s = this.iconRecursiveR.contains(p) ? GuiUtil.getString("TOPO_LABEL_MENU_CANVAS_SELECTALL") : super.getToolTipText(e);
        return s;
    }

    protected void layoutItself() {
        Graphics g = this.getGraphics();
        if (g == null) {
            return;
        }
        if (this.focusEntity == null) {
            return;
        }
        g.setFont(TopoResource.FONT_BOLD);
        FontMetrics fm = g.getFontMetrics();
        int strTypeW = 0;
        int strTypeH = 0;
        int strOffset = 0;
        if (this.strType != null) {
            strTypeW = fm.stringWidth(this.strType);
            strTypeH = fm.getHeight();
            strOffset = fm.getAscent();
        }
        g.setFont(TopoResource.FONT_PLAIN);
        fm = g.getFontMetrics();
        int strLabelW = 0;
        int strLabelH = 0;
        if (this.strLabel != null) {
            strLabelW = fm.stringWidth(this.strLabel);
            strLabelH = fm.getHeight();
        }
        int strCounterW = 0;
        int strCounterH = 0;
        if (this.strCounter != null) {
            strCounterW = fm.stringWidth(this.strCounter);
            strCounterH = fm.getHeight();
        }
        Insets insets = this.getInsets();
        int totalWidth = insets.left + insets.right;
        int totalHeight = insets.top + insets.bottom;
        totalWidth += 10;
        if (this.iconHealth != null) {
            totalWidth += this.iconHealth.getIconWidth() + 3;
        }
        if (this.iconPerf != null) {
            totalWidth += this.iconPerf.getIconWidth() + 3;
        }
        totalWidth += 6;
        totalWidth += this.iconType.getIconWidth() + 3;
        totalWidth += strTypeW + 3;
        totalWidth = this.labelMode == 0 ? (totalWidth += this.maxLabelWidth_compact) : (this.labelMode == 1 ? (totalWidth += strLabelW < this.maxLabelWidth_relax ? strLabelW : this.maxLabelWidth_relax) : (totalWidth += strLabelW));
        if (this.iconPin != null) {
            totalWidth += 3 + this.iconPin.getIconWidth();
        }
        if (this.isIconRecursiveEnabled) {
            totalWidth += 3 + this.iconRecursive.getIconWidth();
        }
        if (this.isStrCounterEnabled) {
            totalWidth += 3 + strCounterW;
        }
        this.preferredSizeD = new Dimension(totalWidth, totalHeight += 22);
        totalWidth = this.getWidth();
        totalHeight = this.getHeight();
        if (totalWidth != 0 && totalHeight != 0) {
            int offsetY;
            int nextX = insets.left + 5;
            int nextY = insets.top;
            int offsetX = totalWidth - insets.left - insets.right - 10;
            if (this.iconHealth != null) {
                offsetX -= this.iconHealth.getIconWidth() + 3;
            }
            if (this.iconPerf != null) {
                offsetX -= this.iconPerf.getIconWidth() + 3;
            }
            offsetX -= 6;
            offsetX -= this.iconType.getIconWidth() + 3;
            offsetX -= strTypeW + 3;
            if (this.iconPin != null) {
                offsetX -= 3 + this.iconPin.getIconWidth();
            }
            if (this.isIconRecursiveEnabled) {
                offsetX -= 3 + this.iconRecursive.getIconWidth();
            }
            if (this.isStrCounterEnabled) {
                offsetX -= 3 + strCounterW;
            }
            int max = offsetX;
            nextX += (offsetX -= strLabelW) > 0 ? offsetX / 2 : 0;
            if (this.iconHealth != null) {
                offsetY = (totalHeight - insets.top - insets.bottom - this.iconHealth.getIconHeight()) / 2;
                offsetY = offsetY > 0 ? offsetY : 0;
                this.iconHealthR.setBounds(nextX, nextY + offsetY, this.iconHealth.getIconWidth(), this.iconHealth.getIconHeight());
                nextX += this.iconHealth.getIconWidth() + 3;
            } else {
                this.iconHealthR.setBounds(0, 0, 0, 0);
            }
            if (this.iconPerf != null) {
                offsetY = (totalHeight - insets.top - insets.bottom - this.iconPerf.getIconHeight()) / 2;
                offsetY = offsetY > 0 ? offsetY : 0;
                this.iconPerfR.setBounds(nextX, nextY + offsetY, this.iconPerf.getIconWidth(), this.iconPerf.getIconHeight());
                nextX += this.iconPerf.getIconWidth() + 3;
            } else {
                this.iconPerfR.setBounds(0, 0, 0, 0);
            }
            offsetY = (totalHeight - insets.top - insets.bottom - this.iconType.getIconHeight()) / 2;
            offsetY = offsetY > 0 ? offsetY : 0;
            this.iconTypeR.setBounds(nextX += 3, nextY + offsetY, this.iconType.getIconWidth(), this.iconType.getIconHeight());
            offsetY = (totalHeight - insets.top - insets.bottom - strTypeH) / 2;
            offsetY = offsetY > 0 ? offsetY : 0;
            this.strTypeP.setLocation(nextX += this.iconType.getIconWidth() + 3, nextY + offsetY + strOffset);
            this.strTypeR.setBounds(nextX, nextY + offsetY, strTypeW, strTypeH);
            nextX += strTypeW + 3;
            if (this.strLabel != null) {
                int i;
                offsetY = (totalHeight - insets.top - insets.bottom - strLabelH) / 2;
                offsetY = offsetY > 0 ? offsetY : 0;
                int w2 = offsetX > 0 ? strLabelW : max;
                this.strLabelP.setLocation(nextX, nextY + offsetY + strOffset);
                this.strLabelR.setBounds(nextX, nextY + offsetY, w2, strLabelH);
                if (offsetX < 0) {
                    String s;
                    int w;
                    this.clippedStrLabel = "";
                    for (i = 0; i < this.strLabel.length() && (w = fm.stringWidth(s = this.strLabel.substring(0, i) + "...")) <= max; ++i) {
                        this.clippedStrLabel = s;
                    }
                } else {
                    this.clippedStrLabel = this.strLabel;
                }
                for (i = 0; i < this.iconJumpingR.length; ++i) {
                    Rectangle r = this.iconJumpingR[i];
                    ImageIcon icon = this.iconJumping[i];
                    if (icon != null) {
                        int w = fm.stringWidth(this.iconJumpingPositionStr[i]);
                        if (w + icon.getIconWidth() < w2) {
                            r.setBounds(nextX + w, nextY + offsetY, icon.getIconWidth(), icon.getIconHeight());
                            continue;
                        }
                        r.setBounds(0, 0, 0, 0);
                        continue;
                    }
                    r.setBounds(0, 0, 0, 0);
                }
                nextX += w2 + 3;
            } else {
                this.strLabelR.setBounds(0, 0, 0, 0);
            }
            nextX += 3;
            if (this.iconPin != null) {
                offsetY = (totalHeight - insets.top - insets.bottom - this.iconPin.getIconHeight()) / 2;
                offsetY = offsetY > 0 ? offsetY : 0;
                this.iconPinR.setBounds(nextX, nextY + offsetY, this.iconPin.getIconWidth(), this.iconPin.getIconHeight());
                nextX += this.iconPin.getIconWidth() + 3;
            } else {
                this.iconPinR.setBounds(0, 0, 0, 0);
            }
            if (this.isIconRecursiveEnabled) {
                offsetY = (totalHeight - insets.top - insets.bottom - this.iconRecursive.getIconHeight()) / 2;
                offsetY = offsetY > 0 ? offsetY : 0;
                this.iconRecursiveR.setBounds(nextX, nextY + offsetY, this.iconRecursive.getIconWidth(), this.iconRecursive.getIconHeight());
                nextX += this.iconRecursive.getIconWidth() + 3;
            }
            if (this.isStrCounterEnabled) {
                offsetY = (totalHeight - insets.top - insets.bottom - strCounterH) / 2;
                offsetY = offsetY > 0 ? offsetY : 0;
                this.strCounterP.setLocation(nextX, nextY + offsetY + strOffset);
                this.strCounterR.setBounds(nextX, nextY + offsetY, strCounterW, strCounterH);
            }
        }
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.isIconRecursiveEnabled) {
            this.iconRecursive.paintIcon(this, g, this.iconRecursiveR.x, this.iconRecursiveR.y);
        }
        if (this.strType != null) {
            g.setFont(TopoResource.FONT_BOLD);
            g.setColor(TopoResource.COLOR_FONT);
            g.drawString(this.strType, this.strTypeP.x, this.strTypeP.y);
        }
        for (int i = 0; i < this.iconJumpingR.length; ++i) {
            Rectangle r = this.iconJumpingR[i];
            ImageIcon icon = this.iconJumping[i];
            if (r.getX() == 0.0 || icon == null) continue;
            icon.paintIcon(this, g, r.x, r.y);
        }
        if (this.isStrCounterEnabled && this.strCounter != null) {
            g.setFont(TopoResource.FONT_PLAIN);
            g.setColor(TopoResource.COLOR_FONT);
            g.drawString(this.strCounter, this.strCounterP.x, this.strCounterP.y);
        }
    }

    public void setIconRecursiveEnabled(boolean b) {
        this.isIconRecursiveEnabled = b;
        this.revalidate();
        this.repaint();
    }

    public void setStrCounterEnabled(boolean b) {
        this.isStrCounterEnabled = b;
        this.revalidate();
        this.repaint();
    }
}

