/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import javax.swing.SwingUtilities;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoCanvas;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoLine;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoUnit;
import org.eclipse.aperi.gui.topo.widget.ITopoAssociationModel;

public abstract class AbstractJTopoLShapedLine
extends AbstractJTopoLine {
    protected AbstractJTopoLShapedLine() {
        this((ITopoAssociationModel)null, true);
    }

    protected AbstractJTopoLShapedLine(ITopoAssociationModel associationModel, boolean isWidgetModelListener) {
        super(associationModel, isWidgetModelListener);
    }

    protected LayoutManager createDefaultLayout() {
        return new DefaultLayout();
    }

    protected class DefaultLayout
    implements LayoutManager {
        protected int gap = 20;

        protected DefaultLayout() {
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 0);
        }

        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        public void layoutContainer(Container parent) {
            if (AbstractJTopoLShapedLine.this.firstPassOfLayout) {
                AbstractJTopoLShapedLine.this.setBounds(0, 0, 1, 1);
                return;
            }
            try {
                ITopoAssociationModel associationModel = (ITopoAssociationModel)AbstractJTopoLShapedLine.this.widgetModel;
                if (associationModel == null) {
                    return;
                }
                AbstractJTopoUnit from = associationModel.getFromWidget().getLastVisibleUnit();
                AbstractJTopoUnit to = associationModel.getToWidget().getLastVisibleUnit();
                AbstractJTopoCanvas.CanvasPanel canvasPanel = AbstractJTopoLShapedLine.this.canvas.getCanvasPanel();
                if (from != to) {
                    Point fromP = null;
                    Point toP = null;
                    fromP = from.getConnectingPoint();
                    toP = to.getConnectingPoint();
                    fromP = SwingUtilities.convertPoint(from.getParent(), fromP, canvasPanel);
                    toP = SwingUtilities.convertPoint(to.getParent(), toP, canvasPanel);
                    Rectangle r = this.setLShapeLine(fromP, toP);
                    r = SwingUtilities.convertRectangle(canvasPanel, r, parent.getParent());
                    AbstractJTopoLShapedLine.this.setBounds(r);
                }
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }

        protected Rectangle setLShapeLine(Point p1, Point p2) {
            try {
                Rectangle r1 = new Rectangle(p1.x - 2, p1.y - 2, 4, 4);
                Rectangle r2 = new Rectangle(p2.x - 2, p2.y - 2, 4, 4);
                Rectangle r = r1.union(r2);
                Point p3 = new Point(p1.x, p2.y);
                AbstractJTopoLShapedLine.this.lineV.removeAllElements();
                AbstractJTopoLShapedLine.this.lineV.add(new Line2D.Float(p1.x - r.x, p1.y - r.y, p3.x - r.x, p3.y - r.y));
                AbstractJTopoLShapedLine.this.lineV.add(new Line2D.Float(p3.x - r.x, p3.y - r.y, p2.x - r.x, p2.y - r.y));
                AbstractJTopoLShapedLine.this.dot1.setRect(r1.x - r.x, r1.y - r.y, r1.width, r1.height);
                AbstractJTopoLShapedLine.this.dot2.setRect(r2.x - r.x, r2.y - r.y, r2.width, r2.height);
                return r;
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                return new Rectangle(0, 0, 0, 0);
            }
        }
    }
}

