/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JLabel;
import org.eclipse.aperi.gui.topo.model.GraphEntity;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoCanvas;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoContainerWithTitle;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoEntity;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoGroup;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoPoster;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoSummaryWithTitle;
import org.eclipse.aperi.gui.topo.widget.ITopoGroupModel;
import org.eclipse.aperi.gui.topo.widget.ITopoNodeModel;
import org.eclipse.aperi.gui.topo.widget.TopoEventSource;
import org.eclipse.aperi.gui.topo.widget.TopoLayoutUtilities;
import org.eclipse.aperi.gui.topo.widget.TopoResource;

public abstract class AbstractJTopoPosterTab
extends AbstractJTopoGroup {
    protected IndexPanel indexPanel;
    protected BodyPanel bodyPanel;
    protected AbstractJTopoPoster poster;
    protected ML_MinusPlus ml_minusPlus;

    protected AbstractJTopoPosterTab() {
        this((ITopoGroupModel)null, true);
    }

    protected AbstractJTopoPosterTab(ITopoGroupModel groupModel, boolean isWidgetModelListener) {
        super(groupModel, isWidgetModelListener);
        groupModel = (ITopoGroupModel)this.widgetModel;
        this.ml_minusPlus = new ML_MinusPlus();
        this.indexPanel = new IndexPanel(groupModel);
        this.bodyPanel = new BodyPanel(groupModel);
        this.initState();
    }

    private void initState() {
        this.poster = null;
        this.setExpansible(false);
        this.indexPanel.setLogicalParent(this);
        this.indexPanel.getTitlePanel().setLogicalParent(this);
        this.indexPanel.getSummaryPanel().setLogicalParent(this);
        this.bodyPanel.setLogicalParent(this);
        this.bodyPanel.getTitlePanel().setLogicalParent(this);
        this.bodyPanel.getContainerPanel().setLogicalParent(this);
        this.add(this.indexPanel);
    }

    public void resetState() {
        super.resetState();
        this.indexPanel.resetState();
        this.bodyPanel.resetState();
        this.initState();
    }

    public void setSessionModel(AbstractJTopoCanvas canvas, String scope) {
        super.setSessionModel(canvas, scope);
        this.indexPanel.setSessionModel(canvas, scope);
        this.bodyPanel.setSessionModel(canvas, scope);
    }

    public void setDataModel(GraphEntity focusEntity) {
        super.setDataModel(focusEntity);
        this.indexPanel.setDataModel(focusEntity);
        this.bodyPanel.setDataModel(focusEntity);
    }

    public IndexPanel getIndexPanel() {
        return this.indexPanel;
    }

    public BodyPanel getBodyPanel() {
        return this.bodyPanel;
    }

    public void modelChanged() {
        this.indexPanel.modelChanged();
        this.bodyPanel.modelChanged();
    }

    public void selectionChanged() {
        this.indexPanel.selectionChanged();
        this.bodyPanel.selectionChanged();
    }

    public void highlightChanged() {
        this.indexPanel.highlightChanged();
        this.bodyPanel.highlightChanged();
    }

    public void setExpansible(boolean b) {
        super.setExpansible(b);
        if (this.isExpansible) {
            this.setExpanded(this.isExpanded);
        } else {
            this.indexPanel.labelMinusPlus.setVisible(false);
            this.bodyPanel.setVisible(false);
            this.revalidate();
            this.repaint();
            this.bodyPanel.revalidate();
            this.bodyPanel.repaint();
        }
    }

    public void setExpanded(boolean b) {
        super.setExpanded(b);
        if (this.isExpanded) {
            this.indexPanel.labelMinusPlus.setIcon(TopoResource.ICON_BOX_MINUS);
            this.indexPanel.labelMinusPlus.setVisible(true);
            this.bodyPanel.setVisible(true);
        } else {
            this.indexPanel.labelMinusPlus.setIcon(TopoResource.ICON_BOX_PLUS);
            this.indexPanel.labelMinusPlus.setVisible(true);
            this.bodyPanel.setVisible(false);
        }
        this.revalidate();
        this.repaint();
        this.bodyPanel.revalidate();
        this.bodyPanel.repaint();
    }

    public void setLogicalParent(AbstractJTopoEntity logicalParent) {
        this.logicalParent = logicalParent;
        this.poster = (AbstractJTopoPoster)logicalParent;
    }

    public AbstractJTopoPoster getPoster() {
        return this.poster;
    }

    public void setPoster(AbstractJTopoPoster poster) {
        this.setLogicalParent(poster);
    }

    public Vector getLogicalChilds() {
        return this.bodyPanel.getEntities();
    }

    public boolean isContainLogicalChild(AbstractJTopoEntity entity) {
        return this.bodyPanel.isContainEntity(entity);
    }

    public void addLogicalChild(AbstractJTopoEntity entity) {
        AbstractJTopoPosterTab oldLogicalParent = (AbstractJTopoPosterTab)entity.getLogicalParent();
        if (oldLogicalParent != null) {
            oldLogicalParent.removeLogicalChild(entity);
        }
        entity.setLogicalParent(this);
        this.bodyPanel.addEntity(entity);
        this.setExpansible(this.isContainNonfilterable());
    }

    public void removeLogicalChild(AbstractJTopoEntity entity) {
        if (entity.getLogicalParent() == this) {
            entity.setLogicalParent(null);
        }
        this.bodyPanel.removeEntity(entity);
        this.setExpansible(this.isContainNonfilterable());
    }

    public void removeAllLogicalChilds() {
        Vector v = this.bodyPanel.getEntities();
        for (int i = 0; i < v.size(); ++i) {
            AbstractJTopoEntity entity = (AbstractJTopoEntity)v.elementAt(i);
            if (entity.getLogicalParent() != this) continue;
            entity.setLogicalParent(null);
        }
        this.bodyPanel.removeAllEntities();
        this.setExpansible(false);
    }

    public void setOverlayHealthEnabled(boolean b) {
        this.indexPanel.setOverlayHealthEnabled(b);
        this.bodyPanel.setOverlayHealthEnabled(b);
    }

    public void setOverlayPerfEnabled(boolean b) {
        this.indexPanel.setOverlayPerfEnabled(b);
        this.bodyPanel.setOverlayPerfEnabled(b);
    }

    public void setArrange(AbstractJTopoCanvas.ArrangeRecord r) {
        this.indexPanel.setArrange(r);
        this.bodyPanel.setArrange(r);
    }

    protected void handleMinusPlusMouseClick(MouseEvent e) {
        if (!e.isMetaDown()) {
            this.setExpanded(!this.isExpanded);
        } else {
            this.handleMouseClick(e);
        }
    }

    protected LayoutManager createDefaultLayout() {
        return new DefaultLayout();
    }

    protected class DefaultLayout
    extends TopoLayoutUtilities.VerticalLayout {
    }

    protected class BodyPanel
    extends AbstractJTopoContainerWithTitle {
        protected JLabel labelMinusPlus;

        public BodyPanel(ITopoNodeModel nodeModel) {
            super(nodeModel, false);
            nodeModel = (ITopoGroupModel)this.widgetModel;
            this.labelMinusPlus = new JLabel();
            this.labelMinusPlus.setIcon(TopoResource.ICON_BOX_MINUS);
            this.add((Component)this.labelMinusPlus, 0);
            this.labelMinusPlus.addMouseListener(AbstractJTopoPosterTab.this.ml_minusPlus);
            this.labelMinusPlus.addMouseListener(this.mlDrag);
            this.labelMinusPlus.addMouseMotionListener(this.mlDrag);
            this.containerPanel.setLayout(new TopoLayoutUtilities.HorizontalLayout());
        }

        protected void reattach() {
        }

        protected LayoutManager createDefaultLayout() {
            return new DefaultLayout();
        }

        protected class DefaultLayout
        implements LayoutManager {
            private int spacingForMinusPlus = 10;

            public void addLayoutComponent(String name, Component comp) {
            }

            public void removeLayoutComponent(Component comp) {
            }

            public Dimension preferredLayoutSize(Container parent) {
                Dimension dim = new Dimension(0, 0);
                Insets insets = parent.getInsets();
                dim.width += insets.left + insets.right;
                dim.height += insets.top + insets.bottom;
                int w = 0;
                int h = 0;
                Dimension d = BodyPanel.this.titlePanel.getPreferredSize();
                w += d.width;
                h += d.height;
                d = BodyPanel.this.containerPanel.getPreferredSize();
                w = d.width > (w += this.spacingForMinusPlus) ? d.width : w;
                dim.width += w;
                dim.height += (h += d.height);
                return dim;
            }

            public Dimension minimumLayoutSize(Container parent) {
                return this.preferredLayoutSize(parent);
            }

            public void layoutContainer(Container parent) {
                Insets insets = parent.getInsets();
                int nextX = insets.left;
                int nextY = insets.top;
                Dimension d = BodyPanel.this.titlePanel.getPreferredSize();
                Rectangle r = new Rectangle();
                r.x = nextX;
                r.y = nextY;
                r.width = parent.getWidth() - insets.left - insets.right;
                r.height = d.height;
                BodyPanel.this.titlePanel.setBounds(r);
                nextY += BodyPanel.this.titlePanel.getHeight();
                d = BodyPanel.this.labelMinusPlus.getPreferredSize();
                r = new Rectangle();
                r.x = parent.getWidth() - insets.right - d.width / 2 - 1;
                r.y = insets.top - d.height / 2;
                r.width = d.width;
                r.height = d.height;
                BodyPanel.this.labelMinusPlus.setBounds(r);
                d = BodyPanel.this.containerPanel.getPreferredSize();
                r = new Rectangle();
                r.x = nextX;
                r.y = nextY;
                r.width = BodyPanel.this.titlePanel.getWidth();
                r.height = d.height;
                BodyPanel.this.containerPanel.setBounds(r);
            }
        }
    }

    protected class IndexPanel
    extends AbstractJTopoSummaryWithTitle {
        protected JLabel labelMinusPlus;

        public IndexPanel(ITopoGroupModel groupModel) {
            super(groupModel, false);
            groupModel = (ITopoGroupModel)this.widgetModel;
            this.labelMinusPlus = new JLabel();
            this.add((Component)this.labelMinusPlus, 0);
            this.labelMinusPlus.addMouseListener(AbstractJTopoPosterTab.this.ml_minusPlus);
            this.labelMinusPlus.addMouseListener(this.mlDrag);
            this.labelMinusPlus.addMouseMotionListener(this.mlDrag);
        }

        protected void reattach() {
        }

        protected LayoutManager createDefaultLayout() {
            return new DefaultLayout();
        }

        protected class DefaultLayout
        implements LayoutManager {
            private int spacingForMinusPlus = 10;

            public void addLayoutComponent(String name, Component comp) {
            }

            public void removeLayoutComponent(Component comp) {
            }

            public Dimension preferredLayoutSize(Container parent) {
                Dimension dim = new Dimension(0, 0);
                Insets insets = parent.getInsets();
                dim.width += insets.left + insets.right;
                dim.height += insets.top + insets.bottom;
                int w = 0;
                int h = 0;
                Dimension d = IndexPanel.this.titlePanel.getPreferredSize();
                w += d.width;
                h += d.height;
                d = IndexPanel.this.summaryPanel.getPreferredSize();
                w = d.width > (w += this.spacingForMinusPlus) ? d.width : w;
                dim.width += w;
                dim.height += (h += d.height);
                return dim;
            }

            public Dimension minimumLayoutSize(Container parent) {
                return this.preferredLayoutSize(parent);
            }

            public void layoutContainer(Container parent) {
                Insets insets = parent.getInsets();
                int nextX = insets.left;
                int nextY = insets.top;
                Dimension d = IndexPanel.this.titlePanel.getPreferredSize();
                Rectangle r = new Rectangle();
                r.x = nextX;
                r.y = nextY;
                r.width = parent.getWidth() - insets.left - insets.right;
                r.height = d.height;
                IndexPanel.this.titlePanel.setBounds(r);
                nextY += IndexPanel.this.titlePanel.getHeight();
                d = IndexPanel.this.labelMinusPlus.getPreferredSize();
                r = new Rectangle();
                r.x = parent.getWidth() - insets.right - d.width / 2 - 1;
                r.y = insets.top - d.height / 2;
                r.width = d.width;
                r.height = d.height;
                IndexPanel.this.labelMinusPlus.setBounds(r);
                d = IndexPanel.this.summaryPanel.getPreferredSize();
                r = new Rectangle();
                r.x = nextX;
                r.y = nextY;
                r.width = IndexPanel.this.titlePanel.getWidth();
                r.height = d.height;
                IndexPanel.this.summaryPanel.setBounds(r);
            }
        }
    }

    protected class ML_MinusPlus
    extends MouseAdapter {
        protected ML_MinusPlus() {
        }

        public void mouseClicked(MouseEvent e) {
            e.setSource(new TopoEventSource(e));
            AbstractJTopoPosterTab.this.handleMinusPlusMouseClick(e);
        }
    }
}

