/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.topo.model.GraphEntity;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.model.GraphModelConstant;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputer;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputerGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputerSummary;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabricSummary;
import org.eclipse.aperi.gui.topo.model.bean.GraphOther;
import org.eclipse.aperi.gui.topo.model.bean.GraphOtherGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphOtherSummary;
import org.eclipse.aperi.gui.topo.model.bean.GraphStorageSummary;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystemGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitchGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitchSummary;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeLibrary;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeLibraryGroup;
import org.eclipse.aperi.gui.topo.util.GraphDebug;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoBase;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoTable;
import org.eclipse.aperi.gui.topo.widget.ControllerApp;
import org.eclipse.aperi.gui.topo.widget.ControllerView;
import org.eclipse.aperi.gui.topo.widget.DefaultTopoTableModel;
import org.eclipse.aperi.gui.topo.widget.JTopoApp;
import org.eclipse.aperi.gui.topo.widget.JTopoTableConnectionL1;
import org.eclipse.aperi.gui.topo.widget.JTopoTableConnectionL2;
import org.eclipse.aperi.gui.topo.widget.JTopoTableZone;
import org.eclipse.aperi.gui.topo.widget.JTopoTabularOverview;
import org.eclipse.aperi.gui.topo.widget.PinList;
import org.eclipse.aperi.gui.topo.widget.TopoResource;
import org.eclipse.aperi.gui.topo.widget.TopoSetting;

public abstract class AbstractJTopoTabular
extends AbstractJTopoBase {
    protected static final String TABLE_OVERVIEW = GuiUtil.getString("TOPO_LABEL_ENTITY_TOPOLOGY");
    protected static final String TABLE_FABRIC = GuiUtil.getString("TOPO_LABEL_ENTITY_FABRIC");
    protected static final String TABLE_COMPUTER = GuiUtil.getString("TOPO_LABEL_ENTITY_COMPUTER");
    protected static final String TABLE_SWITCH = GuiUtil.getString("TOPO_LABEL_ENTITY_SWITCH");
    protected static final String TABLE_SUBSYSTEM = GuiUtil.getString("TOPO_LABEL_ENTITY_SUBSYSTEM");
    protected static final String TABLE_TAPELIBRARY = GuiUtil.getString("TOPO_LABEL_ENTITY_TAPELIBRARY");
    protected static final String TABLE_OTHER = GuiUtil.getString("TOPO_LABEL_ENTITY_OTHER") + "/" + GuiUtil.getString("TOPO_LABEL_ENTITY_UNKNOWN");
    protected static final String TABLE_HBA = GuiUtil.getString("TOPO_LABEL_ENTITY_HBA");
    protected static final String TABLE_FCPORT = GuiUtil.getString("TOPO_LABEL_ENTITY_FCPORT");
    protected static final String TABLE_DISK = GuiUtil.getString("TOPO_LABEL_ENTITY_DISK");
    protected static final String TABLE_POOL = GuiUtil.getString("TOPO_LABEL_ENTITY_POOL");
    protected static final String TABLE_VOLUME = GuiUtil.getString("TOPO_LABEL_ENTITY_VOLUME");
    protected static final String TABLE_LOGICALVOLUME = GuiUtil.getString("TOPO_LABEL_ENTITY_LOGICALVOLUME");
    protected static final String TABLE_LUN = GuiUtil.getString("TOPO_LABEL_ENTITY_LUN");
    protected static final String TABLE_FILESYSTEM = GuiUtil.getString("TOPO_LABEL_ENTITY_FILESYSTEM");
    protected static final String TABLE_TABLESPACE = GuiUtil.getString("TOPO_LABEL_ENTITY_TABLESPACE");
    protected static final String TABLE_TAPEDRIVE = GuiUtil.getString("TOPO_LABEL_ENTITY_TAPEDRIVE");
    protected static final String TABLE_MEDIACHANGER = GuiUtil.getString("TOPO_LABEL_ENTITY_MEDIACHANGER");
    protected static final String TABLE_CONNECTION = GuiUtil.getString("TOPO_LABEL_ENTITY_CONNECTION");
    protected static final String TABLE_ZONE = GuiUtil.getString("TOPO_LABEL_ENTITY_ZONE");
    protected ControllerView controllerView;
    protected GraphModel dataModel;
    protected JTabbedPane tabbedPane;
    protected JPanel actionP;
    protected JComboBox actionCBDefault;
    protected JComboBox actionCBConnection;
    protected JComboBox actionCBZone;
    protected Action actionExandAll;
    protected Action actionCollapseAll;
    protected Action actionCloseView;
    protected Action actionCloseAllViews;
    protected Action actionClearHighlights;
    protected Action actionRefreshView;
    protected Action actionRefreshAllViews;
    protected Action actionGlobalSetting;
    protected Action actionRefreshSetting;
    protected JComboBox locateCB;

    protected AbstractJTopoTabular() {
        this.setLayout(new BorderLayout());
        JPanel toolP = new JPanel();
        toolP.setBorder(LineBorder.createGrayLineBorder());
        toolP.setLayout(new BorderLayout());
        this.add((Component)toolP, "North");
        this.actionP = new JPanel();
        this.actionP.setLayout(new FlowLayout(0));
        toolP.add((Component)this.actionP, "West");
        JLabel actionLabel1 = new JLabel(GuiUtil.getString("TOPO_LABEL_TABULAR_ACTION") + ": ");
        this.actionP.add(actionLabel1);
        this.actionExandAll = new Action_ExpandAll();
        this.actionCollapseAll = new Action_CollapseAll();
        this.actionCloseView = new Action_CloseView();
        this.actionCloseAllViews = new Action_CloseAllViews();
        this.actionClearHighlights = new Action_ClearHighlights();
        this.actionRefreshView = new Action_RefreshView();
        this.actionRefreshAllViews = new Action_RefreshAllViews();
        this.actionGlobalSetting = new Action_GlobalSetting();
        this.actionRefreshSetting = new Action_RefreshSetting();
        this.actionCBDefault = new JComboBox();
        this.actionP.add(this.actionCBDefault);
        this.actionCBDefault.addActionListener(new AL_ActionCB());
        ActionMap actionMap = this.actionCBDefault.getActionMap();
        actionMap.put(this.actionExandAll.getValue("Name"), this.actionExandAll);
        actionMap.put(this.actionCollapseAll.getValue("Name"), this.actionCollapseAll);
        actionMap.put(this.actionCloseView.getValue("Name"), this.actionCloseView);
        actionMap.put(this.actionCloseAllViews.getValue("Name"), this.actionCloseAllViews);
        actionMap.put(this.actionClearHighlights.getValue("Name"), this.actionClearHighlights);
        actionMap.put(this.actionRefreshView.getValue("Name"), this.actionRefreshView);
        actionMap.put(this.actionRefreshAllViews.getValue("Name"), this.actionRefreshAllViews);
        actionMap.put(this.actionGlobalSetting.getValue("Name"), this.actionGlobalSetting);
        actionMap.put(this.actionRefreshSetting.getValue("Name"), this.actionRefreshSetting);
        this.actionCBConnection = new JComboBox();
        this.actionP.add(this.actionCBConnection);
        this.actionCBConnection.addActionListener(new AL_ActionCB());
        actionMap = this.actionCBConnection.getActionMap();
        actionMap.put(this.actionCloseView.getValue("Name"), this.actionCloseView);
        actionMap.put(this.actionCloseAllViews.getValue("Name"), this.actionCloseAllViews);
        actionMap.put(this.actionClearHighlights.getValue("Name"), this.actionClearHighlights);
        actionMap.put(this.actionRefreshView.getValue("Name"), this.actionRefreshView);
        actionMap.put(this.actionRefreshAllViews.getValue("Name"), this.actionRefreshAllViews);
        actionMap.put(this.actionGlobalSetting.getValue("Name"), this.actionGlobalSetting);
        actionMap.put(this.actionRefreshSetting.getValue("Name"), this.actionRefreshSetting);
        this.actionCBZone = new JComboBox();
        this.actionP.add(this.actionCBZone);
        this.actionCBZone.addActionListener(new AL_ActionCB());
        actionMap = this.actionCBZone.getActionMap();
        actionMap.put(this.actionExandAll.getValue("Name"), this.actionExandAll);
        actionMap.put(this.actionCollapseAll.getValue("Name"), this.actionCollapseAll);
        actionMap.put(this.actionCloseView.getValue("Name"), this.actionCloseView);
        actionMap.put(this.actionCloseAllViews.getValue("Name"), this.actionCloseAllViews);
        actionMap.put(this.actionClearHighlights.getValue("Name"), this.actionClearHighlights);
        actionMap.put(this.actionRefreshView.getValue("Name"), this.actionRefreshView);
        actionMap.put(this.actionRefreshAllViews.getValue("Name"), this.actionRefreshAllViews);
        actionMap.put(this.actionGlobalSetting.getValue("Name"), this.actionGlobalSetting);
        actionMap.put(this.actionRefreshSetting.getValue("Name"), this.actionRefreshSetting);
        JPanel locateP = new JPanel();
        locateP.setLayout(new FlowLayout(0));
        toolP.add((Component)locateP, "East");
        JLabel locateLabel1 = new JLabel(GuiUtil.getString("TOPO_LABEL_TABULAR_LOCATE") + ": ");
        locateP.add(locateLabel1);
        this.locateCB = new JComboBox();
        this.locateCB.setEditable(true);
        this.locateCB.setFont(TopoResource.FONT_PLAIN);
        this.locateCB.addActionListener(new Action_Locate());
        locateP.add(this.locateCB);
        JButton locateButton = new JButton(GuiUtil.getString("TOPO_LABEL_TABULAR_LOCATE_GO"));
        locateButton.addActionListener(new Action_Locate_Find());
        locateP.add(locateButton);
        this.tabbedPane = new JTabbedPane();
        this.add((Component)this.tabbedPane, "Center");
        this.tabbedPane.addChangeListener(new CL_TabSelected());
        this.updateActionDropdownList(null);
        this.addGlobalActionForConnectionTable();
        this.addGlobalActionForZoneTable();
    }

    private void initState() {
        this.controllerView = null;
        this.dataModel = null;
        if (this.tabbedPane.getTabCount() > 0) {
            this.tabbedPane.setSelectedIndex(0);
        }
    }

    public void resetState() {
        this.initState();
    }

    protected void reattach() {
    }

    public ControllerView getControllerView() {
        return this.controllerView;
    }

    public void setSessionModel(ControllerView controllerView) {
        this.controllerView = controllerView;
        TopoSetting setting = controllerView.getControllerApp().getTopoSetting();
        this.setOverlayHealthEnabled(setting.isOverlayHealthEnabled());
        this.setOverlayPerfEnabled(setting.isOverlayPerfEnabled());
    }

    public GraphModel getDataModel() {
        return this.dataModel;
    }

    public void setDataModel(GraphModel dataModel) {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("AbstractJTopoTabular, setDataModel()");
        }
        if (dataModel == null) {
            if (GraphDebug.isErrorVisible()) {
                GraphDebug.error("AbstractJTopoTabular.setModel(), dataModel=null");
            }
            return;
        }
        this.dataModel = dataModel;
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            AbstractJTopoTable table = (AbstractJTopoTable)this.tabbedPane.getComponentAt(i);
            table.setDataModel(dataModel);
        }
        this.updateContainer();
    }

    public JComboBox getActionCBDefault() {
        return this.actionCBDefault;
    }

    public JComboBox getActionCBConnection() {
        return this.actionCBConnection;
    }

    public JComboBox getActionCBZone() {
        return this.actionCBZone;
    }

    protected void applySelection(ControllerView.SelectionDelta delta) {
        int firstIndex = -1;
        boolean foundInCurrentTab = false;
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            boolean foundClicking;
            AbstractJTopoTable table = (AbstractJTopoTable)this.tabbedPane.getComponentAt(i);
            if (table instanceof JTopoTableZone || !(foundClicking = table.applySelection(delta))) continue;
            if (firstIndex == -1) {
                firstIndex = i;
            }
            if (this.tabbedPane.getSelectedIndex() != i) continue;
            foundInCurrentTab = true;
        }
        if (firstIndex != -1 && !foundInCurrentTab) {
            this.tabbedPane.setSelectedIndex(firstIndex);
        }
        this.updateActionDropdownList(delta.getClickedEntityID());
    }

    protected void applyHighlight(ControllerView.HighlightDelta delta) {
    }

    protected void applyLocate(ControllerView.LocateDelta delta) {
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            AbstractJTopoTable table = (AbstractJTopoTable)this.tabbedPane.getComponentAt(i);
            table.applyLocate(delta);
        }
    }

    protected void setShowConnectionEnabled(boolean b) {
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            AbstractJTopoTable table = (AbstractJTopoTable)this.tabbedPane.getComponentAt(i);
            table.setShowConnectionEnabled(b);
        }
    }

    protected void setShowZoneEnabled(boolean b) {
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            int previousSelected;
            String tabTitle = this.tabbedPane.getTitleAt(i);
            if (!tabTitle.equals(TABLE_ZONE)) continue;
            this.tabbedPane.setEnabledAt(i, b);
            if (b || (previousSelected = this.tabbedPane.getSelectedIndex()) != i) continue;
            this.tabbedPane.setSelectedIndex(0);
        }
    }

    public void setOverlayHealthEnabled(boolean b) {
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            AbstractJTopoTable table = (AbstractJTopoTable)this.tabbedPane.getComponentAt(i);
            table.setOverlayHealthEnabled(b);
        }
    }

    public void setOverlayPerfEnabled(boolean b) {
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            AbstractJTopoTable table = (AbstractJTopoTable)this.tabbedPane.getComponentAt(i);
            table.setOverlayPerfEnabled(b);
        }
    }

    public void setFilteringLevel(int filteringLevel) {
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            AbstractJTopoTable table = (AbstractJTopoTable)this.tabbedPane.getComponentAt(i);
            table.setFilteringLevel(filteringLevel);
        }
    }

    public void setPinList(PinList pinList) {
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            AbstractJTopoTable table = (AbstractJTopoTable)this.tabbedPane.getComponentAt(i);
            table.setPinnedList(pinList);
        }
    }

    public abstract AbstractJTopoTable findTable(GraphEntity.ID var1);

    public DefaultTopoTableModel.MemberNode getFirstMember(GraphEntity.ID nodeID) {
        AbstractJTopoTable table;
        DefaultTopoTableModel tableModel;
        DefaultTopoTableModel.MemberNode member = null;
        for (int i = 0; i < this.tabbedPane.getTabCount() && (member = (tableModel = (table = (AbstractJTopoTable)this.tabbedPane.getComponentAt(i)).getTableModel()).findMemberNode(nodeID)) == null; ++i) {
        }
        return member;
    }

    public Vector getAllMembers(GraphEntity.ID nodeID) {
        Vector<DefaultTopoTableModel.MemberNode> v = new Vector<DefaultTopoTableModel.MemberNode>();
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            AbstractJTopoTable table = (AbstractJTopoTable)this.tabbedPane.getComponentAt(i);
            DefaultTopoTableModel tableModel = table.getTableModel();
            DefaultTopoTableModel.MemberNode member = tableModel.findMemberNode(nodeID);
            if (member == null) continue;
            v.add(member);
        }
        return v;
    }

    public void updateActionDropdownList(GraphEntity.ID clickedNodeID) {
        ActionMap actionMap = this.actionCBDefault.getActionMap();
        DefaultComboBoxModel cbModel = (DefaultComboBoxModel)this.actionCBDefault.getModel();
        cbModel.removeAllElements();
        DefaultTopoTableModel.MemberNode clickedMember = this.getFirstMember(clickedNodeID);
        if (clickedMember != null) {
            if (clickedMember instanceof DefaultTopoTableModel.GroupNode) {
                Vector selectionV = new Vector();
                for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
                    AbstractJTopoTable table = (AbstractJTopoTable)this.tabbedPane.getComponentAt(i);
                    DefaultTopoTableModel tableModel = table.getTableModel();
                    DefaultTopoTableModel.RootNode root = tableModel.getRootNode();
                    this.updateActionDropdownList_groupSelectedHelper(root, selectionV);
                }
                if (selectionV.size() == 1) {
                    AbstractAction action;
                    DefaultTopoTableModel.GroupNode group = (DefaultTopoTableModel.GroupNode)selectionV.elementAt(0);
                    GraphEntity.ID nodeID = group.getRef();
                    if (nodeID instanceof GraphComputerGroup.ID || nodeID instanceof GraphSwitchGroup.ID || nodeID instanceof GraphSubsystemGroup.ID || nodeID instanceof GraphTapeLibraryGroup.ID || nodeID instanceof GraphOtherGroup.ID) {
                        action = new Action_OpenDetailView(group);
                        actionMap.put(action.getValue("Name"), action);
                        cbModel.addElement(action.getValue("Name"));
                    }
                    if (nodeID instanceof GraphFabric.ID) {
                        action = new Action_LaunchDetailPanel(group);
                        actionMap.put(action.getValue("Name"), action);
                        cbModel.addElement(action.getValue("Name"));
                    }
                }
                if (selectionV.size() > 0) {
                    boolean doIt = true;
                    Vector nodeV = new Vector();
                    for (int i = 0; i < selectionV.size(); ++i) {
                        DefaultTopoTableModel.MemberNode member = (DefaultTopoTableModel.MemberNode)selectionV.elementAt(i);
                        GraphEntity.ID nodeID = member.getRef();
                        GraphEntity node = this.dataModel.get(nodeID);
                        if (node instanceof GraphFabric && GraphModelConstant.STATUS_MISSING.equals(node.getHealthStatus())) continue;
                        doIt = false;
                        break;
                    }
                    if (doIt && selectionV.size() > 0) {
                        Action_RemoveMissingEntity action = new Action_RemoveMissingEntity(selectionV);
                        actionMap.put(action.getValue("Name"), action);
                        cbModel.addElement(action.getValue("Name"));
                    }
                }
            } else {
                AbstractAction action;
                Vector selectionV = new Vector();
                for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
                    AbstractJTopoTable table = (AbstractJTopoTable)this.tabbedPane.getComponentAt(i);
                    DefaultTopoTableModel tableModel = table.getTableModel();
                    DefaultTopoTableModel.RootNode root = tableModel.getRootNode();
                    this.updateActionDropdownList_memberSelectedHelper(root, selectionV);
                }
                if (selectionV.size() == 1) {
                    DefaultTopoTableModel.MemberNode member = (DefaultTopoTableModel.MemberNode)selectionV.elementAt(0);
                    GraphEntity.ID nodeID = member.getRef();
                    if (nodeID instanceof GraphFabric.ID || nodeID instanceof GraphSwitch.ID || nodeID instanceof GraphSubsystem.ID || nodeID instanceof GraphTapeLibrary.ID || nodeID instanceof GraphComputer.ID || nodeID instanceof GraphOther.ID || nodeID instanceof GraphFabricSummary.ID || nodeID instanceof GraphComputerSummary.ID || nodeID instanceof GraphSwitchSummary.ID || nodeID instanceof GraphStorageSummary.ID || nodeID instanceof GraphOtherSummary.ID) {
                        action = new Action_OpenDetailView(member);
                        actionMap.put(action.getValue("Name"), action);
                        cbModel.addElement(action.getValue("Name"));
                    }
                    if (nodeID instanceof GraphFabric.ID || nodeID instanceof GraphSwitch.ID || nodeID instanceof GraphSubsystem.ID || nodeID instanceof GraphTapeLibrary.ID || nodeID instanceof GraphComputer.ID || nodeID instanceof GraphOther.ID) {
                        action = new Action_LaunchDetailPanel(member);
                        actionMap.put(action.getValue("Name"), action);
                        cbModel.addElement(action.getValue("Name"));
                    }
                    if (nodeID instanceof GraphSwitch.ID || nodeID instanceof GraphSubsystem.ID || nodeID instanceof GraphTapeLibrary.ID) {
                        action = new Action_LaunchElementManager(member);
                        actionMap.put(action.getValue("Name"), action);
                        cbModel.addElement(action.getValue("Name"));
                    }
                }
                if (selectionV.size() > 0) {
                    GraphEntity.ID nodeID;
                    DefaultTopoTableModel.MemberNode member;
                    int i;
                    boolean doIt = true;
                    for (i = 0; i < selectionV.size(); ++i) {
                        member = (DefaultTopoTableModel.MemberNode)selectionV.elementAt(i);
                        nodeID = member.getRef();
                        if (nodeID instanceof GraphSwitch.ID || nodeID instanceof GraphSubsystem.ID || nodeID instanceof GraphTapeLibrary.ID || nodeID instanceof GraphComputer.ID || nodeID instanceof GraphOther.ID) continue;
                        doIt = false;
                        break;
                    }
                    if (doIt && selectionV.size() > 0) {
                        boolean pin = true;
                        for (int i2 = 0; i2 < selectionV.size(); ++i2) {
                            DefaultTopoTableModel.MemberNode member2 = (DefaultTopoTableModel.MemberNode)selectionV.elementAt(i2);
                            GraphEntity.ID nodeID2 = member2.getRef();
                            if (!this.controllerView.getControllerApp().getPinList().isInPinList(nodeID2)) continue;
                            pin = false;
                            break;
                        }
                        action = new Action_Pin(selectionV, pin);
                        actionMap.put(action.getValue("Name"), action);
                        cbModel.addElement(action.getValue("Name"));
                    }
                    doIt = true;
                    for (i = 0; i < selectionV.size(); ++i) {
                        member = (DefaultTopoTableModel.MemberNode)selectionV.elementAt(i);
                        nodeID = member.getRef();
                        GraphEntity node = this.dataModel.get(nodeID);
                        if ((node instanceof GraphSwitch || node instanceof GraphSubsystem || node instanceof GraphTapeLibrary || node instanceof GraphComputer || node instanceof GraphOther || node instanceof GraphFabric) && GraphModelConstant.STATUS_MISSING.equals(node.getHealthStatus())) continue;
                        doIt = false;
                        break;
                    }
                    if (doIt && selectionV.size() > 0) {
                        Action_RemoveMissingEntity action2 = new Action_RemoveMissingEntity(selectionV);
                        actionMap.put(action2.getValue("Name"), action2);
                        cbModel.addElement(action2.getValue("Name"));
                    }
                }
            }
        }
        this.addGlobalActionForDefaultTable();
    }

    protected void updateActionDropdownList_groupSelectedHelper(DefaultTopoTableModel.GroupNode group, Vector selectionV) {
        Vector memberV = group.getMemberVector();
        for (int i = 0; i < memberV.size(); ++i) {
            DefaultTopoTableModel.MemberNode member = (DefaultTopoTableModel.MemberNode)memberV.elementAt(i);
            if (!(member instanceof DefaultTopoTableModel.GroupNode)) continue;
            DefaultTopoTableModel.GroupNode g = (DefaultTopoTableModel.GroupNode)member;
            if (g.isSelected()) {
                selectionV.add(g);
            }
            this.updateActionDropdownList_groupSelectedHelper(g, selectionV);
        }
    }

    protected void updateActionDropdownList_memberSelectedHelper(DefaultTopoTableModel.GroupNode group, Vector selectionV) {
        Vector memberV = group.getMemberVector();
        for (int i = 0; i < memberV.size(); ++i) {
            DefaultTopoTableModel.MemberNode member = (DefaultTopoTableModel.MemberNode)memberV.elementAt(i);
            if (member instanceof DefaultTopoTableModel.GroupNode) {
                DefaultTopoTableModel.GroupNode g = (DefaultTopoTableModel.GroupNode)member;
                this.updateActionDropdownList_memberSelectedHelper(g, selectionV);
                continue;
            }
            if (!member.isSelected()) continue;
            selectionV.add(member);
        }
    }

    protected void addGlobalActionForDefaultTable() {
        DefaultComboBoxModel cbModel = (DefaultComboBoxModel)this.actionCBDefault.getModel();
        cbModel.addElement(this.actionExandAll.getValue("Name"));
        cbModel.addElement(this.actionCollapseAll.getValue("Name"));
        if (!(this instanceof JTopoTabularOverview)) {
            cbModel.addElement(this.actionCloseView.getValue("Name"));
        }
        cbModel.addElement(this.actionCloseAllViews.getValue("Name"));
        cbModel.addElement(this.actionClearHighlights.getValue("Name"));
        cbModel.addElement(this.actionRefreshView.getValue("Name"));
        cbModel.addElement(this.actionRefreshAllViews.getValue("Name"));
        cbModel.addElement(this.actionGlobalSetting.getValue("Name"));
        cbModel.addElement(this.actionRefreshSetting.getValue("Name"));
    }

    protected void addGlobalActionForConnectionTable() {
        DefaultComboBoxModel cbModel = (DefaultComboBoxModel)this.actionCBConnection.getModel();
        cbModel.addElement(this.actionCloseView.getValue("Name"));
        cbModel.addElement(this.actionCloseAllViews.getValue("Name"));
        cbModel.addElement(this.actionClearHighlights.getValue("Name"));
        cbModel.addElement(this.actionRefreshView.getValue("Name"));
        cbModel.addElement(this.actionRefreshAllViews.getValue("Name"));
        cbModel.addElement(this.actionGlobalSetting.getValue("Name"));
        cbModel.addElement(this.actionRefreshSetting.getValue("Name"));
    }

    protected void addGlobalActionForZoneTable() {
        DefaultComboBoxModel cbModel = (DefaultComboBoxModel)this.actionCBZone.getModel();
        cbModel.addElement(this.actionExandAll.getValue("Name"));
        cbModel.addElement(this.actionCollapseAll.getValue("Name"));
        cbModel.addElement(this.actionCloseView.getValue("Name"));
        cbModel.addElement(this.actionCloseAllViews.getValue("Name"));
        cbModel.addElement(this.actionClearHighlights.getValue("Name"));
        cbModel.addElement(this.actionRefreshView.getValue("Name"));
        cbModel.addElement(this.actionRefreshAllViews.getValue("Name"));
        cbModel.addElement(this.actionGlobalSetting.getValue("Name"));
        cbModel.addElement(this.actionRefreshSetting.getValue("Name"));
    }

    public void locate(String pattern) {
        ControllerView.LocateDelta delta = new ControllerView.LocateDelta(pattern, this.controllerView.getLocate());
        if (pattern == null) {
            delta.removeAll();
        } else {
            int firstIndex = -1;
            boolean foundInCurrentTab = false;
            for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
                AbstractJTopoTable table = (AbstractJTopoTable)this.tabbedPane.getComponentAt(i);
                boolean found = table.locate(delta, pattern);
                if (!found) continue;
                if (firstIndex == -1) {
                    firstIndex = i;
                }
                if (this.tabbedPane.getSelectedIndex() != i) continue;
                foundInCurrentTab = true;
            }
            if (!foundInCurrentTab && firstIndex != -1) {
                this.tabbedPane.setSelectedIndex(firstIndex);
            }
        }
        this.controllerView.updateLocate(delta);
    }

    public void openView(DefaultTopoTableModel.MemberNode member) {
        GraphEntity.ID focusEntityID = member.getRef();
        GraphEntity focusEntity = this.dataModel.get(focusEntityID);
        Vector<GraphEntity.ID> childFocusEntityIDV = null;
        if (focusEntity instanceof GraphComputerGroup || focusEntity instanceof GraphSwitchGroup || focusEntity instanceof GraphSubsystemGroup || focusEntity instanceof GraphTapeLibraryGroup || focusEntity instanceof GraphOtherGroup) {
            Vector memberV = ((DefaultTopoTableModel.GroupNode)member).getMemberVector();
            childFocusEntityIDV = new Vector<GraphEntity.ID>();
            for (int i = 0; i < memberV.size(); ++i) {
                DefaultTopoTableModel.MemberNode m = (DefaultTopoTableModel.MemberNode)memberV.elementAt(i);
                GraphEntity.ID childFocusEntityID = m.getRef();
                childFocusEntityIDV.add(childFocusEntityID);
            }
        }
        this.controllerView.getControllerApp().openView(focusEntity, childFocusEntityIDV);
    }

    protected class Action_Locate_Find
    implements ActionListener {
        protected Action_Locate_Find() {
        }

        public void actionPerformed(ActionEvent e) {
            String pattern = (String)AbstractJTopoTabular.this.locateCB.getSelectedItem();
            pattern = pattern.toLowerCase();
            AbstractJTopoTabular.this.controllerView.setLocate(pattern);
        }
    }

    protected class Action_Locate
    implements ActionListener {
        protected Action_Locate() {
        }

        public void actionPerformed(ActionEvent e) {
            String pattern = (String)AbstractJTopoTabular.this.locateCB.getSelectedItem();
            if (pattern == null) {
                AbstractJTopoTabular.this.locate(null);
                return;
            }
            if ((pattern = pattern.trim()).equals("")) {
                AbstractJTopoTabular.this.locate(null);
                return;
            }
            DefaultComboBoxModel cbModel = (DefaultComboBoxModel)AbstractJTopoTabular.this.locateCB.getModel();
            int index = cbModel.getIndexOf(pattern);
            if (index != -1) {
                cbModel.removeElementAt(index);
            }
            cbModel.insertElementAt(pattern, 0);
            AbstractJTopoTabular.this.locateCB.setSelectedIndex(0);
            pattern = pattern.toLowerCase();
            AbstractJTopoTabular.this.controllerView.setLocate(pattern);
        }
    }

    protected class CL_TabSelected
    implements ChangeListener {
        protected CL_TabSelected() {
        }

        public void stateChanged(ChangeEvent e) {
            AbstractJTopoTable table = (AbstractJTopoTable)AbstractJTopoTabular.this.tabbedPane.getSelectedComponent();
            if (table instanceof JTopoTableConnectionL1 || table instanceof JTopoTableConnectionL2) {
                AbstractJTopoTabular.this.actionCBDefault.setVisible(false);
                AbstractJTopoTabular.this.actionCBConnection.setVisible(true);
                AbstractJTopoTabular.this.actionCBZone.setVisible(false);
            } else if (table instanceof JTopoTableZone) {
                AbstractJTopoTabular.this.actionCBDefault.setVisible(false);
                AbstractJTopoTabular.this.actionCBConnection.setVisible(false);
                AbstractJTopoTabular.this.actionCBZone.setVisible(true);
            } else {
                AbstractJTopoTabular.this.actionCBDefault.setVisible(true);
                AbstractJTopoTabular.this.actionCBConnection.setVisible(false);
                AbstractJTopoTabular.this.actionCBZone.setVisible(false);
            }
        }
    }

    protected class Action_PrintPreview
    extends AbstractAction {
        public Action_PrintPreview() {
            this.putValue("Name", GuiUtil.getString("TOPO_LABEL_MENU_CANVAS_PRINTPREVIEW"));
        }

        public void actionPerformed(ActionEvent e) {
        }
    }

    protected class Action_Print
    extends AbstractAction {
        public Action_Print() {
            this.putValue("Name", GuiUtil.getString("TOPO_LABEL_MENU_CANVAS_PRINT"));
        }

        public void actionPerformed(ActionEvent e) {
        }
    }

    protected class Action_RefreshSetting
    extends AbstractAction {
        public Action_RefreshSetting() {
            this.putValue("Name", GuiUtil.getString("TOPO_LABEL_MENU_CANVAS_REFRESHSETTINGS"));
        }

        public void actionPerformed(ActionEvent e) {
            JTopoApp topoApp = AbstractJTopoTabular.this.controllerView.getControllerApp().getTopoApp();
            topoApp.showRefreshSettingDialog();
        }
    }

    protected class Action_GlobalSetting
    extends AbstractAction {
        public Action_GlobalSetting() {
            this.putValue("Name", GuiUtil.getString("TOPO_LABEL_MENU_CANVAS_GLOBALSETTINGS"));
        }

        public void actionPerformed(ActionEvent e) {
            JTopoApp topoApp = AbstractJTopoTabular.this.controllerView.getControllerApp().getTopoApp();
            topoApp.showGlobalSettingDialog();
        }
    }

    protected class Action_ClearHighlights
    extends AbstractAction {
        public Action_ClearHighlights() {
            this.putValue("Name", GuiUtil.getString("TOPO_LABEL_MENU_CANVAS_CLEARHIGHLIGHTS"));
        }

        public void actionPerformed(ActionEvent e) {
            ControllerView.HighlightDelta delta = new ControllerView.HighlightDelta(AbstractJTopoTabular.this.controllerView.getHighlight());
            delta.removeAll();
            AbstractJTopoTabular.this.controllerView.updateHighlight(delta);
            ControllerView.LocateDelta delta2 = new ControllerView.LocateDelta(null, AbstractJTopoTabular.this.controllerView.getLocate());
            delta2.removeAll();
            AbstractJTopoTabular.this.controllerView.updateLocate(delta2);
        }
    }

    protected class Action_CloseAllViews
    extends AbstractAction {
        public Action_CloseAllViews() {
            this.putValue("Name", GuiUtil.getString("TOPO_LABEL_MENU_CANVAS_CLOSEALLVIEWS"));
        }

        public void actionPerformed(ActionEvent e) {
            ControllerApp topoControllerApp = AbstractJTopoTabular.this.controllerView.getControllerApp();
            topoControllerApp.closeAllViews();
        }
    }

    protected class Action_CloseView
    extends AbstractAction {
        public Action_CloseView() {
            this.putValue("Name", GuiUtil.getString("TOPO_LABEL_MENU_CANVAS_CLOSETHISVIEW"));
        }

        public void actionPerformed(ActionEvent e) {
            GraphModel.ID modelID = AbstractJTopoTabular.this.dataModel.getModelID();
            ControllerApp topoControllerApp = AbstractJTopoTabular.this.controllerView.getControllerApp();
            topoControllerApp.closeView(modelID);
        }
    }

    protected class Action_RefreshAllViews
    extends AbstractAction {
        public Action_RefreshAllViews() {
            this.putValue("Name", GuiUtil.getString("TOPO_LABEL_MENU_CANVAS_REFRESHALLVIEWS"));
        }

        public void actionPerformed(ActionEvent e) {
            ControllerApp topoControllerApp = AbstractJTopoTabular.this.controllerView.getControllerApp();
            topoControllerApp.refreshAllViews();
        }
    }

    protected class Action_RefreshView
    extends AbstractAction {
        public Action_RefreshView() {
            this.putValue("Name", GuiUtil.getString("TOPO_LABEL_MENU_CANVAS_REFRESHTHISVIEW"));
        }

        public void actionPerformed(ActionEvent e) {
            GraphModel.ID modelID = AbstractJTopoTabular.this.dataModel.getModelID();
            ControllerApp topoControllerApp = AbstractJTopoTabular.this.controllerView.getControllerApp();
            topoControllerApp.refreshView(modelID);
        }
    }

    protected class Action_CollapseAll
    extends AbstractAction {
        public Action_CollapseAll() {
            this.putValue("Name", GuiUtil.getString("TOPO_LABEL_MENU_CANVAS_COLLAPSEALL"));
        }

        public void actionPerformed(ActionEvent e) {
            for (int i = 0; i < AbstractJTopoTabular.this.tabbedPane.getTabCount(); ++i) {
                AbstractJTopoTable table = (AbstractJTopoTable)AbstractJTopoTabular.this.tabbedPane.getComponentAt(i);
                table.collapseAll();
            }
        }
    }

    protected class Action_ExpandAll
    extends AbstractAction {
        public Action_ExpandAll() {
            this.putValue("Name", GuiUtil.getString("TOPO_LABEL_MENU_CANVAS_EXPANDALL"));
        }

        public void actionPerformed(ActionEvent e) {
            for (int i = 0; i < AbstractJTopoTabular.this.tabbedPane.getTabCount(); ++i) {
                AbstractJTopoTable table = (AbstractJTopoTable)AbstractJTopoTabular.this.tabbedPane.getComponentAt(i);
                table.expandAll();
            }
        }
    }

    protected class Action_RemoveMissingEntity
    extends AbstractAction {
        private Vector memberV;

        public Action_RemoveMissingEntity(Vector memberV) {
            this.memberV = memberV;
            this.putValue("Name", GuiUtil.getString("TOPO_LABEL_MENU_UNIT_REMOVE"));
        }

        public void actionPerformed(ActionEvent e) {
            Vector<GraphEntity> nodeV = new Vector<GraphEntity>();
            for (int i = 0; i < this.memberV.size(); ++i) {
                DefaultTopoTableModel.MemberNode member = (DefaultTopoTableModel.MemberNode)this.memberV.elementAt(i);
                GraphEntity.ID nodeID = member.getRef();
                GraphEntity node = AbstractJTopoTabular.this.dataModel.get(nodeID);
                nodeV.add(node);
            }
            ControllerApp topoControllerApp = AbstractJTopoTabular.this.controllerView.getControllerApp();
            topoControllerApp.removeMissingEntity(nodeV);
        }
    }

    protected class Action_LaunchElementManager
    extends AbstractAction {
        private DefaultTopoTableModel.MemberNode member;

        public Action_LaunchElementManager(DefaultTopoTableModel.MemberNode member) {
            this.member = member;
            this.putValue("Name", GuiUtil.getString("TOPO_LABEL_MENU_UNIT_ELEMENTMANAGER"));
        }

        public void actionPerformed(ActionEvent e) {
            GraphEntity.ID nodeID = this.member.getRef();
            GraphEntity node = AbstractJTopoTabular.this.dataModel.get(nodeID);
            ControllerApp topoControllerApp = AbstractJTopoTabular.this.controllerView.getControllerApp();
            topoControllerApp.launchElementManager(node);
        }
    }

    protected class Action_LaunchDetailPanel
    extends AbstractAction {
        private DefaultTopoTableModel.MemberNode member;

        public Action_LaunchDetailPanel(DefaultTopoTableModel.MemberNode member) {
            this.member = member;
            this.putValue("Name", GuiUtil.getString("TOPO_LABEL_MENU_UNIT_DETAIL"));
        }

        public void actionPerformed(ActionEvent e) {
            GraphEntity.ID nodeID = this.member.getRef();
            ControllerApp topoControllerApp = AbstractJTopoTabular.this.controllerView.getControllerApp();
            topoControllerApp.launchDetailPanel(nodeID);
        }
    }

    protected class Action_Pin
    extends AbstractAction {
        private Vector memberV;
        private boolean pinned;

        public Action_Pin(Vector memberV, boolean pinned) {
            this.memberV = memberV;
            this.pinned = pinned;
            if (pinned) {
                this.putValue("Name", GuiUtil.getString("TOPO_LABEL_MENU_UNIT_PINNED"));
            } else {
                this.putValue("Name", GuiUtil.getString("TOPO_LABEL_MENU_UNIT_UNPINNED"));
            }
        }

        public void actionPerformed(ActionEvent e) {
            Vector<GraphEntity.ID> nodeIDV = new Vector<GraphEntity.ID>();
            for (int i = 0; i < this.memberV.size(); ++i) {
                DefaultTopoTableModel.MemberNode member = (DefaultTopoTableModel.MemberNode)this.memberV.elementAt(i);
                GraphEntity.ID nodeID = member.getRef();
                nodeIDV.add(nodeID);
            }
            ControllerApp topoControllerApp = AbstractJTopoTabular.this.controllerView.getControllerApp();
            PinList pinnedList = topoControllerApp.getPinList();
            if (this.pinned) {
                pinnedList.addPins(nodeIDV);
            } else {
                pinnedList.removePins(nodeIDV);
            }
        }
    }

    protected class Action_OpenDetailView
    extends AbstractAction {
        private DefaultTopoTableModel.MemberNode member;

        public Action_OpenDetailView(DefaultTopoTableModel.MemberNode member) {
            this.member = member;
            this.putValue("Name", GuiUtil.getString("TOPO_LABEL_MENU_UNIT_OPEN"));
        }

        public void actionPerformed(ActionEvent e) {
            AbstractJTopoTabular.this.openView(this.member);
        }
    }

    protected class AL_ActionCB
    implements ActionListener {
        private Object oldItem = null;

        protected AL_ActionCB() {
        }

        public void actionPerformed(ActionEvent e) {
            JComboBox cb = (JComboBox)e.getSource();
            Object item = cb.getSelectedItem();
            if (this.oldItem != item) {
                this.oldItem = item;
            } else {
                ActionMap actionMap = cb.getActionMap();
                Action action = actionMap.get(item);
                if (action != null) {
                    action.actionPerformed(e);
                }
            }
        }
    }
}

