/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoIcon;
import org.eclipse.aperi.gui.topo.widget.ITopoNodeModel;
import org.eclipse.aperi.gui.topo.widget.TopoResource;

public abstract class AbstractJTopoTitle
extends AbstractJTopoIcon {
    protected static final int TITLE_HEIGHT = 22;
    protected static final int GAP5 = 5;

    protected AbstractJTopoTitle() {
        this((ITopoNodeModel)null, true);
    }

    protected AbstractJTopoTitle(ITopoNodeModel nodeModel, boolean isWidgetModelListener) {
        super(nodeModel, isWidgetModelListener);
        this.initState();
    }

    private void initState() {
        this.labelMode = 1;
    }

    public void resetState() {
        super.resetState();
        this.initState();
    }

    protected void modelChanged_setSelection() {
        super.modelChanged_setSelection();
        ITopoNodeModel nodeModel = (ITopoNodeModel)this.widgetModel;
        Color color = null;
        color = nodeModel.isSelected() ? TopoResource.COLOR_SELECTED : TopoResource.COLOR_UNSELECTED;
        this.setBackground(color);
    }

    protected void handleMouseClick(MouseEvent e) {
        this.handleMouseClick_regular(e);
    }

    protected void layoutItself() {
        Graphics g = this.getGraphics();
        if (g == null) {
            return;
        }
        if (this.focusEntity == null) {
            return;
        }
        g.setFont(TopoResource.FONT_PLAIN);
        FontMetrics fm = g.getFontMetrics();
        int strLabelW = 0;
        int strLabelH = 0;
        int strOffset = 0;
        if (this.strLabel != null) {
            strLabelW = fm.stringWidth(this.strLabel);
            strLabelH = fm.getHeight();
            strOffset = fm.getAscent();
        }
        Insets insets = this.getInsets();
        int totalWidth = insets.left + insets.right;
        int totalHeight = insets.top + insets.bottom;
        totalWidth += 10;
        if (this.iconHealth != null) {
            totalWidth += this.iconHealth.getIconWidth() + 3;
        }
        if (this.iconPerf != null) {
            totalWidth += this.iconPerf.getIconWidth() + 3;
        }
        totalWidth += 6;
        totalWidth += this.iconType.getIconWidth() + 3;
        totalWidth = this.labelMode == 0 ? (totalWidth += this.maxLabelWidth_compact) : (this.labelMode == 1 ? (totalWidth += strLabelW < this.maxLabelWidth_relax ? strLabelW : this.maxLabelWidth_relax) : (totalWidth += strLabelW));
        if (this.iconPin != null) {
            totalWidth += 3 + this.iconPin.getIconWidth();
        }
        this.preferredSizeD = new Dimension(totalWidth, totalHeight += 22);
        totalWidth = this.getWidth();
        totalHeight = this.getHeight();
        if (totalWidth != 0 && totalHeight != 0) {
            int offsetY;
            int nextX = insets.left + 5;
            int nextY = insets.top;
            int offsetX = totalWidth - insets.left - insets.right - 10;
            if (this.iconHealth != null) {
                offsetX -= this.iconHealth.getIconWidth() + 3;
            }
            if (this.iconPerf != null) {
                offsetX -= this.iconPerf.getIconWidth() + 3;
            }
            offsetX -= 6;
            offsetX -= this.iconType.getIconWidth() + 3;
            if (this.iconPin != null) {
                offsetX -= 3 + this.iconPin.getIconWidth();
            }
            int max = offsetX;
            nextX += (offsetX -= strLabelW) > 0 ? offsetX / 2 : 0;
            if (this.iconHealth != null) {
                offsetY = (totalHeight - insets.top - insets.bottom - this.iconHealth.getIconHeight()) / 2;
                offsetY = offsetY > 0 ? offsetY : 0;
                this.iconHealthR.setBounds(nextX, nextY + offsetY, this.iconHealth.getIconWidth(), this.iconHealth.getIconHeight());
                nextX += this.iconHealth.getIconWidth() + 3;
            } else {
                this.iconHealthR.setBounds(0, 0, 0, 0);
            }
            if (this.iconPerf != null) {
                offsetY = (totalHeight - insets.top - insets.bottom - this.iconPerf.getIconHeight()) / 2;
                offsetY = offsetY > 0 ? offsetY : 0;
                this.iconPerfR.setBounds(nextX, nextY + offsetY, this.iconPerf.getIconWidth(), this.iconPerf.getIconHeight());
                nextX += this.iconPerf.getIconWidth() + 3;
            } else {
                this.iconPerfR.setBounds(0, 0, 0, 0);
            }
            offsetY = (totalHeight - insets.top - insets.bottom - this.iconType.getIconHeight()) / 2;
            offsetY = offsetY > 0 ? offsetY : 0;
            this.iconTypeR.setBounds(nextX += 3, nextY + offsetY, this.iconType.getIconWidth(), this.iconType.getIconHeight());
            nextX += this.iconType.getIconWidth() + 3;
            if (this.strLabel != null) {
                offsetY = (totalHeight - insets.top - insets.bottom - strLabelH) / 2;
                offsetY = offsetY > 0 ? offsetY : 0;
                int w2 = offsetX > 0 ? strLabelW : max;
                this.strLabelP.setLocation(nextX, nextY + offsetY + strOffset);
                this.strLabelR.setBounds(nextX, nextY + offsetY, w2, strLabelH);
                nextX += w2 + 3;
                if (offsetX < 0) {
                    String s;
                    int w;
                    this.clippedStrLabel = "";
                    for (int i = 0; i < this.strLabel.length() && (w = fm.stringWidth(s = this.strLabel.substring(0, i) + "...")) <= max; ++i) {
                        this.clippedStrLabel = s;
                    }
                } else {
                    this.clippedStrLabel = this.strLabel;
                }
            } else {
                this.strLabelR.setBounds(0, 0, 0, 0);
            }
            nextX += 3;
            if (this.iconPin != null) {
                offsetY = (totalHeight - insets.top - insets.bottom - this.iconPin.getIconHeight()) / 2;
                offsetY = offsetY > 0 ? offsetY : 0;
                this.iconPinR.setBounds(nextX, nextY + offsetY, this.iconPin.getIconWidth(), this.iconPin.getIconHeight());
            } else {
                this.iconPinR.setBounds(0, 0, 0, 0);
            }
        }
    }
}

