/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.awt.Container;
import java.awt.LayoutManager;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.SwingUtilities;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.topo.model.GraphEntity;
import org.eclipse.aperi.gui.topo.model.GraphModelPinList;
import org.eclipse.aperi.gui.topo.model.GraphModelUtilities;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputer;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputerSummary;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric2Computer;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric2Other;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric2Subsystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric2Switch;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric2TapeLibrary;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabricSummary;
import org.eclipse.aperi.gui.topo.model.bean.GraphOther;
import org.eclipse.aperi.gui.topo.model.bean.GraphOtherSummary;
import org.eclipse.aperi.gui.topo.model.bean.GraphStorageSummary;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitchSummary;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeLibrary;
import org.eclipse.aperi.gui.topo.util.GraphDebug;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoCanvas;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoEntity;
import org.eclipse.aperi.gui.topo.widget.ITopoPinContainerWidget;
import org.eclipse.aperi.gui.topo.widget.JTopoBoxComputerSummary;
import org.eclipse.aperi.gui.topo.widget.JTopoBoxFabricSummary;
import org.eclipse.aperi.gui.topo.widget.JTopoBoxOtherSummary;
import org.eclipse.aperi.gui.topo.widget.JTopoBoxStorageSummary;
import org.eclipse.aperi.gui.topo.widget.JTopoBoxSwitchSummary;
import org.eclipse.aperi.gui.topo.widget.JTopoView;
import org.eclipse.aperi.gui.topo.widget.PinList;
import org.eclipse.aperi.gui.topo.widget.TopoLayoutUtilities;
import org.eclipse.aperi.gui.topo.widget.WidgetPool;

public class JTopoCanvasOverview
extends AbstractJTopoCanvas {
    protected static final String WIDGET_FABRICSUMMARY = "WIDGET_FABRICSUMMARY";
    protected static final String WIDGET_COMPUTERSUMMARY = "WIDGET_COMPUTERSUMMARY";
    protected static final String WIDGET_SWITCHSUMMARY = "WIDGET_SWITCHSUMMARY";
    protected static final String WIDGET_STORAGESUMMARY = "WIDGET_STORAGESUMMARY";
    protected static final String WIDGET_OTHERSUMMARY = "WIDGET_OTHERSUMMARY";

    public JTopoCanvasOverview() {
        this.widgetH.put(WIDGET_FABRICSUMMARY, new Hashtable());
        this.widgetH.put(WIDGET_COMPUTERSUMMARY, new Hashtable());
        this.widgetH.put(WIDGET_SWITCHSUMMARY, new Hashtable());
        this.widgetH.put(WIDGET_STORAGESUMMARY, new Hashtable());
        this.widgetH.put(WIDGET_OTHERSUMMARY, new Hashtable());
    }

    public String getViewName() {
        return GuiUtil.getString("TOPO_LABEL_VIEW_OVERVIEW");
    }

    protected void reattach() {
        Enumeration otherSummaryEnu;
        Enumeration storageSummaryEnu;
        Enumeration swSummaryEnu;
        Enumeration computerSummaryEnu;
        if (GraphDebug.isInfoVisible()) {
            GraphDebug.info("---------------JTopoCanvasOverview, reattach()---------------");
        }
        WidgetPool widgetPool = WidgetPool.getInstance();
        Integer canvasStatus = null;
        Enumeration fabricSummaryEnu = this.dataModel.enumerate(GraphFabricSummary.TYPE);
        if (fabricSummaryEnu.hasMoreElements()) {
            GraphFabricSummary fabricSummary = (GraphFabricSummary)fabricSummaryEnu.nextElement();
            GraphFabricSummary.ID fabricSummaryID = (GraphFabricSummary.ID)fabricSummary.getEntityID();
            Hashtable fabricSummaryH = (Hashtable)this.widgetH.get(WIDGET_FABRICSUMMARY);
            JTopoBoxFabricSummary fabricSummaryWidget = (JTopoBoxFabricSummary)fabricSummaryH.get(fabricSummaryID);
            if (fabricSummaryWidget == null) {
                fabricSummaryWidget = (JTopoBoxFabricSummary)widgetPool.getWidget(JTopoBoxFabricSummary.class);
                fabricSummaryWidget.setSessionModel(this, "Focus");
                fabricSummaryH.put(fabricSummaryID, fabricSummaryWidget);
                this.canvasPanel.add(fabricSummaryWidget);
            }
            fabricSummaryWidget.setDataModel(fabricSummary);
            canvasStatus = GraphModelUtilities.aggregateStatus(canvasStatus, fabricSummary.getHealthStatus());
        }
        if ((computerSummaryEnu = this.dataModel.enumerate(GraphComputerSummary.TYPE)).hasMoreElements()) {
            GraphComputerSummary computerSummary = (GraphComputerSummary)computerSummaryEnu.nextElement();
            GraphComputerSummary.ID computerSummaryID = (GraphComputerSummary.ID)computerSummary.getEntityID();
            Hashtable computerSummaryH = (Hashtable)this.widgetH.get(WIDGET_COMPUTERSUMMARY);
            JTopoBoxComputerSummary computerSummaryWidget = (JTopoBoxComputerSummary)computerSummaryH.get(computerSummaryID);
            if (computerSummaryWidget == null) {
                computerSummaryWidget = (JTopoBoxComputerSummary)widgetPool.getWidget(JTopoBoxComputerSummary.class);
                computerSummaryWidget.setSessionModel(this, "Focus");
                computerSummaryH.put(computerSummaryID, computerSummaryWidget);
                this.canvasPanel.add(computerSummaryWidget);
            }
            computerSummaryWidget.setDataModel(computerSummary);
            canvasStatus = GraphModelUtilities.aggregateStatus(canvasStatus, computerSummary.getHealthStatus());
        }
        if ((swSummaryEnu = this.dataModel.enumerate(GraphSwitchSummary.TYPE)).hasMoreElements()) {
            GraphSwitchSummary swSummary = (GraphSwitchSummary)swSummaryEnu.nextElement();
            GraphSwitchSummary.ID swSummaryID = (GraphSwitchSummary.ID)swSummary.getEntityID();
            Hashtable swSummaryH = (Hashtable)this.widgetH.get(WIDGET_FABRICSUMMARY);
            JTopoBoxSwitchSummary swSummaryWidget = (JTopoBoxSwitchSummary)swSummaryH.get(swSummaryID);
            if (swSummaryWidget == null) {
                swSummaryWidget = (JTopoBoxSwitchSummary)widgetPool.getWidget(JTopoBoxSwitchSummary.class);
                swSummaryWidget.setSessionModel(this, "Focus");
                swSummaryH.put(swSummaryID, swSummaryWidget);
                this.canvasPanel.add(swSummaryWidget);
            }
            swSummaryWidget.setDataModel(swSummary);
            canvasStatus = GraphModelUtilities.aggregateStatus(canvasStatus, swSummary.getHealthStatus());
        }
        if ((storageSummaryEnu = this.dataModel.enumerate(GraphStorageSummary.TYPE)).hasMoreElements()) {
            GraphStorageSummary storageSummary = (GraphStorageSummary)storageSummaryEnu.nextElement();
            GraphStorageSummary.ID storageSummaryID = (GraphStorageSummary.ID)storageSummary.getEntityID();
            Hashtable storageSummaryH = (Hashtable)this.widgetH.get(WIDGET_STORAGESUMMARY);
            JTopoBoxStorageSummary storageSummaryWidget = (JTopoBoxStorageSummary)storageSummaryH.get(storageSummaryID);
            if (storageSummaryWidget == null) {
                storageSummaryWidget = (JTopoBoxStorageSummary)widgetPool.getWidget(JTopoBoxStorageSummary.class);
                storageSummaryWidget.setSessionModel(this, "Focus");
                storageSummaryH.put(storageSummaryID, storageSummaryWidget);
                this.canvasPanel.add(storageSummaryWidget);
            }
            storageSummaryWidget.setDataModel(storageSummary);
            canvasStatus = GraphModelUtilities.aggregateStatus(canvasStatus, storageSummary.getHealthStatus());
        }
        if ((otherSummaryEnu = this.dataModel.enumerate(GraphOtherSummary.TYPE)).hasMoreElements()) {
            GraphOtherSummary otherSummary = (GraphOtherSummary)otherSummaryEnu.nextElement();
            GraphOtherSummary.ID otherSummaryID = (GraphOtherSummary.ID)otherSummary.getEntityID();
            Hashtable otherSummaryH = (Hashtable)this.widgetH.get(WIDGET_OTHERSUMMARY);
            JTopoBoxOtherSummary otherSummaryWidget = (JTopoBoxOtherSummary)otherSummaryH.get(otherSummaryID);
            if (otherSummaryWidget == null) {
                otherSummaryWidget = (JTopoBoxOtherSummary)widgetPool.getWidget(JTopoBoxOtherSummary.class);
                otherSummaryWidget.setSessionModel(this, "Focus");
                otherSummaryH.put(otherSummaryID, otherSummaryWidget);
                this.canvasPanel.add(otherSummaryWidget);
            }
            otherSummaryWidget.setDataModel(otherSummary);
            canvasStatus = GraphModelUtilities.aggregateStatus(canvasStatus, otherSummary.getHealthStatus());
        }
        JTopoView topoView = this.controllerView.getTopoView();
        topoView.setStatus(canvasStatus);
    }

    public Vector getPinContainers(GraphEntity.ID entityID) {
        PinList pinList = this.controllerView.getControllerApp().getPinList();
        GraphModelPinList pinListModel = (GraphModelPinList)pinList.getModel();
        Vector<ITopoPinContainerWidget> v = new Vector<ITopoPinContainerWidget>();
        Enumeration enu2 = this.widgetH.elements();
        while (enu2.hasMoreElements()) {
            Hashtable h = (Hashtable)enu2.nextElement();
            Enumeration enu = h.elements();
            while (enu.hasMoreElements()) {
                ITopoPinContainerWidget pinContainer = (ITopoPinContainerWidget)enu.nextElement();
                boolean flag = false;
                if (pinContainer instanceof JTopoBoxFabricSummary) {
                    Enumeration fabricEnu = null;
                    if (entityID instanceof GraphComputer.ID) {
                        fabricEnu = pinListModel.associatorID(GraphFabric2Computer.TYPE, entityID);
                    } else if (entityID instanceof GraphSwitch.ID) {
                        fabricEnu = pinListModel.associatorID(GraphFabric2Switch.TYPE, entityID);
                    } else if (entityID instanceof GraphSubsystem.ID) {
                        fabricEnu = pinListModel.associatorID(GraphFabric2Subsystem.TYPE, entityID);
                    } else if (entityID instanceof GraphTapeLibrary.ID) {
                        fabricEnu = pinListModel.associatorID(GraphFabric2TapeLibrary.TYPE, entityID);
                    } else if (entityID instanceof GraphOther.ID) {
                        fabricEnu = pinListModel.associatorID(GraphFabric2Other.TYPE, entityID);
                    }
                    if (fabricEnu != null && fabricEnu.hasMoreElements()) {
                        flag = true;
                    }
                } else if (pinContainer instanceof JTopoBoxComputerSummary && entityID instanceof GraphComputer.ID) {
                    flag = true;
                } else if (pinContainer instanceof JTopoBoxSwitchSummary && entityID instanceof GraphSwitch.ID) {
                    flag = true;
                } else if (pinContainer instanceof JTopoBoxStorageSummary && (entityID instanceof GraphSubsystem.ID || entityID instanceof GraphTapeLibrary.ID)) {
                    flag = true;
                } else if (pinContainer instanceof JTopoBoxOtherSummary && entityID instanceof GraphOther.ID) {
                    flag = true;
                }
                if (!flag) continue;
                v.add(pinContainer);
            }
        }
        return v;
    }

    protected Vector getFirstLevelGroup() {
        Vector groupWidgetV = new Vector();
        return groupWidgetV;
    }

    protected void clearAllLines() {
    }

    protected HashSet addLine(AbstractJTopoEntity widget, boolean isAutoExpand) {
        return new HashSet();
    }

    protected void removeLine(AbstractJTopoEntity widget) {
    }

    protected LayoutManager createDefaultLayout() {
        return new DefaultLayout();
    }

    protected class DefaultLayout
    extends TopoLayoutUtilities.HorizontalLayout {
        public void layoutContainer(Container parent) {
            super.layoutContainer(parent);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JTopoCanvasOverview.this.controllerView.canvasLayoutChanged();
                }
            });
        }
    }
}

