/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import org.eclipse.aperi.gui.topo.model.GraphModelConstant;
import org.eclipse.aperi.gui.topo.util.GraphDebug;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoBase;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoCanvas;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoEntity;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoGroup;
import org.eclipse.aperi.gui.topo.widget.ITopoEntityModel;
import org.eclipse.aperi.gui.topo.widget.TopoResource;

public class JTopoMiniMap
extends AbstractJTopoBase {
    private AbstractJTopoCanvas canvas;
    private float ratio;
    private JPanel auxPanel;
    private JPanel miniCanvas;
    private JPanel miniFocusPanel;
    private ML_Click ml_click;
    private ML_Drag ml_drag;
    private Hashtable unitH;
    private InvalidPanel invalidPanel;

    public JTopoMiniMap() {
        this.setBorder(LineBorder.createGrayLineBorder());
        this.setBackground(TopoResource.COLOR_BACKGROUND);
        this.setLayout(this.createDefaultLayout());
        this.auxPanel = new JPanel();
        this.auxPanel.setBackground(TopoResource.COLOR_BACKGROUND);
        this.auxPanel.setBorder(LineBorder.createGrayLineBorder());
        this.auxPanel.setLayout(new BorderLayout());
        this.add(this.auxPanel);
        this.miniCanvas = new JPanel();
        this.miniCanvas.setBackground(TopoResource.COLOR_BACKGROUND);
        this.miniCanvas.setLayout(null);
        this.ml_click = new ML_Click();
        this.miniCanvas.addMouseListener(this.ml_click);
        this.auxPanel.add(this.miniCanvas);
        this.miniFocusPanel = new JPanel();
        this.miniFocusPanel.setBackground(TopoResource.COLOR_TRANSPARENTBOX);
        this.miniFocusPanel.setBorder(LineBorder.createGrayLineBorder());
        this.miniFocusPanel.addMouseListener(this.ml_click);
        this.ml_drag = new ML_Drag();
        this.miniFocusPanel.addMouseListener(this.ml_drag);
        this.miniFocusPanel.addMouseMotionListener(this.ml_drag);
        this.unitH = new Hashtable();
        this.invalidPanel = new InvalidPanel();
        this.initState();
    }

    private void initState() {
        this.canvas = null;
        this.ratio = 0.0f;
        this.unitH.clear();
        this.miniFocusPanel.setLocation(0, 0);
        this.setEnabled(true);
    }

    public void resetState() {
        this.initState();
    }

    protected void reattach() {
        if (this.canvas == null) {
            return;
        }
        this.miniCanvas.removeAll();
        this.unitH.clear();
        this.miniCanvas.add(this.miniFocusPanel);
        this.addUnit(this.canvas.getCanvasPanel(), 0);
        this.validate();
    }

    public AbstractJTopoCanvas getDataModel() {
        return this.canvas;
    }

    public void setDataModel(AbstractJTopoCanvas canvas) {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("JTopoMiniMap, setModel()");
        }
        if (canvas == null) {
            if (GraphDebug.isErrorVisible()) {
                GraphDebug.error("JTopoMiniMap.setModel(), canvas=null");
            }
            return;
        }
        this.canvas = canvas;
        this.updateContainer();
    }

    public void canvasLayoutChanged() {
        this.updateContainer();
    }

    public void viewportPositionChanged() {
        this.layoutFocusPanel();
    }

    protected void addUnit(Container src, int level) {
        for (int i = 0; i < src.getComponentCount(); ++i) {
            AbstractJTopoGroup group;
            Component comp = src.getComponent(i);
            Unit u = null;
            if (comp instanceof AbstractJTopoGroup) {
                u = new Unit(comp);
            }
            if (u != null) {
                this.miniCanvas.add((Component)u, 1);
                this.unitH.put(comp, u);
            }
            if (!comp.isVisible() || comp instanceof AbstractJTopoGroup && !(group = (AbstractJTopoGroup)comp).isExpanded() || !(comp instanceof Container)) continue;
            this.addUnit((Container)comp, level + 1);
        }
    }

    protected void layoutFocusPanel() {
        if (this.ratio == 0.0f) {
            return;
        }
        JViewport viewport = this.canvas.getViewport();
        Dimension viewportD = viewport.getExtentSize();
        Rectangle r = new Rectangle();
        r.width = (int)((float)viewportD.width / this.ratio);
        r.height = (int)((float)viewportD.height / this.ratio);
        r.x = (int)((float)viewport.getViewPosition().x / this.ratio);
        r.y = (int)((float)viewport.getViewPosition().y / this.ratio);
        this.miniFocusPanel.setBounds(r);
    }

    protected LayoutManager createDefaultLayout() {
        return new DefaultLayout();
    }

    public void setEnabled(boolean enabled) {
        this.remove(this.invalidPanel);
        if (!enabled) {
            this.add((Component)this.invalidPanel, 0);
        }
        super.setEnabled(enabled);
    }

    protected class InvalidPanel
    extends JPanel {
        public InvalidPanel() {
            this.setBackground(new Color(255, 255, 255, 200));
            this.addMouseListener(new DummyMouseAdapter());
        }

        protected class DummyMouseAdapter
        extends MouseAdapter {
            protected DummyMouseAdapter() {
            }
        }
    }

    protected class Unit
    extends JPanel {
        protected Component comp;

        public Unit(Component comp) {
            this.comp = comp;
            if (comp == null) {
                return;
            }
            if (comp instanceof AbstractJTopoEntity) {
                AbstractJTopoEntity entity = (AbstractJTopoEntity)comp;
                this.setBorder(LineBorder.createGrayLineBorder());
                ITopoEntityModel entityModel = (ITopoEntityModel)entity.getWidgetModel();
                Integer health = entityModel.getHealth();
                if (health == null) {
                    this.setBackground(TopoResource.COLOR_NA);
                } else if (health.equals(GraphModelConstant.STATUS_UNKNOWN)) {
                    this.setBackground(TopoResource.COLOR_UNKNOWN);
                } else if (health.equals(GraphModelConstant.STATUS_NORMAL)) {
                    this.setBackground(TopoResource.COLOR_NORMAL);
                } else if (health.equals(GraphModelConstant.STATUS_WARNING)) {
                    this.setBackground(TopoResource.COLOR_WARNING);
                } else if (health.equals(GraphModelConstant.STATUS_CRITICAL)) {
                    this.setBackground(TopoResource.COLOR_CRITICAL);
                } else if (health.equals(GraphModelConstant.STATUS_MISSING)) {
                    this.setBackground(TopoResource.COLOR_MISSING);
                } else {
                    this.setBackground(TopoResource.COLOR_NA);
                }
            }
        }

        public Component getRefComp() {
            return this.comp;
        }
    }

    protected class DefaultLayout
    implements LayoutManager {
        protected int gap = 5;

        protected DefaultLayout() {
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 0);
        }

        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        public void layoutContainer(Container parent) {
            if (!parent.isEnabled()) {
                Insets insets = parent.getInsets();
                int x = insets.left;
                int y = insets.top;
                int w = parent.getWidth() - insets.left - insets.right;
                int h = parent.getHeight() - insets.top - insets.bottom;
                JTopoMiniMap.this.invalidPanel.setBounds(x, y, w, h);
            }
            Dimension miniMapD = JTopoMiniMap.this.getSize();
            Dimension tmpMiniCanvasD = new Dimension(miniMapD.width - 2 * this.gap, miniMapD.height - 2 * this.gap);
            Dimension canvasD = JTopoMiniMap.this.canvas.getCanvasPanel().getSize();
            if ((float)canvasD.width / (float)canvasD.height > (float)tmpMiniCanvasD.width / (float)tmpMiniCanvasD.height) {
                JTopoMiniMap.this.ratio = (float)canvasD.width / (float)tmpMiniCanvasD.width;
            } else {
                JTopoMiniMap.this.ratio = (float)canvasD.height / (float)tmpMiniCanvasD.height;
            }
            if (JTopoMiniMap.this.ratio == 0.0f) {
                return;
            }
            Rectangle r = new Rectangle();
            r.width = (int)((float)canvasD.width / JTopoMiniMap.this.ratio);
            r.height = (int)((float)canvasD.height / JTopoMiniMap.this.ratio);
            r.x = (miniMapD.width - r.width) / 2;
            r.y = (miniMapD.height - r.height) / 2;
            JTopoMiniMap.this.miniCanvas.setBounds(r);
            Rectangle r2 = new Rectangle();
            r2.x = r.x - 1;
            r2.y = r.y - 1;
            r2.width = r.width + 2;
            r2.height = r.height + 2;
            JTopoMiniMap.this.auxPanel.setBounds(r2);
            JTopoMiniMap.this.layoutFocusPanel();
            Enumeration enu = JTopoMiniMap.this.unitH.elements();
            while (enu.hasMoreElements()) {
                Unit unit = (Unit)enu.nextElement();
                Component comp = unit.getRefComp();
                Rectangle r3 = SwingUtilities.convertRectangle(comp.getParent(), comp.getBounds(), JTopoMiniMap.this.canvas.getCanvasPanel());
                r3.x = (int)((float)r3.x / JTopoMiniMap.this.ratio);
                r3.y = (int)((float)r3.y / JTopoMiniMap.this.ratio);
                r3.width = (int)((float)r3.width / JTopoMiniMap.this.ratio);
                r3.height = (int)((float)r3.height / JTopoMiniMap.this.ratio);
                unit.setBounds(r3);
            }
        }
    }

    protected class ML_Drag
    extends MouseAdapter
    implements MouseMotionListener {
        protected Point last;
        protected boolean isCursorSet;

        protected ML_Drag() {
        }

        public void mousePressed(MouseEvent e) {
            this.last = e.getPoint();
        }

        public void mouseDragged(MouseEvent e) {
            if (!this.isCursorSet) {
                JTopoMiniMap.this.setCursor(Cursor.getPredefinedCursor(13));
                this.isCursorSet = true;
            }
            Point drag = e.getPoint();
            Point oldPos = JTopoMiniMap.this.miniFocusPanel.getLocation();
            Point dragAdjusted = new Point(oldPos.x + drag.x, oldPos.y + drag.y);
            Dimension offset = new Dimension(drag.x - this.last.x, drag.y - this.last.y);
            Rectangle miniCanvasR = new Rectangle(0, 0, JTopoMiniMap.this.miniCanvas.getWidth(), JTopoMiniMap.this.miniCanvas.getHeight());
            if (miniCanvasR.contains(dragAdjusted)) {
                JViewport viewport = JTopoMiniMap.this.canvas.getViewport();
                Point viewPos = viewport.getViewPosition();
                Point scrollTo = new Point((int)((float)viewPos.x + (float)offset.width * JTopoMiniMap.this.ratio), (int)((float)viewPos.y + (float)offset.height * JTopoMiniMap.this.ratio));
                JTopoMiniMap.this.canvas.setViewPosition(scrollTo);
            }
        }

        public void mouseReleased(MouseEvent e) {
            this.last = null;
            if (this.isCursorSet) {
                JTopoMiniMap.this.setCursor(Cursor.getPredefinedCursor(0));
                this.isCursorSet = false;
            }
        }

        public void mouseMoved(MouseEvent e) {
        }
    }

    protected class ML_Click
    extends MouseAdapter {
        protected ML_Click() {
        }

        public void mouseClicked(MouseEvent e) {
            Point click = null;
            click = e.getSource() == JTopoMiniMap.this.miniFocusPanel ? new Point(e.getX() + JTopoMiniMap.this.miniFocusPanel.getX(), e.getY() + JTopoMiniMap.this.miniFocusPanel.getY()) : e.getPoint();
            Dimension d = JTopoMiniMap.this.miniFocusPanel.getSize();
            Point newPos = new Point(click.x - d.width / 2, click.y - d.height / 2);
            JViewport viewport = JTopoMiniMap.this.canvas.getViewport();
            Point viewPos = viewport.getViewPosition();
            Point scrollTo = new Point((int)((float)newPos.x * JTopoMiniMap.this.ratio), (int)((float)newPos.y * JTopoMiniMap.this.ratio));
            JTopoMiniMap.this.canvas.setViewPosition(scrollTo);
        }
    }
}

