/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.awt.LayoutManager;
import javax.swing.JPanel;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubviewOtherL1Device;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoBox;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoEntity;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoSubview;
import org.eclipse.aperi.gui.topo.widget.ITopoGroupModel;
import org.eclipse.aperi.gui.topo.widget.ITopoUnitModel;
import org.eclipse.aperi.gui.topo.widget.JTopoBoxVolumeGroup;
import org.eclipse.aperi.gui.topo.widget.TopoLayoutUtilities;
import org.eclipse.aperi.gui.topo.widget.TopoResource;

public class JTopoSubviewOtherL1Device
extends AbstractJTopoSubview {
    protected void reattach() {
        if (this.focusEntity == null) {
            return;
        }
        GraphSubviewOtherL1Device device = (GraphSubviewOtherL1Device)this.focusEntity;
        ITopoGroupModel groupModel = (ITopoGroupModel)this.widgetModel;
        groupModel.setType(device.getDisplayName());
        groupModel.setLabel(device.getDisplayName());
        groupModel.setHealth(device.getHealthStatus());
        groupModel.setIconSelected(TopoResource.ICON_VOLUMEGROUP_16_SELECTED);
        groupModel.setIconUnselected(TopoResource.ICON_VOLUMEGROUP_16_UNSELECTED);
        groupModel.setIconMissing(TopoResource.ICON_VOLUMEGROUP_16_MISSING);
        groupModel.removeAllSummaries();
        int volumeTotal = device.getNumOfVolumes();
        int volumeUnfiltered = device.getNumOfAbnormalVolumes();
        groupModel.addSummary(new ITopoGroupModel.Summary(volumeTotal, volumeUnfiltered, GuiUtil.getString("TOPO_LABEL_ENTITY_VOLUME"), GuiUtil.getString("TOPO_LABEL_ENTITY_VOLUMES")));
        int total = volumeTotal;
        int unfiltered = volumeUnfiltered;
        groupModel.setTotalCount(total);
        groupModel.setUnfilteredCount(unfiltered);
        groupModel.setGroupKey(device.getGroupKey());
        groupModel.fireModelChanged();
    }

    protected AbstractJTopoBox.ContainerPanel createContainerPanel(ITopoGroupModel groupModel) {
        return new ContainerPanel((ITopoUnitModel)groupModel);
    }

    protected class ContainerPanel
    extends AbstractJTopoBox.ContainerPanel {
        protected JPanel volumeGroupPanel;

        public ContainerPanel(ITopoUnitModel unitModel) {
            super(unitModel);
            this.volumeGroupPanel = new JPanel();
            this.volumeGroupPanel.setBackground(TopoResource.COLOR_BACKGROUND);
            TopoLayoutUtilities.SquareGridLayout layout = new TopoLayoutUtilities.SquareGridLayout();
            this.volumeGroupPanel.setLayout(layout);
            this.initState();
        }

        private void initState() {
            this.add(this.volumeGroupPanel);
            this.removeAllEntities();
        }

        public void resetState() {
            super.resetState();
            this.initState();
        }

        public void addEntity(AbstractJTopoEntity entity) {
            this.entityV.add(entity);
            if (entity instanceof JTopoBoxVolumeGroup) {
                this.volumeGroupPanel.setVisible(true);
                this.volumeGroupPanel.add(entity);
            }
        }

        public void removeEntity(AbstractJTopoEntity entity) {
            this.entityV.remove(entity);
            if (entity instanceof JTopoBoxVolumeGroup) {
                this.volumeGroupPanel.remove(entity);
                this.volumeGroupPanel.setVisible(this.volumeGroupPanel.getComponentCount() > 0);
            }
        }

        public void removeAllEntities() {
            this.entityV.clear();
            this.volumeGroupPanel.removeAll();
            this.volumeGroupPanel.setVisible(false);
        }

        protected LayoutManager createDefaultLayout() {
            return new DefaultLayout();
        }

        protected class DefaultLayout
        extends TopoLayoutUtilities.VerticalLayout {
            public DefaultLayout() {
                this.setMargin(15);
            }
        }
    }
}

