/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.awt.LayoutManager;
import javax.swing.JPanel;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubviewSubsystemL2Device;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoBox;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoEntity;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoSubview;
import org.eclipse.aperi.gui.topo.widget.ITopoGroupModel;
import org.eclipse.aperi.gui.topo.widget.ITopoUnitModel;
import org.eclipse.aperi.gui.topo.widget.JTopoBoxDiskGroup;
import org.eclipse.aperi.gui.topo.widget.JTopoBoxLunGroup;
import org.eclipse.aperi.gui.topo.widget.JTopoBoxPoolGroup;
import org.eclipse.aperi.gui.topo.widget.JTopoBoxVolumeGroup;
import org.eclipse.aperi.gui.topo.widget.TopoLayoutUtilities;
import org.eclipse.aperi.gui.topo.widget.TopoResource;

public class JTopoSubviewSubsystemL2Device
extends AbstractJTopoSubview {
    protected void reattach() {
        if (this.focusEntity == null) {
            return;
        }
        GraphSubviewSubsystemL2Device device = (GraphSubviewSubsystemL2Device)this.focusEntity;
        ITopoGroupModel groupModel = (ITopoGroupModel)this.widgetModel;
        boolean isSVC = device.getIsSVC() != null ? device.getIsSVC() : false;
        groupModel.setType(device.getDisplayName());
        groupModel.setLabel(device.getDisplayName());
        groupModel.setHealth(device.getHealthStatus());
        groupModel.setIconSelected(TopoResource.ICON_VOLUMEGROUP_16_SELECTED);
        groupModel.setIconUnselected(TopoResource.ICON_VOLUMEGROUP_16_UNSELECTED);
        groupModel.setIconMissing(TopoResource.ICON_VOLUMEGROUP_16_MISSING);
        groupModel.removeAllSummaries();
        if (isSVC) {
            int externalVolumeTotal = device.getNumOfExternalVolumes();
            int externalVolumeUnfiltered = device.getNumOfAbnormalExternalVolumes();
            groupModel.addSummary(new ITopoGroupModel.Summary(externalVolumeTotal, externalVolumeUnfiltered, GuiUtil.getString("TOPO_LABEL_ENTITY_BACKENDVOLUME"), GuiUtil.getString("TOPO_LABEL_ENTITY_BACKENDVOLUMES")));
        }
        int diskTotal = device.getNumOfDisks();
        int diskUnfiltered = device.getNumOfAbnormalDisks();
        groupModel.addSummary(new ITopoGroupModel.Summary(diskTotal, diskUnfiltered, GuiUtil.getString("TOPO_LABEL_ENTITY_DISK"), GuiUtil.getString("TOPO_LABEL_ENTITY_DISKS")));
        int poolTotal = device.getNumOfPools();
        int poolUnfiltered = device.getNumOfAbnormalPools();
        groupModel.addSummary(new ITopoGroupModel.Summary(poolTotal, poolUnfiltered, GuiUtil.getString("TOPO_LABEL_ENTITY_POOL"), GuiUtil.getString("TOPO_LABEL_ENTITY_POOLS")));
        int volumeTotal = device.getNumOfVolumes();
        int volumeUnfiltered = device.getNumOfAbnormalVolumes();
        groupModel.addSummary(new ITopoGroupModel.Summary(volumeTotal, volumeUnfiltered, GuiUtil.getString("TOPO_LABEL_ENTITY_VOLUME"), GuiUtil.getString("TOPO_LABEL_ENTITY_VOLUMES")));
        if (!isSVC) {
            int externalDiskTotal = device.getNumOfExternalDisks();
            int externalDiskUnfiltered = device.getNumOfAbnormalExternalDisks();
            groupModel.addSummary(new ITopoGroupModel.Summary(externalDiskTotal, externalDiskUnfiltered, GuiUtil.getString("TOPO_LABEL_ENTITY_MDISK"), GuiUtil.getString("TOPO_LABEL_ENTITY_MDISKS")));
        }
        int lunTotal = device.getNumOfLuns();
        int lunUnfiltered = device.getNumOfAbnormalLuns();
        groupModel.addSummary(new ITopoGroupModel.Summary(lunTotal, lunUnfiltered, GuiUtil.getString("TOPO_LABEL_ENTITY_LUN"), GuiUtil.getString("TOPO_LABEL_ENTITY_LUNS")));
        int total = diskTotal + poolTotal + volumeTotal + lunTotal;
        int unfiltered = diskUnfiltered + poolUnfiltered + volumeUnfiltered + lunUnfiltered;
        groupModel.setTotalCount(total);
        groupModel.setUnfilteredCount(unfiltered);
        groupModel.setGroupKey(device.getGroupKey());
        groupModel.fireModelChanged();
    }

    protected AbstractJTopoBox.ContainerPanel createContainerPanel(ITopoGroupModel groupModel) {
        return new ContainerPanel((ITopoUnitModel)groupModel);
    }

    protected class ContainerPanel
    extends AbstractJTopoBox.ContainerPanel {
        protected JPanel externalVolumeGroupPanel;
        protected JPanel diskGroupPanel;
        protected JPanel poolGroupPanel;
        protected JPanel volumeGroupPanel;
        protected JPanel rightPanel;
        protected JPanel externalDiskGroupPanel;
        protected JPanel lunGroupPanel;

        public ContainerPanel(ITopoUnitModel unitModel) {
            super(unitModel);
            this.externalVolumeGroupPanel = new JPanel();
            this.externalVolumeGroupPanel.setBackground(TopoResource.COLOR_BACKGROUND);
            TopoLayoutUtilities.VerticalLayout layout = new TopoLayoutUtilities.VerticalLayout();
            this.externalVolumeGroupPanel.setLayout(layout);
            this.diskGroupPanel = new JPanel();
            this.diskGroupPanel.setBackground(TopoResource.COLOR_BACKGROUND);
            layout = new TopoLayoutUtilities.VerticalLayout();
            this.diskGroupPanel.setLayout(layout);
            this.poolGroupPanel = new JPanel();
            this.poolGroupPanel.setBackground(TopoResource.COLOR_BACKGROUND);
            layout = new TopoLayoutUtilities.VerticalLayout();
            this.poolGroupPanel.setLayout(layout);
            this.volumeGroupPanel = new JPanel();
            this.volumeGroupPanel.setBackground(TopoResource.COLOR_BACKGROUND);
            layout = new TopoLayoutUtilities.VerticalLayout();
            this.volumeGroupPanel.setLayout(layout);
            this.rightPanel = new JPanel();
            this.rightPanel.setBackground(TopoResource.COLOR_BACKGROUND);
            layout = new TopoLayoutUtilities.VerticalLayout();
            layout.setSpacing(20);
            this.rightPanel.setLayout(layout);
            this.externalDiskGroupPanel = new JPanel();
            this.externalDiskGroupPanel.setBackground(TopoResource.COLOR_BACKGROUND);
            layout = new TopoLayoutUtilities.VerticalLayout();
            this.externalDiskGroupPanel.setLayout(layout);
            this.rightPanel.add(this.externalDiskGroupPanel);
            this.lunGroupPanel = new JPanel();
            this.lunGroupPanel.setBackground(TopoResource.COLOR_BACKGROUND);
            layout = new TopoLayoutUtilities.VerticalLayout();
            this.lunGroupPanel.setLayout(layout);
            this.rightPanel.add(this.lunGroupPanel);
            this.initState();
        }

        private void initState() {
            this.add(this.externalVolumeGroupPanel);
            this.add(this.diskGroupPanel);
            this.add(this.poolGroupPanel);
            this.add(this.volumeGroupPanel);
            this.add(this.rightPanel);
            this.removeAllEntities();
        }

        public void resetState() {
            super.resetState();
            this.initState();
        }

        public void addEntity(AbstractJTopoEntity entity) {
            this.entityV.add(entity);
            if (entity instanceof JTopoBoxDiskGroup) {
                if ("External".equals(entity.getScope())) {
                    this.externalDiskGroupPanel.setVisible(true);
                    this.externalDiskGroupPanel.add(entity);
                    this.rightPanel.setVisible(true);
                } else {
                    this.diskGroupPanel.setVisible(true);
                    this.diskGroupPanel.add(entity);
                }
            } else if (entity instanceof JTopoBoxPoolGroup) {
                this.poolGroupPanel.setVisible(true);
                this.poolGroupPanel.add(entity);
            } else if (entity instanceof JTopoBoxVolumeGroup) {
                if ("External".equals(entity.getScope())) {
                    this.externalVolumeGroupPanel.setVisible(true);
                    this.externalVolumeGroupPanel.add(entity);
                } else {
                    this.volumeGroupPanel.setVisible(true);
                    this.volumeGroupPanel.add(entity);
                }
            } else if (entity instanceof JTopoBoxLunGroup) {
                this.lunGroupPanel.setVisible(true);
                this.lunGroupPanel.add(entity);
                this.rightPanel.setVisible(true);
            }
        }

        public void removeEntity(AbstractJTopoEntity entity) {
            this.entityV.remove(entity);
            if (entity instanceof JTopoBoxDiskGroup) {
                if ("External".equals(entity.getScope())) {
                    this.externalDiskGroupPanel.remove(entity);
                    this.externalDiskGroupPanel.setVisible(this.externalDiskGroupPanel.getComponentCount() > 0);
                    this.rightPanel.setVisible(this.externalDiskGroupPanel.isVisible() || this.lunGroupPanel.isVisible());
                } else {
                    this.diskGroupPanel.remove(entity);
                    this.diskGroupPanel.setVisible(this.diskGroupPanel.getComponentCount() > 0);
                }
            } else if (entity instanceof JTopoBoxPoolGroup) {
                this.poolGroupPanel.remove(entity);
                this.poolGroupPanel.setVisible(this.poolGroupPanel.getComponentCount() > 0);
            } else if (entity instanceof JTopoBoxVolumeGroup) {
                if ("External".equals(entity.getScope())) {
                    this.externalVolumeGroupPanel.remove(entity);
                    this.externalVolumeGroupPanel.setVisible(this.externalVolumeGroupPanel.getComponentCount() > 0);
                } else {
                    this.volumeGroupPanel.remove(entity);
                    this.volumeGroupPanel.setVisible(this.volumeGroupPanel.getComponentCount() > 0);
                }
            } else if (entity instanceof JTopoBoxLunGroup) {
                this.lunGroupPanel.remove(entity);
                this.lunGroupPanel.setVisible(this.lunGroupPanel.getComponentCount() > 0);
            }
        }

        public void removeAllEntities() {
            this.entityV.clear();
            this.externalVolumeGroupPanel.removeAll();
            this.externalVolumeGroupPanel.setVisible(false);
            this.diskGroupPanel.removeAll();
            this.diskGroupPanel.setVisible(false);
            this.poolGroupPanel.removeAll();
            this.poolGroupPanel.setVisible(false);
            this.volumeGroupPanel.removeAll();
            this.volumeGroupPanel.setVisible(false);
            this.externalDiskGroupPanel.removeAll();
            this.externalDiskGroupPanel.setVisible(false);
            this.lunGroupPanel.removeAll();
            this.lunGroupPanel.setVisible(false);
            this.rightPanel.setVisible(false);
        }

        protected LayoutManager createDefaultLayout() {
            return new DefaultLayout();
        }

        protected class DefaultLayout
        extends TopoLayoutUtilities.HorizontalLayout {
            public DefaultLayout() {
                this.setMargin(15);
                this.setSpacing(20);
                this.setAlignment(1);
            }
        }
    }
}

