/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.awt.LayoutManager;
import javax.swing.JPanel;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubviewTapeLibraryL2Device;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoBox;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoEntity;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoSubview;
import org.eclipse.aperi.gui.topo.widget.ITopoGroupModel;
import org.eclipse.aperi.gui.topo.widget.ITopoUnitModel;
import org.eclipse.aperi.gui.topo.widget.JTopoBoxMediaChangerGroup;
import org.eclipse.aperi.gui.topo.widget.TopoLayoutUtilities;
import org.eclipse.aperi.gui.topo.widget.TopoResource;

public class JTopoSubviewTapeLibraryL2Device
extends AbstractJTopoSubview {
    protected void reattach() {
        if (this.focusEntity == null) {
            return;
        }
        GraphSubviewTapeLibraryL2Device device = (GraphSubviewTapeLibraryL2Device)this.focusEntity;
        ITopoGroupModel groupModel = (ITopoGroupModel)this.widgetModel;
        groupModel.setType(device.getDisplayName());
        groupModel.setLabel(device.getDisplayName());
        groupModel.setHealth(device.getHealthStatus());
        groupModel.setIconSelected(TopoResource.ICON_VOLUMEGROUP_16_SELECTED);
        groupModel.setIconUnselected(TopoResource.ICON_VOLUMEGROUP_16_UNSELECTED);
        groupModel.setIconMissing(TopoResource.ICON_VOLUMEGROUP_16_MISSING);
        groupModel.removeAllSummaries();
        int filesystemTotal = device.getNumOfMediaChangers();
        int filesystemUnfiltered = device.getNumOfAbnormalMediaChangers();
        groupModel.addSummary(new ITopoGroupModel.Summary(filesystemTotal, filesystemUnfiltered, GuiUtil.getString("TOPO_LABEL_ENTITY_MEDIACHANGER"), GuiUtil.getString("TOPO_LABEL_ENTITY_MEDIACHANGERS")));
        int total = filesystemTotal;
        int unfiltered = filesystemUnfiltered;
        groupModel.setTotalCount(total);
        groupModel.setUnfilteredCount(unfiltered);
        groupModel.setGroupKey(device.getGroupKey());
        groupModel.fireModelChanged();
    }

    protected AbstractJTopoBox.ContainerPanel createContainerPanel(ITopoGroupModel groupModel) {
        return new ContainerPanel((ITopoUnitModel)groupModel);
    }

    protected class ContainerPanel
    extends AbstractJTopoBox.ContainerPanel {
        protected JPanel mediaChangerGroupPanel;

        public ContainerPanel(ITopoUnitModel unitModel) {
            super(unitModel);
            this.mediaChangerGroupPanel = new JPanel();
            this.mediaChangerGroupPanel.setBackground(TopoResource.COLOR_BACKGROUND);
            TopoLayoutUtilities.SquareGridLayout layout = new TopoLayoutUtilities.SquareGridLayout();
            this.mediaChangerGroupPanel.setLayout(layout);
            this.initState();
        }

        private void initState() {
            this.add(this.mediaChangerGroupPanel);
            this.removeAllEntities();
        }

        public void resetState() {
            super.resetState();
            this.initState();
        }

        public void addEntity(AbstractJTopoEntity entity) {
            this.entityV.add(entity);
            if (entity instanceof JTopoBoxMediaChangerGroup) {
                this.mediaChangerGroupPanel.setVisible(true);
                this.mediaChangerGroupPanel.add(entity);
            }
        }

        public void removeEntity(AbstractJTopoEntity entity) {
            this.entityV.remove(entity);
            if (entity instanceof JTopoBoxMediaChangerGroup) {
                this.mediaChangerGroupPanel.remove(entity);
                this.mediaChangerGroupPanel.setVisible(this.mediaChangerGroupPanel.getComponentCount() > 0);
            }
        }

        public void removeAllEntities() {
            this.entityV.clear();
            this.mediaChangerGroupPanel.removeAll();
            this.mediaChangerGroupPanel.setVisible(false);
        }

        protected LayoutManager createDefaultLayout() {
            return new DefaultLayout();
        }

        protected class DefaultLayout
        extends TopoLayoutUtilities.VerticalLayout {
            public DefaultLayout() {
                this.setMargin(15);
            }
        }
    }
}

