/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.text.CollationKey;
import java.text.RuleBasedCollator;
import java.util.Enumeration;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.topo.model.GraphEntity;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputer;
import org.eclipse.aperi.gui.topo.model.bean.GraphFCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphOther;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeLibrary;
import org.eclipse.aperi.gui.topo.model.bean.GraphZone;
import org.eclipse.aperi.gui.topo.model.bean.GraphZone2ZoneMember;
import org.eclipse.aperi.gui.topo.model.bean.GraphZoneFabric;
import org.eclipse.aperi.gui.topo.model.bean.GraphZoneFabric2ZoneSet;
import org.eclipse.aperi.gui.topo.model.bean.GraphZoneMember;
import org.eclipse.aperi.gui.topo.model.bean.GraphZoneSet;
import org.eclipse.aperi.gui.topo.model.bean.GraphZoneSet2Zone;
import org.eclipse.aperi.gui.topo.util.GraphDebug;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoTable;
import org.eclipse.aperi.gui.topo.widget.ControllerView;
import org.eclipse.aperi.gui.topo.widget.DefaultTopoTableColumnGroup;
import org.eclipse.aperi.gui.topo.widget.DefaultTopoTableColumnModel;
import org.eclipse.aperi.gui.topo.widget.DefaultTopoTableColumnRegular;
import org.eclipse.aperi.gui.topo.widget.DefaultTopoTableColumnStatus;
import org.eclipse.aperi.gui.topo.widget.DefaultTopoTableModel;
import org.eclipse.aperi.gui.topo.widget.JCustomRendererTable;

public class JTopoTableZone
extends AbstractJTopoTable {
    public JTopoTableZone() {
        this.tableColumnModel = new DefaultTopoTableColumnModel();
        int columnCount = 0;
        this.tableColumnModel.addColumn(new DefaultTopoTableColumnStatus(columnCount++, "TOPO_LABEL_ATTR_COMMON_LOCATED", null));
        this.tableColumnModel.addColumn(new DefaultTopoTableColumnGroup(columnCount++, 300));
        if (GraphDebug.isInfoVisible()) {
            this.tableColumnModel.addColumn(new DefaultTopoTableColumnRegular(columnCount++, "TOPO_LABEL_ATTR_COMMON_DEBUG", 150));
        }
        this.tableColumnModel.addColumn(new DefaultTopoTableColumnRegular(columnCount++, "TOPO_LABEL_ATTR_COMMON_LABEL", 150));
        this.tableColumnModel.addColumn(new DefaultTopoTableColumnRegular(columnCount++, "TOPO_LABEL_ATTR_ZONE_ENTITY", 250));
        this.tableColumnModel.addColumn(new DefaultTopoTableColumnRegular(columnCount++, "TOPO_LABEL_ENTITY_FCPORT", 150));
        this.tableColumnModel.addColumn(new DefaultTopoTableColumnRegular(columnCount++, "TOPO_LABEL_ATTR_FCPORT_PORTNUMBER"));
        this.table.setColumnModel(this.tableColumnModel);
        this.tableModel = new DefaultTopoTableModel(this.tableColumnModel);
        this.table.setModel(this.tableModel);
        this.arrangeRecordGroup = new AbstractJTopoTable.ArrangeRecord("TOPO_LABEL_ATTR_COMMON_GROUP", true);
        this.arrangeRecord = new AbstractJTopoTable.ArrangeRecord("TOPO_LABEL_ATTR_ZONE_ENTITY", true);
    }

    protected void reattach() {
        DefaultTopoTableModel tableModel = (DefaultTopoTableModel)this.table.getModel();
        tableModel.removeAll();
        if (this.dataModel == null) {
            return;
        }
        RuleBasedCollator collator = (RuleBasedCollator)RuleBasedCollator.getInstance();
        DefaultTopoTableModel.RootNode root = tableModel.getRootNode();
        Enumeration zoneFabricEnu = this.dataModel.enumerate(GraphZoneFabric.TYPE);
        while (zoneFabricEnu.hasMoreElements()) {
            GraphZoneFabric zoneFabric = (GraphZoneFabric)zoneFabricEnu.nextElement();
            GraphZoneFabric.ID zoneFabricID = (GraphZoneFabric.ID)zoneFabric.getEntityID();
            String prefix = GuiUtil.getString("TOPO_LABEL_ENTITY_FABRIC") + ": ";
            String zoneFabricDisplayName = prefix + zoneFabric.getDisplayName();
            DefaultTopoTableModel defaultTopoTableModel = tableModel;
            defaultTopoTableModel.getClass();
            DefaultTopoTableModel.GroupNode zoneFabricGroup = defaultTopoTableModel.new DefaultTopoTableModel.GroupNode(zoneFabricID);
            root.addMember(zoneFabricGroup);
            zoneFabricGroup.addData(new JCustomRendererTable.StatusCell(null, null, null));
            zoneFabricGroup.addData(new JCustomRendererTable.GroupLabelCell(zoneFabricDisplayName, zoneFabric.getSortingValue(), zoneFabric.getCollationKey(), zoneFabricGroup));
            Enumeration zsetEnu = this.dataModel.associator(GraphZoneFabric2ZoneSet.TYPE, zoneFabricID);
            while (zsetEnu.hasMoreElements()) {
                GraphZoneSet zset = (GraphZoneSet)zsetEnu.nextElement();
                GraphZoneSet.ID zsetID = (GraphZoneSet.ID)zset.getEntityID();
                String active = zset.getActive() == null ? "" : (zset.getActive() != false ? "(" + GuiUtil.getString("TOPO_LABEL_ATTR_COMMON_ACTIVE") + ") " : "");
                boolean isOrphan = zset.containScope("Orphan");
                prefix = !isOrphan ? GuiUtil.getString("TOPO_LABEL_ENTITY_ZONESET") + ": " : "";
                String zsetDisplayName = active + prefix + zset.getDisplayName();
                DefaultTopoTableModel defaultTopoTableModel2 = tableModel;
                defaultTopoTableModel2.getClass();
                DefaultTopoTableModel.GroupNode zsetGroup = defaultTopoTableModel2.new DefaultTopoTableModel.GroupNode(zsetID);
                zsetGroup.setCollapse(true);
                zoneFabricGroup.addMember(zsetGroup);
                zsetGroup.addData(new JCustomRendererTable.StatusCell(null, null, null));
                if (isOrphan) {
                    CollationKey orphanCollationKey = collator.getCollationKey("ZZZZ" + zsetDisplayName);
                    zsetGroup.addData(new JCustomRendererTable.GroupLabelCell(zsetDisplayName, zset.getSortingValue(), orphanCollationKey, zsetGroup));
                } else {
                    zsetGroup.addData(new JCustomRendererTable.GroupLabelCell(zsetDisplayName, zset.getSortingValue(), zset.getCollationKey(), zsetGroup));
                }
                Enumeration zoneEnu = this.dataModel.associator(GraphZoneSet2Zone.TYPE, zsetID);
                while (zoneEnu.hasMoreElements()) {
                    GraphZone zone = (GraphZone)zoneEnu.nextElement();
                    GraphZone.ID zoneID = (GraphZone.ID)zone.getEntityID();
                    active = zone.getActive() == null ? "" : (zset.getActive() != false ? "(" + GuiUtil.getString("TOPO_LABEL_ATTR_COMMON_ACTIVE") + ") " : "");
                    prefix = GuiUtil.getString("TOPO_LABEL_ENTITY_ZONE") + ": ";
                    String zoneDisplayName = active + prefix + zone.getDisplayName();
                    DefaultTopoTableModel defaultTopoTableModel3 = tableModel;
                    defaultTopoTableModel3.getClass();
                    DefaultTopoTableModel.GroupNode zoneGroup = defaultTopoTableModel3.new DefaultTopoTableModel.GroupNode(zoneID);
                    zoneGroup.setCollapse(true);
                    zsetGroup.addMember(zoneGroup);
                    zoneGroup.addData(new JCustomRendererTable.StatusCell(null, null, null));
                    zoneGroup.addData(new JCustomRendererTable.GroupLabelCell(zoneDisplayName, zone.getSortingValue(), zone.getCollationKey(), zoneGroup));
                    Enumeration zmemEnu = this.dataModel.associator(GraphZone2ZoneMember.TYPE, zoneID);
                    while (zmemEnu.hasMoreElements()) {
                        GraphZoneMember zmem = (GraphZoneMember)zmemEnu.nextElement();
                        GraphZoneMember.ID zmemID = (GraphZoneMember.ID)zmem.getEntityID();
                        DefaultTopoTableModel defaultTopoTableModel4 = tableModel;
                        defaultTopoTableModel4.getClass();
                        DefaultTopoTableModel.MemberNode member = defaultTopoTableModel4.new DefaultTopoTableModel.MemberNode(zmemID);
                        zoneGroup.addMember(member);
                        member.addData(new JCustomRendererTable.StatusCell(null, null, null));
                        member.addData(new JCustomRendererTable.MemberGroupLabelCell(zoneDisplayName, zoneGroup));
                        if (GraphDebug.isInfoVisible()) {
                            member.addData(new JCustomRendererTable.ComparableCell((Comparable)((Object)zmemID.getID().toString())));
                        }
                        member.addData(new JCustomRendererTable.CollatorCell(zmem.getDisplayName(), zmem.getCollationKey()));
                        String parentPrefix = null;
                        GraphEntity.ID parentID = zmem.getParentID();
                        if (parentID instanceof GraphSwitch.ID) {
                            parentPrefix = GuiUtil.getString("TOPO_LABEL_ENTITY_SWITCH");
                        } else if (parentID instanceof GraphComputer.ID) {
                            parentPrefix = GuiUtil.getString("TOPO_LABEL_ENTITY_COMPUTER");
                        } else if (parentID instanceof GraphSubsystem.ID) {
                            parentPrefix = GuiUtil.getString("TOPO_LABEL_ENTITY_SUBSYSTEM");
                        } else if (parentID instanceof GraphTapeLibrary.ID) {
                            parentPrefix = GuiUtil.getString("TOPO_LABEL_ENTITY_TAPELIBRARY");
                        } else if (parentID instanceof GraphOther.ID) {
                            parentPrefix = GuiUtil.getString("TOPO_LABEL_ENTITY_OTHER");
                        }
                        String parentDisplayName = zmem.getParentLabel();
                        if (parentPrefix != null) {
                            parentDisplayName = parentPrefix + " (" + parentDisplayName + ")";
                        }
                        member.addData(new JCustomRendererTable.CollatorCell(parentDisplayName, collator.getCollationKey(parentDisplayName)));
                        String fcportDisplayName = zmem.getFCPortLabel();
                        member.addData(new JCustomRendererTable.CollatorCell(fcportDisplayName, collator.getCollationKey(fcportDisplayName)));
                        member.addData(new JCustomRendererTable.ComparableCell((Comparable)((Object)zmem.getFCPortPortNumber())));
                    }
                }
            }
        }
        this.arrange();
    }

    protected void handleTableSelection() {
        ControllerView controllerView = this.tabular.getControllerView();
        ControllerView.HighlightDelta delta = new ControllerView.HighlightDelta(controllerView.getHighlight());
        delta.removeAll();
        int[] selectedRows = this.table.getSelectedRows();
        for (int i = 0; i < selectedRows.length; ++i) {
            GraphFCPort.ID fcportID;
            int selectedRow = selectedRows[i];
            DefaultTopoTableModel.MemberNode member = this.tableModel.findMemberNode(selectedRow);
            GraphEntity.ID nodeID = member.getRef();
            if (!(nodeID instanceof GraphZoneMember.ID)) continue;
            GraphZoneMember zmem = (GraphZoneMember)this.dataModel.get(nodeID);
            GraphEntity.ID parentID = zmem.getParentID();
            if (parentID != null) {
                delta.add(parentID);
            }
            if ((fcportID = zmem.getFCPortID()) != null) {
                delta.add(fcportID);
            }
            delta.setClickedEntityID(nodeID);
        }
        controllerView.updateHighlight(delta);
    }

    public boolean applySelection(ControllerView.SelectionDelta delta) {
        return false;
    }
}

