/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ImageIcon;
import javax.swing.JInternalFrame;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.util.GraphDebug;
import org.eclipse.aperi.gui.topo.widget.JClosableTabbedPane;
import org.eclipse.aperi.gui.topo.widget.JTopoApp;
import org.eclipse.aperi.gui.topo.widget.JTopoMiniMap;
import org.eclipse.aperi.gui.topo.widget.JTopoView;
import org.eclipse.aperi.gui.topo.widget.TopoResource;

public class JTopoViewGroup
extends JClosableTabbedPane {
    protected JTopoApp topoApp;

    public JTopoViewGroup(JTopoApp topoApp) {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("JTopoViewGroup, constructor");
        }
        this.topoApp = topoApp;
        this.addChangeListener(new CL_TabSelected());
        this.addPropertyChangeListener(new PCL_TabRemoveIconClicked());
    }

    public JTopoView getFocusedTopoView() {
        return (JTopoView)this.getSelectedComponent();
    }

    public void setFocusedTopoView(JTopoView topoView) {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("JTopoViewGroup, setFocusedTopoView, topoView=" + topoView);
        }
        this.setSelectedComponent(topoView);
        this.reattachFocusedView();
    }

    protected void reattachFocusedView() {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("JTopoViewGroup, reattachFocusedView");
        }
        JTopoView topoView = this.getFocusedTopoView();
        this.requestFocus();
        JInternalFrame miniMapFrame = this.topoApp.getMiniMapFrame();
        Container c = miniMapFrame.getContentPane();
        JTopoMiniMap miniMap = topoView.getMiniMap();
        c.removeAll();
        c.add(miniMap);
        String title = topoView.getTitle();
        this.setViewTitle(topoView, title);
        Integer status = topoView.getStatus();
        this.setViewStatus(topoView, status);
        miniMapFrame.validate();
        miniMapFrame.repaint();
    }

    public void addTopoView(JTopoView topoView) {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("JTopoViewGroup, addTopoView, topoView=" + topoView);
        }
        this.add(topoView);
    }

    public void removeTopoView(JTopoView topoView) {
        int index;
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("JTopoViewGroup, removeTopoView, topoView=" + topoView);
        }
        if ((index = this.indexOfComponent(topoView)) != -1) {
            if (index == this.getTabCount() - 1) {
                --index;
            }
            this.remove(topoView);
            this.setSelectedIndex(index);
            this.reattachFocusedView();
        }
    }

    public void setViewTitle(JTopoView topoView, String title) {
        int tabIndex = this.indexOfComponent(topoView);
        if (tabIndex != -1) {
            this.setTitleAt(tabIndex, title);
            this.setToolTipTextAt(tabIndex, title);
            if ((JTopoView)this.getSelectedComponent() == topoView) {
                this.topoApp.getMiniMapFrame().setTitle(title);
            }
        }
    }

    public void setViewStatus(JTopoView topoView, Integer status) {
        ImageIcon icon = TopoResource.getIconHealth(status);
        int tabIndex = this.indexOfComponent(topoView);
        if (tabIndex != -1) {
            this.setIconAt(tabIndex, icon);
            if ((JTopoView)this.getSelectedComponent() == topoView) {
                this.topoApp.getMiniMapFrame().setFrameIcon(icon);
            }
        }
    }

    protected class PCL_TabRemoveIconClicked
    implements PropertyChangeListener {
        protected PCL_TabRemoveIconClicked() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals(JClosableTabbedPane.PCL_TABREMOVEICONCLICKED)) {
                GraphDebug.trace("JTopoViewGroup, PCL_TabRemoveIconClicked, propertyChange(), propName=" + e.getPropertyName());
                int tabIndex = (Integer)e.getOldValue();
                JTopoView topoView = (JTopoView)JTopoViewGroup.this.getComponentAt(tabIndex);
                GraphModel.ID focusedModelID = topoView.getControllerView().getModelID();
                JTopoViewGroup.this.topoApp.getControllerApp().closeView(focusedModelID);
            }
        }
    }

    protected class CL_TabSelected
    implements ChangeListener {
        protected CL_TabSelected() {
        }

        public void stateChanged(ChangeEvent e) {
            GraphDebug.trace("JTopoViewGroup, CL_TabSelected, stateChanged()");
            JTopoViewGroup.this.reattachFocusedView();
        }
    }
}

