/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget.plaf.basic;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.ImageObserver;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import org.eclipse.aperi.gui.topo.widget.JClosableTabbedPane;
import org.eclipse.aperi.gui.topo.widget.JTopoView;
import org.eclipse.aperi.gui.topo.widget.TopoResource;

public class BasicClosableTabbedPaneUI
extends BasicTabbedPaneUI
implements ImageObserver {
    private ImageIcon closeIcon;
    private ImageIcon refreshIcon;
    private Rectangle[] closeIconRects = new Rectangle[0];
    private Rectangle[] refreshIconRects = new Rectangle[0];

    public BasicClosableTabbedPaneUI() {
        this.closeIcon = TopoResource.ICON_TAB_CLOSE;
        this.refreshIcon = TopoResource.ICON_TAB_REFRESH;
        this.refreshIcon.setImageObserver(this);
    }

    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        for (int i = 0; i < this.refreshIconRects.length; ++i) {
            this.tabPane.repaint(this.refreshIconRects[i]);
        }
        if (infoflags < 16) {
            return true;
        }
        boolean anyInProgress = false;
        for (int i = 0; i < this.tabPane.getTabCount(); ++i) {
            JTopoView topoView = (JTopoView)this.tabPane.getComponentAt(i);
            if (!topoView.isRefreshInProgress()) continue;
            anyInProgress = true;
            break;
        }
        return anyInProgress;
    }

    protected void assureRectsCreated(int tabCount) {
        int i;
        Rectangle[] tempRects;
        super.assureRectsCreated(tabCount);
        int len = this.refreshIconRects.length;
        if (tabCount != len) {
            tempRects = new Rectangle[tabCount];
            System.arraycopy(this.refreshIconRects, 0, tempRects, 0, Math.min(len, tabCount));
            this.refreshIconRects = tempRects;
            for (i = len; i < tabCount; ++i) {
                this.refreshIconRects[i] = new Rectangle();
            }
        }
        if (tabCount != (len = this.closeIconRects.length)) {
            tempRects = new Rectangle[tabCount];
            System.arraycopy(this.closeIconRects, 0, tempRects, 0, Math.min(len, tabCount));
            this.closeIconRects = tempRects;
            for (i = len; i < tabCount; ++i) {
                this.closeIconRects[i] = new Rectangle();
            }
        }
    }

    protected int calculateTabWidth(int tabPlacement, int tabIndex, FontMetrics metrics) {
        boolean refreshInProgress;
        int width = super.calculateTabWidth(tabPlacement, tabIndex, metrics);
        JTopoView topoView = (JTopoView)this.tabPane.getComponentAt(tabIndex);
        String focusLevel = topoView.getDtataModel().getModelID().getFocusLevel();
        if (!"Overview".equals(focusLevel)) {
            width += this.textIconGap + this.closeIcon.getIconWidth();
        }
        if (refreshInProgress = topoView.isRefreshInProgress()) {
            width += this.textIconGap + this.refreshIcon.getIconWidth();
        }
        return width;
    }

    protected int calculateTabHeight(int tabPlacement, int tabIndex, int fontHeight) {
        int height = super.calculateTabHeight(tabPlacement, tabIndex, fontHeight);
        Rectangle refreshRect = this.refreshIconRects[tabIndex];
        Rectangle closeRect = this.closeIconRects[tabIndex];
        height = Math.max(height, this.closeIcon.getIconHeight());
        JTopoView topoView = (JTopoView)this.tabPane.getComponentAt(tabIndex);
        boolean refreshInProgress = topoView.isRefreshInProgress();
        if (refreshInProgress) {
            height = Math.max(height, this.refreshIcon.getIconHeight());
        }
        return height += 4;
    }

    protected void layoutLabel(int tabPlacement, FontMetrics metrics, int tabIndex, String title, Icon icon, Rectangle tabRect, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        int y;
        int x;
        int height;
        int width;
        int w;
        super.layoutLabel(tabPlacement, metrics, tabIndex, title, icon, tabRect, iconRect, textRect, isSelected);
        JTopoView topoView = (JTopoView)this.tabPane.getComponentAt(tabIndex);
        String focusLevel = topoView.getDtataModel().getModelID().getFocusLevel();
        Rectangle refreshRect = this.refreshIconRects[tabIndex];
        Rectangle closeRect = this.closeIconRects[tabIndex];
        boolean refreshInProgress = topoView.isRefreshInProgress();
        if (!refreshInProgress && !"Overview".equals(focusLevel)) {
            w = this.textIconGap + this.closeIcon.getIconWidth();
            iconRect.x -= w / 2;
            textRect.x -= w / 2;
        } else if (refreshInProgress && "Overview".equals(focusLevel)) {
            w = this.refreshIcon.getIconWidth() + this.textIconGap;
            iconRect.x += w / 2;
            textRect.x += w / 2;
        }
        if (refreshInProgress) {
            width = this.refreshIcon.getIconWidth();
            height = this.refreshIcon.getIconHeight();
            x = iconRect.x - this.textIconGap - width;
            y = tabRect.y + (tabRect.height - height) / 2;
            refreshRect.setBounds(x, y, width, height);
        }
        if (!"Overview".equals(focusLevel)) {
            width = this.closeIcon.getIconWidth();
            height = this.closeIcon.getIconHeight();
            x = textRect.x + textRect.width + this.textIconGap;
            y = tabRect.y + (tabRect.height - height) / 2;
            closeRect.setBounds(x, y, width, height);
        }
    }

    public static ComponentUI createUI(JComponent c) {
        return new BasicClosableTabbedPaneUI();
    }

    protected void paintTab(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect) {
        String focusLevel;
        super.paintTab(g, tabPlacement, rects, tabIndex, iconRect, textRect);
        JTopoView topoView = (JTopoView)this.tabPane.getComponentAt(tabIndex);
        Rectangle refreshRect = this.refreshIconRects[tabIndex];
        Rectangle closeRect = this.closeIconRects[tabIndex];
        boolean refreshInProgress = topoView.isRefreshInProgress();
        if (refreshInProgress) {
            this.refreshIcon.paintIcon(this.tabPane, g, refreshRect.x, refreshRect.y);
        }
        if (!"Overview".equals(focusLevel = topoView.getDtataModel().getModelID().getFocusLevel())) {
            this.closeIcon.paintIcon(this.tabPane, g, closeRect.x, closeRect.y);
        }
    }

    protected MouseListener createMouseListener() {
        return new MouseHandler();
    }

    protected class MouseHandler
    extends BasicTabbedPaneUI.MouseHandler {
        protected MouseHandler() {
            super(BasicClosableTabbedPaneUI.this);
        }

        public void mouseClicked(MouseEvent e) {
            Rectangle closeRect;
            super.mouseClicked(e);
            Point p = e.getPoint();
            int tabIndex = -1;
            for (int i = 0; i < BasicClosableTabbedPaneUI.this.tabPane.getTabCount(); ++i) {
                if (!BasicClosableTabbedPaneUI.this.rects[i].contains(p.x, p.y)) continue;
                tabIndex = i;
            }
            if (tabIndex != -1 && (closeRect = BasicClosableTabbedPaneUI.this.closeIconRects[tabIndex]).contains(p)) {
                BasicClosableTabbedPaneUI.this.tabPane.firePropertyChange(JClosableTabbedPane.PCL_TABREMOVEICONCLICKED, tabIndex, -1);
            }
        }
    }
}

