/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.guid.impl;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Serializable;
import java.util.UUID;

public class GUIDImpl
implements Serializable {
    static final long serialVersionUID = -1100099098385751265L;
    private UUID jguid;

    public static GUIDImpl readGUID() {
        GUIDImpl guid = null;
        try {
            BufferedReader in = new BufferedReader(new FileReader("../guid.txt"));
            String line = in.readLine();
            guid = new GUIDImpl(line);
        }
        catch (Exception e) {
            guid = null;
        }
        return guid;
    }

    public GUIDImpl(UUID uuid) throws Exception {
        StringBuffer sb = new StringBuffer();
        String u = uuid.toString();
        for (int i = 0; i < u.length(); ++i) {
            if (u.charAt(i) == '-') continue;
            sb.append(u.charAt(i));
        }
        String s = sb.toString();
        String j15GUID = this.noDotsToJava15(s);
        this.jguid = UUID.fromString(j15GUID);
    }

    public GUIDImpl(String dottedGUID) throws Exception {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < 47; ++i) {
            if ((i + 1) % 3 == 0) continue;
            sb.append(dottedGUID.charAt(i));
        }
        String undottedGUID = new String(sb);
        String j15GUID = this.noDotsToJava15(undottedGUID);
        this.jguid = UUID.fromString(j15GUID);
    }

    public GUIDImpl(String undottedGUID, int dummy) {
        String j15GUID = this.noDotsToJava15(undottedGUID);
        this.jguid = UUID.fromString(j15GUID);
    }

    public String toString() {
        String s = this.toNoDotString();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            sb.append(s.charAt(i));
            if ((i + 1) % 2 != 0 || i == s.length() - 1) continue;
            sb.append('.');
        }
        return new String(sb);
    }

    public String toNoDotString() {
        String s = this.jguid.toString();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '-') continue;
            sb.append(c);
        }
        return new String(sb);
    }

    public String toJava15String() {
        return this.jguid.toString();
    }

    public byte[] toByteArray() {
        String undottedGUID = this.toNoDotString();
        byte[] bytes = new byte[16];
        for (int i = 0; i < 16; ++i) {
            bytes[i] = (byte)Integer.parseInt(undottedGUID.substring(i * 2, i * 2 + 2), 16);
        }
        return bytes;
    }

    String noDotsToJava15(String in) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < 32; ++i) {
            sb.append(in.charAt(i));
            if (i != 7 && i != 11 && i != 15 && i != 19) continue;
            sb.append('-');
        }
        return new String(sb);
    }
}

