/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.SQLExceptionHelper;
import org.eclipse.aperi.infrastructure.database.objects.Identifier;
import org.eclipse.aperi.infrastructure.database.sql.SqlIdentifier;
import org.eclipse.aperi.sanmgmt.Variables;

public class AutoIdentifier {
    public static final int RESOURCE_ID = 1;
    public static final int RUN_NUMBER_ID = 2;
    public static final int SCHEDULE_ID = 3;
    public static final int JOB_ID = 4;
    public static final int CALENDAR_ID = 5;
    public static final int ALERT_LOG_ID = 6;
    public static final int DEVICE_SERVER_RUN_ID = 7;
    public static final int TOKEN_ID = 8;
    public static final int SNAPSHOT_ID = 9;
    public static final int SNMP_ID = 10;
    public static final int PM_TIME_ID = 11;
    public static final int PM_RECORD_ID = 12;
    public static final int VENDOR_ID = 13;
    public static final int MODEL_ID = 14;
    public static final int CLASSNAME_ID = 15;
    public static final int SWITCHTYPE_ID = 16;
    public static List idList = null;
    private static final int ALLOC_LEN = 1000;
    private static final int MIN_LEN = 100;
    public static String baseDir = null;
    public static final String cacheFile = "idList";

    public static void initialize() {
        try {
            baseDir = Variables.getBaseDirectory();
            baseDir = baseDir + File.separator;
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(baseDir + cacheFile));
            int len = ois.readInt();
            idList = Collections.synchronizedList(new LinkedList());
            for (int i = 0; i < len; ++i) {
                int start = ois.readInt();
                int count = ois.readInt();
                int idType = ois.readInt();
                idList.add(new idElement(start, count, idType));
            }
            ois.close();
            File f = new File(baseDir + cacheFile);
            f.delete();
        }
        catch (FileNotFoundException fe) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void shutdown() {
        try {
            if (idList != null) {
                ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(baseDir + cacheFile));
                oos.writeInt(idList.size());
                ListIterator iter = idList.listIterator();
                while (iter.hasNext()) {
                    idElement el = (idElement)iter.next();
                    oos.writeInt(el.start);
                    oos.writeInt(el.count);
                    oos.writeInt(el.idType);
                }
                oos.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static synchronized int getIdentifier(int idType, int idCount) throws SQLException {
        idElement el;
        int total_len = 0;
        int max_len = 0;
        if (idList != null) {
            ListIterator iter = idList.listIterator();
            while (iter.hasNext()) {
                el = (idElement)iter.next();
                if (el.idType != idType) continue;
                total_len += el.count;
                if (el.count <= max_len) continue;
                max_len = el.count;
            }
        }
        if (total_len < 100) {
            int start = AutoIdentifier.getIdentifierFromDB(idType, 1000);
            if (idList == null) {
                idList = Collections.synchronizedList(new LinkedList());
            }
            el = new idElement(start, 1000, idType);
            idList.add(el);
            total_len += 1000;
            if (1000 > max_len) {
                max_len = 1000;
            }
        }
        if (idCount > max_len) {
            int ret_val = AutoIdentifier.getIdentifierFromDB(idType, idCount);
            return ret_val;
        }
        int ret_val = -1;
        idElement target_el = null;
        ListIterator iter = idList.listIterator();
        while (iter.hasNext()) {
            idElement el2 = (idElement)iter.next();
            if (el2.idType != idType || idCount > el2.count) continue;
            ret_val = el2.start;
            el2.start += idCount;
            el2.count -= idCount;
            target_el = el2;
            break;
        }
        if (target_el.count == 0) {
            idList.remove(target_el);
        }
        return ret_val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getIdentifierFromDB(int idType, int idCount) throws SQLException {
        DBConnPoolDataSource ds = DBConnPoolDataSource.getInstance();
        DBConnection dbConnection = (DBConnection)ds.getPooledConnection();
        Connection con = dbConnection.getConnection();
        DatabaseMetaData dbmd = con.getMetaData();
        String db_vendor = dbmd.getDatabaseProductName();
        int deadlockRetries = 3;
        int ret = -1;
        try {
            while (true) {
                try {
                    Identifier id = new Identifier();
                    Vector<ColumnInfo> v1 = new Vector<ColumnInfo>();
                    Vector<String> v2 = new Vector<String>();
                    v1.add(Identifier.getColumnInfo("IDENTIFIER"));
                    v2.add(String.valueOf(idCount));
                    v1.add(Identifier.getColumnInfo("ID_TYPE"));
                    v2.add(String.valueOf(idType));
                    Hashtable params = ComplexQuery.generateHashtable(v1, v2);
                    int rowCount = SqlIdentifier.sqlUpdate(dbConnection, SqlIdentifier.updateIdentifierIndex, params);
                    if (rowCount <= 0) {
                        throw new SQLException("No rows were updated in the identifier table for ID type " + idType + " and ID count " + idCount);
                    }
                    id.setIdType(idType);
                    id.retrieve(dbConnection);
                    int identifier = id.getIdentifier();
                    dbConnection.commit();
                    ret = identifier - idCount;
                }
                catch (SQLException e) {
                    block11: {
                        if (SQLExceptionHelper.isDeadlock(dbConnection, e) && --deadlockRetries >= 0) {
                            try {
                                Thread.sleep(2000L);
                            }
                            catch (InterruptedException ie) {
                                // empty catch block
                                break block11;
                            }
                            continue;
                        }
                    }
                    throw e;
                }
                break;
            }
        }
        finally {
            if (dbConnection != null) {
                dbConnection.close();
            }
            return ret;
        }
    }

    private static class idElement
    implements Serializable {
        int start;
        int count;
        int idType;

        public idElement(int start, int count, int idType) {
            this.start = start;
            this.count = count;
            this.idType = idType;
        }
    }
}

