/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database;

import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import org.eclipse.aperi.infrastructure.database.AutoIdentifier;
import org.eclipse.aperi.infrastructure.database.CurrentTime;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.Database;

public class DBConnPoolDataSource
implements ConnectionPoolDataSource {
    private static Pool pool = null;
    private static DBConnPoolDataSource ds = null;
    private static boolean initialized = false;
    private static int nextLeasedCountLevel = 25;

    private DBConnPoolDataSource() {
    }

    public static synchronized void initialize(String driver, String url, String schema, String user, String password, int maxConn) {
        AutoIdentifier.initialize();
        pool = new Pool(driver, url, schema, user, password, maxConn);
        if (!initialized) {
            initialized = true;
        } else {
            Exception whereami = new Exception("Multiple invocations of DBConnPoolDataSource.initialize() detected");
            DBConnection.debugPrintException(whereami);
        }
    }

    public static synchronized void initialize(String driverJar, String driver, String url, String schema, String user, String password, int maxConn) {
        AutoIdentifier.initialize();
        pool = new Pool(driverJar, driver, url, schema, user, password, maxConn);
        if (!initialized) {
            initialized = true;
        } else {
            Exception whereami = new Exception("Multiple invocations of DBConnPoolDataSource.initialize() detected");
            DBConnection.debugPrintException(whereami);
        }
    }

    public static synchronized DBConnPoolDataSource getInstance() {
        if (ds == null) {
            ds = new DBConnPoolDataSource();
        }
        return ds;
    }

    public static synchronized void closeInstance() throws SQLException {
        pool.shutdown();
        AutoIdentifier.shutdown();
        ds = null;
        pool = null;
    }

    public static void returnConnection(DBConnection conn) throws SQLException {
        pool.add(conn);
    }

    public static int connectionCount() {
        return pool.getConnectionCount();
    }

    public PooledConnection getPooledConnection() throws SQLException {
        DBConnection conn = null;
        if (ds == null || pool == null) {
            throw new SQLException("No connection pool exists");
        }
        try {
            conn = pool.remove();
            conn.clear();
            conn.setAutoCommit(false);
            if (conn.getTransactionIsolation() != DBConnPoolDataSource.pool.level) {
                conn.setTransactionIsolation(DBConnPoolDataSource.pool.level);
            }
        }
        catch (SQLException sqle) {
            DBConnection.debugPrintException(sqle);
            pool.printLeasedConnections();
            throw sqle;
        }
        return conn;
    }

    public PooledConnection getPooledConnection(String user, String password) throws SQLException {
        throw new SQLException("The method getPooledConnection(user, password) is not implemented");
    }

    public PrintWriter getLogWriter() throws SQLException {
        return null;
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
    }

    public void setLoginTimeout(int seconds) throws SQLException {
    }

    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    public static void printLeasedConnections() {
        pool.printLeasedConnections();
    }

    public static void printLeasedConnections(PrintWriter pw) {
        pool.printLeasedConnections(pw);
    }

    public static synchronized void printLeasedConnectionsWithStatements(PrintWriter pw) {
        pool.printLeasedConnectionsWithStatements(pw);
    }

    private static class Pool {
        private int maxConn;
        private Database db;
        private LinkedList queue = new LinkedList();
        private Hashtable leasedConnH = new Hashtable();
        public int connectionCount = 0;
        private String schema;
        public int level = 2;

        public Pool(String driver, String url, String schema, String user, String password, int maxConn) {
            this.maxConn = maxConn;
            this.db = new Database(url, user, password);
            this.db.setDriver(driver);
            this.schema = schema;
        }

        public Pool(String driverJar, String driver, String url, String schema, String user, String password, int maxConn) {
            this.maxConn = maxConn;
            this.db = new Database(url, user, password);
            Database.setDriverJar(driverJar);
            this.db.setDriver(driver);
            this.schema = schema;
        }

        public synchronized void shutdown() throws SQLException {
            SQLException ee = null;
            Enumeration enu = this.leasedConnH.keys();
            while (enu.hasMoreElements()) {
                DBConnection conn = (DBConnection)enu.nextElement();
                try {
                    conn.commit();
                    conn.closeReal();
                }
                catch (SQLException e) {
                    ee = e;
                }
            }
            int size = this.queue.size();
            for (int i = 0; i < size; ++i) {
                DBConnection conn = (DBConnection)this.queue.removeFirst();
                try {
                    conn.closeReal();
                    continue;
                }
                catch (SQLException e) {
                    ee = e;
                }
            }
            this.connectionCount = 0;
            if (ee != null) {
                throw ee;
            }
        }

        public synchronized void add(DBConnection conn) throws SQLException {
            Object obj = this.leasedConnH.remove(conn);
            if (obj != null) {
                if (this.queue.size() < this.maxConn) {
                    this.queue.addLast(conn);
                } else {
                    conn.closeReal();
                }
                --this.connectionCount;
            } else {
                DBConnection.debugPrintException(new Exception("Connection is being closed multiple times"));
                throw new SQLException("Connection is being closed multiple times");
            }
        }

        public synchronized DBConnection remove() throws SQLException {
            DBConnection conn = null;
            boolean valid = true;
            do {
                valid = true;
                if (this.queue.size() == 0) {
                    conn = this.db.getConnection();
                    conn.setSchema(this.schema);
                    this.level = conn.getTransactionIsolation();
                } else {
                    conn = (DBConnection)((DBConnection)this.queue.removeLast()).clone();
                }
                try {
                    CurrentTime.initialize(conn);
                }
                catch (SQLException e) {
                    DBConnection.debugPrintExceptions("Stale connection encountered =  " + conn.getConnection().toString(), null);
                    valid = false;
                }
            } while (!valid);
            if (conn != null) {
                ++this.connectionCount;
                this.leasedConnH.put(conn, new Exception("Leased " + conn));
            }
            return conn;
        }

        public synchronized int getConnectionCount() {
            return this.connectionCount;
        }

        public synchronized int getLeasedConnectionCount() {
            return this.leasedConnH.size();
        }

        public synchronized void printLeasedConnections() {
            DBConnection.debugPrintExceptions("Leased connection count is " + this.getLeasedConnectionCount(), this.leasedConnH.elements());
        }

        public synchronized void printLeasedConnections(PrintWriter pw) {
            DBConnection.debugPrintExceptions(pw, "Leased connection count is " + this.getLeasedConnectionCount(), this.leasedConnH.elements());
        }

        public synchronized void printLeasedConnectionsWithStatements(PrintWriter pw) {
            DBConnection.debugPrintln(pw, "Leased connection count is " + this.getLeasedConnectionCount());
            Enumeration enu = this.leasedConnH.keys();
            while (enu.hasMoreElements()) {
                DBConnection conn = (DBConnection)enu.nextElement();
                DBConnection.debugPrintException(pw, (Exception)this.leasedConnH.get(conn));
                conn.printActiveTransaction(pw);
                conn.printOpenStatements(pw);
            }
        }
    }
}

