/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database;

import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.eclipse.aperi.infrastructure.database.DBConnection;

public class Database
implements Serializable {
    static final String className = Database.class.getName();
    private static final String db2AppDriver = "COM.ibm.db2.jdbc.app.DB2Driver";
    private static final String db2NetDriver = "COM.ibm.db2.jdbc.net.DB2Driver";
    private static final String db2JccDriver = "com.ibm.db2.jcc.DB2Driver";
    private String driver = "COM.ibm.db2.jdbc.app.DB2Driver";
    private boolean isJccDriver = false;
    private String url;
    private String user;
    private String password;
    private boolean autoCommit = false;
    private static ClassLoader loader = null;
    private static Driver driverInstance = null;
    private static Class loadedDriverClass = null;
    private static final String envName = "APERI";

    public Database(String url, String user, String password) {
        this.url = url;
        this.user = user;
        this.password = password;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
        if (driver != null && driver.equals(db2JccDriver)) {
            this.isJccDriver = true;
        }
    }

    public static void setDriverJar(String driverJar) {
        if (driverJar != null) {
            URL[] classpath = null;
            if (driverJar.toLowerCase().endsWith("db2jcc.jar")) {
                int index = driverJar.lastIndexOf(File.separator);
                String dir = null;
                dir = index == -1 ? "" : driverJar.substring(0, index + 1);
                classpath = new URL[2];
                try {
                    classpath[0] = new URL("file", null, dir + "db2jcc.jar");
                    classpath[1] = new URL("file", null, dir + "db2jcc_license_cu.jar");
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                    return;
                }
            }
            classpath = new URL[1];
            try {
                classpath[0] = new URL("file", null, driverJar);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                return;
            }
            loader = new URLClassLoader(classpath, Database.class.getClassLoader());
        }
    }

    public static synchronized Class loadDriver(String driver) {
        String methodName = "loadDriver";
        Class<?> c = loadedDriverClass;
        if (loadedDriverClass == null) {
            try {
                c = loader == null ? Class.forName(driver) : Class.forName(driver, true, loader);
                driverInstance = (Driver)c.newInstance();
                loadedDriverClass = c;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (!loadedDriverClass.getName().equals(driver)) {
            // empty if block
        }
        return c;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return null;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean getAutoCommit() {
        return this.autoCommit;
    }

    public void setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    public synchronized DBConnection getConnection() throws SQLException {
        return this.getConnection(this.url, this.user, this.password);
    }

    private synchronized DBConnection getConnection(String url, String user, String password) throws SQLException {
        String methodName = "getConnection";
        DBConnection dbc = null;
        Connection connection = null;
        Database.loadDriver(this.driver);
        Properties p = new Properties();
        p.setProperty("user", user);
        p.setProperty("password", password);
        if (this.isJccDriver) {
            p.setProperty("clientProgramName", envName + Thread.currentThread().getName());
        }
        connection = driverInstance == null ? DriverManager.getConnection(url, p) : driverInstance.connect(url, p);
        connection.setAutoCommit(this.autoCommit);
        dbc = new DBConnection(connection);
        return dbc;
    }
}

