/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.Properties;
import java.util.Random;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.Debug;

public class TpcDBDataPopulator {
    protected static String schema = "Aperi.";
    protected static String url = "jdbc:derby://localhost:1527/Aperi";
    protected static String user = "Aperi";
    protected static String password = "Aperi";
    static boolean failIfAlreadyExists = false;
    static Random rand = new Random(0L);
    static Connection con = null;
    public static final String INSERT_SERVER = "INSERT INTO " + schema + "T_RES_HOST " + "\t(GUID, HOST_URL, OS_TYPE, OS_VERSION, " + "\tNETWORK_NAME, DOMAIN_NAME, COMPUTER_ID, HOST_NAME, HARDWARE_ID, VENDOR_ID, " + "\tTIME_ZONE, DISCOVERED_TIME, CPU_ARCHITECTURE, ORIGINAL_ALIAS," + "\tDETECTABLE, OPERATIONAL_STATUS, CONSOLIDATED_STATUS)" + "\tVALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    public static int modelId = 0;
    public static String INSERT_MODEL = "INSERT INTO " + schema + "T_RES_MODEL (MODEL_ID, MODEL_NAME, MODEL_DESCRIPTION) VALUES (?,?,?)";
    public static String[] NAMES = new String[]{"Mayaguez", "Aguadilla", "CaboRojo", "Moca", "SanGerman", "Ponce", "Patillas", "Penuelas", "SanJuan", "Vieques", "Culebra", "Anasco", "Arecibo", "Adjuntas", "Aibonito", "Aguada", "Isabela", "LasMarias", "Maricao", "SabanaGrande", "Guanica", "Lares", "Cayey", "Camuy", "Carolina", "Canovanas", "RioGrande", "RioPiedras", "VegaBaja", "VegaAlta", "ToaBaja", "Jayuya", "Utuado", "Florida", "Hatillo", "Quebradillas", "SanSebastian", "Yauco", "Fajardo", "SantaIsabelle", "Humacao", "Manati", "Ciales", "Villalba", "Barceloneta", "Naranjito", "Comerio", "AguasBuenas", "Cidra", "Luquillo", "Naguabo", "Ceiba", "SanLorenzo", "Arroyo", "Maunabo", "Orocovis", "Bayamon"};
    static int TOTAL_SERVERS = 800;
    static int TOTAL_SWITCHES = 10;
    static int TOTAL_SA = 10;
    static int guid = 0;
    static int nameCtr = 0;
    static int computerId = 299;
    public static final String INSERT_HBA = "INSERT INTO " + schema + "T_RES_HBA " + "\t(VENDOR_ID, MODEL_ID, API_VERSION, HBA_WWN, HBA_ID, NAME, SERIAL_NUMBER, DRIVER_VERSION," + "\tDRIVER_NAME, HOST_ID," + "\tDETECTABLE, OPERATIONAL_STATUS, CONSOLIDATED_STATUS)" + "\tVALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    static int nodeId = 0;
    public static final String INSERT_NODE = "INSERT INTO " + schema + "T_RES_NODE " + "\t(SCSI_SUPPORT, " + "\tNODE_ID, " + "\tNAME, " + "\tNAME_FORMAT, " + "\tPLATFORM_TYPE, RNID_TYPE, SYSTEM_ID," + "\tBLADE_ID, DISPLAY_NAME, DISPLAY_ICON_TYPE, " + "\tMGMT_URL_ADDR, MGMT_TEL_ADDR, MGMT_SNMP_ADDR," + "\tDETECTABLE, OPERATIONAL_STATUS, CONSOLIDATED_STATUS)" + "\tVALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    static int node2HbaId = 0;
    public static final String INSERT_NODE2HBA = "INSERT INTO " + schema + "T_RES_NODE2HBA " + "\t(NODE2HBA_ID, NODE_ID, HBA_ID," + "\tDETECTABLE, OPERATIONAL_STATUS, CONSOLIDATED_STATUS)" + "\tVALUES (?, ?, ?, ?, ?, ?)";
    static int portId = 0;
    public static final String INSERT_PORT = "INSERT INTO " + schema + "T_RES_PORT " + "\t(PORT_ID, NAME, NAME_FORMAT, PORT_NUMBER, TYPE, " + "\tNODE_ID, DISPLAY_NAME, DISPLAY_ICON_TYPE, RIO_LOOP_ID, " + "\tDETECTABLE, OPERATIONAL_STATUS, CONSOLIDATED_STATUS)" + "\tVALUES (?, ?, ?, ?, ?,  ?, ?, ?, ?, ?, ?, ? )";
    public static int portStatId = 0;
    public static final String INSERT_PORT_STAT = "INSERT INTO " + schema + "T_PRF_FABRIC_PORT " + "\t(TIME_ID, PORT_ID, INTERVAL_LEN, SEND_KB, RECV_KB, SEND_PKTS, RECV_PKTS, PEAK_TX_RATE, PEAK_RX_RATE)" + "\tVALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
    public static int hbaID = 0;
    public static final String INSERT_SWITCH = "INSERT INTO " + schema + "T_RES_SWITCH " + "\t(SWITCH_WWN, SWITCH_ID, VENDOR_ID, MODEL_ID, PARENT_SWITCH_WWN, SERIAL_NUMBER, DESCRIPTION," + "\tCONTACT, LOCATION, IP_ADDRESS,  DISPLAY_NAME, DOMAIN, MANAGEMENT_ID, MGMT_TEL_ADDR," + "\tMGMT_SNMP_ADDR, MGMT_URL_ADDR, VERSION," + "\tDETECTABLE, OPERATIONAL_STATUS, CONSOLIDATED_STATUS, USER_ATTRIB1, USER_ATTRIB2, USER_ATTRIB3)" + "\tVALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    public static int switch2portId = 0;
    public static final String INSERT_SWITCH2PORT = "INSERT INTO " + schema + "T_RES_SWITCH2PORT " + "\t(SWITCH2PORT_ID, SWITCH_WWN, PORT_ID)" + "\tVALUES (?, ?, ?)";
    public static int switchId = 0;
    public static final String INSERT_STORAGE_SUBSYSTEM = "INSERT INTO " + schema + "T_RES_STORAGE_SUBSYSTEM " + "\t(SUBSYSTEM_ID, " + "\tALLOCATED_CAPACITY, " + "\tAVAILABLE_CAPACITY, " + "\tBACKEND_STORAGE_CAPACITY," + "\tVENDOR_ID, " + "\tMODEL_ID," + "\tNAME, " + "\tNAME_FORMAT, " + "\tCACHE, " + "\tNVS, " + "\tDG_FREESPACE," + "\tN_DISKS, " + "\tN_LUNS, " + "\tLAST_PROBE_TIME, " + "\tPROBE_STATUS, " + "\tGROUP_ID, \t" + "\tVG_CAPACITY," + "\tVG_FREESPACE, " + "\tOS_TYPE, " + "\tPRODUCT_STATES, " + "\tTYPE, " + "\tIP_ADDRESS, " + "\tCODE_LEVEL," + "\tSERIAL_NUMBER," + "\tDISPLAY_NAME,  " + "\tDETECTABLE, OPERATIONAL_STATUS, CONSOLIDATED_STATUS)" + "\tVALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, " + "\t\t?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    public static final String INSERT_PHY_PE = "INSERT INTO " + schema + "T_RES_PHY_PE " + "\t(PHY_PE_ID, PE_NAME, SERIAL_NUMBER, VENDOR_ID, MODEL_ID, FIRMWARE_REVISION, DISPLAY_NAME) " + "\tVALUES (?, ?, ?, ?, ?, ?, ?)";
    public static final String INSERT_PE2NODE = "INSERT INTO " + schema + "T_RES_PE2NODE " + "\t(PE2NODE_ID, PHY_PE_ID, NODE_ID, DETECTABLE) " + "\tVALUES (?, ?, ?, ?)";
    public static int pe2nodeId = 0;
    public static int phyPEId = 0;
    public static short subsystemId = 0;
    public static int fabricId = 0;
    public static final String INSERT_FABRIC = "INSERT INTO " + schema + "T_RES_FABRIC " + "\t(FABRIC_WWN, " + "\tFABRIC_ID, SAN_WWN, SUPPORTS_ZONING, ACTIVE, PARENT_FABRIC_WWN, IS_PHYSICAL, DISPLAY_NAME, " + "\tCREATION_CLASS_NAME_ID, " + "\tDETECTABLE, OPERATIONAL_STATUS, CONSOLIDATED_STATUS, USER_ATTRIB1, USER_ATTRIB2, USER_ATTRIB3)" + "\tVALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    public static int fabrid2SwitchID = 0;
    public static final String INSERT_FABRIC2SWITCH = "INSERT INTO " + schema + "T_RES_FABRIC2SWITCH " + "\t(FABRIC2SWITCH_ID, FABRIC_WWN, SWITCH_WWN," + "\tDETECTABLE, OPERATIONAL_STATUS, CONSOLIDATED_STATUS)" + "\tVALUES (?, ?, ?, ?, ?, ?)";
    public static int port2portId = 0;
    public static final String INSERT_PORT2PORT = "INSERT INTO " + schema + "T_RES_PORT2PORT " + "\t(PORT2PORT_ID, PORT_ID1, PORT_ID2," + "\tDETECTABLE, OPERATIONAL_STATUS, CONSOLIDATED_STATUS)" + "\tVALUES (?, ?, ?, ?, ?, ?)";
    public static final String INSERT_STORAGE_VOLUME = "INSERT INTO " + schema + "T_RES_STORAGE_VOLUME " + "\t(SVID, CAPACITY, PACKAGE_REDUNDANCY, DATA_REDUNDANCY, SIZE_ALLOCATED," + "\tBLOCK_SIZE, CONSUMABLE_BLOCKS, NATIVE_STATUS, NUMBER_OF_BLOCKS, THROTTLE," + "\tNAME, NAME_FORMAT, SUBSYSTEM_ID, " + "\t POOL_ID,  LOGICAL_DISK_TYPE, MIRROR_COUNT," + "\tIS_SWAP, USE_COUNT, SNAP_SOURCE_ID, IS_VCMDB, REPLICATION_MODE, NOT_EXPOSED, OVERHEAD, LSS," + "\tSERIAL_NUMBER, " + "\tDETECTABLE, OPERATIONAL_STATUS, CONSOLIDATED_STATUS)" + "\tVALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, " + "\t?, ?, ?, ?, ?, ?)";
    static int vol = 1;
    public static final String INSERT_STORAGE_POOL = "INSERT INTO " + schema + "T_RES_STORAGE_POOL" + "\t(POOL_ID, TOTAL_MANAGED_SPACE, REMAINING_MANAGED_SPACE, PRIMORDIAL, CAPACITY, " + "\tEXTENT_SIZE, NATIVE_STATUS, NUMBER_OF_BACKEND_VOLUMES, NUMBER_OF_STORAGE_VOLUMES, " + "\tTOTAL_AVAILABLE_SPACE, ELEMENT_TYPE, RAID_LEVEL, NAME, " + "\tINSTANCE_ID, SUBSYSTEM_ID,  VOL_GROUP_TYPE,  CONFIG, DISK_GROUP_ID, " + "\tFORMAT, SURFACED_LUN_CAP, UNSURFACED_LUN_CAP, DISCOVERED_TIME, LAST_PROBE_TIME," + "\tDETECTABLE, OPERATIONAL_STATUS, CONSOLIDATED_STATUS, CLASS_NAME_ID) " + "\tVALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,  ?, ?, ?, ?, ?, ?, ?, ?, " + "\t?, ?, ?, ?, ?, ?, ?)";
    public static int physicalVolumeId = 0;
    public static String INSERT_PHYSICAL_VOLUME = "INSERT INTO " + schema + "T_RES_PHYSICAL_VOLUME " + "\t(PHYSICAL_VOLUME_ID, VENDOR_ID, MODEL_ID, DISK_GROUP_ID, SUBSYSTEM_ID, CAPACITY, OPERATIONAL_STATUS, DEVICE_ID) " + "\tVALUES (?, ?, ?, ?, ?, ?, ?, ?)";
    public static int diskGroupId = 0;
    public static final String INSERT_DISK_GROUP = "INSERT INTO " + schema + "T_RES_DISK_GROUP " + "\t(DISK_GROUP_ID, NAME, DESCRIPTION, RAID_LEVEL, ARRAY, STORAGE_EXTENT_ID, SUBSYSTEM_ID, TAG ) " + "\tVALUES (?, ?, ?, ?, ?, ?, ?, ?)";
    public static int extentId = 0;
    public static final String INSERT_STORAGE_EXTENT = "INSERT INTO " + schema + "T_RES_STORAGE_EXTENT " + "\t(STORAGE_EXTENT_ID, " + "\tNUM_EXTENTS, EXTENT_TYPE, POOL_ID, TOTAL_CAPACITY, FREE_SPACE, VOLS_IN_STORAGE_EXTENT, NAME, OTHER_NAME," + "\tCONFIG, VOL_GROUP_ID, GROUP_ID, CREATION_CLASS_NAME_ID, SYSTEM_CREATION_CLASS_NAME_ID, DEVICE_ID, SUBSYSTEM_ID, SYSTEM_NAMES_ID) " + "\tVALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?)";
    public static final String INSERT_DATA_PATH = "INSERT INTO " + schema + "T_RES_DATA_PATH" + "\t(DATA_PATH_ID, HOST_LUN_ID, DEVICE_LUN_ID, INITIATOR_PORT_ID, TARGET_PORT_ID, VOLUME_ID, UNKNOWN_HOST_NAME)" + "\tVALUES (?, ?, ?, ?, ?, ?, ?)";
    public static final String SELECT_HOST_FROM_WWN = "select distinct       HOST.COMPUTER_ID HOST_ID from       " + schema + "T_RES_HOST HOST, " + "\t\t" + schema + "T_RES_HBA HBA, " + schema + "T_RES_NODE2HBA NODE2HBA, " + schema + "T_RES_NODE NODE, " + "      " + schema + "T_RES_PORT PORT1 " + "where " + "      HOST.COMPUTER_ID = HBA.HOST_ID and " + "      HBA.HBA_ID = NODE2HBA.HBA_ID and " + "      NODE2HBA.NODE_ID = NODE.NODE_ID and " + "      NODE.NODE_ID = PORT1.NODE_ID and " + "      PORT1.NAME = ?";
    public static final String INSERT_ZSET = "INSERT INTO " + schema + "T_RES_ZSET " + "\t(ZSET_ID, SAN_WWN, ACTIVE, DESCRIPTION, ZSET_NAME)" + "\tVALUES (?, ?, ?, ?, ?)";
    public static final String INSERT_ZONE = "INSERT INTO " + schema + "T_RES_ZONE " + "\t(ZONE_ID, SAN_WWN, ZONE_TYPE, VENDOR_MODEL, ACTIVE, ZONE_NAME, DESCRIPTION)" + "\tVALUES (?, ?, ?, ?, ?, ?, ?)";
    public static final String INSERT_ZSET2ZONE = "INSERT INTO " + schema + "T_RES_ZSET2ZONE " + "\t(ZONE_ID, ZSET_ID)" + "\tVALUES (?, ?)";
    public static final String INSERT_ZSONE2PORT = "INSERT INTO " + schema + "T_RES_ZSET2PORT " + "\t(PORT_WWN, ZONE_ID)" + "\tVALUES (?, ?)";
    public static final String INSERT_ZONE2MEMBER = "INSERT INTO " + schema + "T_RES_ZONE2MEMBER " + "\t(ZONE_ID, MEMBER)" + "\tVALUES (?, ?)";
    public static String SELECT_PORTS_FROM_HOST = "select distinct    " + schema + "T_RES_HOST.COMPUTER_ID COMPUTER_ID, " + "    PORT1.PORT_ID PORT_ID " + "from " + "    " + schema + "T_RES_HOST," + schema + "T_RES_HBA HBA," + schema + "T_RES_NODE2HBA NODE2HBA," + schema + "T_RES_NODE NODE, " + "     " + schema + "T_RES_PORT PORT1 " + "where " + "     " + schema + "T_RES_HOST.COMPUTER_ID = HBA.HOST_ID and " + "      HBA.HBA_ID = NODE2HBA.HBA_ID and " + "      NODE2HBA.NODE_ID = NODE.NODE_ID and " + "      NODE.NODE_ID = PORT1.NODE_ID and" + "\t\t" + schema + "T_RES_HOST.COMPUTER_ID = ?";
    public static String SELECT_PORTS_FROM_SWITCH = "select distinct     PORT.PORT_ID PORT_ID from    " + schema + "T_RES_SWITCH SWITCH," + schema + "T_RES_SWITCH2PORT SWITCH2PORT, " + "    " + schema + "T_RES_PORT PORT " + "where " + "  SWITCH.SWITCH_WWN = ? and " + "  SWITCH.SWITCH_WWN = SWITCH2PORT.SWITCH_WWN and " + "  SWITCH2PORT.PORT_ID = PORT.PORT_ID";
    public static String SELECT_PORTS_FROM_SUBSYSTEM = "select distinct     PORT.PORT_ID PORT_ID from    " + schema + "T_RES_STORAGE_SUBSYSTEM SUBSYSTEM," + schema + "T_RES_NODE NODE, " + "   " + schema + "T_RES_PORT PORT " + "where " + "  SUBSYSTEM.SUBSYSTEM_ID = ? and " + "  SUBSYSTEM.SUBSYSTEM_ID = NODE.SYSTEM_ID and " + "  NODE.NODE_ID = PORT.NODE_ID";
    public static final String SELECT_CONNECTED_PORT = "select distinct     PORT2PORT.PORT_ID1 PORT_ID from     " + schema + "T_RES_PORT PORT1," + schema + "T_RES_PORT2PORT PORT2PORT " + "where " + "      PORT1.PORT_ID = ? and " + "      PORT1.PORT_ID = PORT2PORT.PORT_ID2 " + "union " + "select distinct " + "    PORT2PORT.PORT_ID2 PORT_ID " + "from " + "    " + schema + "T_RES_PORT PORT1," + schema + "T_RES_PORT2PORT PORT2PORT " + "where " + "      PORT1.PORT_ID = ? and " + "      PORT1.PORT_ID = PORT2PORT.PORT_ID1";
    public static final String SELECT_PORT_WWN_FROM_PORT_ID = "select distinct     PORT1.NAME NAME from     " + schema + "T_RES_PORT PORT1 " + "where " + "      PORT1.PORT_ID = ?";
    public static final String SELECT_HOST_FROM_ARRAY = "    select \t  HOST2FABRIC.COMPUTER_ID COMPUTER_ID from      (     SELECT distinct         FABRIC.FABRIC_WWN FABRIC_WWN,        " + schema + "T_RES_STORAGE_SUBSYSTEM.SUBSYSTEM_ID SUBSYSTEM_ID " + "    FROM " + "       " + schema + "T_RES_FABRIC FABRIC," + schema + "T_RES_FABRIC2SWITCH FABRIC2SWITCH," + schema + "T_RES_SWITCH SWITCH," + schema + "T_RES_SWITCH2PORT SWITCH2PORT, " + "       " + schema + "T_RES_NODE NODE," + schema + "T_RES_PORT2PORT PORT2PORT, " + "       " + schema + "T_RES_STORAGE_SUBSYSTEM," + schema + "T_RES_PORT PORT1," + schema + "T_RES_PORT PORT2 " + "    WHERE " + "        FABRIC.FABRIC_WWN = FABRIC2SWITCH.FABRIC_WWN AND " + "        FABRIC2SWITCH.SWITCH_WWN = SWITCH.SWITCH_WWN and " + "        SWITCH.SWITCH_WWN = SWITCH2PORT.SWITCH_WWN AND " + "        SWITCH2PORT.PORT_ID = PORT1.PORT_ID AND " + "        (PORT1.PORT_ID = PORT2PORT.PORT_ID1 AND PORT2PORT.PORT_ID2 = PORT2.PORT_ID) and " + "        PORT2.NODE_ID = NODE.NODE_ID AND " + "        NODE.SYSTEM_ID =" + schema + "T_RES_STORAGE_SUBSYSTEM.SUBSYSTEM_ID and " + "       " + schema + "T_RES_STORAGE_SUBSYSTEM.SUBSYSTEM_ID = ? " + "    union " + "    SELECT distinct " + "        FABRIC.FABRIC_WWN FABRIC_WWN, " + "       " + schema + "T_RES_STORAGE_SUBSYSTEM.SUBSYSTEM_ID SUBSYSTEM_ID " + "    FROM " + "       " + schema + "T_RES_FABRIC FABRIC," + schema + "T_RES_FABRIC2SWITCH FABRIC2SWITCH," + schema + "T_RES_SWITCH SWITCH," + schema + "T_RES_SWITCH2PORT SWITCH2PORT, " + "       " + schema + "T_RES_NODE NODE," + schema + "T_RES_PORT2PORT PORT2PORT, " + "       " + schema + "T_RES_STORAGE_SUBSYSTEM," + schema + "T_RES_PORT PORT1," + schema + "T_RES_PORT PORT2 " + "    WHERE " + "        FABRIC.FABRIC_WWN = FABRIC2SWITCH.FABRIC_WWN AND " + "        FABRIC2SWITCH.SWITCH_WWN = SWITCH.SWITCH_WWN and " + "        SWITCH.SWITCH_WWN = SWITCH2PORT.SWITCH_WWN AND " + "        SWITCH2PORT.PORT_ID = PORT1.PORT_ID AND " + "        (PORT1.PORT_ID = PORT2PORT.PORT_ID2 AND PORT2PORT.PORT_ID1 = PORT2.PORT_ID) and " + "        PORT2.NODE_ID = NODE.NODE_ID AND " + "        NODE.SYSTEM_ID =" + schema + "T_RES_STORAGE_SUBSYSTEM.SUBSYSTEM_ID and " + "       " + schema + "T_RES_STORAGE_SUBSYSTEM.SUBSYSTEM_ID = ? " + "        ) as FABRIC2SUBSYSTEM, " + " (  select distinct " + "     " + schema + "T_RES_HOST.COMPUTER_ID, " + "      FABRIC.FABRIC_WWN " + "      from " + "           " + schema + "T_RES_HOST," + schema + "T_RES_HBA HBA," + schema + "T_RES_NODE2HBA NODE2HBA," + schema + "T_RES_NODE NODE, " + "           " + schema + "T_RES_PORT PORT1," + schema + "T_RES_PORT PORT2," + schema + "T_RES_PORT2PORT PORT2PORT, " + "           " + schema + "T_RES_SWITCH SWITCH," + schema + "T_RES_FABRIC2SWITCH FABRIC2SWITCH," + schema + "T_RES_FABRIC FABRIC, " + "           " + schema + "T_RES_SWITCH2PORT SWITCH2PORT " + "      where " + "           " + schema + "T_RES_HOST.COMPUTER_ID = HBA.HOST_ID and " + "            HBA.HBA_ID = NODE2HBA.HBA_ID and " + "            NODE2HBA.NODE_ID = NODE.NODE_ID and " + "            NODE.NODE_ID = PORT1.NODE_ID and " + "            (PORT1.PORT_ID = PORT2PORT.PORT_ID2 and PORT2.PORT_ID = PORT2PORT.PORT_ID1) and " + "            PORT2.PORT_ID = SWITCH2PORT.PORT_ID and " + "            SWITCH2PORT.SWITCH_WWN = SWITCH.SWITCH_WWN and " + "            SWITCH.SWITCH_WWN = FABRIC2SWITCH.SWITCH_WWN and " + "            FABRIC2SWITCH.FABRIC_WWN = FABRIC.FABRIC_WWN " + "      union " + "      select distinct " + "     " + schema + "T_RES_HOST.COMPUTER_ID, " + "      FABRIC.FABRIC_WWN " + "      from " + "           " + schema + "T_RES_HOST," + schema + "T_RES_HBA HBA," + schema + "T_RES_NODE2HBA NODE2HBA," + schema + "T_RES_NODE NODE, " + "           " + schema + "T_RES_PORT PORT1," + schema + "T_RES_PORT PORT2," + schema + "T_RES_PORT2PORT PORT2PORT, " + "           " + schema + "T_RES_SWITCH SWITCH," + schema + "T_RES_FABRIC2SWITCH FABRIC2SWITCH," + schema + "T_RES_FABRIC FABRIC, " + "           " + schema + "T_RES_SWITCH2PORT SWITCH2PORT " + "      where " + "           " + schema + "T_RES_HOST.COMPUTER_ID = HBA.HOST_ID and " + "            HBA.HBA_ID = NODE2HBA.HBA_ID and " + "            NODE2HBA.NODE_ID = NODE.NODE_ID and " + "            NODE.NODE_ID = PORT1.NODE_ID and " + "            (PORT1.PORT_ID = PORT2PORT.PORT_ID1 and PORT2.PORT_ID = PORT2PORT.PORT_ID2) and " + "            PORT2.PORT_ID = SWITCH2PORT.PORT_ID and " + "            SWITCH2PORT.SWITCH_WWN = SWITCH.SWITCH_WWN and " + "            SWITCH.SWITCH_WWN = FABRIC2SWITCH.SWITCH_WWN and " + "            FABRIC2SWITCH.FABRIC_WWN = FABRIC.FABRIC_WWN " + "      ) as HOST2FABRIC " + "    where " + "       HOST2FABRIC.FABRIC_WWN = FABRIC2SUBSYSTEM.FABRIC_WWN ";
    public static final String SELECT_VOLUME_FROM_SUBSYSTEM = "SELECT distinct  \t" + schema + "T_RES_STORAGE_VOLUME.SVID SVID " + "FROM " + "   " + schema + "T_RES_STORAGE_VOLUME," + schema + "T_RES_STORAGE_SUBSYSTEM " + "WHERE " + "   " + schema + "T_RES_STORAGE_VOLUME.SUBSYSTEM_ID =" + schema + "T_RES_STORAGE_SUBSYSTEM.SUBSYSTEM_ID and " + "   " + schema + "T_RES_STORAGE_SUBSYSTEM.SUBSYSTEM_ID = ?";
    public static final String SELECT_SUBSYSTEM = "SELECT distinct \t" + schema + "T_RES_STORAGE_SUBSYSTEM.SUBSYSTEM_ID SUBSYSTEM_ID " + "FROM " + "   " + schema + "T_RES_STORAGE_SUBSYSTEM";

    public static void executeStmt(PreparedStatement stmt) throws SQLException {
        block3: {
            try {
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                if (failIfAlreadyExists) {
                    throw e;
                }
                if ("23505".equals(e.getSQLState())) break block3;
                throw e;
            }
        }
    }

    public static void deleteTable(String tableName) {
        try {
            PreparedStatement stmt = null;
            stmt = con.prepareStatement("DELETE FROM " + tableName);
            TpcDBDataPopulator.executeStmt(stmt);
            stmt.close();
        }
        catch (Exception e) {
            Debug.warning("Deleting tableNamed: " + tableName);
            Debug.warning(e);
            System.exit(-1);
        }
    }

    public static void cleanupFabric() {
        TpcDBDataPopulator.deleteTable("" + schema + "T_RES_HOST");
        TpcDBDataPopulator.deleteTable("" + schema + "T_RES_SWITCH");
        TpcDBDataPopulator.deleteTable("" + schema + "T_RES_SWITCH_BLADE");
        TpcDBDataPopulator.deleteTable("" + schema + "T_RES_SWITCH_BLADE_TYPE");
        TpcDBDataPopulator.deleteTable("" + schema + "T_RES_SWITCH2PORT");
        TpcDBDataPopulator.deleteTable("" + schema + "T_RES_STORAGE_SUBSYSTEM");
        TpcDBDataPopulator.deleteTable("" + schema + "T_RES_PORT");
        TpcDBDataPopulator.deleteTable("" + schema + "T_RES_HBA");
        TpcDBDataPopulator.deleteTable("" + schema + "T_RES_PORT2PORT");
        TpcDBDataPopulator.deleteTable("" + schema + "T_RES_NODE");
        TpcDBDataPopulator.deleteTable("" + schema + "T_RES_NODE2HBA");
        TpcDBDataPopulator.deleteTable("" + schema + "T_RES_FABRIC2SWITCH");
        TpcDBDataPopulator.deleteTable("" + schema + "T_RES_NODE2HBA");
        TpcDBDataPopulator.deleteTable("" + schema + "T_RES_STORAGE_POOL");
        TpcDBDataPopulator.deleteTable("" + schema + "T_RES_STORAGE_VOLUME");
        TpcDBDataPopulator.deleteTable("" + schema + "T_RES_STORAGE_EXTENT");
        TpcDBDataPopulator.deleteTable("" + schema + "T_RES_PHYSICAL_VOLUME");
        TpcDBDataPopulator.deleteTable("" + schema + "T_RES_DISK_GROUP");
        TpcDBDataPopulator.deleteTable("" + schema + "T_RES_DATA_PATH");
        TpcDBDataPopulator.deleteTable("" + schema + "T_RES_DATA_PATH");
        TpcDBDataPopulator.deleteTable("" + schema + "T_RES_MODEL");
        TpcDBDataPopulator.deleteTable("" + schema + "T_RES_VENDOR");
        TpcDBDataPopulator.deleteTable("" + schema + "T_RES_USER_ATTRIBUTES");
        TpcDBDataPopulator.deleteTable("" + schema + "T_PRF_FABRIC_PORT");
        TpcDBDataPopulator.deleteTable("" + schema + "T_RES_PE2NODE");
        TpcDBDataPopulator.deleteTable("" + schema + "T_RES_PHY_PE");
    }

    public static void cleanupZones() {
        TpcDBDataPopulator.deleteTable("" + schema + "T_RES_ZONE");
        TpcDBDataPopulator.deleteTable("" + schema + "T_RES_ZSET2ZONE");
        TpcDBDataPopulator.deleteTable("" + schema + "T_RES_ZSET");
        TpcDBDataPopulator.deleteTable("" + schema + "T_RES_ZONE2ALIAS");
    }

    public static void cleanupConfiguration() {
        TpcDBDataPopulator.deleteTable("" + schema + "T_RES_REGISTERED_CIMOM");
        TpcDBDataPopulator.deleteTable("" + schema + "T_RES_STORAGE_SUBSYSTEM");
    }

    public static void updateTable(String insertQuery) {
        try {
            PreparedStatement stmt = null;
            stmt = con.prepareStatement(insertQuery);
            TpcDBDataPopulator.executeStmt(stmt);
            stmt.close();
        }
        catch (Exception e) {
            Debug.warning("INSERTING QUERY: " + insertQuery);
            Debug.warning(e);
            System.exit(-1);
        }
    }

    public static void populateConfiguration() {
        String INSERT_SERVER1 = "INSERT INTO " + schema + "T_RES_HOST (" + "GUID, HOST_URL, OS_TYPE, OS_VERSION, HOST_NAME, NETWORK_NAME, DOMAIN_NAME,COMPUTER_ID,HARDWARE_ID,\tVENDOR,\tTIME_ZONE,\tDISCOVERED_TIME) " + "VALUES ('12345678901234567890123456789000','mayaguez.almaden.ibm.com',\t1,'Windows XP',\t'9.1.72.75','9.1.72.75','almaden.ibm.com',299, 'PXS-100', 2, 'America/Los_Angeles','2005-01-01 11:11:11')";
        String INSERT_SERVER2 = "INSERT INTO " + schema + "T_RES_HOST (" + "GUID, HOST_URL, OS_TYPE, OS_VERSION, HOST_NAME, NETWORK_NAME, DOMAIN_NAME,COMPUTER_ID,HARDWARE_ID,\tVENDOR,\tTIME_ZONE,\tDISCOVERED_TIME) " + "VALUES ('12345678901234567890123456789000','mayaguez.almaden.ibm.com',\t2,'Windows XP',\t'9.1.72.76','9.1.72.76','almaden.ibm.com',375, 'PXS-100', 2, 'America/Los_Angeles','2005-01-01 11:11:11')";
        TpcDBDataPopulator.populateModels();
        TpcDBDataPopulator.populateVendors();
        TpcDBDataPopulator.populateSwitchBladeTypes();
    }

    public static void populateModels() {
        String INSERT_MODEL0 = "INSERT INTO " + schema + "T_RES_MODEL (MODEL_ID, MODEL_NAME, MODEL_DESCRIPTION) VALUES (0, 'Unknown','Unknown')";
        String INSERT_MODEL1 = "INSERT INTO " + schema + "T_RES_MODEL (MODEL_ID, MODEL_NAME, MODEL_DESCRIPTION) VALUES (1, 'Unknown','Unknown')";
        String INSERT_MODEL2 = "INSERT INTO " + schema + "T_RES_MODEL (MODEL_ID, MODEL_NAME, MODEL_DESCRIPTION) VALUES (2, 'Unknown','Unknown')";
        String INSERT_MODEL3 = "INSERT INTO " + schema + "T_RES_MODEL (MODEL_ID, MODEL_NAME, MODEL_DESCRIPTION) VALUES (3, 'Unknown','Unknown')";
        String INSERT_MODEL4 = "INSERT INTO " + schema + "T_RES_MODEL (MODEL_ID, MODEL_NAME, MODEL_DESCRIPTION) VALUES (4, 'Unknown','Unknown')";
        String INSERT_MODEL10 = "INSERT INTO " + schema + "T_RES_MODEL (MODEL_ID, MODEL_NAME, MODEL_DESCRIPTION) VALUES (10, 'DS4000','Model1')";
        String INSERT_MODEL11 = "INSERT INTO " + schema + "T_RES_MODEL (MODEL_ID, MODEL_NAME, MODEL_DESCRIPTION) VALUES (11, 'DS8000','Model2')";
        String INSERT_MODEL12 = "INSERT INTO " + schema + "T_RES_MODEL (MODEL_ID, MODEL_NAME, MODEL_DESCRIPTION) VALUES (12, 'ESS800','Model5')";
        String INSERT_MODEL20 = "INSERT INTO " + schema + "T_RES_MODEL (MODEL_ID, MODEL_NAME, MODEL_DESCRIPTION) VALUES (20, 'Clarion','Model1')";
        String INSERT_MODEL21 = "INSERT INTO " + schema + "T_RES_MODEL (MODEL_ID, MODEL_NAME, MODEL_DESCRIPTION) VALUES (21, 'Simetrix','Model2')";
        String INSERT_MODEL22 = "INSERT INTO " + schema + "T_RES_MODEL (MODEL_ID, MODEL_NAME, MODEL_DESCRIPTION) VALUES (22, 'CIMEX','Model3')";
        String INSERT_MODEL30 = "INSERT INTO " + schema + "T_RES_MODEL (MODEL_ID, MODEL_NAME, MODEL_DESCRIPTION) VALUES (30, 'EVA','Model1')";
        String INSERT_MODEL31 = "INSERT INTO " + schema + "T_RES_MODEL (MODEL_ID, MODEL_NAME, MODEL_DESCRIPTION) VALUES (31, 'XP128','Model2')";
        String INSERT_MODEL32 = "INSERT INTO " + schema + "T_RES_MODEL (MODEL_ID, MODEL_NAME, MODEL_DESCRIPTION) VALUES (32, 'EMA','Model3')";
        String INSERT_MODEL60 = "INSERT INTO " + schema + "T_RES_MODEL (MODEL_ID, MODEL_NAME, MODEL_DESCRIPTION) VALUES (60, 'Sphereon 4500','Model3')";
        String INSERT_MODEL70 = "INSERT INTO " + schema + "T_RES_MODEL (MODEL_ID, MODEL_NAME, MODEL_DESCRIPTION) VALUES (70, 'SilkWorm 6400','Model3')";
        String INSERT_MODEL80 = "INSERT INTO " + schema + "T_RES_MODEL (MODEL_ID, MODEL_NAME, MODEL_DESCRIPTION) VALUES (80, 'MDS 9000','Model3')";
        String INSERT_MODEL90 = "INSERT INTO " + schema + "T_RES_MODEL (MODEL_ID, MODEL_NAME, MODEL_DESCRIPTION) VALUES (90, 'SANbox 5200','Model3')";
        String INSERT_MODEL91 = "INSERT INTO " + schema + "T_RES_MODEL (MODEL_ID, MODEL_NAME, MODEL_DESCRIPTION) VALUES (91, 'SAN Blade 2310','Model3')";
        String INSERT_MODEL100 = "INSERT INTO " + schema + "T_RES_MODEL (MODEL_ID, MODEL_NAME, MODEL_DESCRIPTION) VALUES (100, 'ST3120020A','Model1')";
        String INSERT_MODEL101 = "INSERT INTO " + schema + "T_RES_MODEL (MODEL_ID, MODEL_NAME, MODEL_DESCRIPTION) VALUES (101, 'ST3120022A','Model2')";
        String INSERT_MODEL102 = "INSERT INTO " + schema + "T_RES_MODEL (MODEL_ID, MODEL_NAME, MODEL_DESCRIPTION) VALUES (102, 'ST3120022AS','Model3')";
        TpcDBDataPopulator.updateTable(INSERT_MODEL0);
        TpcDBDataPopulator.updateTable(INSERT_MODEL1);
        TpcDBDataPopulator.updateTable(INSERT_MODEL2);
        TpcDBDataPopulator.updateTable(INSERT_MODEL3);
        TpcDBDataPopulator.updateTable(INSERT_MODEL4);
        TpcDBDataPopulator.updateTable(INSERT_MODEL10);
        TpcDBDataPopulator.updateTable(INSERT_MODEL11);
        TpcDBDataPopulator.updateTable(INSERT_MODEL12);
        TpcDBDataPopulator.updateTable(INSERT_MODEL20);
        TpcDBDataPopulator.updateTable(INSERT_MODEL21);
        TpcDBDataPopulator.updateTable(INSERT_MODEL22);
        TpcDBDataPopulator.updateTable(INSERT_MODEL30);
        TpcDBDataPopulator.updateTable(INSERT_MODEL31);
        TpcDBDataPopulator.updateTable(INSERT_MODEL32);
        TpcDBDataPopulator.updateTable(INSERT_MODEL60);
        TpcDBDataPopulator.updateTable(INSERT_MODEL70);
        TpcDBDataPopulator.updateTable(INSERT_MODEL80);
        TpcDBDataPopulator.updateTable(INSERT_MODEL100);
        TpcDBDataPopulator.updateTable(INSERT_MODEL101);
        TpcDBDataPopulator.updateTable(INSERT_MODEL102);
    }

    public static void populateVendors() {
        String INSERT_VENDOR0 = "INSERT INTO " + schema + "T_RES_VENDOR (VENDOR_ID, VENDOR_NAME, VENDOR_DESCRIPTION) VALUES (0, 'Unknown','Unknown')";
        String INSERT_VENDOR1 = "INSERT INTO " + schema + "T_RES_VENDOR (VENDOR_ID, VENDOR_NAME, VENDOR_DESCRIPTION) VALUES (1, 'IBM','IBM Inc.')";
        String INSERT_VENDOR2 = "INSERT INTO " + schema + "T_RES_VENDOR (VENDOR_ID, VENDOR_NAME, VENDOR_DESCRIPTION) VALUES (2, 'EMX','Vendor 2')";
        String INSERT_VENDOR3 = "INSERT INTO " + schema + "T_RES_VENDOR (VENDOR_ID, VENDOR_NAME, VENDOR_DESCRIPTION) VALUES (3, 'HP','Vendor 3')";
        String INSERT_VENDOR4 = "INSERT INTO " + schema + "T_RES_VENDOR (VENDOR_ID, VENDOR_NAME, VENDOR_DESCRIPTION) VALUES (4, 'Veritas','Vendor 3')";
        String INSERT_VENDOR5 = "INSERT INTO " + schema + "T_RES_VENDOR (VENDOR_ID, VENDOR_NAME, VENDOR_DESCRIPTION) VALUES (5, 'Hitachi','Vendor 3')";
        String INSERT_VENDOR6 = "INSERT INTO " + schema + "T_RES_VENDOR (VENDOR_ID, VENDOR_NAME, VENDOR_DESCRIPTION) VALUES (6, 'McData','Vendor 3')";
        String INSERT_VENDOR7 = "INSERT INTO " + schema + "T_RES_VENDOR (VENDOR_ID, VENDOR_NAME, VENDOR_DESCRIPTION) VALUES (7, 'Brocade','Vendor 3')";
        String INSERT_VENDOR8 = "INSERT INTO " + schema + "T_RES_VENDOR (VENDOR_ID, VENDOR_NAME, VENDOR_DESCRIPTION) VALUES (8, 'Cisco','Vendor 3')";
        String INSERT_VENDOR9 = "INSERT INTO " + schema + "T_RES_VENDOR (VENDOR_ID, VENDOR_NAME, VENDOR_DESCRIPTION) VALUES (9, 'Cisco','Vendor 3')";
        String INSERT_VENDOR10 = "INSERT INTO " + schema + "T_RES_VENDOR (VENDOR_ID, VENDOR_NAME, VENDOR_DESCRIPTION) VALUES (10, 'Seagate','Vendor 3')";
        TpcDBDataPopulator.updateTable(INSERT_VENDOR0);
        TpcDBDataPopulator.updateTable(INSERT_VENDOR1);
        TpcDBDataPopulator.updateTable(INSERT_VENDOR2);
        TpcDBDataPopulator.updateTable(INSERT_VENDOR3);
        TpcDBDataPopulator.updateTable(INSERT_VENDOR4);
        TpcDBDataPopulator.updateTable(INSERT_VENDOR5);
        TpcDBDataPopulator.updateTable(INSERT_VENDOR6);
        TpcDBDataPopulator.updateTable(INSERT_VENDOR7);
        TpcDBDataPopulator.updateTable(INSERT_VENDOR8);
        TpcDBDataPopulator.updateTable(INSERT_VENDOR9);
        TpcDBDataPopulator.updateTable(INSERT_VENDOR10);
    }

    public static void populateSwitchBladeTypes() {
        String INSERT_SWITCH_BLADE_TYPE0 = "INSERT INTO " + schema + "T_RES_SWITCH_BLADE_TYPE (SWITCH_BLADE_TYPE_ID, TYPE_NAME) VALUES (0, 'Unknown')";
        String INSERT_SWITCH_BLADE_TYPE1 = "INSERT INTO " + schema + "T_RES_SWITCH_BLADE_TYPE (SWITCH_BLADE_TYPE_ID, TYPE_NAME) VALUES (1, 'Unknown')";
        TpcDBDataPopulator.updateTable(INSERT_SWITCH_BLADE_TYPE0);
        TpcDBDataPopulator.updateTable(INSERT_SWITCH_BLADE_TYPE1);
    }

    public static void cleanup() {
        TpcDBDataPopulator.deleteTable("" + schema + "T_RES_FABRIC");
        TpcDBDataPopulator.cleanupFabric();
        TpcDBDataPopulator.cleanupConfiguration();
    }

    public static String zeropadded(String id, int total) {
        StringBuffer sb = new StringBuffer(id);
        int len = total - sb.length();
        while (len-- > 0) {
            sb.insert(0, '0');
        }
        return sb.toString();
    }

    public static String zeropadded(long id, int total) {
        StringBuffer sb = new StringBuffer(Long.toString(id, 16));
        int len = total - sb.length();
        while (len-- > 0) {
            sb.insert(0, '0');
        }
        return sb.toString();
    }

    public static Vector nameGenerator(int max) {
        int i;
        Vector<String> v = new Vector<String>();
        for (i = 0; i < NAMES.length && max > 0; --max, ++i) {
            v.add(NAMES[i]);
        }
        for (i = 0; i < NAMES.length - 1 && max > 0; ++i) {
            for (int j = i + 1; j < NAMES.length && max > 0; --max, ++j) {
                v.add(NAMES[i] + "_" + NAMES[j]);
            }
        }
        NAMES = new String[v.size()];
        v.toArray(NAMES);
        return v;
    }

    public static String ctrToIP(long ctr) {
        int i1 = (int)(ctr % 255L) + 1;
        int i2 = (int)(ctr / 255L % 255L) + 1;
        int i3 = (int)(ctr / 65025L % 255L) + 1;
        int i4 = (int)(ctr / 16581375L % 255L) + 1;
        return String.valueOf(i4 += 8) + "." + String.valueOf(i3) + "." + String.valueOf(i2) + "." + String.valueOf(i1);
    }

    public static int createPort(String PORT_WWN, int portNumber, Integer nodeId, int portType, String displayName) {
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement(INSERT_PORT);
            int ctr = 1;
            stmt.setInt(ctr++, portId++);
            stmt.setString(ctr++, PORT_WWN);
            stmt.setInt(ctr++, 0);
            stmt.setShort(ctr++, (short)portNumber);
            stmt.setShort(ctr++, (short)portType);
            if (nodeId == null) {
                stmt.setNull(ctr++, 4);
            } else {
                stmt.setObject(ctr++, nodeId);
            }
            stmt.setString(ctr++, displayName);
            stmt.setShort(ctr++, (short)1);
            stmt.setInt(ctr++, 1);
            stmt.setShort(ctr++, (short)rand.nextInt());
            stmt.setShort(ctr++, (short)0);
            stmt.setShort(ctr++, (short)0);
            TpcDBDataPopulator.executeStmt(stmt);
            stmt.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return portId - 1;
    }

    public static void createServerGroup(int total, String domain, long ipCtr, String sanWwnBase, int wwnBase, int wwnBaseInc, int totalHBAs, int nodesPerHba, int totalUnknown, String displayNameForNode, String displayNameForPort, int hbaVendor, int hbaModel) {
        try {
            int len = 16 - sanWwnBase.length();
            String hostUrl = null;
            int ctr = 1;
            for (int i = 0; i < total; ++i) {
                String WWN = sanWwnBase + TpcDBDataPopulator.zeropadded(wwnBase, len);
                PreparedStatement stmt = null;
                String GUID2 = null;
                String name = NAMES[nameCtr++ % NAMES.length];
                stmt = con.prepareStatement(INSERT_SERVER);
                ctr = 1;
                hostUrl = name + "." + domain;
                GUID2 = TpcDBDataPopulator.zeropadded(WWN, 32);
                stmt.setString(ctr++, GUID2);
                stmt.setString(ctr++, hostUrl);
                Random s = new Random();
                String OS = null;
                int osType = Math.abs(s.nextInt() % 7);
                switch (osType) {
                    case 0: {
                        OS = "Unknown";
                        break;
                    }
                    case 1: {
                        switch (Math.abs(s.nextInt() % 3)) {
                            case 0: {
                                OS = "Red Hat";
                                break;
                            }
                            case 1: {
                                OS = "Mandrake";
                                break;
                            }
                            case 2: {
                                OS = "Suse";
                            }
                        }
                        break;
                    }
                    case 2: {
                        OS = "AIX 5.0";
                        break;
                    }
                    case 3: {
                        OS = "HPUX";
                        break;
                    }
                    case 4: {
                        switch (Math.abs(s.nextInt() % 2)) {
                            case 0: {
                                OS = "Windows NT 4.0 sp2";
                                break;
                            }
                            case 1: {
                                OS = "Windows NT";
                            }
                        }
                        break;
                    }
                    case 5: {
                        switch (Math.abs(s.nextInt() % 3)) {
                            case 0: {
                                OS = "Windows 2000";
                                break;
                            }
                            case 1: {
                                OS = "Windows XP";
                                break;
                            }
                            case 2: {
                                OS = "Windowx XP Advance Server";
                            }
                        }
                        break;
                    }
                    case 6: {
                        OS = "Solaris 8.0";
                    }
                }
                stmt.setInt(ctr++, osType);
                stmt.setString(ctr++, OS);
                stmt.setString(ctr++, TpcDBDataPopulator.ctrToIP(ipCtr));
                ++ipCtr;
                stmt.setString(ctr++, domain);
                stmt.setInt(ctr++, computerId);
                stmt.setString(ctr++, hostUrl);
                int size = hostUrl.length() < 19 ? hostUrl.length() - 1 : 19;
                stmt.setBytes(ctr++, TpcDBDataPopulator.zeropadded(hostUrl.substring(0, size), 20).getBytes());
                stmt.setShort(ctr++, (short)1);
                stmt.setString(ctr++, "PST");
                stmt.setTimestamp(ctr++, new Timestamp(2004, 2, 15, 15, 57, 2, 0));
                stmt.setShort(ctr++, (short)0);
                stmt.setString(ctr++, "alias");
                int status = 0;
                int r = rand.nextInt() % 1000;
                status = r < 700 ? 0 : 1;
                stmt.setShort(ctr++, (short)status);
                r = rand.nextInt() % 1000;
                status = r < 800 ? 0 : (r < 950 ? 1 : 2);
                stmt.setShort(ctr++, (short)(status * (rand.nextInt() % 3)));
                stmt.setShort(ctr++, (short)status);
                if (totalUnknown <= 0) {
                    TpcDBDataPopulator.executeStmt(stmt);
                }
                stmt.close();
                long wwnHBABaseInc = wwnBaseInc / 16;
                long wwnHBABase = wwnBase;
                for (int j = 0; j < totalHBAs; ++j) {
                    String HBA_WWN = sanWwnBase + TpcDBDataPopulator.zeropadded(wwnHBABase, len);
                    stmt = con.prepareStatement(INSERT_HBA);
                    ctr = 1;
                    stmt.setShort(ctr++, (short)hbaVendor);
                    stmt.setShort(ctr++, (short)hbaModel);
                    stmt.setShort(ctr++, (short)1);
                    stmt.setString(ctr++, HBA_WWN);
                    stmt.setInt(ctr++, hbaID);
                    if (hbaVendor == 9) {
                        stmt.setString(ctr++, "SAN Blade 2310");
                    } else {
                        stmt.setString(ctr++, "HBA Name:" + HBA_WWN);
                    }
                    String serial = "23DF-JI8Q-KWS9WK28SKF-DKASIK2-DFJM28SA-KE498SKLASDAK-LASD892-3HAJU1J-H1SKJ-DAH12-312";
                    int start = Math.abs(HBA_WWN.hashCode()) % (serial.length() - 16);
                    String _serial = serial.substring(start, start + 15);
                    stmt.setString(ctr++, _serial);
                    String version = null;
                    switch (Math.abs(HBA_WWN.hashCode()) % 6) {
                        case 0: {
                            version = "1.0.1";
                            break;
                        }
                        case 1: {
                            version = "2.0.4";
                            break;
                        }
                        case 2: {
                            version = "1.0.3";
                            break;
                        }
                        case 3: {
                            version = "1.0.2";
                            break;
                        }
                        case 4: {
                            version = "2.0.1";
                            break;
                        }
                        case 5: {
                            version = "1.0.0";
                            break;
                        }
                        default: {
                            version = "3.0.1";
                        }
                    }
                    stmt.setString(ctr++, version);
                    stmt.setString(ctr++, "driver name");
                    stmt.setInt(ctr++, computerId);
                    status = 0;
                    r = rand.nextInt() % 1000;
                    status = r < 700 ? 0 : 1;
                    stmt.setShort(ctr++, (short)status);
                    r = rand.nextInt() % 1000;
                    status = r < 800 ? 0 : (r < 950 ? 1 : 2);
                    stmt.setShort(ctr++, (short)(status * (rand.nextInt() % 3)));
                    stmt.setShort(ctr++, (short)status);
                    if (totalUnknown <= 0) {
                        TpcDBDataPopulator.executeStmt(stmt);
                    }
                    stmt.close();
                    long wwnNodeBaseInc = wwnHBABaseInc / 16L;
                    long wwnNodeBase = wwnHBABase;
                    for (int k = 0; k < nodesPerHba; ++k) {
                        String NODE_WWN = sanWwnBase + TpcDBDataPopulator.zeropadded(wwnNodeBase, len);
                        stmt = con.prepareStatement(INSERT_NODE);
                        ctr = 1;
                        stmt.setShort(ctr++, (short)1);
                        stmt.setInt(ctr++, nodeId);
                        stmt.setString(ctr++, NODE_WWN);
                        stmt.setInt(ctr++, 0);
                        stmt.setShort(ctr++, (short)1);
                        stmt.setShort(ctr++, (short)1);
                        stmt.setNull(ctr++, 4);
                        stmt.setNull(ctr++, 4);
                        if (displayNameForNode != null) {
                            stmt.setString(ctr++, displayNameForNode + ":" + k);
                        } else {
                            stmt.setNull(ctr++, 12);
                        }
                        stmt.setShort(ctr++, (short)1);
                        stmt.setString(ctr++, "Mgmt URL Addr");
                        stmt.setString(ctr++, "Mgmt TEL Addr");
                        stmt.setString(ctr++, "Mgmt SNMP Addr");
                        r = rand.nextInt() % 1000;
                        status = r < 700 ? 0 : 1;
                        stmt.setShort(ctr++, (short)status);
                        r = rand.nextInt() % 1000;
                        status = r < 800 ? 0 : (r < 950 ? 1 : 2);
                        stmt.setShort(ctr++, (short)(status * (rand.nextInt() % 3)));
                        stmt.setShort(ctr++, (short)status);
                        TpcDBDataPopulator.executeStmt(stmt);
                        stmt.close();
                        stmt = con.prepareStatement(INSERT_NODE2HBA);
                        ctr = 1;
                        stmt.setInt(ctr++, node2HbaId++);
                        stmt.setInt(ctr++, nodeId);
                        stmt.setInt(ctr++, hbaID);
                        status = 0;
                        r = rand.nextInt() % 1000;
                        status = r < 700 ? 0 : 1;
                        stmt.setShort(ctr++, (short)status);
                        r = rand.nextInt() % 1000;
                        status = r < 800 ? 0 : (r < 950 ? 1 : 2);
                        stmt.setShort(ctr++, (short)(status * (rand.nextInt() % 3)));
                        stmt.setShort(ctr++, (short)status);
                        if (totalUnknown <= 0) {
                            TpcDBDataPopulator.executeStmt(stmt);
                        }
                        stmt.close();
                        long wwnPortBaseInc = wwnNodeBaseInc / 16L;
                        long wwnPortBase = wwnNodeBase;
                        for (int m = 0; m < 2; ++m) {
                            String PORT_WWN = sanWwnBase + TpcDBDataPopulator.zeropadded(wwnPortBase, len);
                            stmt = con.prepareStatement(INSERT_PORT);
                            ctr = 1;
                            stmt.setInt(ctr++, portId++);
                            stmt.setString(ctr++, PORT_WWN);
                            stmt.setInt(ctr++, 0);
                            stmt.setShort(ctr++, (short)m);
                            stmt.setShort(ctr++, (short)1);
                            stmt.setInt(ctr++, nodeId);
                            if (displayNameForPort != null) {
                                stmt.setString(ctr++, displayNameForPort + m);
                            } else {
                                stmt.setNull(ctr++, 12);
                            }
                            stmt.setShort(ctr++, (short)1);
                            stmt.setInt(ctr++, 1);
                            status = 0;
                            r = rand.nextInt() % 1000;
                            status = r < 700 ? 0 : 1;
                            stmt.setShort(ctr++, (short)status);
                            r = rand.nextInt() % 1000;
                            status = r < 800 ? 0 : (r < 950 ? 1 : 2);
                            stmt.setShort(ctr++, (short)(status * (rand.nextInt() % 3)));
                            stmt.setShort(ctr++, (short)status);
                            TpcDBDataPopulator.executeStmt(stmt);
                            stmt.close();
                            Debug.info("PortWWN:" + PORT_WWN);
                            wwnPortBase += wwnPortBaseInc;
                        }
                        wwnNodeBase += wwnHBABaseInc;
                        ++nodeId;
                    }
                    wwnHBABase += wwnHBABaseInc;
                    ++hbaID;
                }
                wwnBase += wwnBaseInc;
                ++computerId;
                --totalUnknown;
            }
        }
        catch (Exception e) {
            Debug.warning(e);
            System.exit(-1);
        }
    }

    public static void createServers() {
    }

    public static void createRealSwitchGroup(int total, String sanWwnBase, int wwnBase, int wwnBaseInc, long ipCtr, int totalPorts, int vendor, int model, String contact, String displayName, String domain, String parentSwitchWwn, boolean useSerial, String UDP1, String UDP2, String UDP3) {
        try {
            int ctr = 1;
            int len = 16 - sanWwnBase.length();
            for (int i = 0; i < total; ++i) {
                int portNumber = 0;
                String SWITCH_WWN = sanWwnBase + TpcDBDataPopulator.zeropadded(wwnBase, len);
                PreparedStatement stmt = null;
                stmt = con.prepareStatement(INSERT_SWITCH);
                ctr = 1;
                int hash = Math.abs(SWITCH_WWN.hashCode());
                stmt.setString(ctr++, SWITCH_WWN);
                stmt.setInt(ctr++, switchId);
                stmt.setShort(ctr++, (short)vendor);
                stmt.setShort(ctr++, (short)model);
                stmt.setString(ctr++, parentSwitchWwn);
                String serial = "23DF-JI8Q-KWS9WK28SKF-DKASIK2-DFJM28SA-KE498SKLASDAK-LASD892-3HAJU1J-H1SKJ-DAH12-312";
                int start = hash % (serial.length() - 16);
                String _serial = serial.substring(start, start + 15);
                if (useSerial) {
                    stmt.setString(ctr++, _serial);
                } else {
                    stmt.setNull(ctr++, 12);
                }
                stmt.setString(ctr++, "Switch: " + SWITCH_WWN);
                stmt.setString(ctr++, contact);
                String location = null;
                switch (hash % 3) {
                    case 0: {
                        location = "Almaden";
                        break;
                    }
                    case 1: {
                        location = "San Jose";
                        break;
                    }
                    case 2: {
                        location = "Boulder";
                    }
                }
                stmt.setString(ctr++, location);
                stmt.setString(ctr++, TpcDBDataPopulator.ctrToIP(ipCtr++));
                stmt.setString(ctr++, displayName);
                stmt.setString(ctr++, domain);
                stmt.setString(ctr++, "");
                stmt.setString(ctr++, "");
                stmt.setString(ctr++, "");
                stmt.setString(ctr++, "");
                String version = null;
                switch (hash % 6) {
                    case 0: {
                        version = "1.0.1";
                        break;
                    }
                    case 1: {
                        version = "2.1.0";
                        break;
                    }
                    case 2: {
                        version = "2.2.1";
                        break;
                    }
                    case 3: {
                        version = "2.4.1";
                        break;
                    }
                    case 4: {
                        version = "2.2.3";
                        break;
                    }
                    case 5: {
                        version = "1.8.1";
                        break;
                    }
                    default: {
                        version = "3.0.1";
                    }
                }
                stmt.setString(ctr++, version);
                int status = 0;
                int r = rand.nextInt() % 1000;
                status = r < 700 ? 0 : 1;
                stmt.setShort(ctr++, (short)status);
                r = rand.nextInt() % 1000;
                status = r < 800 ? 0 : (r < 950 ? 1 : 2);
                stmt.setShort(ctr++, (short)0);
                stmt.setShort(ctr++, (short)status);
                stmt.setString(ctr++, UDP1);
                stmt.setString(ctr++, UDP2);
                stmt.setString(ctr++, UDP3);
                TpcDBDataPopulator.executeStmt(stmt);
                stmt.close();
                System.out.println("Switch Port:");
                long wwnPortBase = wwnBase;
                long wwnPortBaseInc = wwnBaseInc / 4096;
                for (int m = 0; m < totalPorts; ++m) {
                    String PORT_WWN = sanWwnBase + TpcDBDataPopulator.zeropadded(wwnPortBase, len);
                    ctr = 1;
                    stmt = con.prepareStatement(INSERT_PORT);
                    stmt.setInt(ctr++, portId);
                    stmt.setString(ctr++, PORT_WWN);
                    stmt.setInt(ctr++, 0);
                    stmt.setShort(ctr++, (short)portNumber++);
                    stmt.setShort(ctr++, (short)1);
                    stmt.setNull(ctr++, 4);
                    stmt.setString(ctr++, "Manually Entered name");
                    stmt.setShort(ctr++, (short)1);
                    stmt.setInt(ctr++, 1);
                    r = rand.nextInt() % 1000;
                    status = r < 700 ? 0 : 1;
                    stmt.setShort(ctr++, (short)status);
                    r = rand.nextInt() % 1000;
                    status = r < 800 ? 0 : (r < 950 ? 1 : 2);
                    stmt.setShort(ctr++, (short)0);
                    stmt.setShort(ctr++, (short)status);
                    TpcDBDataPopulator.executeStmt(stmt);
                    stmt.close();
                    stmt = con.prepareStatement(INSERT_SWITCH2PORT);
                    ctr = 1;
                    stmt.setInt(ctr++, switch2portId++);
                    stmt.setString(ctr++, SWITCH_WWN);
                    stmt.setInt(ctr++, portId);
                    stmt.executeUpdate();
                    stmt.close();
                    Debug.info("PortWWN:" + PORT_WWN);
                    wwnPortBase += wwnPortBaseInc;
                    ++portId;
                }
                wwnBase += wwnBaseInc;
                ++switchId;
            }
        }
        catch (Exception e) {
            Debug.warning(e);
            System.exit(-1);
        }
    }

    public static void createStorageGroup(int total, int idBase, int idBaseIncr, String sanWwnBase, int wwnBase, int wwnBaseInc, long ipCtr, int totalPorts, boolean discoverableStorage, boolean discoverablePE, String displayName, String displayNodeName, String displayNamePE, boolean useSerial, long allocatedCapacity, long availablecapacity, long backendStorageCapacity, int vendor, int model, String type) {
        try {
            int len = 16 - sanWwnBase.length();
            for (int i = 0; i < total; ++i) {
                String SA_WWN = sanWwnBase + TpcDBDataPopulator.zeropadded(wwnBase, len);
                PreparedStatement stmt = null;
                int hash = Math.abs(("" + SA_WWN).hashCode());
                stmt = con.prepareStatement(INSERT_STORAGE_SUBSYSTEM);
                int ctr = 1;
                stmt.setInt(ctr++, idBase);
                stmt.setBigDecimal(ctr++, new BigDecimal(allocatedCapacity));
                stmt.setBigDecimal(ctr++, new BigDecimal(availablecapacity));
                stmt.setBigDecimal(ctr++, new BigDecimal(backendStorageCapacity));
                stmt.setShort(ctr++, (short)vendor);
                stmt.setShort(ctr++, (short)model);
                stmt.setString(ctr++, "Storage Array: " + SA_WWN);
                stmt.setShort(ctr++, subsystemId);
                stmt.setInt(ctr++, 0x100000);
                stmt.setInt(ctr++, 1024);
                stmt.setBigDecimal(ctr++, new BigDecimal(10000000));
                stmt.setInt(ctr++, 0);
                stmt.setInt(ctr++, 0);
                stmt.setTimestamp(ctr++, new Timestamp(2004, 2, 15, 15, 57, 2, 0));
                stmt.setString(ctr++, "1");
                stmt.setInt(ctr++, 1);
                stmt.setBigDecimal(ctr++, new BigDecimal(10000000));
                stmt.setBigDecimal(ctr++, new BigDecimal(10000000));
                stmt.setShort(ctr++, (short)1);
                stmt.setString(ctr++, "Product States");
                stmt.setString(ctr++, type);
                stmt.setString(ctr++, TpcDBDataPopulator.ctrToIP(ipCtr++));
                String codeLevel = null;
                switch (hash % 6) {
                    case 0: {
                        codeLevel = "1.0.1";
                        break;
                    }
                    case 1: {
                        codeLevel = "2.1.0";
                        break;
                    }
                    case 2: {
                        codeLevel = "2.2.1";
                        break;
                    }
                    case 3: {
                        codeLevel = "2.4.1";
                        break;
                    }
                    case 4: {
                        codeLevel = "2.2.3";
                        break;
                    }
                    case 5: {
                        codeLevel = "1.8.1";
                    }
                }
                stmt.setString(ctr++, codeLevel);
                String serial = "23DFJ I8QKWS9 WK28S KFDKASI K2DFJM2 8SAKE4 98SKL ASDAK LASD8 923HAJ U1JH1S KJDAH 12312";
                int start = hash % (serial.length() - 16);
                String _serial = serial.substring(start, start + 15);
                if (useSerial) {
                    stmt.setString(ctr++, _serial);
                } else {
                    stmt.setNull(ctr++, 12);
                }
                stmt.setString(ctr++, displayName + (i > 0 ? "" + i : ""));
                int status = 0;
                int r = rand.nextInt() % 1000;
                status = r < 700 ? 0 : 1;
                stmt.setShort(ctr++, (short)status);
                r = rand.nextInt() % 1000;
                status = r < 800 ? 0 : (r < 950 ? 1 : 2);
                stmt.setShort(ctr++, (short)0);
                stmt.setShort(ctr++, (short)status);
                if (discoverableStorage) {
                    TpcDBDataPopulator.executeStmt(stmt);
                }
                stmt.close();
                ctr = 1;
                stmt = con.prepareStatement(INSERT_PHY_PE);
                stmt.setInt(ctr++, phyPEId);
                stmt.setString(ctr++, "Storage Array: " + SA_WWN);
                stmt.setString(ctr++, serial);
                stmt.setInt(ctr++, vendor);
                stmt.setInt(ctr++, model);
                stmt.setString(ctr++, codeLevel);
                stmt.setString(ctr++, displayNamePE + (i > 0 ? "" + i : ""));
                if (discoverablePE) {
                    TpcDBDataPopulator.executeStmt(stmt);
                }
                stmt.close();
                long wwnNodeBaseInc = wwnBaseInc / 16;
                long wwnNodeBase = wwnBase;
                for (int k = 0; k < 1; ++k) {
                    String NODE_WWN = sanWwnBase + TpcDBDataPopulator.zeropadded(wwnNodeBase, len);
                    stmt = con.prepareStatement(INSERT_NODE);
                    ctr = 1;
                    stmt.setShort(ctr++, (short)1);
                    stmt.setInt(ctr++, nodeId);
                    stmt.setString(ctr++, NODE_WWN);
                    stmt.setInt(ctr++, 0);
                    stmt.setShort(ctr++, (short)1);
                    stmt.setShort(ctr++, (short)1);
                    stmt.setInt(ctr++, idBase);
                    stmt.setNull(ctr++, 4);
                    stmt.setString(ctr++, displayNodeName + ":" + k);
                    stmt.setString(ctr++, null);
                    stmt.setString(ctr++, null);
                    stmt.setString(ctr++, null);
                    stmt.setString(ctr++, null);
                    status = 0;
                    r = rand.nextInt() % 1000;
                    status = r < 700 ? 0 : 1;
                    stmt.setShort(ctr++, (short)status);
                    r = rand.nextInt() % 1000;
                    status = r < 800 ? 0 : (r < 950 ? 1 : 2);
                    stmt.setShort(ctr++, (short)0);
                    stmt.setShort(ctr++, (short)status);
                    TpcDBDataPopulator.executeStmt(stmt);
                    stmt.close();
                    stmt = con.prepareStatement(INSERT_PE2NODE);
                    ctr = 1;
                    stmt.setInt(ctr++, pe2nodeId++);
                    stmt.setInt(ctr++, phyPEId);
                    stmt.setInt(ctr++, nodeId);
                    stmt.setInt(ctr++, 0);
                    if (discoverablePE) {
                        TpcDBDataPopulator.executeStmt(stmt);
                    }
                    stmt.close();
                    long wwnPortBase = wwnNodeBase;
                    long wwnPortBaseInc = wwnNodeBaseInc / 4096L;
                    for (int m = 0; m < totalPorts; ++m) {
                        String PORT_WWN = sanWwnBase + TpcDBDataPopulator.zeropadded(wwnPortBase, len);
                        stmt = con.prepareStatement(INSERT_PORT);
                        ctr = 1;
                        stmt.setInt(ctr++, portId++);
                        stmt.setString(ctr++, PORT_WWN);
                        stmt.setInt(ctr++, 0);
                        stmt.setShort(ctr++, (short)m);
                        stmt.setShort(ctr++, (short)1);
                        stmt.setInt(ctr++, nodeId);
                        stmt.setString(ctr++, null);
                        stmt.setString(ctr++, null);
                        stmt.setInt(ctr++, 1);
                        status = 0;
                        r = rand.nextInt() % 1000;
                        status = r < 700 ? 0 : 1;
                        stmt.setShort(ctr++, (short)status);
                        r = rand.nextInt() % 1000;
                        status = r < 800 ? 0 : (r < 950 ? 1 : 2);
                        stmt.setShort(ctr++, (short)0);
                        stmt.setShort(ctr++, (short)status);
                        TpcDBDataPopulator.executeStmt(stmt);
                        stmt.close();
                        Debug.info("PortWWN from Subsystem:" + PORT_WWN);
                        wwnPortBase += wwnPortBaseInc;
                    }
                    wwnNodeBase += wwnNodeBaseInc;
                    ++nodeId;
                }
                idBase += idBaseIncr;
                wwnBase += wwnBaseInc;
                subsystemId = (short)(subsystemId + 1);
                ++phyPEId;
            }
        }
        catch (Exception e) {
            Debug.warning(e);
        }
    }

    public static void createSanGroup(int total, String fabricWwnBase, int wwnBase, int wwnBaseInc, String parentSan, String displayName, boolean active, boolean supportZoning, String sanWwn, String UDP1, String UDP2, String UDP3) {
        try {
            int len = 16 - fabricWwnBase.length();
            for (int i = 0; i < total; ++i) {
                String FABRIC_WWN = fabricWwnBase + TpcDBDataPopulator.zeropadded(wwnBase, len);
                PreparedStatement stmt = null;
                stmt = con.prepareStatement(INSERT_FABRIC);
                int ctr = 1;
                stmt.setString(ctr++, FABRIC_WWN);
                stmt.setInt(ctr++, fabricId++);
                stmt.setString(ctr++, sanWwn);
                stmt.setShort(ctr++, (short)(supportZoning ? 1 : 0));
                stmt.setShort(ctr++, (short)(active ? 1 : 0));
                if (parentSan != null) {
                    stmt.setString(ctr++, parentSan);
                } else {
                    stmt.setNull(ctr++, 12);
                }
                stmt.setShort(ctr++, (short)(parentSan == null ? 1 : 0));
                if (displayName != null) {
                    stmt.setString(ctr++, displayName);
                } else {
                    stmt.setNull(ctr++, 12);
                }
                stmt.setShort(ctr++, (short)1);
                int status = 0;
                int r = rand.nextInt() % 1000;
                status = r < 700 ? 0 : 1;
                stmt.setShort(ctr++, (short)status);
                r = rand.nextInt() % 1000;
                status = r < 800 ? 0 : (r < 950 ? 1 : 2);
                stmt.setShort(ctr++, (short)0);
                stmt.setShort(ctr++, (short)status);
                stmt.setString(ctr++, UDP1);
                stmt.setString(ctr++, UDP2);
                stmt.setString(ctr++, UDP3);
                TpcDBDataPopulator.executeStmt(stmt);
                stmt.close();
                wwnBase += wwnBaseInc;
            }
        }
        catch (Exception e) {
            Debug.warning(e);
        }
    }

    public static void createSan2Switch(String sanWwn, String switchWwn) {
        try {
            int ctr = 1;
            PreparedStatement stmt = null;
            stmt = con.prepareStatement(INSERT_FABRIC2SWITCH);
            stmt.setInt(ctr++, fabrid2SwitchID++);
            stmt.setString(ctr++, sanWwn);
            stmt.setString(ctr++, switchWwn);
            int status = 0;
            int r = rand.nextInt() % 1000;
            status = r < 700 ? 0 : 1;
            stmt.setShort(ctr++, (short)status);
            r = rand.nextInt() % 1000;
            status = r < 800 ? 0 : (r < 950 ? 1 : 2);
            stmt.setShort(ctr++, (short)0);
            stmt.setShort(ctr++, (short)status);
            Debug.info("SAN WWN:" + sanWwn);
            TpcDBDataPopulator.executeStmt(stmt);
            stmt.close();
        }
        catch (Exception e) {
            Debug.warning(e);
        }
    }

    private static int getPortIdForWwn(String port1Wwn) throws SQLException {
        PreparedStatement stmt1 = null;
        stmt1 = con.prepareStatement("SELECT PORT.PORT_ID PORT_ID FROM " + schema + "T_RES_PORT PORT WHERE PORT.NAME = ?");
        stmt1.setString(1, port1Wwn);
        ResultSet result = stmt1.executeQuery();
        while (result.next()) {
            try {
                return result.getInt("PORT_ID");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return -1;
    }

    public static boolean connectionExits(String wwn) throws SQLException {
        PreparedStatement stmt = null;
        stmt = con.prepareStatement("SELECT     PORT2PORT.PORT_ID1 PORT_ID FROM     " + schema + "T_RES_PORT PORT, " + "    " + schema + "T_RES_PORT2PORT PORT2PORT " + "WHERE " + "    (PORT.PORT_ID = PORT2PORT.PORT_ID1 and " + "    PORT.NAME = ?) or " + "    (PORT.PORT_ID = PORT2PORT.PORT_ID2 and " + "    PORT.NAME = ?)");
        stmt.setString(1, wwn);
        stmt.setString(2, wwn);
        ResultSet result = stmt.executeQuery();
        if (result.next()) {
            stmt.close();
            return true;
        }
        stmt.close();
        return false;
    }

    public static void createPort2Port(String port1Wwn, String port2Wwn) {
        TpcDBDataPopulator.createPort2Port(port1Wwn, port2Wwn, true);
    }

    public static void createPort2Port(int portId1, int portId2) {
        try {
            int ctr = 1;
            Debug.info("Port2port: " + portId1 + " -> " + portId2);
            PreparedStatement stmt = null;
            stmt = con.prepareStatement(INSERT_PORT2PORT);
            stmt.setInt(ctr++, port2portId++);
            stmt.setInt(ctr++, portId1);
            stmt.setInt(ctr++, portId2);
            int status = 0;
            int r = rand.nextInt() % 1000;
            status = r < 700 ? 0 : 1;
            stmt.setShort(ctr++, (short)status);
            r = rand.nextInt() % 1000;
            status = r < 800 ? 0 : (r < 950 ? 1 : 2);
            stmt.setShort(ctr++, (short)0);
            stmt.setShort(ctr++, (short)status);
            TpcDBDataPopulator.executeStmt(stmt);
            stmt.close();
        }
        catch (Exception e) {
            Debug.warning(e);
        }
    }

    public static void createPort2Port(String port1Wwn, String port2Wwn, boolean verify) {
        try {
            int ctr = 1;
            Debug.info("Port2port: " + port1Wwn + " -> " + port2Wwn);
            if (verify && failIfAlreadyExists && TpcDBDataPopulator.connectionExits(port1Wwn)) {
                throw new RuntimeException("Connection to port already exits: " + port1Wwn);
            }
            if (verify && failIfAlreadyExists && TpcDBDataPopulator.connectionExits(port2Wwn)) {
                throw new RuntimeException("Connection to port already exits:" + port2Wwn);
            }
            int portId1 = TpcDBDataPopulator.getPortIdForWwn(port1Wwn);
            int portId2 = TpcDBDataPopulator.getPortIdForWwn(port2Wwn);
            if (portId1 == -1 || portId2 == -1) {
                if (portId1 == -1) {
                    Debug.warning("Port not found for WWN:" + port1Wwn);
                } else {
                    Debug.warning("Port not found for WWN:" + port2Wwn);
                }
                throw new RuntimeException("Invalid port number");
            }
            PreparedStatement stmt = null;
            stmt = con.prepareStatement(INSERT_PORT2PORT);
            stmt.setInt(ctr++, port2portId++);
            stmt.setInt(ctr++, portId1);
            stmt.setInt(ctr++, portId2);
            int status = 0;
            int r = rand.nextInt() % 1000;
            status = r < 700 ? 0 : 1;
            stmt.setShort(ctr++, (short)status);
            r = rand.nextInt() % 1000;
            status = r < 800 ? 0 : (r < 950 ? 1 : 2);
            stmt.setShort(ctr++, (short)0);
            stmt.setShort(ctr++, (short)status);
            TpcDBDataPopulator.executeStmt(stmt);
            stmt.close();
            if (verify && !TpcDBDataPopulator.connectionExits(port1Wwn)) {
                throw new RuntimeException("Connection to port wasnt created: " + port1Wwn);
            }
            if (verify && !TpcDBDataPopulator.connectionExits(port2Wwn)) {
                throw new RuntimeException("Connection to port wasnt created:" + port2Wwn);
            }
        }
        catch (Exception e) {
            Debug.warning(e);
        }
    }

    public static void createStorageVolume(int total, int baseVol, int baseVolIncr, String vc_guid, int spid, String device_id, int subsystem_id) {
        try {
            for (int i = 0; i < total; ++i) {
                PreparedStatement stmt = null;
                stmt = con.prepareStatement(INSERT_STORAGE_VOLUME);
                int ctr = 1;
                Debug.info("Volume ID: " + baseVol + " on SP:" + spid + " on Subsystem:" + subsystem_id);
                stmt.setInt(ctr++, baseVol);
                stmt.setBigDecimal(ctr++, new BigDecimal(1000000000));
                stmt.setShort(ctr++, (short)1);
                stmt.setShort(ctr++, (short)1);
                stmt.setDouble(ctr++, 1.0);
                stmt.setBigDecimal(ctr++, new BigDecimal(1000000000));
                stmt.setBigDecimal(ctr++, new BigDecimal(1000000000));
                stmt.setShort(ctr++, (short)1);
                stmt.setBigDecimal(ctr++, new BigDecimal(1000000000));
                stmt.setBigDecimal(ctr++, new BigDecimal(1000000000));
                stmt.setString(ctr++, "Volume: " + baseVol);
                stmt.setShort(ctr++, (short)1);
                stmt.setInt(ctr++, subsystem_id);
                stmt.setInt(ctr++, spid);
                stmt.setString(ctr++, "1");
                stmt.setShort(ctr++, (short)1);
                stmt.setString(ctr++, "Y");
                stmt.setShort(ctr++, (short)1);
                stmt.setInt(ctr++, 1);
                stmt.setString(ctr++, "Y");
                stmt.setString(ctr++, "1");
                stmt.setString(ctr++, "Y");
                stmt.setBigDecimal(ctr++, new BigDecimal(1000000000));
                stmt.setShort(ctr++, (short)1);
                stmt.setString(ctr++, "SerialNumber");
                int status = 0;
                int r = rand.nextInt() % 1000;
                status = r < 700 ? 0 : 1;
                stmt.setShort(ctr++, (short)status);
                r = rand.nextInt() % 1000;
                status = r < 800 ? 0 : (r < 950 ? 1 : 2);
                stmt.setShort(ctr++, (short)0);
                stmt.setShort(ctr++, (short)status);
                TpcDBDataPopulator.executeStmt(stmt);
                stmt.close();
                baseVol += baseVolIncr;
            }
        }
        catch (Exception e) {
            Debug.warning(e);
            System.exit(-1);
        }
    }

    public static void createStoragePool(int total, int baseSP, int baseSPIncr, int subsystem_id, int totalStorageExtents, int totalDisksPerExtent, long totalManagedSpace, long ramanningManagedSpace, double capacity, int extentSize, long totalAvailableSpace) {
        try {
            int ctr = 1;
            for (int i = 0; i < total; ++i) {
                PreparedStatement stmt = null;
                stmt = con.prepareStatement(INSERT_STORAGE_POOL);
                ctr = 1;
                stmt.setInt(ctr++, baseSP);
                stmt.setBigDecimal(ctr++, new BigDecimal(totalManagedSpace));
                stmt.setBigDecimal(ctr++, new BigDecimal(ramanningManagedSpace));
                stmt.setShort(ctr++, (short)1);
                stmt.setDouble(ctr++, capacity);
                stmt.setInt(ctr++, extentSize);
                stmt.setShort(ctr++, (short)1);
                stmt.setInt(ctr++, 1);
                stmt.setInt(ctr++, 1);
                stmt.setBigDecimal(ctr++, new BigDecimal(totalAvailableSpace));
                stmt.setShort(ctr++, (short)1);
                stmt.setShort(ctr++, (short)1);
                stmt.setString(ctr++, "" + (i + 1));
                stmt.setString(ctr++, "SP:" + baseSP);
                stmt.setInt(ctr++, subsystem_id);
                stmt.setShort(ctr++, (short)1);
                stmt.setShort(ctr++, (short)1);
                stmt.setInt(ctr++, 1);
                stmt.setShort(ctr++, (short)1);
                stmt.setBigDecimal(ctr++, new BigDecimal(1000000000));
                stmt.setBigDecimal(ctr++, new BigDecimal(1000000000));
                stmt.setTimestamp(ctr++, new Timestamp(2004, 2, 15, 15, 57, 2, 0));
                stmt.setTimestamp(ctr++, new Timestamp(2004, 2, 15, 15, 57, 2, 0));
                int status = 0;
                int r = rand.nextInt() % 1000;
                status = r < 700 ? 0 : 1;
                stmt.setShort(ctr++, (short)status);
                r = rand.nextInt() % 1000;
                status = r < 800 ? 0 : (r < 950 ? 1 : 2);
                stmt.setShort(ctr++, (short)(status * (rand.nextInt() % 3)));
                stmt.setShort(ctr++, (short)status);
                stmt.setShort(ctr++, (short)1);
                TpcDBDataPopulator.executeStmt(stmt);
                stmt.close();
                for (int n = 0; n < totalStorageExtents; ++n) {
                    stmt = con.prepareStatement(INSERT_STORAGE_EXTENT);
                    ctr = 1;
                    stmt.setInt(ctr++, extentId);
                    stmt.setInt(ctr++, 1);
                    stmt.setInt(ctr++, 1);
                    stmt.setInt(ctr++, baseSP);
                    stmt.setInt(ctr++, 10000);
                    stmt.setInt(ctr++, 1000);
                    stmt.setInt(ctr++, 1);
                    stmt.setString(ctr++, "ExtentName: " + extentId);
                    stmt.setString(ctr++, "Other Name:" + extentId);
                    stmt.setString(ctr++, "Config");
                    stmt.setInt(ctr++, 1);
                    stmt.setString(ctr++, "Group Id");
                    stmt.setInt(ctr++, 1);
                    stmt.setInt(ctr++, 1);
                    stmt.setString(ctr++, "DeviceId:" + extentId);
                    stmt.setInt(ctr++, subsystem_id);
                    stmt.setShort(ctr++, (short)1);
                    TpcDBDataPopulator.executeStmt(stmt);
                    stmt.close();
                    stmt = con.prepareStatement(INSERT_DISK_GROUP);
                    ctr = 1;
                    stmt.setInt(ctr++, diskGroupId);
                    stmt.setString(ctr++, "DiskGroup Name:" + diskGroupId);
                    stmt.setString(ctr++, "Description:");
                    stmt.setString(ctr++, "RAID5");
                    stmt.setString(ctr++, "Array Name:");
                    stmt.setInt(ctr++, extentId);
                    stmt.setInt(ctr++, subsystem_id);
                    stmt.setString(ctr++, "Tag");
                    TpcDBDataPopulator.executeStmt(stmt);
                    stmt.close();
                    for (int m = 0; m < totalDisksPerExtent; ++m) {
                        stmt = con.prepareStatement(INSERT_PHYSICAL_VOLUME);
                        ctr = 1;
                        status = 0;
                        r = rand.nextInt() % 1000;
                        status = r < 900 ? 0 : 1;
                        stmt.setInt(ctr++, physicalVolumeId++);
                        stmt.setInt(ctr++, 10);
                        stmt.setInt(ctr++, 100);
                        stmt.setInt(ctr++, diskGroupId);
                        stmt.setInt(ctr++, subsystem_id);
                        stmt.setInt(ctr++, 16000000);
                        stmt.setInt(ctr++, status);
                        stmt.setString(ctr++, "DeviceID");
                        TpcDBDataPopulator.executeStmt(stmt);
                        stmt.close();
                    }
                    ++diskGroupId;
                    ++extentId;
                }
                baseSP += baseSPIncr;
            }
        }
        catch (Exception e) {
            Debug.warning(e);
        }
    }

    public static void populateStorageExtent(int subsystemId) {
        String EXTENT1 = "INSERT INTO " + schema + "T_RES_STORAGE_EXTENT (STORAGE_EXTENT_ID, SUBSYSTEM_ID, NAME, NAME_FORMAT) " + "\tVALUES (1, " + subsystemId + ", 'RAID0', 'RAID0')";
    }

    private static int getHostIdFromWwn(String port1Wwn) throws SQLException {
        PreparedStatement stmt1 = null;
        stmt1 = con.prepareStatement(SELECT_HOST_FROM_WWN);
        stmt1.setString(1, port1Wwn);
        ResultSet result = stmt1.executeQuery();
        while (result.next()) {
            try {
                return result.getInt("HOST_ID");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return -1;
    }

    public static void createDataPath(int dpId, int host_lun_id, int device_lun_id, int initiator_port_id, int target_port_id, int svid) {
        try {
            int ctr = 1;
            Debug.info("DataPath=Initiator=" + initiator_port_id + ", target=" + target_port_id + ", hostLun=" + host_lun_id + ", devLun=" + device_lun_id + ", svid=" + svid + ", dpId=" + dpId);
            PreparedStatement stmt = null;
            stmt = con.prepareStatement(INSERT_DATA_PATH);
            stmt.setInt(ctr++, dpId);
            stmt.setInt(ctr++, host_lun_id);
            stmt.setInt(ctr++, device_lun_id);
            stmt.setInt(ctr++, initiator_port_id);
            stmt.setInt(ctr++, target_port_id);
            stmt.setInt(ctr++, svid);
            stmt.setString(ctr++, "Unknown Host Name");
            TpcDBDataPopulator.executeStmt(stmt);
            stmt.close();
        }
        catch (Exception e) {
            Debug.warning(e);
        }
    }

    public static final void createZoneSet(int total, int zsetBase, int zsetBaseIncr, String san_wwn, short active) {
        try {
            int ctr = 1;
            for (int i = 0; i < total; ++i) {
                PreparedStatement stmt = null;
                stmt = con.prepareStatement(INSERT_ZSET);
                ctr = 1;
                stmt.setInt(ctr++, zsetBase);
                stmt.setString(ctr++, san_wwn);
                stmt.setShort(ctr++, active);
                stmt.setString(ctr++, "ZoneSet:" + zsetBase);
                stmt.setString(ctr++, "ZoneSet:" + zsetBase);
                TpcDBDataPopulator.executeStmt(stmt);
                stmt.close();
                zsetBase += zsetBaseIncr;
            }
        }
        catch (Exception e) {
            Debug.warning(e);
        }
    }

    public static final void createZone(int total, int zoneBase, int zoneBaseIncr, String san_wwn, short active, short type) {
        try {
            int ctr = 1;
            for (int i = 0; i < total; ++i) {
                PreparedStatement stmt = null;
                stmt = con.prepareStatement(INSERT_ZONE);
                ctr = 1;
                stmt.setInt(ctr++, zoneBase);
                stmt.setString(ctr++, san_wwn);
                stmt.setShort(ctr++, type);
                stmt.setInt(ctr++, 0);
                stmt.setShort(ctr++, active);
                stmt.setString(ctr++, "ZoneName:" + TpcDBDataPopulator.zeropadded(zoneBase, 16) + ":" + active);
                stmt.setString(ctr++, "Description:" + TpcDBDataPopulator.zeropadded(zoneBase, 16) + ":" + active);
                TpcDBDataPopulator.executeStmt(stmt);
                stmt.close();
                zoneBase += zoneBaseIncr;
            }
        }
        catch (Exception e) {
            Debug.warning(e);
        }
    }

    public static final void createZSet2Zone(int zone_id, int zset_id) {
        try {
            int ctr = 1;
            PreparedStatement stmt = null;
            stmt = con.prepareStatement(INSERT_ZSET2ZONE);
            stmt.setInt(ctr++, zone_id);
            stmt.setInt(ctr++, zset_id);
            TpcDBDataPopulator.executeStmt(stmt);
            stmt.close();
        }
        catch (Exception e) {
            Debug.warning(e);
        }
    }

    public static final void createZSet2Port(String port_wwn, int zone_id) {
        try {
            int ctr = 1;
            PreparedStatement stmt = null;
            stmt = con.prepareStatement(INSERT_ZSONE2PORT);
            stmt.setString(ctr++, port_wwn);
            stmt.setInt(ctr++, zone_id);
            TpcDBDataPopulator.executeStmt(stmt);
            stmt.close();
        }
        catch (Exception e) {
            Debug.warning(e);
        }
    }

    public static final void createZSet2Member(int zone_id, String member) {
        try {
            int ctr = 1;
            PreparedStatement stmt = null;
            stmt = con.prepareStatement(INSERT_ZONE2MEMBER);
            stmt.setInt(ctr++, zone_id);
            stmt.setString(ctr++, member);
            TpcDBDataPopulator.executeStmt(stmt);
            stmt.close();
        }
        catch (Exception e) {
            Debug.warning(e);
        }
    }

    public static void createSwitches() {
    }

    public static void connectSwitches(String sanWwnBase1, long wwnBase1, long wwnBaseInc1, long portPos1, String sanWwnBase2, long wwnBase2, long wwnBaseInc2, long portPos2) {
        int len = 16 - sanWwnBase1.length();
        long wwnPortBaseInc1 = wwnBaseInc1 / 4096L;
        String PORT_WWN1 = sanWwnBase1 + TpcDBDataPopulator.zeropadded(wwnBase1 + wwnPortBaseInc1 * (portPos1 - 1L), len);
        long wwnPortBase2 = wwnBase2;
        long wwnPortBaseInc2 = wwnBaseInc2 / 4096L;
        String PORT_WWN2 = sanWwnBase2 + TpcDBDataPopulator.zeropadded(wwnBase2 + wwnPortBaseInc2 * (portPos2 - 1L), len);
        TpcDBDataPopulator.createPort2Port(PORT_WWN1, PORT_WWN2);
    }

    public static Vector getPortsFromHost(int hostId) {
        Vector<Object> res = new Vector<Object>();
        try {
            int ctr = 1;
            PreparedStatement stmt = null;
            stmt = con.prepareStatement(SELECT_PORTS_FROM_HOST);
            stmt.setInt(ctr++, hostId);
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                res.add(result.getObject("PORT_ID"));
            }
            stmt.close();
        }
        catch (Exception e) {
            Debug.warning(e);
        }
        return res;
    }

    public static Vector getPortsFromSwitch(String switchWwn) {
        Vector<Object> res = new Vector<Object>();
        try {
            int ctr = 1;
            PreparedStatement stmt = null;
            stmt = con.prepareStatement(SELECT_PORTS_FROM_SWITCH);
            stmt.setString(ctr++, switchWwn);
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                res.add(result.getObject("PORT_ID"));
            }
            stmt.close();
        }
        catch (Exception e) {
            Debug.warning(e);
        }
        return res;
    }

    public static Vector getPortsFromSubsystem(int subsystemId) {
        Vector<Object> res = new Vector<Object>();
        try {
            int ctr = 1;
            PreparedStatement stmt = null;
            stmt = con.prepareStatement(SELECT_PORTS_FROM_SUBSYSTEM);
            stmt.setInt(ctr++, subsystemId);
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                res.add(result.getObject("PORT_ID"));
            }
            stmt.close();
        }
        catch (Exception e) {
            Debug.warning(e);
        }
        return res;
    }

    public static Vector getConnectedPorts(Vector ports) {
        Vector<Integer> res = new Vector<Integer>();
        for (Integer port : ports) {
            if (TpcDBDataPopulator.getConnectedPort(port) == -1) continue;
            res.add(port);
        }
        return res;
    }

    public static Vector getDisconnectedPorts(Vector ports) {
        Vector<Integer> res = new Vector<Integer>();
        for (Integer port : ports) {
            if (TpcDBDataPopulator.getConnectedPort(port) != -1) continue;
            res.add(port);
        }
        return res;
    }

    public static Vector getDisconnectedPortsFromHost(int hostId) {
        return TpcDBDataPopulator.getDisconnectedPorts(TpcDBDataPopulator.getPortsFromHost(hostId));
    }

    public static Vector getDisconnectedPortsFromSubsystem(int subsystemId) {
        return TpcDBDataPopulator.getDisconnectedPorts(TpcDBDataPopulator.getPortsFromSubsystem(subsystemId));
    }

    public static Vector getDisconnectedPortsFromSwitch(String switchWwn) {
        return TpcDBDataPopulator.getDisconnectedPorts(TpcDBDataPopulator.getPortsFromSwitch(switchWwn));
    }

    public static int getConnectedPort(int portId) {
        try {
            int ctr = 1;
            PreparedStatement stmt = null;
            stmt = con.prepareStatement(SELECT_CONNECTED_PORT);
            stmt.setInt(ctr++, portId);
            stmt.setInt(ctr++, portId);
            ResultSet result = stmt.executeQuery();
            if (result.next()) {
                return result.getInt("PORT_ID");
            }
            stmt.close();
        }
        catch (Exception e) {
            Debug.warning(e);
        }
        return -1;
    }

    public static String getPortWWN(int portId) {
        try {
            int ctr = 1;
            PreparedStatement stmt = null;
            stmt = con.prepareStatement(SELECT_PORT_WWN_FROM_PORT_ID);
            stmt.setInt(ctr++, portId);
            ResultSet result = stmt.executeQuery();
            if (result.next()) {
                return result.getString("NAME");
            }
            stmt.close();
        }
        catch (Exception e) {
            Debug.warning(e);
        }
        return "";
    }

    public static Vector getHostFromArray(int subsystemId) {
        Vector<Object> res = new Vector<Object>();
        try {
            int ctr = 1;
            PreparedStatement stmt = null;
            stmt = con.prepareStatement(SELECT_HOST_FROM_ARRAY);
            stmt.setInt(ctr++, subsystemId);
            stmt.setInt(ctr++, subsystemId);
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                res.add(result.getObject("COMPUTER_ID"));
            }
            stmt.close();
        }
        catch (Exception e) {
            Debug.warning(e);
        }
        return res;
    }

    public static Vector getVolumeFromArray(int subsystemId) {
        Vector<Object> res = new Vector<Object>();
        try {
            int ctr = 1;
            PreparedStatement stmt = null;
            stmt = con.prepareStatement(SELECT_VOLUME_FROM_SUBSYSTEM);
            stmt.setInt(ctr++, subsystemId);
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                res.add(result.getObject("SVID"));
            }
            stmt.close();
        }
        catch (Exception e) {
            Debug.warning(e);
        }
        return res;
    }

    public static Vector getArrays() {
        Vector<Object> res = new Vector<Object>();
        try {
            boolean ctr = true;
            PreparedStatement stmt = null;
            stmt = con.prepareStatement(SELECT_SUBSYSTEM);
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                res.add(result.getObject("SUBSYSTEM_ID"));
            }
            stmt.close();
        }
        catch (Exception e) {
            Debug.warning(e);
        }
        return res;
    }

    public static void addDiskToSubsystem(int subsystemId, int vendor, int model, int capacity, int status) {
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement(INSERT_PHYSICAL_VOLUME);
            int ctr = 1;
            stmt.setInt(ctr++, physicalVolumeId++);
            stmt.setInt(ctr++, vendor);
            stmt.setInt(ctr++, model);
            stmt.setNull(ctr++, 4);
            stmt.setInt(ctr++, subsystemId);
            stmt.setInt(ctr++, capacity);
            stmt.setInt(ctr++, status);
            stmt.setString(ctr++, "Device ID");
            TpcDBDataPopulator.executeStmt(stmt);
            stmt.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void populateStorageSubsystem(int saBase, int spBase, int saBaseIncr, int totalArrays, int totalPoolPerArray, int totalVolumesPerPool) {
        for (int q = 0; q < totalArrays; ++q) {
            int spBaseIncr = 1000;
            boolean volBase = false;
            int volBaseIncr = 1;
            TpcDBDataPopulator.createStoragePool(totalPoolPerArray, spBase, spBaseIncr, saBase, 1, 2, 100000000L, 100000000L, 9.0, 100000, 100000000L);
            for (int p = 0; p < totalPoolPerArray; ++p) {
                TpcDBDataPopulator.createStorageVolume(totalVolumesPerPool, spBase, volBaseIncr, "", spBase, "device_id", saBase);
                spBase += spBaseIncr;
            }
            saBase += saBaseIncr;
        }
    }

    public static void populateSan1() {
        try {
            String hostGroup;
            int j;
            int i;
            int TOTAL_STORAGE_ARRAYS = 2;
            int TOTAL_PORTS_PER_STORAGE_ARRAY = 16;
            int TOTAL_SWITCHES_PER_GROUP = 2;
            int TOTAL_HOSTS_PER_HOSTGROUP = 4;
            int TOTAL_PORTS_PER_SWITCH = 64;
            int TOTAL_STORAGE_POOLS_PER_STORAGE_ARRAY = 2;
            int TOTAL_STORAGE_VOLUMES_PER_STORAGE_POOL = 2;
            TpcDBDataPopulator.nameGenerator(TOTAL_SERVERS);
            TpcDBDataPopulator.createServerGroup(4, "boulder.ibm.com", 0L, "00000000", 0, 0x100000, 1, 2, 0, null, null, 9, 91);
            TpcDBDataPopulator.createServerGroup(4, "almaden.ibm.com", 255L, "11111111", 0, 0x100000, 1, 2, 0, null, null, 9, 91);
            TpcDBDataPopulator.createServerGroup(4, "sanjose.ibm.com", 510L, "22222222", 0, 0x100000, 1, 2, 0, null, null, 9, 91);
            TpcDBDataPopulator.createServerGroup(4, "santateresa.ibm.com", 765L, "33333333", 0, 0x100000, 1, 2, 0, null, null, 9, 91);
            TpcDBDataPopulator.createServerGroup(4, "boulder.ibm.com", 255L, "11110000", 0, 0x100000, 1, 2, 8, null, null, 9, 91);
            System.out.println();
            TpcDBDataPopulator.createRealSwitchGroup(2, "55555555", 0, 0x100000, 1020L, 64, 8, 80, "Eric", "My Virtual Switch1", "Almaden", "ffffffff00000000", false, null, null, null);
            TpcDBDataPopulator.createRealSwitchGroup(2, "66666666", 0, 0x100000, 1275L, 64, 8, 80, "Eric", "My Virtual Switch2", "Almaden", "ffffffff00000000", false, null, null, null);
            TpcDBDataPopulator.createRealSwitchGroup(2, "77777777", 0, 0x100000, 1530L, 64, 8, 80, "Eric", "My Virtual Switch3", "Almaden", "ffffffff00000000", false, null, null, null);
            TpcDBDataPopulator.createRealSwitchGroup(2, "88888888", 0, 0x100000, 1785L, 64, 8, 80, "Eric", "My Virtual Switch4", "Almaden", "ffffffff00000000", false, null, null, null);
            System.out.println("\nSwitch2Switch:");
            TpcDBDataPopulator.connectSwitches("55555555", 0L, 0x100000L, 62L, "66666666", 0L, 0x100000L, 63L);
            TpcDBDataPopulator.connectSwitches("77777777", 0L, 0x100000L, 62L, "88888888", 0L, 0x100000L, 63L);
            System.out.println();
            TpcDBDataPopulator.createStorageGroup(2, 40000000, 100000, "44444444", 0, 0x100000, 2040L, 16, true, true, "Database Storage", "Database Storage", "Database Storage", true, 0x6400000L, 0xC800000L, 314572800L, 1, 12, "800");
            TpcDBDataPopulator.createStorageGroup(2, 50000000, 100000, "99999999", 0, 0x100000, 2295L, 16, true, true, "Database Storage", "Database Storage", "Database Storage", true, 0xA00000L, 0x19000000L, 429916160L, 2, 20, "800");
            TpcDBDataPopulator.populateStorageSubsystem(40000000, 40000000, 100000, 2, 3, 10);
            TpcDBDataPopulator.populateStorageSubsystem(40000000, 40008000, 100000, 1, 5, 2);
            for (int i2 = 0; i2 < 5; ++i2) {
                TpcDBDataPopulator.addDiskToSubsystem(40000000, 10, 100, 0x1000000, 0);
            }
            TpcDBDataPopulator.populateStorageSubsystem(50000000, 50000000, 100000, 2, 10, 2);
            boolean base = false;
            Debug.info("Switch2SAN:");
            TpcDBDataPopulator.createSan2Switch("ffffffff00000000", "5555555500000000");
            TpcDBDataPopulator.createSan2Switch("ffffffff00000000", "6666666600000000");
            TpcDBDataPopulator.createSan2Switch("ffffffff00000000", "5555555500100000");
            TpcDBDataPopulator.createSan2Switch("ffffffff00000000", "6666666600100000");
            TpcDBDataPopulator.createSan2Switch("eeeeeeee00000000", "7777777700000000");
            TpcDBDataPopulator.createSan2Switch("eeeeeeee00000000", "8888888800000000");
            TpcDBDataPopulator.createSan2Switch("eeeeeeee00000000", "7777777700100000");
            TpcDBDataPopulator.createSan2Switch("eeeeeeee00000000", "8888888800100000");
            int base_switch = 0;
            int base_host = 0;
            System.out.println();
            Debug.info("Host2Switch:");
            String[] hostGroupList = new String[]{"00000000", "11111111"};
            for (i = 0; i < hostGroupList.length; ++i) {
                for (j = 0; j < 4; ++j) {
                    hostGroup = hostGroupList[i];
                    TpcDBDataPopulator.createPort2Port(hostGroup + TpcDBDataPopulator.zeropadded(base_host + j * 0x100000 + 0, 8), "55555555" + TpcDBDataPopulator.zeropadded(base_switch + 0 + j * 256 + i * 4 * 256, 8));
                    TpcDBDataPopulator.createPort2Port(hostGroup + TpcDBDataPopulator.zeropadded(base_host + j * 0x100000 + 256, 8), "66666666" + TpcDBDataPopulator.zeropadded(base_switch + 0 + j * 256 + 8192 + i * 4 * 256, 8));
                    TpcDBDataPopulator.createPort2Port(hostGroup + TpcDBDataPopulator.zeropadded(base_host + j * 0x100000 + 0 + 65536, 8), "55555555" + TpcDBDataPopulator.zeropadded(base_switch + 0x100000 + j * 256 + i * 4 * 256, 8));
                    TpcDBDataPopulator.createPort2Port(hostGroup + TpcDBDataPopulator.zeropadded(base_host + j * 0x100000 + 256 + 65536, 8), "66666666" + TpcDBDataPopulator.zeropadded(base_switch + 0x100000 + j * 256 + 8192 + i * 4 * 256, 8));
                }
            }
            hostGroupList = new String[]{"22222222", "33333333", "11110000"};
            for (i = 0; i < hostGroupList.length; ++i) {
                for (j = 0; j < 4; ++j) {
                    hostGroup = hostGroupList[i];
                    TpcDBDataPopulator.createPort2Port(hostGroup + TpcDBDataPopulator.zeropadded(base_host + j * 0x100000 + 0, 8), "77777777" + TpcDBDataPopulator.zeropadded(base_switch + 0 + j * 256 + i * 4 * 256, 8));
                    TpcDBDataPopulator.createPort2Port(hostGroup + TpcDBDataPopulator.zeropadded(base_host + j * 0x100000 + 256, 8), "88888888" + TpcDBDataPopulator.zeropadded(base_switch + 0 + j * 256 + 8192 + i * 4 * 256, 8));
                    TpcDBDataPopulator.createPort2Port(hostGroup + TpcDBDataPopulator.zeropadded(base_host + j * 0x100000 + 0 + 65536, 8), "77777777" + TpcDBDataPopulator.zeropadded(base_switch + 0x100000 + j * 256 + i * 4 * 256, 8));
                    TpcDBDataPopulator.createPort2Port(hostGroup + TpcDBDataPopulator.zeropadded(base_host + j * 0x100000 + 256 + 65536, 8), "88888888" + TpcDBDataPopulator.zeropadded(base_switch + 0x100000 + j * 256 + 8192 + i * 4 * 256, 8));
                }
            }
            System.out.println();
            Debug.info("Switch2Storage:");
            for (i = 0; i < 2; ++i) {
                for (j = 0; j < 2; ++j) {
                    TpcDBDataPopulator.createPort2Port("55555555" + TpcDBDataPopulator.zeropadded(i * 0x100000 + j * 256 + 13824, 8), "44444444" + TpcDBDataPopulator.zeropadded(j * 0x100000 + i * 64, 8));
                    TpcDBDataPopulator.createPort2Port("66666666" + TpcDBDataPopulator.zeropadded(i * 0x100000 + j * 256 + 13824, 8), "44444444" + TpcDBDataPopulator.zeropadded(j * 0x100000 + i * 64 + 16, 8));
                    TpcDBDataPopulator.createPort2Port("77777777" + TpcDBDataPopulator.zeropadded(i * 0x100000 + j * 256 + 13824, 8), "99999999" + TpcDBDataPopulator.zeropadded(j * 0x100000 + i * 64, 8));
                    TpcDBDataPopulator.createPort2Port("88888888" + TpcDBDataPopulator.zeropadded(i * 0x100000 + j * 256 + 13824, 8), "99999999" + TpcDBDataPopulator.zeropadded(j * 0x100000 + i * 64 + 16, 8));
                }
            }
            int[] host_lun_id1 = new int[4];
            int[] host_lun_id2 = new int[4];
            int[] host_lun_id3 = new int[4];
            int[] host_lun_id4 = new int[4];
            System.out.println();
            Debug.info("LunMasking:");
            Vector arrays = TpcDBDataPopulator.getArrays();
            Iterator arrayIter = arrays.iterator();
            int lunId = 0;
            int device_lun_id = 0;
            int dp_id = 1;
            while (arrayIter.hasNext()) {
                Integer subsystemId = (Integer)arrayIter.next();
                Vector volumes = TpcDBDataPopulator.getVolumeFromArray(subsystemId);
                if (volumes.size() != 0) {
                    Vector arrayPorts = TpcDBDataPopulator.getConnectedPorts(TpcDBDataPopulator.getPortsFromSubsystem(subsystemId));
                    Vector hosts = TpcDBDataPopulator.getHostFromArray(subsystemId);
                    for (Integer hostId : hosts) {
                        Vector hostPorts = TpcDBDataPopulator.getConnectedPorts(TpcDBDataPopulator.getPortsFromHost(hostId));
                        for (Integer hostPort : hostPorts) {
                            for (Integer arrayPort : arrayPorts) {
                                TpcDBDataPopulator.createDataPath(dp_id++, lunId++, device_lun_id++, hostPort, arrayPort, (Integer)volumes.elementAt(lunId % volumes.size()));
                            }
                        }
                    }
                    continue;
                }
                Debug.warning("No volumes found on storage subsystem: " + subsystemId);
            }
        }
        catch (Exception e) {
            Debug.warning(e);
        }
    }

    public static void populateSan1a() {
        try {
            Integer ssPort;
            int i;
            Integer sp;
            int TOTAL_STORAGE_ARRAYS = 2;
            int TOTAL_PORTS_PER_STORAGE_ARRAY = 16;
            int TOTAL_SWITCHES_PER_GROUP = 2;
            int TOTAL_HOSTS_PER_HOSTGROUP = 4;
            int TOTAL_PORTS_PER_SWITCH = 64;
            int TOTAL_STORAGE_POOLS_PER_STORAGE_ARRAY = 2;
            int TOTAL_STORAGE_VOLUMES_PER_STORAGE_POOL = 2;
            TpcDBDataPopulator.createRealSwitchGroup(1, "ffffffff", 0, 0x100000, 1785L, 512, 8, 80, "Eric", "Real Cisco switch", "Almaden", null, true, null, null, null);
            TpcDBDataPopulator.createSan2Switch("fefefefe00000000", "ffffffff00000000");
            System.out.println("\nSwitch2Switch:");
            System.out.println();
            boolean base_switch = false;
            boolean base_host = false;
            Vector switchPorts = TpcDBDataPopulator.getPortsFromSwitch("ffffffff00000000");
            int sport = 0;
            for (int i2 = 0; i2 < 4; ++i2) {
                for (int _hostId = 299; _hostId < computerId; ++_hostId) {
                    sp = (Integer)switchPorts.elementAt(sport++);
                    Vector hPort = TpcDBDataPopulator.getPortsFromHost(_hostId);
                    if (hPort.size() <= i2) continue;
                    Integer hp = null;
                    try {
                        hp = (Integer)hPort.elementAt(i2);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    TpcDBDataPopulator.createPort2Port(TpcDBDataPopulator.getPortWWN(hp), TpcDBDataPopulator.getPortWWN(sp), false);
                }
            }
            Vector ssPorts = TpcDBDataPopulator.getConnectedPorts(TpcDBDataPopulator.getPortsFromSubsystem(50000000));
            for (i = 0; i < ssPorts.size(); ++i) {
                sp = (Integer)switchPorts.elementAt(sport++);
                ssPort = (Integer)ssPorts.elementAt(i);
                TpcDBDataPopulator.createPort2Port(TpcDBDataPopulator.getPortWWN(ssPort), TpcDBDataPopulator.getPortWWN(sp), false);
            }
            ssPorts = TpcDBDataPopulator.getConnectedPorts(TpcDBDataPopulator.getPortsFromSubsystem(40000000));
            for (i = 0; i < ssPorts.size(); ++i) {
                sp = (Integer)switchPorts.elementAt(sport++);
                ssPort = (Integer)ssPorts.elementAt(i);
                TpcDBDataPopulator.createPort2Port(TpcDBDataPopulator.getPortWWN(ssPort), TpcDBDataPopulator.getPortWWN(sp), false);
            }
            ssPorts = TpcDBDataPopulator.getConnectedPorts(TpcDBDataPopulator.getPortsFromSubsystem(50100000));
            for (i = 0; i < ssPorts.size(); ++i) {
                sp = (Integer)switchPorts.elementAt(sport++);
                ssPort = (Integer)ssPorts.elementAt(i);
                TpcDBDataPopulator.createPort2Port(TpcDBDataPopulator.getPortWWN(ssPort), TpcDBDataPopulator.getPortWWN(sp), false);
            }
            ssPorts = TpcDBDataPopulator.getConnectedPorts(TpcDBDataPopulator.getPortsFromSubsystem(40100000));
            for (i = 0; i < ssPorts.size(); ++i) {
                sp = (Integer)switchPorts.elementAt(sport++);
                ssPort = (Integer)ssPorts.elementAt(i);
                TpcDBDataPopulator.createPort2Port(TpcDBDataPopulator.getPortWWN(ssPort), TpcDBDataPopulator.getPortWWN(sp), false);
            }
        }
        catch (Exception e) {
            Debug.warning(e);
        }
    }

    public static void populateSan2() {
        try {
            String hostGroup;
            int j;
            int i;
            int TOTAL_STORAGE_ARRAYS = 2;
            int TOTAL_PORTS_PER_STORAGE_ARRAY = 16;
            int TOTAL_SWITCHES_PER_GROUP = 2;
            int TOTAL_HOSTS_PER_HOSTGROUP = 6;
            int TOTAL_PORTS_PER_SWITCH = 64;
            int TOTAL_STORAGE_POOLS_PER_STORAGE_ARRAY = 2;
            int TOTAL_STORAGE_VOLUMES_PER_STORAGE_POOL = 2;
            TpcDBDataPopulator.nameGenerator(TOTAL_SERVERS);
            int startComputerId = computerId;
            TpcDBDataPopulator.createServerGroup(6, "Zurich.ibm.com", 0L, "01010101", 0, 0x100000, 1, 1, 3, null, null, 9, 91);
            TpcDBDataPopulator.createServerGroup(6, "Poughkeepsie.ibm.com", 255L, "10000000", 0, 0x100000, 1, 1, 0, null, null, 9, 91);
            TpcDBDataPopulator.createServerGroup(6, "Austin.ibm.com", 510L, "20000000", 0, 0x100000, 1, 1, 0, null, null, 9, 91);
            TpcDBDataPopulator.createServerGroup(6, "watson.ibm.com", 765L, "30000000", 0, 0x100000, 1, 1, 0, null, null, 9, 91);
            TpcDBDataPopulator.createServerGroup(6, "boulder.ibm.com", 255L, "10100000", 0, 0x100000, 1, 1, 1, null, null, 9, 91);
            TpcDBDataPopulator.createServerGroup(1, "local.ibm.com", 255L, "20200000", 0, 0x100000, 1, 1, 0, null, null, 9, 91);
            System.out.println();
            TpcDBDataPopulator.createRealSwitchGroup(1, "50000000", 0, 0x100000, 1020L, 64, 7, 70, "Danny", null, "Almaden", null, true, "B3-200", null, null);
            TpcDBDataPopulator.createRealSwitchGroup(1, "60000000", 0, 0x100000, 1275L, 64, 7, 70, "Danny", null, "Almaden", null, true, "B2-255", null, null);
            TpcDBDataPopulator.createRealSwitchGroup(1, "70000000", 0, 0x100000, 1530L, 64, 6, 60, "Robert", null, "Almaden", null, true, "B3-200", null, null);
            TpcDBDataPopulator.createRealSwitchGroup(1, "80000000", 0, 0x100000, 1785L, 64, 6, 60, "Robert", null, "Almaden", null, true, "B2-255", null, null);
            System.out.println("\nSwitch2Switch:");
            TpcDBDataPopulator.connectSwitches("50000000", 0L, 0x100000L, 62L, "60000000", 0L, 0x100000L, 63L);
            TpcDBDataPopulator.connectSwitches("70000000", 0L, 0x100000L, 62L, "80000000", 0L, 0x100000L, 63L);
            System.out.println();
            TpcDBDataPopulator.createStorageGroup(1, 60000000, 100000, "40000000", 0, 0x100000, 2040L, 16, true, true, "Database Storage", "Database Storage", "Database Storage", true, 0xA00000L, 0x19000000L, 429916160L, 2, 20, "800");
            TpcDBDataPopulator.createStorageGroup(1, 70000000, 100000, "90000000", 0, 0x100000, 2295L, 16, true, true, "Database Storage", "Database Storage", "Database Storage", true, 0xA00000L, 0x19000000L, 429916160L, 2, 20, "800");
            TpcDBDataPopulator.populateStorageSubsystem(60000000, 60000000, 100000, 2, 2, 10);
            TpcDBDataPopulator.populateStorageSubsystem(70000000, 70000000, 100000, 2, 4, 5);
            boolean base = false;
            Debug.info("Switch2SAN:");
            TpcDBDataPopulator.createSan2Switch("dddddddd00000000", "5000000000000000");
            TpcDBDataPopulator.createSan2Switch("dddddddd00000000", "6000000000000000");
            TpcDBDataPopulator.createSan2Switch("cccccccc00000000", "7000000000000000");
            TpcDBDataPopulator.createSan2Switch("cccccccc00000000", "8000000000000000");
            int base_switch = 0;
            int base_host = 0;
            System.out.println();
            Debug.info("Host2Switch:");
            String[] hostGroupList = new String[]{"01010101"};
            for (i = 0; i < hostGroupList.length; ++i) {
                for (j = 0; j < 6; ++j) {
                    hostGroup = hostGroupList[i];
                    TpcDBDataPopulator.createPort2Port(hostGroup + TpcDBDataPopulator.zeropadded(base_host + j * 0x100000 + 0, 8), "50000000" + TpcDBDataPopulator.zeropadded(base_switch + 0 + j * 256 + i * 6 * 256, 8));
                    TpcDBDataPopulator.createPort2Port(hostGroup + TpcDBDataPopulator.zeropadded(base_host + j * 0x100000 + 256, 8), "60000000" + TpcDBDataPopulator.zeropadded(base_switch + 0 + j * 256 + i * 6 * 256, 8));
                }
            }
            hostGroupList = new String[]{"10000000"};
            for (i = 0; i < hostGroupList.length; ++i) {
                for (j = 0; j < 6; ++j) {
                    hostGroup = hostGroupList[i];
                    TpcDBDataPopulator.createPort2Port(hostGroup + TpcDBDataPopulator.zeropadded(base_host + j * 0x100000, 8), "50000000" + TpcDBDataPopulator.zeropadded(base_switch + 0 + j * 256 + 8192 + i * 6 * 256, 8));
                }
            }
            hostGroupList = new String[]{"10100000"};
            for (i = 0; i < hostGroupList.length; ++i) {
                for (j = 0; j < 6; ++j) {
                    hostGroup = hostGroupList[i];
                    TpcDBDataPopulator.createPort2Port(hostGroup + TpcDBDataPopulator.zeropadded(base_host + j * 0x100000, 8), "60000000" + TpcDBDataPopulator.zeropadded(base_switch + 0 + j * 256 + 8192 + i * 6 * 256, 8));
                }
            }
            int portId = TpcDBDataPopulator.createPort("9999999999999999", 0, null, 7, "Port from an unknown switch");
            Vector disconnectedFromSwitch1 = TpcDBDataPopulator.getDisconnectedPortsFromSwitch("5000000000000000");
            Vector disconnectedFromSwitch2 = TpcDBDataPopulator.getDisconnectedPortsFromSwitch("6000000000000000");
            TpcDBDataPopulator.createPort2Port(TpcDBDataPopulator.getPortWWN((Integer)disconnectedFromSwitch1.elementAt(0)), "9999999999999999");
            Vector ssPorts1 = TpcDBDataPopulator.getDisconnectedPorts(TpcDBDataPopulator.getPortsFromSubsystem(60000000));
            Vector ssPorts2 = TpcDBDataPopulator.getDisconnectedPorts(TpcDBDataPopulator.getPortsFromSubsystem(70000000));
            TpcDBDataPopulator.createPort2Port(TpcDBDataPopulator.getPortWWN((Integer)disconnectedFromSwitch1.elementAt(1)), TpcDBDataPopulator.getPortWWN((Integer)ssPorts1.elementAt(0)), false);
            TpcDBDataPopulator.createPort2Port(TpcDBDataPopulator.getPortWWN((Integer)disconnectedFromSwitch1.elementAt(2)), TpcDBDataPopulator.getPortWWN((Integer)ssPorts2.elementAt(0)), false);
            TpcDBDataPopulator.createPort2Port(TpcDBDataPopulator.getPortWWN((Integer)disconnectedFromSwitch2.elementAt(0)), TpcDBDataPopulator.getPortWWN((Integer)ssPorts1.elementAt(1)), false);
            TpcDBDataPopulator.createPort2Port(TpcDBDataPopulator.getPortWWN((Integer)disconnectedFromSwitch2.elementAt(1)), TpcDBDataPopulator.getPortWWN((Integer)ssPorts2.elementAt(1)), false);
            Vector portsHost = TpcDBDataPopulator.getDisconnectedPorts(TpcDBDataPopulator.getPortsFromHost(computerId - 1));
            if (portsHost.size() > 0) {
                Integer port = (Integer)portsHost.elementAt(0);
                Vector portsArray = TpcDBDataPopulator.getDisconnectedPorts(TpcDBDataPopulator.getPortsFromSubsystem(60000000));
                TpcDBDataPopulator.createPort2Port((Integer)portsArray.elementAt(0), port);
            } else {
                Debug.error("Number of free ports is invalid");
            }
        }
        catch (Exception e) {
            Debug.warning(e);
        }
    }

    public static void populateZones1(String san_wwn, int totalZoneSets, int zonePerZoneSet, int zonememberPerZone, int active) {
        TpcDBDataPopulator.createZoneSet(2, 0, 0x1000000, san_wwn, (short)0);
        int base = 0;
        for (int i = 0; i < totalZoneSets; ++i) {
            TpcDBDataPopulator.createZone(zonePerZoneSet, base, 4096, san_wwn, (short)active, (short)0);
            for (int j = 0; j < zonePerZoneSet; ++j) {
                int zone_id = base + 4096 * j;
                TpcDBDataPopulator.createZSet2Zone(base, zone_id);
                for (int k = 0; k < zonememberPerZone; ++k) {
                    TpcDBDataPopulator.createZSet2Member(zone_id, "ZoneMember:" + TpcDBDataPopulator.zeropadded(zone_id, 16) + ":" + k);
                }
            }
            base += 0x1000000;
        }
    }

    public static void populate() {
        TpcDBDataPopulator.populateConfiguration();
        TpcDBDataPopulator.createSanGroup(1, "fefefefe", 0, 0x100000, null, "Manually Entered Name", true, true, "", "Eric", "B3-255", null);
        TpcDBDataPopulator.createSanGroup(1, "ffffffff", 0, 0x100000, "fefefefe00000000", null, true, true, "0f0f0f0f0f0f0ff0", "Eric", "B3-255", null);
        TpcDBDataPopulator.createSanGroup(1, "eeeeeeee", 0, 0x100000, "fefefefe00000000", null, true, true, "0f0f0f0f0f0f0ff0", "Eric", "B3-255", null);
        TpcDBDataPopulator.createSanGroup(1, "dddddddd", 0, 0x100000, null, null, false, true, "0d0d0d0d0d0d0dfd", "Roberto", "B3-247", null);
        TpcDBDataPopulator.createSanGroup(1, "cccccccc", 0, 0x100000, null, null, true, false, "eeeeeeeeeeeeeeee", "Danny", "B3-255", null);
        TpcDBDataPopulator.populateSan1();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            try {
                System.out.println("Loading JDBC driver... ");
                Class<?> c = Class.forName("org.apache.derby.jdbc.ClientDriver");
                c.newInstance();
                Properties p = new Properties();
                p.setProperty("user", user);
                p.setProperty("password", password);
                con = DriverManager.getConnection(url, p);
                con.setAutoCommit(true);
            }
            catch (SQLException e) {
                e.printStackTrace();
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
            catch (Exception e) {
                Debug.error(e);
                System.exit(-1);
            }
            TpcDBDataPopulator.populate();
        }
        catch (Exception e) {
            Debug.error(e);
        }
        finally {
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (Exception e) {
                Debug.warning(e);
            }
        }
    }
}

