/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.tables.TChartSettingsTable;

public class ChartSettings
extends TChartSettingsTable {
    public static ChartSettingsCursor getCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
        return new ChartSettingsCursor(con, htWhereClause, columns);
    }

    public ChartSettings() {
        this.clear();
    }

    public ChartSettings(int ReportId, int ReportSubtype, int ChartId, int ChartSubtype, int BatchId, short ChartType, int MaxCharts, int MaxSeries, String TrendData, String HoverText, short XAxis, String Creator, String Title) {
        this.clear();
        this.m_ReportId = ReportId;
        this.m_ReportSubtype = ReportSubtype;
        this.m_ChartId = ChartId;
        this.m_ChartSubtype = ChartSubtype;
        this.m_BatchId = BatchId;
        this.m_ChartType = ChartType;
        this.m_MaxCharts = MaxCharts;
        this.m_MaxSeries = MaxSeries;
        this.m_TrendData = TrendData;
        this.m_HoverText = HoverText;
        this.m_XAxis = XAxis;
        this.m_Creator = Creator;
        this.m_Title = Title;
    }

    private void setNonKeyValues(Hashtable htColsAndValues) {
        if (this.m_ReportId != Integer.MIN_VALUE) {
            htColsAndValues.put(ChartSettings.getColumnInfo("REPORT_ID"), String.valueOf(this.m_ReportId));
        }
        if (this.m_ReportSubtype != Integer.MIN_VALUE) {
            htColsAndValues.put(ChartSettings.getColumnInfo("REPORT_SUBTYPE"), String.valueOf(this.m_ReportSubtype));
        }
        if (this.m_ChartId != Integer.MIN_VALUE) {
            htColsAndValues.put(ChartSettings.getColumnInfo("CHART_ID"), String.valueOf(this.m_ChartId));
        }
        if (this.m_ChartSubtype != Integer.MIN_VALUE) {
            htColsAndValues.put(ChartSettings.getColumnInfo("CHART_SUBTYPE"), String.valueOf(this.m_ChartSubtype));
        }
        if (this.m_BatchId != Integer.MIN_VALUE) {
            htColsAndValues.put(ChartSettings.getColumnInfo("BATCH_ID"), String.valueOf(this.m_BatchId));
        }
        if (this.m_ChartType != Short.MIN_VALUE) {
            htColsAndValues.put(ChartSettings.getColumnInfo("CHART_TYPE"), String.valueOf(this.m_ChartType));
        }
        if (this.m_MaxCharts != Integer.MIN_VALUE) {
            htColsAndValues.put(ChartSettings.getColumnInfo("MAX_CHARTS"), String.valueOf(this.m_MaxCharts));
        }
        if (this.m_MaxSeries != Integer.MIN_VALUE) {
            htColsAndValues.put(ChartSettings.getColumnInfo("MAX_SERIES"), String.valueOf(this.m_MaxSeries));
        }
        if (this.m_TrendData != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(ChartSettings.getColumnInfo("TREND_DATA"), this.m_TrendData);
        }
        if (this.m_HoverText != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(ChartSettings.getColumnInfo("HOVER_TEXT"), this.m_HoverText);
        }
        if (this.m_XAxis != Short.MIN_VALUE) {
            htColsAndValues.put(ChartSettings.getColumnInfo("X_AXIS"), String.valueOf(this.m_XAxis));
        }
        if (this.m_Creator != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(ChartSettings.getColumnInfo("CREATOR"), this.m_Creator);
        }
        if (this.m_Title != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(ChartSettings.getColumnInfo("TITLE"), this.m_Title);
        }
    }

    public boolean insert(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_CHART_SETTINGS", con, this.htColsAndValues);
    }

    public boolean insert(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performInsert("T_CHART_SETTINGS", con, htinput);
    }

    public int update(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_CHART_SETTINGS", con, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_CHART_SETTINGS", con, htinput, this.htWhereClause);
    }

    public int delete(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_CHART_SETTINGS", con, this.htWhereClause);
    }

    public int delete(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_CHART_SETTINGS", con, this.htWhereClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieve(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        boolean res = false;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_CHART_SETTINGS", con, this.htWhereClause, null);
            if (DBrs.next()) {
                this.setFields(con, DBrs);
                res = true;
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ChartSettings retrieve(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable htWhereClause = new Hashtable();
        ChartSettings el = null;
        if (htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_CHART_SETTINGS", con, htWhereClause, null);
            if (DBrs.next()) {
                el = new ChartSettings();
                el.setFields(con, DBrs);
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return el;
    }

    public static int update(DBConnection con, Hashtable htinput, Hashtable htWhereClause) throws SQLException {
        if (con == null || htinput == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performUpdate("T_CHART_SETTINGS", con, htinput, htWhereClause);
    }

    public static int deletes(DBConnection con, Hashtable htWhereClause) throws SQLException {
        if (con == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performDelete("T_CHART_SETTINGS", con, htWhereClause);
    }

    protected void setFields(DBConnection con, DBResultSet DBrs) throws SQLException {
        this.setReportId(DBrs.getInt("REPORT_ID"));
        this.setReportSubtype(DBrs.getInt("REPORT_SUBTYPE"));
        this.setChartId(DBrs.getInt("CHART_ID"));
        this.setChartSubtype(DBrs.getInt("CHART_SUBTYPE"));
        this.setBatchId(DBrs.getInt("BATCH_ID"));
        this.setChartType(DBrs.getShort("CHART_TYPE"));
        this.setMaxCharts(DBrs.getInt("MAX_CHARTS"));
        this.setMaxSeries(DBrs.getInt("MAX_SERIES"));
        this.setTrendData(DBrs.getString("TREND_DATA"));
        this.setHoverText(DBrs.getString("HOVER_TEXT"));
        this.setXAxis(DBrs.getShort("X_AXIS"));
        this.setCreator(DBrs.getString("CREATOR"));
        this.setTitle(DBrs.getString("TITLE"));
    }

    public static class ChartSettingsCursor
    extends DBCursor {
        private ChartSettings element = new ChartSettings();
        private DBConnection con;

        public ChartSettingsCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
            super("T_CHART_SETTINGS", con, htWhereClause, columns);
            this.con = con;
        }

        public ChartSettings getObject() throws SQLException {
            ChartSettings el = null;
            if (this.DBrs != null) {
                el = new ChartSettings();
                el.setFields(this.con, this.DBrs);
            }
            return el;
        }

        public ChartSettings getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

