/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.tables.TResCimom2namespaceTable;

public class Cimom2namespace
extends TResCimom2namespaceTable {
    public static Cimom2namespaceCursor getCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
        return new Cimom2namespaceCursor(con, htWhereClause, columns);
    }

    public Cimom2namespace() {
        this.clear();
    }

    public Cimom2namespace(int CimNamespaceId, int CimomId, String Namespace, Timestamp UpdateTimestamp) {
        this.clear();
        this.m_CimNamespaceId = CimNamespaceId;
        this.m_CimomId = CimomId;
        this.m_Namespace = Namespace;
        this.m_UpdateTimestamp = UpdateTimestamp;
    }

    private void setNonKeyValues(Hashtable htColsAndValues) {
        if (this.m_CimNamespaceId != Integer.MIN_VALUE) {
            htColsAndValues.put(Cimom2namespace.getColumnInfo("CIM_NAMESPACE_ID"), String.valueOf(this.m_CimNamespaceId));
        }
        if (this.m_UpdateTimestamp != DBConstants.INVALID_TIMESTAMP_VALUE) {
            htColsAndValues.put(Cimom2namespace.getColumnInfo("UPDATE_TIMESTAMP"), this.m_UpdateTimestamp);
        }
    }

    public boolean insert(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_CimomId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key CIMOM_ID not found");
        }
        this.htColsAndValues.put(Cimom2namespace.getColumnInfo("CIMOM_ID"), String.valueOf(this.m_CimomId));
        if (this.m_Namespace == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key NAMESPACE not found");
        }
        this.htColsAndValues.put(Cimom2namespace.getColumnInfo("NAMESPACE"), this.m_Namespace);
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_CIMOM2NAMESPACE", con, this.htColsAndValues);
    }

    public boolean insert(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(Cimom2namespace.getColumnInfo("CIMOM_ID")) == null) {
            throw new SQLException(" ERROR: key CIMOM_ID not found");
        }
        if (htinput.get(Cimom2namespace.getColumnInfo("NAMESPACE")) == null) {
            throw new SQLException(" ERROR: key NAMESPACE not found");
        }
        return DBQueryAssistant.performInsert("T_RES_CIMOM2NAMESPACE", con, htinput);
    }

    public int update(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_CimomId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key CIMOM_ID not found");
        }
        this.htWhereClause.put(Cimom2namespace.getColumnInfo("CIMOM_ID"), String.valueOf(this.m_CimomId));
        if (this.m_Namespace == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key NAMESPACE not found");
        }
        this.htWhereClause.put(Cimom2namespace.getColumnInfo("NAMESPACE"), this.m_Namespace);
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_CIMOM2NAMESPACE", con, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(Cimom2namespace.getColumnInfo("CIMOM_ID")) == null) {
            throw new SQLException(" ERROR: key CIMOM_ID not found");
        }
        this.htWhereClause.put(Cimom2namespace.getColumnInfo("CIMOM_ID"), htinput.get(Cimom2namespace.getColumnInfo("CIMOM_ID")));
        if (htinput.get(Cimom2namespace.getColumnInfo("NAMESPACE")) == null) {
            throw new SQLException(" ERROR: key NAMESPACE not found");
        }
        this.htWhereClause.put(Cimom2namespace.getColumnInfo("NAMESPACE"), htinput.get(Cimom2namespace.getColumnInfo("NAMESPACE")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_CIMOM2NAMESPACE", con, htinput, this.htWhereClause);
    }

    public int delete(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_CimomId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key CIMOM_ID not found");
        }
        this.htWhereClause.put(Cimom2namespace.getColumnInfo("CIMOM_ID"), String.valueOf(this.m_CimomId));
        if (this.m_Namespace == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key NAMESPACE not found");
        }
        this.htWhereClause.put(Cimom2namespace.getColumnInfo("NAMESPACE"), this.m_Namespace);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_CIMOM2NAMESPACE", con, this.htWhereClause);
    }

    public int delete(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(Cimom2namespace.getColumnInfo("CIMOM_ID")) == null) {
            throw new SQLException(" ERROR: key CIMOM_ID not found");
        }
        this.htWhereClause.put(Cimom2namespace.getColumnInfo("CIMOM_ID"), htinput.get(Cimom2namespace.getColumnInfo("CIMOM_ID")));
        if (htinput.get(Cimom2namespace.getColumnInfo("NAMESPACE")) == null) {
            throw new SQLException(" ERROR: key NAMESPACE not found");
        }
        this.htWhereClause.put(Cimom2namespace.getColumnInfo("NAMESPACE"), htinput.get(Cimom2namespace.getColumnInfo("NAMESPACE")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_CIMOM2NAMESPACE", con, this.htWhereClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieve(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_CimomId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key CIMOM_ID not found");
        }
        this.htWhereClause.put(Cimom2namespace.getColumnInfo("CIMOM_ID"), String.valueOf(this.m_CimomId));
        if (this.m_Namespace == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key NAMESPACE not found");
        }
        this.htWhereClause.put(Cimom2namespace.getColumnInfo("NAMESPACE"), this.m_Namespace);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        boolean res = false;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_CIMOM2NAMESPACE", con, this.htWhereClause, null);
            if (DBrs.next()) {
                this.setFields(con, DBrs);
                res = true;
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Cimom2namespace retrieve(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable htWhereClause = new Hashtable();
        Cimom2namespace el = null;
        if (htinput.get(Cimom2namespace.getColumnInfo("CIMOM_ID")) == null) {
            throw new SQLException(" ERROR: key CIMOM_ID not found");
        }
        htWhereClause.put(Cimom2namespace.getColumnInfo("CIMOM_ID"), htinput.get(Cimom2namespace.getColumnInfo("CIMOM_ID")));
        if (htinput.get(Cimom2namespace.getColumnInfo("NAMESPACE")) == null) {
            throw new SQLException(" ERROR: key NAMESPACE not found");
        }
        htWhereClause.put(Cimom2namespace.getColumnInfo("NAMESPACE"), htinput.get(Cimom2namespace.getColumnInfo("NAMESPACE")));
        if (htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_CIMOM2NAMESPACE", con, htWhereClause, null);
            if (DBrs.next()) {
                el = new Cimom2namespace();
                el.setFields(con, DBrs);
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return el;
    }

    public static int update(DBConnection con, Hashtable htinput, Hashtable htWhereClause) throws SQLException {
        if (con == null || htinput == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performUpdate("T_RES_CIMOM2NAMESPACE", con, htinput, htWhereClause);
    }

    public static int deletes(DBConnection con, Hashtable htWhereClause) throws SQLException {
        if (con == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performDelete("T_RES_CIMOM2NAMESPACE", con, htWhereClause);
    }

    protected void setFields(DBConnection con, DBResultSet DBrs) throws SQLException {
        this.setCimNamespaceId(DBrs.getInt("CIM_NAMESPACE_ID"));
        this.setCimomId(DBrs.getInt("CIMOM_ID"));
        this.setNamespace(DBrs.getString("NAMESPACE"));
        this.setUpdateTimestamp(DBrs.getTimestamp("UPDATE_TIMESTAMP"));
    }

    public static class Cimom2namespaceCursor
    extends DBCursor {
        private Cimom2namespace element = new Cimom2namespace();
        private DBConnection con;

        public Cimom2namespaceCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
            super("T_RES_CIMOM2NAMESPACE", con, htWhereClause, columns);
            this.con = con;
        }

        public Cimom2namespace getObject() throws SQLException {
            Cimom2namespace el = null;
            if (this.DBrs != null) {
                el = new Cimom2namespace();
                el.setFields(this.con, this.DBrs);
            }
            return el;
        }

        public Cimom2namespace getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

