/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.Normalizer;
import org.eclipse.aperi.infrastructure.database.tables.TResClientSettingDataTable;

public class ClientSettingData
extends TResClientSettingDataTable {
    private String m_CreationClassNameId_str;

    public void setCreationClassName(String el) {
        this.m_CreationClassNameId_str = el;
    }

    public String getCreationClassName() {
        return this.m_CreationClassNameId_str;
    }

    public static ClientSettingDataCursor getCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
        return new ClientSettingDataCursor(con, htWhereClause, columns);
    }

    public ClientSettingData() {
        this.clear();
    }

    public ClientSettingData(int SettingDataId, String InstanceId, String ElementName, String ClientTypes, String ClientTypeDescriptions, short CreationClassNameId, int SubsystemId) {
        this.clear();
        this.m_SettingDataId = SettingDataId;
        this.m_InstanceId = InstanceId;
        this.m_ElementName = ElementName;
        this.m_ClientTypes = ClientTypes;
        this.m_ClientTypeDescriptions = ClientTypeDescriptions;
        this.m_CreationClassNameId = CreationClassNameId;
        this.m_SubsystemId = SubsystemId;
    }

    private void setNonKeyValues(Hashtable htColsAndValues) {
        if (this.m_SettingDataId != Integer.MIN_VALUE) {
            htColsAndValues.put(ClientSettingData.getColumnInfo("SETTING_DATA_ID"), String.valueOf(this.m_SettingDataId));
        }
        if (this.m_ElementName != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(ClientSettingData.getColumnInfo("ELEMENT_NAME"), this.m_ElementName);
        }
        if (this.m_ClientTypes != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(ClientSettingData.getColumnInfo("CLIENT_TYPES"), this.m_ClientTypes);
        }
        if (this.m_ClientTypeDescriptions != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(ClientSettingData.getColumnInfo("CLIENT_TYPE_DESCRIPTIONS"), this.m_ClientTypeDescriptions);
        }
        if (this.m_CreationClassNameId != Short.MIN_VALUE) {
            htColsAndValues.put(ClientSettingData.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(this.m_CreationClassNameId));
        }
    }

    public boolean insert(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(con, this.m_CreationClassNameId_str);
        }
        if (this.m_InstanceId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key INSTANCE_ID not found");
        }
        this.htColsAndValues.put(ClientSettingData.getColumnInfo("INSTANCE_ID"), this.m_InstanceId);
        if (this.m_SubsystemId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SUBSYSTEM_ID not found");
        }
        this.htColsAndValues.put(ClientSettingData.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(this.m_SubsystemId));
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_CLIENT_SETTING_DATA", con, this.htColsAndValues);
    }

    public boolean insert(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(ClientSettingData.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(ClientSettingData.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(ClientSettingData.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(ClientSettingData.getColumnInfo("INSTANCE_ID")) == null) {
            throw new SQLException(" ERROR: key INSTANCE_ID not found");
        }
        if (htinput.get(ClientSettingData.getColumnInfo("SUBSYSTEM_ID")) == null) {
            throw new SQLException(" ERROR: key SUBSYSTEM_ID not found");
        }
        return DBQueryAssistant.performInsert("T_RES_CLIENT_SETTING_DATA", con, htinput);
    }

    public int update(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(con, this.m_CreationClassNameId_str);
        }
        if (this.m_InstanceId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key INSTANCE_ID not found");
        }
        this.htWhereClause.put(ClientSettingData.getColumnInfo("INSTANCE_ID"), this.m_InstanceId);
        if (this.m_SubsystemId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(ClientSettingData.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(this.m_SubsystemId));
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_CLIENT_SETTING_DATA", con, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(ClientSettingData.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(ClientSettingData.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(ClientSettingData.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(ClientSettingData.getColumnInfo("INSTANCE_ID")) == null) {
            throw new SQLException(" ERROR: key INSTANCE_ID not found");
        }
        this.htWhereClause.put(ClientSettingData.getColumnInfo("INSTANCE_ID"), htinput.get(ClientSettingData.getColumnInfo("INSTANCE_ID")));
        if (htinput.get(ClientSettingData.getColumnInfo("SUBSYSTEM_ID")) == null) {
            throw new SQLException(" ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(ClientSettingData.getColumnInfo("SUBSYSTEM_ID"), htinput.get(ClientSettingData.getColumnInfo("SUBSYSTEM_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_CLIENT_SETTING_DATA", con, htinput, this.htWhereClause);
    }

    public int delete(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(con, this.m_CreationClassNameId_str);
        }
        if (this.m_InstanceId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key INSTANCE_ID not found");
        }
        this.htWhereClause.put(ClientSettingData.getColumnInfo("INSTANCE_ID"), this.m_InstanceId);
        if (this.m_SubsystemId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(ClientSettingData.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(this.m_SubsystemId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_CLIENT_SETTING_DATA", con, this.htWhereClause);
    }

    public int delete(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(ClientSettingData.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(ClientSettingData.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(ClientSettingData.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(ClientSettingData.getColumnInfo("INSTANCE_ID")) == null) {
            throw new SQLException(" ERROR: key INSTANCE_ID not found");
        }
        this.htWhereClause.put(ClientSettingData.getColumnInfo("INSTANCE_ID"), htinput.get(ClientSettingData.getColumnInfo("INSTANCE_ID")));
        if (htinput.get(ClientSettingData.getColumnInfo("SUBSYSTEM_ID")) == null) {
            throw new SQLException(" ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(ClientSettingData.getColumnInfo("SUBSYSTEM_ID"), htinput.get(ClientSettingData.getColumnInfo("SUBSYSTEM_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_CLIENT_SETTING_DATA", con, this.htWhereClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieve(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(con, this.m_CreationClassNameId_str);
        }
        if (this.m_InstanceId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key INSTANCE_ID not found");
        }
        this.htWhereClause.put(ClientSettingData.getColumnInfo("INSTANCE_ID"), this.m_InstanceId);
        if (this.m_SubsystemId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(ClientSettingData.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(this.m_SubsystemId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        boolean res = false;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_CLIENT_SETTING_DATA", con, this.htWhereClause, null);
            if (DBrs.next()) {
                this.setFields(con, DBrs);
                res = true;
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClientSettingData retrieve(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable htWhereClause = new Hashtable();
        ClientSettingData el = null;
        if (htinput.get(ClientSettingData.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(ClientSettingData.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(ClientSettingData.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(ClientSettingData.getColumnInfo("INSTANCE_ID")) == null) {
            throw new SQLException(" ERROR: key INSTANCE_ID not found");
        }
        htWhereClause.put(ClientSettingData.getColumnInfo("INSTANCE_ID"), htinput.get(ClientSettingData.getColumnInfo("INSTANCE_ID")));
        if (htinput.get(ClientSettingData.getColumnInfo("SUBSYSTEM_ID")) == null) {
            throw new SQLException(" ERROR: key SUBSYSTEM_ID not found");
        }
        htWhereClause.put(ClientSettingData.getColumnInfo("SUBSYSTEM_ID"), htinput.get(ClientSettingData.getColumnInfo("SUBSYSTEM_ID")));
        if (htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_CLIENT_SETTING_DATA", con, htWhereClause, null);
            if (DBrs.next()) {
                el = new ClientSettingData();
                el.setFields(con, DBrs);
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return el;
    }

    public static int update(DBConnection con, Hashtable htinput, Hashtable htWhereClause) throws SQLException {
        if (con == null || htinput == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(ClientSettingData.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(ClientSettingData.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(ClientSettingData.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htWhereClause.get(ClientSettingData.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htWhereClause.put(ClientSettingData.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htWhereClause.get(ClientSettingData.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        return DBQueryAssistant.performUpdate("T_RES_CLIENT_SETTING_DATA", con, htinput, htWhereClause);
    }

    public static int deletes(DBConnection con, Hashtable htWhereClause) throws SQLException {
        if (con == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htWhereClause.get(ClientSettingData.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htWhereClause.put(ClientSettingData.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htWhereClause.get(ClientSettingData.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        return DBQueryAssistant.performDelete("T_RES_CLIENT_SETTING_DATA", con, htWhereClause);
    }

    protected void setFields(DBConnection con, DBResultSet DBrs) throws SQLException {
        this.setSettingDataId(DBrs.getInt("SETTING_DATA_ID"));
        this.setInstanceId(DBrs.getString("INSTANCE_ID"));
        this.setElementName(DBrs.getString("ELEMENT_NAME"));
        this.setClientTypes(DBrs.getString("CLIENT_TYPES"));
        this.setClientTypeDescriptions(DBrs.getString("CLIENT_TYPE_DESCRIPTIONS"));
        this.setCreationClassNameId(DBrs.getShort("CREATION_CLASS_NAME_ID"));
        this.setCreationClassName(Normalizer.CreationClassNameGetName(con, this.m_CreationClassNameId));
        this.setSubsystemId(DBrs.getInt("SUBSYSTEM_ID"));
    }

    public static class ClientSettingDataCursor
    extends DBCursor {
        private ClientSettingData element = new ClientSettingData();
        private DBConnection con;

        private static Hashtable normalize(DBConnection con, Hashtable htWhereClause) throws SQLException {
            if (htWhereClause == null) {
                return null;
            }
            if (htWhereClause.get(TResClientSettingDataTable.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
                htWhereClause.put(TResClientSettingDataTable.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htWhereClause.get(TResClientSettingDataTable.getColumnInfo("CREATION_CLASS_NAME_ID")))));
            }
            return htWhereClause;
        }

        public ClientSettingDataCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
            super("T_RES_CLIENT_SETTING_DATA", con, ClientSettingDataCursor.normalize(con, htWhereClause), columns);
            this.con = con;
        }

        public ClientSettingData getObject() throws SQLException {
            ClientSettingData el = null;
            if (this.DBrs != null) {
                el = new ClientSettingData();
                el.setFields(this.con, this.DBrs);
            }
            return el;
        }

        public ClientSettingData getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

