/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.Normalizer;
import org.eclipse.aperi.infrastructure.database.tables.TViewComputerAttrsTable;

public class ComputerAttrs
extends TViewComputerAttrsTable {
    private String m_VendorId_str;

    public void setVendor(String el) {
        this.m_VendorId_str = el;
    }

    public String getVendor() {
        return this.m_VendorId_str;
    }

    public static ComputerAttrsCursor getCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
        return new ComputerAttrsCursor(con, htWhereClause, columns);
    }

    public ComputerAttrs() {
        this.clear();
    }

    public ComputerAttrs(String Guid, String HostUrl, short OsType, String OsVersion, String NetworkName, String DomainName, int ComputerId, String HostName, byte[] HardwareId, short VendorId, String TimeZone2, Timestamp DiscoveredTime, byte[] ProductStates, short CpuArchitecture, String OriginalAlias, String IpAddress, short Detectable, int OperationalStatus, short ConsolidatedStatus, short PropagatedStatus, Timestamp ChangedTimestamp, Timestamp UpdateTimestamp, String UserAttrib1, String UserAttrib2, String UserAttrib3, String Name2, String WinDomainName, short DiscoveryMethod, String NameIsLocal, Timestamp WhenDiscovered, short TimesMissing, int DomainId, int GroupId, String Manufacturer, String Model2, String SerialNumber, String ProcessorType, short ProcessorCount, short ProcessorSpeed, int Ram, int SwapSpace, double DiskCapacity, double FsFreeSpace, double DiskFreeSpace, Timestamp LastBootTime, String ProbeStatus, Timestamp LastProbeTime, double OwnedDiskCap, double OwnedDiskFreeSp, int ClusterId, int NodeHostedId) {
        this.clear();
        this.m_Guid = Guid;
        this.m_HostUrl = HostUrl;
        this.m_OsType = OsType;
        this.m_OsVersion = OsVersion;
        this.m_NetworkName = NetworkName;
        this.m_DomainName = DomainName;
        this.m_ComputerId = ComputerId;
        this.m_HostName = HostName;
        this.m_HardwareId = HardwareId;
        this.m_VendorId = VendorId;
        this.m_TimeZone = TimeZone2;
        this.m_DiscoveredTime = DiscoveredTime;
        this.m_ProductStates = ProductStates;
        this.m_CpuArchitecture = CpuArchitecture;
        this.m_OriginalAlias = OriginalAlias;
        this.m_IpAddress = IpAddress;
        this.m_Detectable = Detectable;
        this.m_OperationalStatus = OperationalStatus;
        this.m_ConsolidatedStatus = ConsolidatedStatus;
        this.m_PropagatedStatus = PropagatedStatus;
        this.m_ChangedTimestamp = ChangedTimestamp;
        this.m_UpdateTimestamp = UpdateTimestamp;
        this.m_UserAttrib1 = UserAttrib1;
        this.m_UserAttrib2 = UserAttrib2;
        this.m_UserAttrib3 = UserAttrib3;
        this.m_Name = Name2;
        this.m_WinDomainName = WinDomainName;
        this.m_DiscoveryMethod = DiscoveryMethod;
        this.m_NameIsLocal = NameIsLocal;
        this.m_WhenDiscovered = WhenDiscovered;
        this.m_TimesMissing = TimesMissing;
        this.m_DomainId = DomainId;
        this.m_GroupId = GroupId;
        this.m_Manufacturer = Manufacturer;
        this.m_Model = Model2;
        this.m_SerialNumber = SerialNumber;
        this.m_ProcessorType = ProcessorType;
        this.m_ProcessorCount = ProcessorCount;
        this.m_ProcessorSpeed = ProcessorSpeed;
        this.m_Ram = Ram;
        this.m_SwapSpace = SwapSpace;
        this.m_DiskCapacity = DiskCapacity;
        this.m_FsFreeSpace = FsFreeSpace;
        this.m_DiskFreeSpace = DiskFreeSpace;
        this.m_LastBootTime = LastBootTime;
        this.m_ProbeStatus = ProbeStatus;
        this.m_LastProbeTime = LastProbeTime;
        this.m_OwnedDiskCap = OwnedDiskCap;
        this.m_OwnedDiskFreeSp = OwnedDiskFreeSp;
        this.m_ClusterId = ClusterId;
        this.m_NodeHostedId = NodeHostedId;
    }

    private void setNonKeyValues(Hashtable htColsAndValues) {
        if (this.m_Guid != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(ComputerAttrs.getColumnInfo("GUID"), this.m_Guid);
        }
        if (this.m_HostUrl != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(ComputerAttrs.getColumnInfo("HOST_URL"), this.m_HostUrl);
        }
        if (this.m_OsType != Short.MIN_VALUE) {
            htColsAndValues.put(ComputerAttrs.getColumnInfo("OS_TYPE"), String.valueOf(this.m_OsType));
        }
        if (this.m_OsVersion != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(ComputerAttrs.getColumnInfo("OS_VERSION"), this.m_OsVersion);
        }
        if (this.m_NetworkName != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(ComputerAttrs.getColumnInfo("NETWORK_NAME"), this.m_NetworkName);
        }
        if (this.m_DomainName != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(ComputerAttrs.getColumnInfo("DOMAIN_NAME"), this.m_DomainName);
        }
        if (this.m_ComputerId != Integer.MIN_VALUE) {
            htColsAndValues.put(ComputerAttrs.getColumnInfo("COMPUTER_ID"), String.valueOf(this.m_ComputerId));
        }
        if (this.m_HostName != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(ComputerAttrs.getColumnInfo("HOST_NAME"), this.m_HostName);
        }
        if (this.m_HardwareId != DBConstants.INVALID_BYTE_ARRAY_VALUE) {
            htColsAndValues.put(ComputerAttrs.getColumnInfo("HARDWARE_ID"), new String(this.m_HardwareId));
        }
        if (this.m_VendorId != Short.MIN_VALUE) {
            htColsAndValues.put(ComputerAttrs.getColumnInfo("VENDOR_ID"), String.valueOf(this.m_VendorId));
        }
        if (this.m_TimeZone != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(ComputerAttrs.getColumnInfo("TIME_ZONE"), this.m_TimeZone);
        }
        if (this.m_DiscoveredTime != DBConstants.INVALID_TIMESTAMP_VALUE) {
            htColsAndValues.put(ComputerAttrs.getColumnInfo("DISCOVERED_TIME"), this.m_DiscoveredTime);
        }
        if (this.m_ProductStates != DBConstants.INVALID_BYTE_ARRAY_VALUE) {
            htColsAndValues.put(ComputerAttrs.getColumnInfo("PRODUCT_STATES"), new String(this.m_ProductStates));
        }
        if (this.m_CpuArchitecture != Short.MIN_VALUE) {
            htColsAndValues.put(ComputerAttrs.getColumnInfo("CPU_ARCHITECTURE"), String.valueOf(this.m_CpuArchitecture));
        }
        if (this.m_OriginalAlias != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(ComputerAttrs.getColumnInfo("ORIGINAL_ALIAS"), this.m_OriginalAlias);
        }
        if (this.m_IpAddress != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(ComputerAttrs.getColumnInfo("IP_ADDRESS"), this.m_IpAddress);
        }
        if (this.m_Detectable != Short.MIN_VALUE) {
            htColsAndValues.put(ComputerAttrs.getColumnInfo("DETECTABLE"), String.valueOf(this.m_Detectable));
        }
        if (this.m_OperationalStatus != Integer.MIN_VALUE) {
            htColsAndValues.put(ComputerAttrs.getColumnInfo("OPERATIONAL_STATUS"), String.valueOf(this.m_OperationalStatus));
        }
        if (this.m_ConsolidatedStatus != Short.MIN_VALUE) {
            htColsAndValues.put(ComputerAttrs.getColumnInfo("CONSOLIDATED_STATUS"), String.valueOf(this.m_ConsolidatedStatus));
        }
        if (this.m_PropagatedStatus != Short.MIN_VALUE) {
            htColsAndValues.put(ComputerAttrs.getColumnInfo("PROPAGATED_STATUS"), String.valueOf(this.m_PropagatedStatus));
        }
        if (this.m_ChangedTimestamp != DBConstants.INVALID_TIMESTAMP_VALUE) {
            htColsAndValues.put(ComputerAttrs.getColumnInfo("CHANGED_TIMESTAMP"), this.m_ChangedTimestamp);
        }
        if (this.m_UpdateTimestamp != DBConstants.INVALID_TIMESTAMP_VALUE) {
            htColsAndValues.put(ComputerAttrs.getColumnInfo("UPDATE_TIMESTAMP"), this.m_UpdateTimestamp);
        }
        if (this.m_UserAttrib1 != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(ComputerAttrs.getColumnInfo("USER_ATTRIB1"), this.m_UserAttrib1);
        }
        if (this.m_UserAttrib2 != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(ComputerAttrs.getColumnInfo("USER_ATTRIB2"), this.m_UserAttrib2);
        }
        if (this.m_UserAttrib3 != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(ComputerAttrs.getColumnInfo("USER_ATTRIB3"), this.m_UserAttrib3);
        }
        if (this.m_Name != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(ComputerAttrs.getColumnInfo("NAME"), this.m_Name);
        }
        if (this.m_WinDomainName != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(ComputerAttrs.getColumnInfo("WIN_DOMAIN_NAME"), this.m_WinDomainName);
        }
        if (this.m_DiscoveryMethod != Short.MIN_VALUE) {
            htColsAndValues.put(ComputerAttrs.getColumnInfo("DISCOVERY_METHOD"), String.valueOf(this.m_DiscoveryMethod));
        }
        if (this.m_NameIsLocal != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(ComputerAttrs.getColumnInfo("NAME_IS_LOCAL"), this.m_NameIsLocal);
        }
        if (this.m_WhenDiscovered != DBConstants.INVALID_TIMESTAMP_VALUE) {
            htColsAndValues.put(ComputerAttrs.getColumnInfo("WHEN_DISCOVERED"), this.m_WhenDiscovered);
        }
        if (this.m_TimesMissing != Short.MIN_VALUE) {
            htColsAndValues.put(ComputerAttrs.getColumnInfo("TIMES_MISSING"), String.valueOf(this.m_TimesMissing));
        }
        if (this.m_DomainId != Integer.MIN_VALUE) {
            htColsAndValues.put(ComputerAttrs.getColumnInfo("DOMAIN_ID"), String.valueOf(this.m_DomainId));
        }
        if (this.m_GroupId != Integer.MIN_VALUE) {
            htColsAndValues.put(ComputerAttrs.getColumnInfo("GROUP_ID"), String.valueOf(this.m_GroupId));
        }
        if (this.m_Manufacturer != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(ComputerAttrs.getColumnInfo("MANUFACTURER"), this.m_Manufacturer);
        }
        if (this.m_Model != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(ComputerAttrs.getColumnInfo("MODEL"), this.m_Model);
        }
        if (this.m_SerialNumber != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(ComputerAttrs.getColumnInfo("SERIAL_NUMBER"), this.m_SerialNumber);
        }
        if (this.m_ProcessorType != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(ComputerAttrs.getColumnInfo("PROCESSOR_TYPE"), this.m_ProcessorType);
        }
        if (this.m_ProcessorCount != Short.MIN_VALUE) {
            htColsAndValues.put(ComputerAttrs.getColumnInfo("PROCESSOR_COUNT"), String.valueOf(this.m_ProcessorCount));
        }
        if (this.m_ProcessorSpeed != Short.MIN_VALUE) {
            htColsAndValues.put(ComputerAttrs.getColumnInfo("PROCESSOR_SPEED"), String.valueOf(this.m_ProcessorSpeed));
        }
        if (this.m_Ram != Integer.MIN_VALUE) {
            htColsAndValues.put(ComputerAttrs.getColumnInfo("RAM"), String.valueOf(this.m_Ram));
        }
        if (this.m_SwapSpace != Integer.MIN_VALUE) {
            htColsAndValues.put(ComputerAttrs.getColumnInfo("SWAP_SPACE"), String.valueOf(this.m_SwapSpace));
        }
        if (this.m_DiskCapacity != Double.MIN_VALUE) {
            htColsAndValues.put(ComputerAttrs.getColumnInfo("DISK_CAPACITY"), String.valueOf(this.m_DiskCapacity));
        }
        if (this.m_FsFreeSpace != Double.MIN_VALUE) {
            htColsAndValues.put(ComputerAttrs.getColumnInfo("FS_FREE_SPACE"), String.valueOf(this.m_FsFreeSpace));
        }
        if (this.m_DiskFreeSpace != Double.MIN_VALUE) {
            htColsAndValues.put(ComputerAttrs.getColumnInfo("DISK_FREE_SPACE"), String.valueOf(this.m_DiskFreeSpace));
        }
        if (this.m_LastBootTime != DBConstants.INVALID_TIMESTAMP_VALUE) {
            htColsAndValues.put(ComputerAttrs.getColumnInfo("LAST_BOOT_TIME"), this.m_LastBootTime);
        }
        if (this.m_ProbeStatus != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(ComputerAttrs.getColumnInfo("PROBE_STATUS"), this.m_ProbeStatus);
        }
        if (this.m_LastProbeTime != DBConstants.INVALID_TIMESTAMP_VALUE) {
            htColsAndValues.put(ComputerAttrs.getColumnInfo("LAST_PROBE_TIME"), this.m_LastProbeTime);
        }
        if (this.m_OwnedDiskCap != Double.MIN_VALUE) {
            htColsAndValues.put(ComputerAttrs.getColumnInfo("OWNED_DISK_CAP"), String.valueOf(this.m_OwnedDiskCap));
        }
        if (this.m_OwnedDiskFreeSp != Double.MIN_VALUE) {
            htColsAndValues.put(ComputerAttrs.getColumnInfo("OWNED_DISK_FREE_SP"), String.valueOf(this.m_OwnedDiskFreeSp));
        }
        if (this.m_ClusterId != Integer.MIN_VALUE) {
            htColsAndValues.put(ComputerAttrs.getColumnInfo("CLUSTER_ID"), String.valueOf(this.m_ClusterId));
        }
        if (this.m_NodeHostedId != Integer.MIN_VALUE) {
            htColsAndValues.put(ComputerAttrs.getColumnInfo("NODE_HOSTED_ID"), String.valueOf(this.m_NodeHostedId));
        }
    }

    public boolean insert(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(con, this.m_VendorId_str);
        }
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_VIEW_COMPUTER_ATTRS", con, this.htColsAndValues);
    }

    public boolean insert(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(ComputerAttrs.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(ComputerAttrs.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(ComputerAttrs.getColumnInfo("VENDOR_ID")))));
        }
        return DBQueryAssistant.performInsert("T_VIEW_COMPUTER_ATTRS", con, htinput);
    }

    public int update(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(con, this.m_VendorId_str);
        }
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_VIEW_COMPUTER_ATTRS", con, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(ComputerAttrs.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(ComputerAttrs.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(ComputerAttrs.getColumnInfo("VENDOR_ID")))));
        }
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_VIEW_COMPUTER_ATTRS", con, htinput, this.htWhereClause);
    }

    public int delete(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(con, this.m_VendorId_str);
        }
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_VIEW_COMPUTER_ATTRS", con, this.htWhereClause);
    }

    public int delete(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(ComputerAttrs.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(ComputerAttrs.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(ComputerAttrs.getColumnInfo("VENDOR_ID")))));
        }
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_VIEW_COMPUTER_ATTRS", con, this.htWhereClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieve(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(con, this.m_VendorId_str);
        }
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        boolean res = false;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_VIEW_COMPUTER_ATTRS", con, this.htWhereClause, null);
            if (DBrs.next()) {
                this.setFields(con, DBrs);
                res = true;
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ComputerAttrs retrieve(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable htWhereClause = new Hashtable();
        ComputerAttrs el = null;
        if (htinput.get(ComputerAttrs.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(ComputerAttrs.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(ComputerAttrs.getColumnInfo("VENDOR_ID")))));
        }
        if (htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_VIEW_COMPUTER_ATTRS", con, htWhereClause, null);
            if (DBrs.next()) {
                el = new ComputerAttrs();
                el.setFields(con, DBrs);
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return el;
    }

    public static int update(DBConnection con, Hashtable htinput, Hashtable htWhereClause) throws SQLException {
        if (con == null || htinput == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(ComputerAttrs.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(ComputerAttrs.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(ComputerAttrs.getColumnInfo("VENDOR_ID")))));
        }
        if (htWhereClause.get(ComputerAttrs.getColumnInfo("VENDOR_ID")) != null) {
            htWhereClause.put(ComputerAttrs.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htWhereClause.get(ComputerAttrs.getColumnInfo("VENDOR_ID")))));
        }
        return DBQueryAssistant.performUpdate("T_VIEW_COMPUTER_ATTRS", con, htinput, htWhereClause);
    }

    public static int deletes(DBConnection con, Hashtable htWhereClause) throws SQLException {
        if (con == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htWhereClause.get(ComputerAttrs.getColumnInfo("VENDOR_ID")) != null) {
            htWhereClause.put(ComputerAttrs.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htWhereClause.get(ComputerAttrs.getColumnInfo("VENDOR_ID")))));
        }
        return DBQueryAssistant.performDelete("T_VIEW_COMPUTER_ATTRS", con, htWhereClause);
    }

    protected void setFields(DBConnection con, DBResultSet DBrs) throws SQLException {
        this.setGuid(DBrs.getString("GUID"));
        this.setHostUrl(DBrs.getString("HOST_URL"));
        this.setOsType(DBrs.getShort("OS_TYPE"));
        this.setOsVersion(DBrs.getString("OS_VERSION"));
        this.setNetworkName(DBrs.getString("NETWORK_NAME"));
        this.setDomainName(DBrs.getString("DOMAIN_NAME"));
        this.setComputerId(DBrs.getInt("COMPUTER_ID"));
        this.setHostName(DBrs.getString("HOST_NAME"));
        this.setHardwareId(DBrs.getBytes("HARDWARE_ID"));
        this.setVendorId(DBrs.getShort("VENDOR_ID"));
        this.setVendor(Normalizer.VendorGetName(con, this.m_VendorId));
        this.setTimeZone(DBrs.getString("TIME_ZONE"));
        this.setDiscoveredTime(DBrs.getTimestamp("DISCOVERED_TIME"));
        this.setProductStates(DBrs.getBytes("PRODUCT_STATES"));
        this.setCpuArchitecture(DBrs.getShort("CPU_ARCHITECTURE"));
        this.setOriginalAlias(DBrs.getString("ORIGINAL_ALIAS"));
        this.setIpAddress(DBrs.getString("IP_ADDRESS"));
        this.setDetectable(DBrs.getShort("DETECTABLE"));
        this.setOperationalStatus(DBrs.getInt("OPERATIONAL_STATUS"));
        this.setConsolidatedStatus(DBrs.getShort("CONSOLIDATED_STATUS"));
        this.setPropagatedStatus(DBrs.getShort("PROPAGATED_STATUS"));
        this.setChangedTimestamp(DBrs.getTimestamp("CHANGED_TIMESTAMP"));
        this.setUpdateTimestamp(DBrs.getTimestamp("UPDATE_TIMESTAMP"));
        this.setUserAttrib1(DBrs.getString("USER_ATTRIB1"));
        this.setUserAttrib2(DBrs.getString("USER_ATTRIB2"));
        this.setUserAttrib3(DBrs.getString("USER_ATTRIB3"));
        this.setName(DBrs.getString("NAME"));
        this.setWinDomainName(DBrs.getString("WIN_DOMAIN_NAME"));
        this.setDiscoveryMethod(DBrs.getShort("DISCOVERY_METHOD"));
        this.setNameIsLocal(DBrs.getString("NAME_IS_LOCAL"));
        this.setWhenDiscovered(DBrs.getTimestamp("WHEN_DISCOVERED"));
        this.setTimesMissing(DBrs.getShort("TIMES_MISSING"));
        this.setDomainId(DBrs.getInt("DOMAIN_ID"));
        this.setGroupId(DBrs.getInt("GROUP_ID"));
        this.setManufacturer(DBrs.getString("MANUFACTURER"));
        this.setModel(DBrs.getString("MODEL"));
        this.setSerialNumber(DBrs.getString("SERIAL_NUMBER"));
        this.setProcessorType(DBrs.getString("PROCESSOR_TYPE"));
        this.setProcessorCount(DBrs.getShort("PROCESSOR_COUNT"));
        this.setProcessorSpeed(DBrs.getShort("PROCESSOR_SPEED"));
        this.setRam(DBrs.getInt("RAM"));
        this.setSwapSpace(DBrs.getInt("SWAP_SPACE"));
        this.setDiskCapacity(DBrs.getDouble("DISK_CAPACITY"));
        this.setFsFreeSpace(DBrs.getDouble("FS_FREE_SPACE"));
        this.setDiskFreeSpace(DBrs.getDouble("DISK_FREE_SPACE"));
        this.setLastBootTime(DBrs.getTimestamp("LAST_BOOT_TIME"));
        this.setProbeStatus(DBrs.getString("PROBE_STATUS"));
        this.setLastProbeTime(DBrs.getTimestamp("LAST_PROBE_TIME"));
        this.setOwnedDiskCap(DBrs.getDouble("OWNED_DISK_CAP"));
        this.setOwnedDiskFreeSp(DBrs.getDouble("OWNED_DISK_FREE_SP"));
        this.setClusterId(DBrs.getInt("CLUSTER_ID"));
        this.setNodeHostedId(DBrs.getInt("NODE_HOSTED_ID"));
    }

    public static class ComputerAttrsCursor
    extends DBCursor {
        private ComputerAttrs element = new ComputerAttrs();
        private DBConnection con;

        private static Hashtable normalize(DBConnection con, Hashtable htWhereClause) throws SQLException {
            if (htWhereClause == null) {
                return null;
            }
            if (htWhereClause.get(TViewComputerAttrsTable.getColumnInfo("VENDOR_ID")) != null) {
                htWhereClause.put(TViewComputerAttrsTable.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htWhereClause.get(TViewComputerAttrsTable.getColumnInfo("VENDOR_ID")))));
            }
            return htWhereClause;
        }

        public ComputerAttrsCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
            super("T_VIEW_COMPUTER_ATTRS", con, ComputerAttrsCursor.normalize(con, htWhereClause), columns);
            this.con = con;
        }

        public ComputerAttrs getObject() throws SQLException {
            ComputerAttrs el = null;
            if (this.DBrs != null) {
                el = new ComputerAttrs();
                el.setFields(this.con, this.DBrs);
            }
            return el;
        }

        public ComputerAttrs getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

