/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.tables.TResDataPathTable;

public class DataPath
extends TResDataPathTable {
    public static DataPathCursor getCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
        return new DataPathCursor(con, htWhereClause, columns);
    }

    public DataPath() {
        this.clear();
    }

    public DataPath(int DataPathId, int HostLunId, int DeviceLunId, int InitiatorPortId, int TargetPortId, int VolumeId, String UnknownHostName, Timestamp UpdateTimestamp, int MaskingInfoId, int SubsystemId) {
        this.clear();
        this.m_DataPathId = DataPathId;
        this.m_HostLunId = HostLunId;
        this.m_DeviceLunId = DeviceLunId;
        this.m_InitiatorPortId = InitiatorPortId;
        this.m_TargetPortId = TargetPortId;
        this.m_VolumeId = VolumeId;
        this.m_UnknownHostName = UnknownHostName;
        this.m_UpdateTimestamp = UpdateTimestamp;
        this.m_MaskingInfoId = MaskingInfoId;
        this.m_SubsystemId = SubsystemId;
    }

    private void setNonKeyValues(Hashtable htColsAndValues) {
        if (this.m_DataPathId != Integer.MIN_VALUE) {
            htColsAndValues.put(DataPath.getColumnInfo("DATA_PATH_ID"), String.valueOf(this.m_DataPathId));
        }
        if (this.m_HostLunId != Integer.MIN_VALUE) {
            htColsAndValues.put(DataPath.getColumnInfo("HOST_LUN_ID"), String.valueOf(this.m_HostLunId));
        }
        if (this.m_DeviceLunId != Integer.MIN_VALUE) {
            htColsAndValues.put(DataPath.getColumnInfo("DEVICE_LUN_ID"), String.valueOf(this.m_DeviceLunId));
        }
        if (this.m_UnknownHostName != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(DataPath.getColumnInfo("UNKNOWN_HOST_NAME"), this.m_UnknownHostName);
        }
        if (this.m_UpdateTimestamp != DBConstants.INVALID_TIMESTAMP_VALUE) {
            htColsAndValues.put(DataPath.getColumnInfo("UPDATE_TIMESTAMP"), this.m_UpdateTimestamp);
        }
        if (this.m_MaskingInfoId != Integer.MIN_VALUE) {
            htColsAndValues.put(DataPath.getColumnInfo("MASKING_INFO_ID"), String.valueOf(this.m_MaskingInfoId));
        }
        if (this.m_SubsystemId != Integer.MIN_VALUE) {
            htColsAndValues.put(DataPath.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(this.m_SubsystemId));
        }
    }

    public boolean insert(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_InitiatorPortId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key INITIATOR_PORT_ID not found");
        }
        this.htColsAndValues.put(DataPath.getColumnInfo("INITIATOR_PORT_ID"), String.valueOf(this.m_InitiatorPortId));
        if (this.m_TargetPortId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key TARGET_PORT_ID not found");
        }
        this.htColsAndValues.put(DataPath.getColumnInfo("TARGET_PORT_ID"), String.valueOf(this.m_TargetPortId));
        if (this.m_VolumeId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key VOLUME_ID not found");
        }
        this.htColsAndValues.put(DataPath.getColumnInfo("VOLUME_ID"), String.valueOf(this.m_VolumeId));
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_DATA_PATH", con, this.htColsAndValues);
    }

    public boolean insert(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(DataPath.getColumnInfo("INITIATOR_PORT_ID")) == null) {
            throw new SQLException(" ERROR: key INITIATOR_PORT_ID not found");
        }
        if (htinput.get(DataPath.getColumnInfo("TARGET_PORT_ID")) == null) {
            throw new SQLException(" ERROR: key TARGET_PORT_ID not found");
        }
        if (htinput.get(DataPath.getColumnInfo("VOLUME_ID")) == null) {
            throw new SQLException(" ERROR: key VOLUME_ID not found");
        }
        return DBQueryAssistant.performInsert("T_RES_DATA_PATH", con, htinput);
    }

    public int update(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_InitiatorPortId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key INITIATOR_PORT_ID not found");
        }
        this.htWhereClause.put(DataPath.getColumnInfo("INITIATOR_PORT_ID"), String.valueOf(this.m_InitiatorPortId));
        if (this.m_TargetPortId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key TARGET_PORT_ID not found");
        }
        this.htWhereClause.put(DataPath.getColumnInfo("TARGET_PORT_ID"), String.valueOf(this.m_TargetPortId));
        if (this.m_VolumeId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key VOLUME_ID not found");
        }
        this.htWhereClause.put(DataPath.getColumnInfo("VOLUME_ID"), String.valueOf(this.m_VolumeId));
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_DATA_PATH", con, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(DataPath.getColumnInfo("INITIATOR_PORT_ID")) == null) {
            throw new SQLException(" ERROR: key INITIATOR_PORT_ID not found");
        }
        this.htWhereClause.put(DataPath.getColumnInfo("INITIATOR_PORT_ID"), htinput.get(DataPath.getColumnInfo("INITIATOR_PORT_ID")));
        if (htinput.get(DataPath.getColumnInfo("TARGET_PORT_ID")) == null) {
            throw new SQLException(" ERROR: key TARGET_PORT_ID not found");
        }
        this.htWhereClause.put(DataPath.getColumnInfo("TARGET_PORT_ID"), htinput.get(DataPath.getColumnInfo("TARGET_PORT_ID")));
        if (htinput.get(DataPath.getColumnInfo("VOLUME_ID")) == null) {
            throw new SQLException(" ERROR: key VOLUME_ID not found");
        }
        this.htWhereClause.put(DataPath.getColumnInfo("VOLUME_ID"), htinput.get(DataPath.getColumnInfo("VOLUME_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_DATA_PATH", con, htinput, this.htWhereClause);
    }

    public int delete(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_InitiatorPortId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key INITIATOR_PORT_ID not found");
        }
        this.htWhereClause.put(DataPath.getColumnInfo("INITIATOR_PORT_ID"), String.valueOf(this.m_InitiatorPortId));
        if (this.m_TargetPortId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key TARGET_PORT_ID not found");
        }
        this.htWhereClause.put(DataPath.getColumnInfo("TARGET_PORT_ID"), String.valueOf(this.m_TargetPortId));
        if (this.m_VolumeId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key VOLUME_ID not found");
        }
        this.htWhereClause.put(DataPath.getColumnInfo("VOLUME_ID"), String.valueOf(this.m_VolumeId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_DATA_PATH", con, this.htWhereClause);
    }

    public int delete(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(DataPath.getColumnInfo("INITIATOR_PORT_ID")) == null) {
            throw new SQLException(" ERROR: key INITIATOR_PORT_ID not found");
        }
        this.htWhereClause.put(DataPath.getColumnInfo("INITIATOR_PORT_ID"), htinput.get(DataPath.getColumnInfo("INITIATOR_PORT_ID")));
        if (htinput.get(DataPath.getColumnInfo("TARGET_PORT_ID")) == null) {
            throw new SQLException(" ERROR: key TARGET_PORT_ID not found");
        }
        this.htWhereClause.put(DataPath.getColumnInfo("TARGET_PORT_ID"), htinput.get(DataPath.getColumnInfo("TARGET_PORT_ID")));
        if (htinput.get(DataPath.getColumnInfo("VOLUME_ID")) == null) {
            throw new SQLException(" ERROR: key VOLUME_ID not found");
        }
        this.htWhereClause.put(DataPath.getColumnInfo("VOLUME_ID"), htinput.get(DataPath.getColumnInfo("VOLUME_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_DATA_PATH", con, this.htWhereClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieve(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_InitiatorPortId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key INITIATOR_PORT_ID not found");
        }
        this.htWhereClause.put(DataPath.getColumnInfo("INITIATOR_PORT_ID"), String.valueOf(this.m_InitiatorPortId));
        if (this.m_TargetPortId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key TARGET_PORT_ID not found");
        }
        this.htWhereClause.put(DataPath.getColumnInfo("TARGET_PORT_ID"), String.valueOf(this.m_TargetPortId));
        if (this.m_VolumeId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key VOLUME_ID not found");
        }
        this.htWhereClause.put(DataPath.getColumnInfo("VOLUME_ID"), String.valueOf(this.m_VolumeId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        boolean res = false;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_DATA_PATH", con, this.htWhereClause, null);
            if (DBrs.next()) {
                this.setFields(con, DBrs);
                res = true;
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataPath retrieve(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable htWhereClause = new Hashtable();
        DataPath el = null;
        if (htinput.get(DataPath.getColumnInfo("INITIATOR_PORT_ID")) == null) {
            throw new SQLException(" ERROR: key INITIATOR_PORT_ID not found");
        }
        htWhereClause.put(DataPath.getColumnInfo("INITIATOR_PORT_ID"), htinput.get(DataPath.getColumnInfo("INITIATOR_PORT_ID")));
        if (htinput.get(DataPath.getColumnInfo("TARGET_PORT_ID")) == null) {
            throw new SQLException(" ERROR: key TARGET_PORT_ID not found");
        }
        htWhereClause.put(DataPath.getColumnInfo("TARGET_PORT_ID"), htinput.get(DataPath.getColumnInfo("TARGET_PORT_ID")));
        if (htinput.get(DataPath.getColumnInfo("VOLUME_ID")) == null) {
            throw new SQLException(" ERROR: key VOLUME_ID not found");
        }
        htWhereClause.put(DataPath.getColumnInfo("VOLUME_ID"), htinput.get(DataPath.getColumnInfo("VOLUME_ID")));
        if (htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_DATA_PATH", con, htWhereClause, null);
            if (DBrs.next()) {
                el = new DataPath();
                el.setFields(con, DBrs);
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return el;
    }

    public static int update(DBConnection con, Hashtable htinput, Hashtable htWhereClause) throws SQLException {
        if (con == null || htinput == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performUpdate("T_RES_DATA_PATH", con, htinput, htWhereClause);
    }

    public static int deletes(DBConnection con, Hashtable htWhereClause) throws SQLException {
        if (con == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performDelete("T_RES_DATA_PATH", con, htWhereClause);
    }

    protected void setFields(DBConnection con, DBResultSet DBrs) throws SQLException {
        this.setDataPathId(DBrs.getInt("DATA_PATH_ID"));
        this.setHostLunId(DBrs.getInt("HOST_LUN_ID"));
        this.setDeviceLunId(DBrs.getInt("DEVICE_LUN_ID"));
        this.setInitiatorPortId(DBrs.getInt("INITIATOR_PORT_ID"));
        this.setTargetPortId(DBrs.getInt("TARGET_PORT_ID"));
        this.setVolumeId(DBrs.getInt("VOLUME_ID"));
        this.setUnknownHostName(DBrs.getString("UNKNOWN_HOST_NAME"));
        this.setUpdateTimestamp(DBrs.getTimestamp("UPDATE_TIMESTAMP"));
        this.setMaskingInfoId(DBrs.getInt("MASKING_INFO_ID"));
        this.setSubsystemId(DBrs.getInt("SUBSYSTEM_ID"));
    }

    public static class DataPathCursor
    extends DBCursor {
        private DataPath element = new DataPath();
        private DBConnection con;

        public DataPathCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
            super("T_RES_DATA_PATH", con, htWhereClause, columns);
            this.con = con;
        }

        public DataPath getObject() throws SQLException {
            DataPath el = null;
            if (this.DBrs != null) {
                el = new DataPath();
                el.setFields(this.con, this.DBrs);
            }
            return el;
        }

        public DataPath getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

