/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.tables.TStatDiskTable;

public class Disk
extends TStatDiskTable {
    public static DiskCursor getCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
        return new DiskCursor(con, htWhereClause, columns);
    }

    public Disk() {
        this.clear();
    }

    public Disk(int DiskId, int Heads, int Cylinders, int Rpm, int SectorSize, int SectorsAvgTrack, int SectorsOutrTrack, int SectorsInnrTrack, int LogicalBlockSize, int MinutesPoweredOn, String WriteProtected, String WriteCacheEnable, String ReadCacheDisable, String AutoWriteRealloc, String AutoReadRealloc, String NoErrorRecovery, String FailurePredicted, double Capacity, int SpareBlocks, int VolgroupId, String DesiredAwre, String DesiredArre, String DesiredNoerrrcvry, int LogicalDiskId, String DiskIdentity) {
        this.clear();
        this.m_DiskId = DiskId;
        this.m_Heads = Heads;
        this.m_Cylinders = Cylinders;
        this.m_Rpm = Rpm;
        this.m_SectorSize = SectorSize;
        this.m_SectorsAvgTrack = SectorsAvgTrack;
        this.m_SectorsOutrTrack = SectorsOutrTrack;
        this.m_SectorsInnrTrack = SectorsInnrTrack;
        this.m_LogicalBlockSize = LogicalBlockSize;
        this.m_MinutesPoweredOn = MinutesPoweredOn;
        this.m_WriteProtected = WriteProtected;
        this.m_WriteCacheEnable = WriteCacheEnable;
        this.m_ReadCacheDisable = ReadCacheDisable;
        this.m_AutoWriteRealloc = AutoWriteRealloc;
        this.m_AutoReadRealloc = AutoReadRealloc;
        this.m_NoErrorRecovery = NoErrorRecovery;
        this.m_FailurePredicted = FailurePredicted;
        this.m_Capacity = Capacity;
        this.m_SpareBlocks = SpareBlocks;
        this.m_VolgroupId = VolgroupId;
        this.m_DesiredAwre = DesiredAwre;
        this.m_DesiredArre = DesiredArre;
        this.m_DesiredNoerrrcvry = DesiredNoerrrcvry;
        this.m_LogicalDiskId = LogicalDiskId;
        this.m_DiskIdentity = DiskIdentity;
    }

    private void setNonKeyValues(Hashtable htColsAndValues) {
        if (this.m_DiskId != Integer.MIN_VALUE) {
            htColsAndValues.put(Disk.getColumnInfo("DISK_ID"), String.valueOf(this.m_DiskId));
        }
        if (this.m_Heads != Integer.MIN_VALUE) {
            htColsAndValues.put(Disk.getColumnInfo("HEADS"), String.valueOf(this.m_Heads));
        }
        if (this.m_Cylinders != Integer.MIN_VALUE) {
            htColsAndValues.put(Disk.getColumnInfo("CYLINDERS"), String.valueOf(this.m_Cylinders));
        }
        if (this.m_Rpm != Integer.MIN_VALUE) {
            htColsAndValues.put(Disk.getColumnInfo("RPM"), String.valueOf(this.m_Rpm));
        }
        if (this.m_SectorSize != Integer.MIN_VALUE) {
            htColsAndValues.put(Disk.getColumnInfo("SECTOR_SIZE"), String.valueOf(this.m_SectorSize));
        }
        if (this.m_SectorsAvgTrack != Integer.MIN_VALUE) {
            htColsAndValues.put(Disk.getColumnInfo("SECTORS_AVG_TRACK"), String.valueOf(this.m_SectorsAvgTrack));
        }
        if (this.m_SectorsOutrTrack != Integer.MIN_VALUE) {
            htColsAndValues.put(Disk.getColumnInfo("SECTORS_OUTR_TRACK"), String.valueOf(this.m_SectorsOutrTrack));
        }
        if (this.m_SectorsInnrTrack != Integer.MIN_VALUE) {
            htColsAndValues.put(Disk.getColumnInfo("SECTORS_INNR_TRACK"), String.valueOf(this.m_SectorsInnrTrack));
        }
        if (this.m_LogicalBlockSize != Integer.MIN_VALUE) {
            htColsAndValues.put(Disk.getColumnInfo("LOGICAL_BLOCK_SIZE"), String.valueOf(this.m_LogicalBlockSize));
        }
        if (this.m_MinutesPoweredOn != Integer.MIN_VALUE) {
            htColsAndValues.put(Disk.getColumnInfo("MINUTES_POWERED_ON"), String.valueOf(this.m_MinutesPoweredOn));
        }
        if (this.m_WriteProtected != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Disk.getColumnInfo("WRITE_PROTECTED"), this.m_WriteProtected);
        }
        if (this.m_WriteCacheEnable != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Disk.getColumnInfo("WRITE_CACHE_ENABLE"), this.m_WriteCacheEnable);
        }
        if (this.m_ReadCacheDisable != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Disk.getColumnInfo("READ_CACHE_DISABLE"), this.m_ReadCacheDisable);
        }
        if (this.m_AutoWriteRealloc != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Disk.getColumnInfo("AUTO_WRITE_REALLOC"), this.m_AutoWriteRealloc);
        }
        if (this.m_AutoReadRealloc != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Disk.getColumnInfo("AUTO_READ_REALLOC"), this.m_AutoReadRealloc);
        }
        if (this.m_NoErrorRecovery != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Disk.getColumnInfo("NO_ERROR_RECOVERY"), this.m_NoErrorRecovery);
        }
        if (this.m_FailurePredicted != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Disk.getColumnInfo("FAILURE_PREDICTED"), this.m_FailurePredicted);
        }
        if (this.m_Capacity != Double.MIN_VALUE) {
            htColsAndValues.put(Disk.getColumnInfo("CAPACITY"), String.valueOf(this.m_Capacity));
        }
        if (this.m_SpareBlocks != Integer.MIN_VALUE) {
            htColsAndValues.put(Disk.getColumnInfo("SPARE_BLOCKS"), String.valueOf(this.m_SpareBlocks));
        }
        if (this.m_VolgroupId != Integer.MIN_VALUE) {
            htColsAndValues.put(Disk.getColumnInfo("VOLGROUP_ID"), String.valueOf(this.m_VolgroupId));
        }
        if (this.m_DesiredAwre != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Disk.getColumnInfo("DESIRED_AWRE"), this.m_DesiredAwre);
        }
        if (this.m_DesiredArre != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Disk.getColumnInfo("DESIRED_ARRE"), this.m_DesiredArre);
        }
        if (this.m_DesiredNoerrrcvry != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Disk.getColumnInfo("DESIRED_NOERRRCVRY"), this.m_DesiredNoerrrcvry);
        }
        if (this.m_LogicalDiskId != Integer.MIN_VALUE) {
            htColsAndValues.put(Disk.getColumnInfo("LOGICAL_DISK_ID"), String.valueOf(this.m_LogicalDiskId));
        }
        if (this.m_DiskIdentity != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Disk.getColumnInfo("DISK_IDENTITY"), this.m_DiskIdentity);
        }
    }

    public boolean insert(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_STAT_DISK", con, this.htColsAndValues);
    }

    public boolean insert(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performInsert("T_STAT_DISK", con, htinput);
    }

    public int update(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_STAT_DISK", con, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_STAT_DISK", con, htinput, this.htWhereClause);
    }

    public int delete(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_STAT_DISK", con, this.htWhereClause);
    }

    public int delete(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_STAT_DISK", con, this.htWhereClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieve(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        boolean res = false;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_STAT_DISK", con, this.htWhereClause, null);
            if (DBrs.next()) {
                this.setFields(con, DBrs);
                res = true;
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Disk retrieve(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable htWhereClause = new Hashtable();
        Disk el = null;
        if (htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_STAT_DISK", con, htWhereClause, null);
            if (DBrs.next()) {
                el = new Disk();
                el.setFields(con, DBrs);
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return el;
    }

    public static int update(DBConnection con, Hashtable htinput, Hashtable htWhereClause) throws SQLException {
        if (con == null || htinput == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performUpdate("T_STAT_DISK", con, htinput, htWhereClause);
    }

    public static int deletes(DBConnection con, Hashtable htWhereClause) throws SQLException {
        if (con == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performDelete("T_STAT_DISK", con, htWhereClause);
    }

    protected void setFields(DBConnection con, DBResultSet DBrs) throws SQLException {
        this.setDiskId(DBrs.getInt("DISK_ID"));
        this.setHeads(DBrs.getInt("HEADS"));
        this.setCylinders(DBrs.getInt("CYLINDERS"));
        this.setRpm(DBrs.getInt("RPM"));
        this.setSectorSize(DBrs.getInt("SECTOR_SIZE"));
        this.setSectorsAvgTrack(DBrs.getInt("SECTORS_AVG_TRACK"));
        this.setSectorsOutrTrack(DBrs.getInt("SECTORS_OUTR_TRACK"));
        this.setSectorsInnrTrack(DBrs.getInt("SECTORS_INNR_TRACK"));
        this.setLogicalBlockSize(DBrs.getInt("LOGICAL_BLOCK_SIZE"));
        this.setMinutesPoweredOn(DBrs.getInt("MINUTES_POWERED_ON"));
        this.setWriteProtected(DBrs.getString("WRITE_PROTECTED"));
        this.setWriteCacheEnable(DBrs.getString("WRITE_CACHE_ENABLE"));
        this.setReadCacheDisable(DBrs.getString("READ_CACHE_DISABLE"));
        this.setAutoWriteRealloc(DBrs.getString("AUTO_WRITE_REALLOC"));
        this.setAutoReadRealloc(DBrs.getString("AUTO_READ_REALLOC"));
        this.setNoErrorRecovery(DBrs.getString("NO_ERROR_RECOVERY"));
        this.setFailurePredicted(DBrs.getString("FAILURE_PREDICTED"));
        this.setCapacity(DBrs.getDouble("CAPACITY"));
        this.setSpareBlocks(DBrs.getInt("SPARE_BLOCKS"));
        this.setVolgroupId(DBrs.getInt("VOLGROUP_ID"));
        this.setDesiredAwre(DBrs.getString("DESIRED_AWRE"));
        this.setDesiredArre(DBrs.getString("DESIRED_ARRE"));
        this.setDesiredNoerrrcvry(DBrs.getString("DESIRED_NOERRRCVRY"));
        this.setLogicalDiskId(DBrs.getInt("LOGICAL_DISK_ID"));
        this.setDiskIdentity(DBrs.getString("DISK_IDENTITY"));
    }

    public static class DiskCursor
    extends DBCursor {
        private Disk element = new Disk();
        private DBConnection con;

        public DiskCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
            super("T_STAT_DISK", con, htWhereClause, columns);
            this.con = con;
        }

        public Disk getObject() throws SQLException {
            Disk el = null;
            if (this.DBrs != null) {
                el = new Disk();
                el.setFields(this.con, this.DBrs);
            }
            return el;
        }

        public Disk getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

