/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.tables.TResFilesystemTable;

public class Filesystem
extends TResFilesystemTable {
    public static FilesystemCursor getCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
        return new FilesystemCursor(con, htWhereClause, columns);
    }

    public Filesystem() {
        this.clear();
    }

    public Filesystem(int FilesystemId, int ComputerId, int GroupId, int LogicalDiskId, int LogDiskId, int Maxfiles, double UsedInodes, double FreeInodes, double PhysicalSize, double Capacity, double UsedSpace, double FreeSpace, double FileCount, double DirectoryCount, Timestamp LastScanTime, short FilesystemType, short UseCount, String MountPoint, Timestamp DiscoveredTime, int ScanningCompId, String ExportName) {
        this.clear();
        this.m_FilesystemId = FilesystemId;
        this.m_ComputerId = ComputerId;
        this.m_GroupId = GroupId;
        this.m_LogicalDiskId = LogicalDiskId;
        this.m_LogDiskId = LogDiskId;
        this.m_Maxfiles = Maxfiles;
        this.m_UsedInodes = UsedInodes;
        this.m_FreeInodes = FreeInodes;
        this.m_PhysicalSize = PhysicalSize;
        this.m_Capacity = Capacity;
        this.m_UsedSpace = UsedSpace;
        this.m_FreeSpace = FreeSpace;
        this.m_FileCount = FileCount;
        this.m_DirectoryCount = DirectoryCount;
        this.m_LastScanTime = LastScanTime;
        this.m_FilesystemType = FilesystemType;
        this.m_UseCount = UseCount;
        this.m_MountPoint = MountPoint;
        this.m_DiscoveredTime = DiscoveredTime;
        this.m_ScanningCompId = ScanningCompId;
        this.m_ExportName = ExportName;
    }

    private void setNonKeyValues(Hashtable htColsAndValues) {
        if (this.m_FilesystemId != Integer.MIN_VALUE) {
            htColsAndValues.put(Filesystem.getColumnInfo("FILESYSTEM_ID"), String.valueOf(this.m_FilesystemId));
        }
        if (this.m_ComputerId != Integer.MIN_VALUE) {
            htColsAndValues.put(Filesystem.getColumnInfo("COMPUTER_ID"), String.valueOf(this.m_ComputerId));
        }
        if (this.m_GroupId != Integer.MIN_VALUE) {
            htColsAndValues.put(Filesystem.getColumnInfo("GROUP_ID"), String.valueOf(this.m_GroupId));
        }
        if (this.m_LogicalDiskId != Integer.MIN_VALUE) {
            htColsAndValues.put(Filesystem.getColumnInfo("LOGICAL_DISK_ID"), String.valueOf(this.m_LogicalDiskId));
        }
        if (this.m_LogDiskId != Integer.MIN_VALUE) {
            htColsAndValues.put(Filesystem.getColumnInfo("LOG_DISK_ID"), String.valueOf(this.m_LogDiskId));
        }
        if (this.m_Maxfiles != Integer.MIN_VALUE) {
            htColsAndValues.put(Filesystem.getColumnInfo("MAXFILES"), String.valueOf(this.m_Maxfiles));
        }
        if (this.m_UsedInodes != Double.MIN_VALUE) {
            htColsAndValues.put(Filesystem.getColumnInfo("USED_INODES"), String.valueOf(this.m_UsedInodes));
        }
        if (this.m_FreeInodes != Double.MIN_VALUE) {
            htColsAndValues.put(Filesystem.getColumnInfo("FREE_INODES"), String.valueOf(this.m_FreeInodes));
        }
        if (this.m_PhysicalSize != Double.MIN_VALUE) {
            htColsAndValues.put(Filesystem.getColumnInfo("PHYSICAL_SIZE"), String.valueOf(this.m_PhysicalSize));
        }
        if (this.m_Capacity != Double.MIN_VALUE) {
            htColsAndValues.put(Filesystem.getColumnInfo("CAPACITY"), String.valueOf(this.m_Capacity));
        }
        if (this.m_UsedSpace != Double.MIN_VALUE) {
            htColsAndValues.put(Filesystem.getColumnInfo("USED_SPACE"), String.valueOf(this.m_UsedSpace));
        }
        if (this.m_FreeSpace != Double.MIN_VALUE) {
            htColsAndValues.put(Filesystem.getColumnInfo("FREE_SPACE"), String.valueOf(this.m_FreeSpace));
        }
        if (this.m_FileCount != Double.MIN_VALUE) {
            htColsAndValues.put(Filesystem.getColumnInfo("FILE_COUNT"), String.valueOf(this.m_FileCount));
        }
        if (this.m_DirectoryCount != Double.MIN_VALUE) {
            htColsAndValues.put(Filesystem.getColumnInfo("DIRECTORY_COUNT"), String.valueOf(this.m_DirectoryCount));
        }
        if (this.m_LastScanTime != DBConstants.INVALID_TIMESTAMP_VALUE) {
            htColsAndValues.put(Filesystem.getColumnInfo("LAST_SCAN_TIME"), this.m_LastScanTime);
        }
        if (this.m_FilesystemType != Short.MIN_VALUE) {
            htColsAndValues.put(Filesystem.getColumnInfo("FILESYSTEM_TYPE"), String.valueOf(this.m_FilesystemType));
        }
        if (this.m_UseCount != Short.MIN_VALUE) {
            htColsAndValues.put(Filesystem.getColumnInfo("USE_COUNT"), String.valueOf(this.m_UseCount));
        }
        if (this.m_MountPoint != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Filesystem.getColumnInfo("MOUNT_POINT"), this.m_MountPoint);
        }
        if (this.m_DiscoveredTime != DBConstants.INVALID_TIMESTAMP_VALUE) {
            htColsAndValues.put(Filesystem.getColumnInfo("DISCOVERED_TIME"), this.m_DiscoveredTime);
        }
        if (this.m_ScanningCompId != Integer.MIN_VALUE) {
            htColsAndValues.put(Filesystem.getColumnInfo("SCANNING_COMP_ID"), String.valueOf(this.m_ScanningCompId));
        }
        if (this.m_ExportName != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Filesystem.getColumnInfo("EXPORT_NAME"), this.m_ExportName);
        }
    }

    public boolean insert(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_FILESYSTEM", con, this.htColsAndValues);
    }

    public boolean insert(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performInsert("T_RES_FILESYSTEM", con, htinput);
    }

    public int update(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_FILESYSTEM", con, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_FILESYSTEM", con, htinput, this.htWhereClause);
    }

    public int delete(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_FILESYSTEM", con, this.htWhereClause);
    }

    public int delete(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_FILESYSTEM", con, this.htWhereClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieve(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        boolean res = false;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_FILESYSTEM", con, this.htWhereClause, null);
            if (DBrs.next()) {
                this.setFields(con, DBrs);
                res = true;
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Filesystem retrieve(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable htWhereClause = new Hashtable();
        Filesystem el = null;
        if (htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_FILESYSTEM", con, htWhereClause, null);
            if (DBrs.next()) {
                el = new Filesystem();
                el.setFields(con, DBrs);
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return el;
    }

    public static int update(DBConnection con, Hashtable htinput, Hashtable htWhereClause) throws SQLException {
        if (con == null || htinput == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performUpdate("T_RES_FILESYSTEM", con, htinput, htWhereClause);
    }

    public static int deletes(DBConnection con, Hashtable htWhereClause) throws SQLException {
        if (con == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performDelete("T_RES_FILESYSTEM", con, htWhereClause);
    }

    protected void setFields(DBConnection con, DBResultSet DBrs) throws SQLException {
        this.setFilesystemId(DBrs.getInt("FILESYSTEM_ID"));
        this.setComputerId(DBrs.getInt("COMPUTER_ID"));
        this.setGroupId(DBrs.getInt("GROUP_ID"));
        this.setLogicalDiskId(DBrs.getInt("LOGICAL_DISK_ID"));
        this.setLogDiskId(DBrs.getInt("LOG_DISK_ID"));
        this.setMaxfiles(DBrs.getInt("MAXFILES"));
        this.setUsedInodes(DBrs.getDouble("USED_INODES"));
        this.setFreeInodes(DBrs.getDouble("FREE_INODES"));
        this.setPhysicalSize(DBrs.getDouble("PHYSICAL_SIZE"));
        this.setCapacity(DBrs.getDouble("CAPACITY"));
        this.setUsedSpace(DBrs.getDouble("USED_SPACE"));
        this.setFreeSpace(DBrs.getDouble("FREE_SPACE"));
        this.setFileCount(DBrs.getDouble("FILE_COUNT"));
        this.setDirectoryCount(DBrs.getDouble("DIRECTORY_COUNT"));
        this.setLastScanTime(DBrs.getTimestamp("LAST_SCAN_TIME"));
        this.setFilesystemType(DBrs.getShort("FILESYSTEM_TYPE"));
        this.setUseCount(DBrs.getShort("USE_COUNT"));
        this.setMountPoint(DBrs.getString("MOUNT_POINT"));
        this.setDiscoveredTime(DBrs.getTimestamp("DISCOVERED_TIME"));
        this.setScanningCompId(DBrs.getInt("SCANNING_COMP_ID"));
        this.setExportName(DBrs.getString("EXPORT_NAME"));
    }

    public static class FilesystemCursor
    extends DBCursor {
        private Filesystem element = new Filesystem();
        private DBConnection con;

        public FilesystemCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
            super("T_RES_FILESYSTEM", con, htWhereClause, columns);
            this.con = con;
        }

        public Filesystem getObject() throws SQLException {
            Filesystem el = null;
            if (this.DBrs != null) {
                el = new Filesystem();
                el.setFields(this.con, this.DBrs);
            }
            return el;
        }

        public Filesystem getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

