/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.Normalizer;
import org.eclipse.aperi.infrastructure.database.tables.TResRedundancySnapshotTable;

public class RedundancySnapshot
extends TResRedundancySnapshotTable {
    private String m_CreationClassNameId_str;

    public void setCreationClassName(String el) {
        this.m_CreationClassNameId_str = el;
    }

    public String getCreationClassName() {
        return this.m_CreationClassNameId_str;
    }

    public static RedundancySnapshotCursor getCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
        return new RedundancySnapshotCursor(con, htWhereClause, columns);
    }

    public RedundancySnapshot() {
        this.clear();
    }

    public RedundancySnapshot(int SnapshotId, int RedundancyId, int SubsystemId, String ComponentId, String IpAddress, int NodeId, Timestamp UpdateTimestamp, short CreationClassNameId, String Name2, short NameFormat, int OperationalStatus, String Wwn, String DisplayName, int IoGroupId) {
        this.clear();
        this.m_SnapshotId = SnapshotId;
        this.m_RedundancyId = RedundancyId;
        this.m_SubsystemId = SubsystemId;
        this.m_ComponentId = ComponentId;
        this.m_IpAddress = IpAddress;
        this.m_NodeId = NodeId;
        this.m_UpdateTimestamp = UpdateTimestamp;
        this.m_CreationClassNameId = CreationClassNameId;
        this.m_Name = Name2;
        this.m_NameFormat = NameFormat;
        this.m_OperationalStatus = OperationalStatus;
        this.m_Wwn = Wwn;
        this.m_DisplayName = DisplayName;
        this.m_IoGroupId = IoGroupId;
    }

    private void setNonKeyValues(Hashtable htColsAndValues) {
        if (this.m_RedundancyId != Integer.MIN_VALUE) {
            htColsAndValues.put(RedundancySnapshot.getColumnInfo("REDUNDANCY_ID"), String.valueOf(this.m_RedundancyId));
        }
        if (this.m_IpAddress != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(RedundancySnapshot.getColumnInfo("IP_ADDRESS"), this.m_IpAddress);
        }
        if (this.m_NodeId != Integer.MIN_VALUE) {
            htColsAndValues.put(RedundancySnapshot.getColumnInfo("NODE_ID"), String.valueOf(this.m_NodeId));
        }
        if (this.m_UpdateTimestamp != DBConstants.INVALID_TIMESTAMP_VALUE) {
            htColsAndValues.put(RedundancySnapshot.getColumnInfo("UPDATE_TIMESTAMP"), this.m_UpdateTimestamp);
        }
        if (this.m_CreationClassNameId != Short.MIN_VALUE) {
            htColsAndValues.put(RedundancySnapshot.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(this.m_CreationClassNameId));
        }
        if (this.m_Name != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(RedundancySnapshot.getColumnInfo("NAME"), this.m_Name);
        }
        if (this.m_NameFormat != Short.MIN_VALUE) {
            htColsAndValues.put(RedundancySnapshot.getColumnInfo("NAME_FORMAT"), String.valueOf(this.m_NameFormat));
        }
        if (this.m_OperationalStatus != Integer.MIN_VALUE) {
            htColsAndValues.put(RedundancySnapshot.getColumnInfo("OPERATIONAL_STATUS"), String.valueOf(this.m_OperationalStatus));
        }
        if (this.m_Wwn != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(RedundancySnapshot.getColumnInfo("WWN"), this.m_Wwn);
        }
        if (this.m_DisplayName != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(RedundancySnapshot.getColumnInfo("DISPLAY_NAME"), this.m_DisplayName);
        }
        if (this.m_IoGroupId != Integer.MIN_VALUE) {
            htColsAndValues.put(RedundancySnapshot.getColumnInfo("IO_GROUP_ID"), String.valueOf(this.m_IoGroupId));
        }
    }

    public boolean insert(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(con, this.m_CreationClassNameId_str);
        if (this.m_SubsystemId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SUBSYSTEM_ID not found");
        }
        this.htColsAndValues.put(RedundancySnapshot.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(this.m_SubsystemId));
        if (this.m_ComponentId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key COMPONENT_ID not found");
        }
        this.htColsAndValues.put(RedundancySnapshot.getColumnInfo("COMPONENT_ID"), this.m_ComponentId);
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htColsAndValues.put(RedundancySnapshot.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_REDUNDANCY_SNAPSHOT", con, this.htColsAndValues);
    }

    public boolean insert(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(RedundancySnapshot.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(RedundancySnapshot.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(RedundancySnapshot.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(RedundancySnapshot.getColumnInfo("SUBSYSTEM_ID")) == null) {
            throw new SQLException(" ERROR: key SUBSYSTEM_ID not found");
        }
        if (htinput.get(RedundancySnapshot.getColumnInfo("COMPONENT_ID")) == null) {
            throw new SQLException(" ERROR: key COMPONENT_ID not found");
        }
        if (htinput.get(RedundancySnapshot.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        return DBQueryAssistant.performInsert("T_RES_REDUNDANCY_SNAPSHOT", con, htinput);
    }

    public int update(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(con, this.m_CreationClassNameId_str);
        if (this.m_SubsystemId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(RedundancySnapshot.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(this.m_SubsystemId));
        if (this.m_ComponentId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key COMPONENT_ID not found");
        }
        this.htWhereClause.put(RedundancySnapshot.getColumnInfo("COMPONENT_ID"), this.m_ComponentId);
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(RedundancySnapshot.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_REDUNDANCY_SNAPSHOT", con, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(RedundancySnapshot.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(RedundancySnapshot.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(RedundancySnapshot.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(RedundancySnapshot.getColumnInfo("SUBSYSTEM_ID")) == null) {
            throw new SQLException(" ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(RedundancySnapshot.getColumnInfo("SUBSYSTEM_ID"), htinput.get(RedundancySnapshot.getColumnInfo("SUBSYSTEM_ID")));
        if (htinput.get(RedundancySnapshot.getColumnInfo("COMPONENT_ID")) == null) {
            throw new SQLException(" ERROR: key COMPONENT_ID not found");
        }
        this.htWhereClause.put(RedundancySnapshot.getColumnInfo("COMPONENT_ID"), htinput.get(RedundancySnapshot.getColumnInfo("COMPONENT_ID")));
        if (htinput.get(RedundancySnapshot.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(RedundancySnapshot.getColumnInfo("SNAPSHOT_ID"), htinput.get(RedundancySnapshot.getColumnInfo("SNAPSHOT_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_REDUNDANCY_SNAPSHOT", con, htinput, this.htWhereClause);
    }

    public int delete(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(con, this.m_CreationClassNameId_str);
        if (this.m_SubsystemId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(RedundancySnapshot.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(this.m_SubsystemId));
        if (this.m_ComponentId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key COMPONENT_ID not found");
        }
        this.htWhereClause.put(RedundancySnapshot.getColumnInfo("COMPONENT_ID"), this.m_ComponentId);
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(RedundancySnapshot.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_REDUNDANCY_SNAPSHOT", con, this.htWhereClause);
    }

    public int delete(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(RedundancySnapshot.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(RedundancySnapshot.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(RedundancySnapshot.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(RedundancySnapshot.getColumnInfo("SUBSYSTEM_ID")) == null) {
            throw new SQLException(" ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(RedundancySnapshot.getColumnInfo("SUBSYSTEM_ID"), htinput.get(RedundancySnapshot.getColumnInfo("SUBSYSTEM_ID")));
        if (htinput.get(RedundancySnapshot.getColumnInfo("COMPONENT_ID")) == null) {
            throw new SQLException(" ERROR: key COMPONENT_ID not found");
        }
        this.htWhereClause.put(RedundancySnapshot.getColumnInfo("COMPONENT_ID"), htinput.get(RedundancySnapshot.getColumnInfo("COMPONENT_ID")));
        if (htinput.get(RedundancySnapshot.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(RedundancySnapshot.getColumnInfo("SNAPSHOT_ID"), htinput.get(RedundancySnapshot.getColumnInfo("SNAPSHOT_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_REDUNDANCY_SNAPSHOT", con, this.htWhereClause);
    }

    public boolean retrieve(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(con, this.m_CreationClassNameId_str);
        if (this.m_SubsystemId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(RedundancySnapshot.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(this.m_SubsystemId));
        if (this.m_ComponentId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key COMPONENT_ID not found");
        }
        this.htWhereClause.put(RedundancySnapshot.getColumnInfo("COMPONENT_ID"), this.m_ComponentId);
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(RedundancySnapshot.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = DBQueryAssistant.performRetrieve("T_RES_REDUNDANCY_SNAPSHOT", con, this.htWhereClause, null);
        if (DBrs.next()) {
            this.setFields(con, DBrs);
            return true;
        }
        return false;
    }

    public static RedundancySnapshot retrieve(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable htWhereClause = new Hashtable();
        if (htinput.get(RedundancySnapshot.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(RedundancySnapshot.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(RedundancySnapshot.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(RedundancySnapshot.getColumnInfo("SUBSYSTEM_ID")) == null) {
            throw new SQLException(" ERROR: key SUBSYSTEM_ID not found");
        }
        htWhereClause.put(RedundancySnapshot.getColumnInfo("SUBSYSTEM_ID"), htinput.get(RedundancySnapshot.getColumnInfo("SUBSYSTEM_ID")));
        if (htinput.get(RedundancySnapshot.getColumnInfo("COMPONENT_ID")) == null) {
            throw new SQLException(" ERROR: key COMPONENT_ID not found");
        }
        htWhereClause.put(RedundancySnapshot.getColumnInfo("COMPONENT_ID"), htinput.get(RedundancySnapshot.getColumnInfo("COMPONENT_ID")));
        if (htinput.get(RedundancySnapshot.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        htWhereClause.put(RedundancySnapshot.getColumnInfo("SNAPSHOT_ID"), htinput.get(RedundancySnapshot.getColumnInfo("SNAPSHOT_ID")));
        if (htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = DBQueryAssistant.performRetrieve("T_RES_REDUNDANCY_SNAPSHOT", con, htWhereClause, null);
        if (DBrs.next()) {
            RedundancySnapshot el = new RedundancySnapshot();
            el.setFields(con, DBrs);
            return el;
        }
        return null;
    }

    public static int update(DBConnection con, Hashtable htinput, Hashtable htWhereClause) throws SQLException {
        if (con == null || htinput == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(RedundancySnapshot.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(RedundancySnapshot.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(RedundancySnapshot.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htWhereClause.get(RedundancySnapshot.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htWhereClause.put(RedundancySnapshot.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htWhereClause.get(RedundancySnapshot.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        return DBQueryAssistant.performUpdate("T_RES_REDUNDANCY_SNAPSHOT", con, htinput, htWhereClause);
    }

    public static int deletes(DBConnection con, Hashtable htWhereClause) throws SQLException {
        if (con == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htWhereClause.get(RedundancySnapshot.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htWhereClause.put(RedundancySnapshot.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htWhereClause.get(RedundancySnapshot.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        return DBQueryAssistant.performDelete("T_RES_REDUNDANCY_SNAPSHOT", con, htWhereClause);
    }

    protected void setFields(DBConnection con, DBResultSet DBrs) throws SQLException {
        this.setSnapshotId(DBrs.getInt("SNAPSHOT_ID"));
        this.setRedundancyId(DBrs.getInt("REDUNDANCY_ID"));
        this.setSubsystemId(DBrs.getInt("SUBSYSTEM_ID"));
        this.setComponentId(DBrs.getString("COMPONENT_ID"));
        this.setIpAddress(DBrs.getString("IP_ADDRESS"));
        this.setNodeId(DBrs.getInt("NODE_ID"));
        this.setUpdateTimestamp(DBrs.getTimestamp("UPDATE_TIMESTAMP"));
        this.setCreationClassNameId(DBrs.getShort("CREATION_CLASS_NAME_ID"));
        this.setCreationClassName(Normalizer.CreationClassNameGetName(con, this.m_CreationClassNameId));
        this.setName(DBrs.getString("NAME"));
        this.setNameFormat(DBrs.getShort("NAME_FORMAT"));
        this.setOperationalStatus(DBrs.getInt("OPERATIONAL_STATUS"));
        this.setWwn(DBrs.getString("WWN"));
        this.setDisplayName(DBrs.getString("DISPLAY_NAME"));
        this.setIoGroupId(DBrs.getInt("IO_GROUP_ID"));
    }

    public static class RedundancySnapshotCursor
    extends DBCursor {
        private RedundancySnapshot element = new RedundancySnapshot();
        private DBConnection con;

        private static Hashtable normalize(DBConnection con, Hashtable htWhereClause) throws SQLException {
            if (htWhereClause == null) {
                return null;
            }
            if (htWhereClause.get(TResRedundancySnapshotTable.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
                htWhereClause.put(TResRedundancySnapshotTable.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htWhereClause.get(TResRedundancySnapshotTable.getColumnInfo("CREATION_CLASS_NAME_ID")))));
            }
            return htWhereClause;
        }

        public RedundancySnapshotCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
            super("T_RES_REDUNDANCY_SNAPSHOT", con, RedundancySnapshotCursor.normalize(con, htWhereClause), columns);
            this.con = con;
        }

        public RedundancySnapshot getObject() throws SQLException {
            RedundancySnapshot el = null;
            if (this.DBrs != null) {
                el = new RedundancySnapshot();
                el.setFields(this.con, this.DBrs);
            }
            return el;
        }

        public RedundancySnapshot getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

