/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.tables.TRunJobsTable;

public class RunJobs
extends TRunJobsTable {
    public static RunJobsCursor getCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
        return new RunJobsCursor(con, htWhereClause, columns);
    }

    public RunJobs() {
        this.clear();
    }

    public RunJobs(double TimeStamp, int ScheduleId, int SidRunNumber, int ComputerId, int JobRunNumber, int SubmitStatus, int ReturnCode, int ProcessId, double StartTime, double FinishTime, String LogFileName, double SubmitMillis, int DeviceServerRunId, short ResourceType2) {
        this.clear();
        this.m_TimeStamp = TimeStamp;
        this.m_ScheduleId = ScheduleId;
        this.m_SidRunNumber = SidRunNumber;
        this.m_ComputerId = ComputerId;
        this.m_JobRunNumber = JobRunNumber;
        this.m_SubmitStatus = SubmitStatus;
        this.m_ReturnCode = ReturnCode;
        this.m_ProcessId = ProcessId;
        this.m_StartTime = StartTime;
        this.m_FinishTime = FinishTime;
        this.m_LogFileName = LogFileName;
        this.m_SubmitMillis = SubmitMillis;
        this.m_DeviceServerRunId = DeviceServerRunId;
        this.m_ResourceType = ResourceType2;
    }

    private void setNonKeyValues(Hashtable htColsAndValues) {
        if (this.m_TimeStamp != Double.MIN_VALUE) {
            htColsAndValues.put(RunJobs.getColumnInfo("TIME_STAMP"), String.valueOf(this.m_TimeStamp));
        }
        if (this.m_ScheduleId != Integer.MIN_VALUE) {
            htColsAndValues.put(RunJobs.getColumnInfo("SCHEDULE_ID"), String.valueOf(this.m_ScheduleId));
        }
        if (this.m_SidRunNumber != Integer.MIN_VALUE) {
            htColsAndValues.put(RunJobs.getColumnInfo("SID_RUN_NUMBER"), String.valueOf(this.m_SidRunNumber));
        }
        if (this.m_ComputerId != Integer.MIN_VALUE) {
            htColsAndValues.put(RunJobs.getColumnInfo("COMPUTER_ID"), String.valueOf(this.m_ComputerId));
        }
        if (this.m_SubmitStatus != Integer.MIN_VALUE) {
            htColsAndValues.put(RunJobs.getColumnInfo("SUBMIT_STATUS"), String.valueOf(this.m_SubmitStatus));
        }
        if (this.m_ReturnCode != Integer.MIN_VALUE) {
            htColsAndValues.put(RunJobs.getColumnInfo("RETURN_CODE"), String.valueOf(this.m_ReturnCode));
        }
        if (this.m_ProcessId != Integer.MIN_VALUE) {
            htColsAndValues.put(RunJobs.getColumnInfo("PROCESS_ID"), String.valueOf(this.m_ProcessId));
        }
        if (this.m_StartTime != Double.MIN_VALUE) {
            htColsAndValues.put(RunJobs.getColumnInfo("START_TIME"), String.valueOf(this.m_StartTime));
        }
        if (this.m_FinishTime != Double.MIN_VALUE) {
            htColsAndValues.put(RunJobs.getColumnInfo("FINISH_TIME"), String.valueOf(this.m_FinishTime));
        }
        if (this.m_LogFileName != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(RunJobs.getColumnInfo("LOG_FILE_NAME"), this.m_LogFileName);
        }
        if (this.m_SubmitMillis != Double.MIN_VALUE) {
            htColsAndValues.put(RunJobs.getColumnInfo("SUBMIT_MILLIS"), String.valueOf(this.m_SubmitMillis));
        }
        if (this.m_DeviceServerRunId != Integer.MIN_VALUE) {
            htColsAndValues.put(RunJobs.getColumnInfo("DEVICE_SERVER_RUN_ID"), String.valueOf(this.m_DeviceServerRunId));
        }
        if (this.m_ResourceType != Short.MIN_VALUE) {
            htColsAndValues.put(RunJobs.getColumnInfo("RESOURCE_TYPE"), String.valueOf(this.m_ResourceType));
        }
    }

    public boolean insert(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_JobRunNumber == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key JOB_RUN_NUMBER not found");
        }
        this.htColsAndValues.put(RunJobs.getColumnInfo("JOB_RUN_NUMBER"), String.valueOf(this.m_JobRunNumber));
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RUN_JOBS", con, this.htColsAndValues);
    }

    public boolean insert(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(RunJobs.getColumnInfo("JOB_RUN_NUMBER")) == null) {
            throw new SQLException(" ERROR: key JOB_RUN_NUMBER not found");
        }
        return DBQueryAssistant.performInsert("T_RUN_JOBS", con, htinput);
    }

    public int update(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_JobRunNumber == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key JOB_RUN_NUMBER not found");
        }
        this.htWhereClause.put(RunJobs.getColumnInfo("JOB_RUN_NUMBER"), String.valueOf(this.m_JobRunNumber));
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RUN_JOBS", con, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(RunJobs.getColumnInfo("JOB_RUN_NUMBER")) == null) {
            throw new SQLException(" ERROR: key JOB_RUN_NUMBER not found");
        }
        this.htWhereClause.put(RunJobs.getColumnInfo("JOB_RUN_NUMBER"), htinput.get(RunJobs.getColumnInfo("JOB_RUN_NUMBER")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RUN_JOBS", con, htinput, this.htWhereClause);
    }

    public int delete(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_JobRunNumber == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key JOB_RUN_NUMBER not found");
        }
        this.htWhereClause.put(RunJobs.getColumnInfo("JOB_RUN_NUMBER"), String.valueOf(this.m_JobRunNumber));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RUN_JOBS", con, this.htWhereClause);
    }

    public int delete(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(RunJobs.getColumnInfo("JOB_RUN_NUMBER")) == null) {
            throw new SQLException(" ERROR: key JOB_RUN_NUMBER not found");
        }
        this.htWhereClause.put(RunJobs.getColumnInfo("JOB_RUN_NUMBER"), htinput.get(RunJobs.getColumnInfo("JOB_RUN_NUMBER")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RUN_JOBS", con, this.htWhereClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieve(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_JobRunNumber == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key JOB_RUN_NUMBER not found");
        }
        this.htWhereClause.put(RunJobs.getColumnInfo("JOB_RUN_NUMBER"), String.valueOf(this.m_JobRunNumber));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        boolean res = false;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RUN_JOBS", con, this.htWhereClause, null);
            if (DBrs.next()) {
                this.setFields(con, DBrs);
                res = true;
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RunJobs retrieve(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable htWhereClause = new Hashtable();
        RunJobs el = null;
        if (htinput.get(RunJobs.getColumnInfo("JOB_RUN_NUMBER")) == null) {
            throw new SQLException(" ERROR: key JOB_RUN_NUMBER not found");
        }
        htWhereClause.put(RunJobs.getColumnInfo("JOB_RUN_NUMBER"), htinput.get(RunJobs.getColumnInfo("JOB_RUN_NUMBER")));
        if (htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RUN_JOBS", con, htWhereClause, null);
            if (DBrs.next()) {
                el = new RunJobs();
                el.setFields(con, DBrs);
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return el;
    }

    public static int update(DBConnection con, Hashtable htinput, Hashtable htWhereClause) throws SQLException {
        if (con == null || htinput == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performUpdate("T_RUN_JOBS", con, htinput, htWhereClause);
    }

    public static int deletes(DBConnection con, Hashtable htWhereClause) throws SQLException {
        if (con == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performDelete("T_RUN_JOBS", con, htWhereClause);
    }

    protected void setFields(DBConnection con, DBResultSet DBrs) throws SQLException {
        this.setTimeStamp(DBrs.getDouble("TIME_STAMP"));
        this.setScheduleId(DBrs.getInt("SCHEDULE_ID"));
        this.setSidRunNumber(DBrs.getInt("SID_RUN_NUMBER"));
        this.setComputerId(DBrs.getInt("COMPUTER_ID"));
        this.setJobRunNumber(DBrs.getInt("JOB_RUN_NUMBER"));
        this.setSubmitStatus(DBrs.getInt("SUBMIT_STATUS"));
        this.setReturnCode(DBrs.getInt("RETURN_CODE"));
        this.setProcessId(DBrs.getInt("PROCESS_ID"));
        this.setStartTime(DBrs.getDouble("START_TIME"));
        this.setFinishTime(DBrs.getDouble("FINISH_TIME"));
        this.setLogFileName(DBrs.getString("LOG_FILE_NAME"));
        this.setSubmitMillis(DBrs.getDouble("SUBMIT_MILLIS"));
        this.setDeviceServerRunId(DBrs.getInt("DEVICE_SERVER_RUN_ID"));
        this.setResourceType(DBrs.getShort("RESOURCE_TYPE"));
    }

    public static class RunJobsCursor
    extends DBCursor {
        private RunJobs element = new RunJobs();
        private DBConnection con;

        public RunJobsCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
            super("T_RUN_JOBS", con, htWhereClause, columns);
            this.con = con;
        }

        public RunJobs getObject() throws SQLException {
            RunJobs el = null;
            if (this.DBrs != null) {
                el = new RunJobs();
                el.setFields(this.con, this.DBrs);
            }
            return el;
        }

        public RunJobs getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

