/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.Normalizer;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageExtentTable;

public class StorageExtent
extends TResStorageExtentTable {
    private String m_CreationClassNameId_str;
    private String m_SystemCreationClassNameId_str;
    private String m_SystemNamesId_str;

    public void setCreationClassName(String el) {
        this.m_CreationClassNameId_str = el;
    }

    public String getCreationClassName() {
        return this.m_CreationClassNameId_str;
    }

    public void setSystemCreationClassName(String el) {
        this.m_SystemCreationClassNameId_str = el;
    }

    public String getSystemCreationClassName() {
        return this.m_SystemCreationClassNameId_str;
    }

    public void setSystemNames(String el) {
        this.m_SystemNamesId_str = el;
    }

    public String getSystemNames() {
        return this.m_SystemNamesId_str;
    }

    public static StorageExtentCursor getCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
        return new StorageExtentCursor(con, htWhereClause, columns);
    }

    public StorageExtent() {
        this.clear();
    }

    public StorageExtent(int StorageExtentId, int NumExtents, int ExtentType, int PoolId, double TotalCapacity, double FreeSpace, int VolsInStorageExtent, String Name2, String ElementName, String OtherName, String RankId, String Config2, int VolGroupId, String GroupId, String DeviceId, short CreationClassNameId, short SystemCreationClassNameId, short SystemNamesId, int SubsystemId, int BlockSize, double NumOfBlocks, double ConsumableBlocks, int OperationalStatus, short NativeStatus, int Mode, String DisplayName, Timestamp UpdateTimestamp, int BackendControllerId, String SerialNumber, String ArrayIds, int Redundancy2) {
        this.clear();
        this.m_StorageExtentId = StorageExtentId;
        this.m_NumExtents = NumExtents;
        this.m_ExtentType = ExtentType;
        this.m_PoolId = PoolId;
        this.m_TotalCapacity = TotalCapacity;
        this.m_FreeSpace = FreeSpace;
        this.m_VolsInStorageExtent = VolsInStorageExtent;
        this.m_Name = Name2;
        this.m_ElementName = ElementName;
        this.m_OtherName = OtherName;
        this.m_RankId = RankId;
        this.m_Config = Config2;
        this.m_VolGroupId = VolGroupId;
        this.m_GroupId = GroupId;
        this.m_DeviceId = DeviceId;
        this.m_CreationClassNameId = CreationClassNameId;
        this.m_SystemCreationClassNameId = SystemCreationClassNameId;
        this.m_SystemNamesId = SystemNamesId;
        this.m_SubsystemId = SubsystemId;
        this.m_BlockSize = BlockSize;
        this.m_NumOfBlocks = NumOfBlocks;
        this.m_ConsumableBlocks = ConsumableBlocks;
        this.m_OperationalStatus = OperationalStatus;
        this.m_NativeStatus = NativeStatus;
        this.m_Mode = Mode;
        this.m_DisplayName = DisplayName;
        this.m_UpdateTimestamp = UpdateTimestamp;
        this.m_BackendControllerId = BackendControllerId;
        this.m_SerialNumber = SerialNumber;
        this.m_ArrayIds = ArrayIds;
        this.m_Redundancy = Redundancy2;
    }

    private void setNonKeyValues(Hashtable htColsAndValues) {
        if (this.m_StorageExtentId != Integer.MIN_VALUE) {
            htColsAndValues.put(StorageExtent.getColumnInfo("STORAGE_EXTENT_ID"), String.valueOf(this.m_StorageExtentId));
        }
        if (this.m_NumExtents != Integer.MIN_VALUE) {
            htColsAndValues.put(StorageExtent.getColumnInfo("NUM_EXTENTS"), String.valueOf(this.m_NumExtents));
        }
        if (this.m_ExtentType != Integer.MIN_VALUE) {
            htColsAndValues.put(StorageExtent.getColumnInfo("EXTENT_TYPE"), String.valueOf(this.m_ExtentType));
        }
        if (this.m_PoolId != Integer.MIN_VALUE) {
            htColsAndValues.put(StorageExtent.getColumnInfo("POOL_ID"), String.valueOf(this.m_PoolId));
        }
        if (this.m_TotalCapacity != Double.MIN_VALUE) {
            htColsAndValues.put(StorageExtent.getColumnInfo("TOTAL_CAPACITY"), String.valueOf(this.m_TotalCapacity));
        }
        if (this.m_FreeSpace != Double.MIN_VALUE) {
            htColsAndValues.put(StorageExtent.getColumnInfo("FREE_SPACE"), String.valueOf(this.m_FreeSpace));
        }
        if (this.m_VolsInStorageExtent != Integer.MIN_VALUE) {
            htColsAndValues.put(StorageExtent.getColumnInfo("VOLS_IN_STORAGE_EXTENT"), String.valueOf(this.m_VolsInStorageExtent));
        }
        if (this.m_Name != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(StorageExtent.getColumnInfo("NAME"), this.m_Name);
        }
        if (this.m_ElementName != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(StorageExtent.getColumnInfo("ELEMENT_NAME"), this.m_ElementName);
        }
        if (this.m_OtherName != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(StorageExtent.getColumnInfo("OTHER_NAME"), this.m_OtherName);
        }
        if (this.m_RankId != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(StorageExtent.getColumnInfo("RANK_ID"), this.m_RankId);
        }
        if (this.m_Config != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(StorageExtent.getColumnInfo("CONFIG"), this.m_Config);
        }
        if (this.m_VolGroupId != Integer.MIN_VALUE) {
            htColsAndValues.put(StorageExtent.getColumnInfo("VOL_GROUP_ID"), String.valueOf(this.m_VolGroupId));
        }
        if (this.m_GroupId != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(StorageExtent.getColumnInfo("GROUP_ID"), this.m_GroupId);
        }
        if (this.m_CreationClassNameId != Short.MIN_VALUE) {
            htColsAndValues.put(StorageExtent.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(this.m_CreationClassNameId));
        }
        if (this.m_SystemCreationClassNameId != Short.MIN_VALUE) {
            htColsAndValues.put(StorageExtent.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(this.m_SystemCreationClassNameId));
        }
        if (this.m_SystemNamesId != Short.MIN_VALUE) {
            htColsAndValues.put(StorageExtent.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(this.m_SystemNamesId));
        }
        if (this.m_BlockSize != Integer.MIN_VALUE) {
            htColsAndValues.put(StorageExtent.getColumnInfo("BLOCK_SIZE"), String.valueOf(this.m_BlockSize));
        }
        if (this.m_NumOfBlocks != Double.MIN_VALUE) {
            htColsAndValues.put(StorageExtent.getColumnInfo("NUM_OF_BLOCKS"), String.valueOf(this.m_NumOfBlocks));
        }
        if (this.m_ConsumableBlocks != Double.MIN_VALUE) {
            htColsAndValues.put(StorageExtent.getColumnInfo("CONSUMABLE_BLOCKS"), String.valueOf(this.m_ConsumableBlocks));
        }
        if (this.m_OperationalStatus != Integer.MIN_VALUE) {
            htColsAndValues.put(StorageExtent.getColumnInfo("OPERATIONAL_STATUS"), String.valueOf(this.m_OperationalStatus));
        }
        if (this.m_NativeStatus != Short.MIN_VALUE) {
            htColsAndValues.put(StorageExtent.getColumnInfo("NATIVE_STATUS"), String.valueOf(this.m_NativeStatus));
        }
        if (this.m_Mode != Integer.MIN_VALUE) {
            htColsAndValues.put(StorageExtent.getColumnInfo("MODE"), String.valueOf(this.m_Mode));
        }
        if (this.m_DisplayName != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(StorageExtent.getColumnInfo("DISPLAY_NAME"), this.m_DisplayName);
        }
        if (this.m_UpdateTimestamp != DBConstants.INVALID_TIMESTAMP_VALUE) {
            htColsAndValues.put(StorageExtent.getColumnInfo("UPDATE_TIMESTAMP"), this.m_UpdateTimestamp);
        }
        if (this.m_BackendControllerId != Integer.MIN_VALUE) {
            htColsAndValues.put(StorageExtent.getColumnInfo("BACKEND_CONTROLLER_ID"), String.valueOf(this.m_BackendControllerId));
        }
        if (this.m_SerialNumber != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(StorageExtent.getColumnInfo("SERIAL_NUMBER"), this.m_SerialNumber);
        }
        if (this.m_ArrayIds != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(StorageExtent.getColumnInfo("ARRAY_IDS"), this.m_ArrayIds);
        }
        if (this.m_Redundancy != Integer.MIN_VALUE) {
            htColsAndValues.put(StorageExtent.getColumnInfo("REDUNDANCY"), String.valueOf(this.m_Redundancy));
        }
    }

    public boolean insert(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(con, this.m_CreationClassNameId_str);
        }
        if (this.m_SystemCreationClassNameId_str != null) {
            this.m_SystemCreationClassNameId = Normalizer.SystemCreationClassNameGetID(con, this.m_SystemCreationClassNameId_str);
        }
        if (this.m_SystemNamesId_str != null) {
            this.m_SystemNamesId = Normalizer.SystemNamesGetID(con, this.m_SystemNamesId_str);
        }
        if (this.m_DeviceId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key DEVICE_ID not found");
        }
        this.htColsAndValues.put(StorageExtent.getColumnInfo("DEVICE_ID"), this.m_DeviceId);
        if (this.m_SubsystemId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SUBSYSTEM_ID not found");
        }
        this.htColsAndValues.put(StorageExtent.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(this.m_SubsystemId));
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_STORAGE_EXTENT", con, this.htColsAndValues);
    }

    public boolean insert(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(StorageExtent.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(StorageExtent.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(StorageExtent.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(StorageExtent.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(StorageExtent.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(con, (String)htinput.get(StorageExtent.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(StorageExtent.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            htinput.put(StorageExtent.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(con, (String)htinput.get(StorageExtent.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        if (htinput.get(StorageExtent.getColumnInfo("DEVICE_ID")) == null) {
            throw new SQLException(" ERROR: key DEVICE_ID not found");
        }
        if (htinput.get(StorageExtent.getColumnInfo("SUBSYSTEM_ID")) == null) {
            throw new SQLException(" ERROR: key SUBSYSTEM_ID not found");
        }
        return DBQueryAssistant.performInsert("T_RES_STORAGE_EXTENT", con, htinput);
    }

    public int update(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(con, this.m_CreationClassNameId_str);
        }
        if (this.m_SystemCreationClassNameId_str != null) {
            this.m_SystemCreationClassNameId = Normalizer.SystemCreationClassNameGetID(con, this.m_SystemCreationClassNameId_str);
        }
        if (this.m_SystemNamesId_str != null) {
            this.m_SystemNamesId = Normalizer.SystemNamesGetID(con, this.m_SystemNamesId_str);
        }
        if (this.m_DeviceId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key DEVICE_ID not found");
        }
        this.htWhereClause.put(StorageExtent.getColumnInfo("DEVICE_ID"), this.m_DeviceId);
        if (this.m_SubsystemId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(StorageExtent.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(this.m_SubsystemId));
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_STORAGE_EXTENT", con, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(StorageExtent.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(StorageExtent.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(StorageExtent.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(StorageExtent.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(StorageExtent.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(con, (String)htinput.get(StorageExtent.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(StorageExtent.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            htinput.put(StorageExtent.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(con, (String)htinput.get(StorageExtent.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        if (htinput.get(StorageExtent.getColumnInfo("DEVICE_ID")) == null) {
            throw new SQLException(" ERROR: key DEVICE_ID not found");
        }
        this.htWhereClause.put(StorageExtent.getColumnInfo("DEVICE_ID"), htinput.get(StorageExtent.getColumnInfo("DEVICE_ID")));
        if (htinput.get(StorageExtent.getColumnInfo("SUBSYSTEM_ID")) == null) {
            throw new SQLException(" ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(StorageExtent.getColumnInfo("SUBSYSTEM_ID"), htinput.get(StorageExtent.getColumnInfo("SUBSYSTEM_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_STORAGE_EXTENT", con, htinput, this.htWhereClause);
    }

    public int delete(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(con, this.m_CreationClassNameId_str);
        }
        if (this.m_SystemCreationClassNameId_str != null) {
            this.m_SystemCreationClassNameId = Normalizer.SystemCreationClassNameGetID(con, this.m_SystemCreationClassNameId_str);
        }
        if (this.m_SystemNamesId_str != null) {
            this.m_SystemNamesId = Normalizer.SystemNamesGetID(con, this.m_SystemNamesId_str);
        }
        if (this.m_DeviceId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key DEVICE_ID not found");
        }
        this.htWhereClause.put(StorageExtent.getColumnInfo("DEVICE_ID"), this.m_DeviceId);
        if (this.m_SubsystemId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(StorageExtent.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(this.m_SubsystemId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_STORAGE_EXTENT", con, this.htWhereClause);
    }

    public int delete(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(StorageExtent.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(StorageExtent.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(StorageExtent.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(StorageExtent.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(StorageExtent.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(con, (String)htinput.get(StorageExtent.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(StorageExtent.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            htinput.put(StorageExtent.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(con, (String)htinput.get(StorageExtent.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        if (htinput.get(StorageExtent.getColumnInfo("DEVICE_ID")) == null) {
            throw new SQLException(" ERROR: key DEVICE_ID not found");
        }
        this.htWhereClause.put(StorageExtent.getColumnInfo("DEVICE_ID"), htinput.get(StorageExtent.getColumnInfo("DEVICE_ID")));
        if (htinput.get(StorageExtent.getColumnInfo("SUBSYSTEM_ID")) == null) {
            throw new SQLException(" ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(StorageExtent.getColumnInfo("SUBSYSTEM_ID"), htinput.get(StorageExtent.getColumnInfo("SUBSYSTEM_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_STORAGE_EXTENT", con, this.htWhereClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieve(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(con, this.m_CreationClassNameId_str);
        }
        if (this.m_SystemCreationClassNameId_str != null) {
            this.m_SystemCreationClassNameId = Normalizer.SystemCreationClassNameGetID(con, this.m_SystemCreationClassNameId_str);
        }
        if (this.m_SystemNamesId_str != null) {
            this.m_SystemNamesId = Normalizer.SystemNamesGetID(con, this.m_SystemNamesId_str);
        }
        if (this.m_DeviceId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key DEVICE_ID not found");
        }
        this.htWhereClause.put(StorageExtent.getColumnInfo("DEVICE_ID"), this.m_DeviceId);
        if (this.m_SubsystemId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(StorageExtent.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(this.m_SubsystemId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        boolean res = false;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_STORAGE_EXTENT", con, this.htWhereClause, null);
            if (DBrs.next()) {
                this.setFields(con, DBrs);
                res = true;
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StorageExtent retrieve(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable htWhereClause = new Hashtable();
        StorageExtent el = null;
        if (htinput.get(StorageExtent.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(StorageExtent.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(StorageExtent.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(StorageExtent.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(StorageExtent.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(con, (String)htinput.get(StorageExtent.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(StorageExtent.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            htinput.put(StorageExtent.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(con, (String)htinput.get(StorageExtent.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        if (htinput.get(StorageExtent.getColumnInfo("DEVICE_ID")) == null) {
            throw new SQLException(" ERROR: key DEVICE_ID not found");
        }
        htWhereClause.put(StorageExtent.getColumnInfo("DEVICE_ID"), htinput.get(StorageExtent.getColumnInfo("DEVICE_ID")));
        if (htinput.get(StorageExtent.getColumnInfo("SUBSYSTEM_ID")) == null) {
            throw new SQLException(" ERROR: key SUBSYSTEM_ID not found");
        }
        htWhereClause.put(StorageExtent.getColumnInfo("SUBSYSTEM_ID"), htinput.get(StorageExtent.getColumnInfo("SUBSYSTEM_ID")));
        if (htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_STORAGE_EXTENT", con, htWhereClause, null);
            if (DBrs.next()) {
                el = new StorageExtent();
                el.setFields(con, DBrs);
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return el;
    }

    public static int update(DBConnection con, Hashtable htinput, Hashtable htWhereClause) throws SQLException {
        if (con == null || htinput == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(StorageExtent.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(StorageExtent.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(StorageExtent.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(StorageExtent.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(StorageExtent.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(con, (String)htinput.get(StorageExtent.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(StorageExtent.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            htinput.put(StorageExtent.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(con, (String)htinput.get(StorageExtent.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        if (htWhereClause.get(StorageExtent.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htWhereClause.put(StorageExtent.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htWhereClause.get(StorageExtent.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htWhereClause.get(StorageExtent.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
            htWhereClause.put(StorageExtent.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(con, (String)htWhereClause.get(StorageExtent.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
        }
        if (htWhereClause.get(StorageExtent.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            htWhereClause.put(StorageExtent.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(con, (String)htWhereClause.get(StorageExtent.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        return DBQueryAssistant.performUpdate("T_RES_STORAGE_EXTENT", con, htinput, htWhereClause);
    }

    public static int deletes(DBConnection con, Hashtable htWhereClause) throws SQLException {
        if (con == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htWhereClause.get(StorageExtent.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htWhereClause.put(StorageExtent.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htWhereClause.get(StorageExtent.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htWhereClause.get(StorageExtent.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
            htWhereClause.put(StorageExtent.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(con, (String)htWhereClause.get(StorageExtent.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
        }
        if (htWhereClause.get(StorageExtent.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            htWhereClause.put(StorageExtent.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(con, (String)htWhereClause.get(StorageExtent.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        return DBQueryAssistant.performDelete("T_RES_STORAGE_EXTENT", con, htWhereClause);
    }

    protected void setFields(DBConnection con, DBResultSet DBrs) throws SQLException {
        this.setStorageExtentId(DBrs.getInt("STORAGE_EXTENT_ID"));
        this.setNumExtents(DBrs.getInt("NUM_EXTENTS"));
        this.setExtentType(DBrs.getInt("EXTENT_TYPE"));
        this.setPoolId(DBrs.getInt("POOL_ID"));
        this.setTotalCapacity(DBrs.getDouble("TOTAL_CAPACITY"));
        this.setFreeSpace(DBrs.getDouble("FREE_SPACE"));
        this.setVolsInStorageExtent(DBrs.getInt("VOLS_IN_STORAGE_EXTENT"));
        this.setName(DBrs.getString("NAME"));
        this.setElementName(DBrs.getString("ELEMENT_NAME"));
        this.setOtherName(DBrs.getString("OTHER_NAME"));
        this.setRankId(DBrs.getString("RANK_ID"));
        this.setConfig(DBrs.getString("CONFIG"));
        this.setVolGroupId(DBrs.getInt("VOL_GROUP_ID"));
        this.setGroupId(DBrs.getString("GROUP_ID"));
        this.setDeviceId(DBrs.getString("DEVICE_ID"));
        this.setCreationClassNameId(DBrs.getShort("CREATION_CLASS_NAME_ID"));
        this.setCreationClassName(Normalizer.CreationClassNameGetName(con, this.m_CreationClassNameId));
        this.setSystemCreationClassNameId(DBrs.getShort("SYSTEM_CREATION_CLASS_NAME_ID"));
        this.setSystemCreationClassName(Normalizer.SystemCreationClassNameGetName(con, this.m_SystemCreationClassNameId));
        this.setSystemNamesId(DBrs.getShort("SYSTEM_NAMES_ID"));
        this.setSystemNames(Normalizer.SystemNamesGetName(con, this.m_SystemNamesId));
        this.setSubsystemId(DBrs.getInt("SUBSYSTEM_ID"));
        this.setBlockSize(DBrs.getInt("BLOCK_SIZE"));
        this.setNumOfBlocks(DBrs.getDouble("NUM_OF_BLOCKS"));
        this.setConsumableBlocks(DBrs.getDouble("CONSUMABLE_BLOCKS"));
        this.setOperationalStatus(DBrs.getInt("OPERATIONAL_STATUS"));
        this.setNativeStatus(DBrs.getShort("NATIVE_STATUS"));
        this.setMode(DBrs.getInt("MODE"));
        this.setDisplayName(DBrs.getString("DISPLAY_NAME"));
        this.setUpdateTimestamp(DBrs.getTimestamp("UPDATE_TIMESTAMP"));
        this.setBackendControllerId(DBrs.getInt("BACKEND_CONTROLLER_ID"));
        this.setSerialNumber(DBrs.getString("SERIAL_NUMBER"));
        this.setArrayIds(DBrs.getString("ARRAY_IDS"));
        this.setRedundancy(DBrs.getInt("REDUNDANCY"));
    }

    public static class StorageExtentCursor
    extends DBCursor {
        private StorageExtent element = new StorageExtent();
        private DBConnection con;

        private static Hashtable normalize(DBConnection con, Hashtable htWhereClause) throws SQLException {
            if (htWhereClause == null) {
                return null;
            }
            if (htWhereClause.get(TResStorageExtentTable.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
                htWhereClause.put(TResStorageExtentTable.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htWhereClause.get(TResStorageExtentTable.getColumnInfo("CREATION_CLASS_NAME_ID")))));
            }
            if (htWhereClause.get(TResStorageExtentTable.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
                htWhereClause.put(TResStorageExtentTable.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(con, (String)htWhereClause.get(TResStorageExtentTable.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
            }
            if (htWhereClause.get(TResStorageExtentTable.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
                htWhereClause.put(TResStorageExtentTable.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(con, (String)htWhereClause.get(TResStorageExtentTable.getColumnInfo("SYSTEM_NAMES_ID")))));
            }
            return htWhereClause;
        }

        public StorageExtentCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
            super("T_RES_STORAGE_EXTENT", con, StorageExtentCursor.normalize(con, htWhereClause), columns);
            this.con = con;
        }

        public StorageExtent getObject() throws SQLException {
            StorageExtent el = null;
            if (this.DBrs != null) {
                el = new StorageExtent();
                el.setFields(this.con, this.DBrs);
            }
            return el;
        }

        public StorageExtent getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

