/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageSubsystemAttributeSnapshotTable;

public class StorageSubsystemAttributeSnapshot
extends TResStorageSubsystemAttributeSnapshotTable {
    public static StorageSubsystemAttributeSnapshotCursor getCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
        return new StorageSubsystemAttributeSnapshotCursor(con, htWhereClause, columns);
    }

    public StorageSubsystemAttributeSnapshot() {
        this.clear();
    }

    public StorageSubsystemAttributeSnapshot(int SubsystemId, long Cache2, String CodeLevel, long AllocatedCapacity, long AvailableCapacity, long BackendStorageCapacity, short Detectable, int OperationalStatus) {
        this.clear();
        this.m_SubsystemId = SubsystemId;
        this.m_Cache = Cache2;
        this.m_CodeLevel = CodeLevel;
        this.m_AllocatedCapacity = AllocatedCapacity;
        this.m_AvailableCapacity = AvailableCapacity;
        this.m_BackendStorageCapacity = BackendStorageCapacity;
        this.m_Detectable = Detectable;
        this.m_OperationalStatus = OperationalStatus;
    }

    private void setNonKeyValues(Hashtable htColsAndValues) {
        if (this.m_Cache != Long.MIN_VALUE) {
            htColsAndValues.put(StorageSubsystemAttributeSnapshot.getColumnInfo("CACHE"), String.valueOf(this.m_Cache));
        }
        if (this.m_CodeLevel != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(StorageSubsystemAttributeSnapshot.getColumnInfo("CODE_LEVEL"), this.m_CodeLevel);
        }
        if (this.m_AllocatedCapacity != Long.MIN_VALUE) {
            htColsAndValues.put(StorageSubsystemAttributeSnapshot.getColumnInfo("ALLOCATED_CAPACITY"), String.valueOf(this.m_AllocatedCapacity));
        }
        if (this.m_AvailableCapacity != Long.MIN_VALUE) {
            htColsAndValues.put(StorageSubsystemAttributeSnapshot.getColumnInfo("AVAILABLE_CAPACITY"), String.valueOf(this.m_AvailableCapacity));
        }
        if (this.m_BackendStorageCapacity != Long.MIN_VALUE) {
            htColsAndValues.put(StorageSubsystemAttributeSnapshot.getColumnInfo("BACKEND_STORAGE_CAPACITY"), String.valueOf(this.m_BackendStorageCapacity));
        }
        if (this.m_Detectable != Short.MIN_VALUE) {
            htColsAndValues.put(StorageSubsystemAttributeSnapshot.getColumnInfo("DETECTABLE"), String.valueOf(this.m_Detectable));
        }
        if (this.m_OperationalStatus != Integer.MIN_VALUE) {
            htColsAndValues.put(StorageSubsystemAttributeSnapshot.getColumnInfo("OPERATIONAL_STATUS"), String.valueOf(this.m_OperationalStatus));
        }
    }

    public boolean insert(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_SubsystemId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SUBSYSTEM_ID not found");
        }
        this.htColsAndValues.put(StorageSubsystemAttributeSnapshot.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(this.m_SubsystemId));
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_STORAGE_SUBSYSTEM_ATTRIBUTE_SNAPSHOT", con, this.htColsAndValues);
    }

    public boolean insert(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(StorageSubsystemAttributeSnapshot.getColumnInfo("SUBSYSTEM_ID")) == null) {
            throw new SQLException(" ERROR: key SUBSYSTEM_ID not found");
        }
        return DBQueryAssistant.performInsert("T_RES_STORAGE_SUBSYSTEM_ATTRIBUTE_SNAPSHOT", con, htinput);
    }

    public int update(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_SubsystemId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(StorageSubsystemAttributeSnapshot.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(this.m_SubsystemId));
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_STORAGE_SUBSYSTEM_ATTRIBUTE_SNAPSHOT", con, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(StorageSubsystemAttributeSnapshot.getColumnInfo("SUBSYSTEM_ID")) == null) {
            throw new SQLException(" ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(StorageSubsystemAttributeSnapshot.getColumnInfo("SUBSYSTEM_ID"), htinput.get(StorageSubsystemAttributeSnapshot.getColumnInfo("SUBSYSTEM_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_STORAGE_SUBSYSTEM_ATTRIBUTE_SNAPSHOT", con, htinput, this.htWhereClause);
    }

    public int delete(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_SubsystemId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(StorageSubsystemAttributeSnapshot.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(this.m_SubsystemId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_STORAGE_SUBSYSTEM_ATTRIBUTE_SNAPSHOT", con, this.htWhereClause);
    }

    public int delete(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(StorageSubsystemAttributeSnapshot.getColumnInfo("SUBSYSTEM_ID")) == null) {
            throw new SQLException(" ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(StorageSubsystemAttributeSnapshot.getColumnInfo("SUBSYSTEM_ID"), htinput.get(StorageSubsystemAttributeSnapshot.getColumnInfo("SUBSYSTEM_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_STORAGE_SUBSYSTEM_ATTRIBUTE_SNAPSHOT", con, this.htWhereClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieve(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_SubsystemId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(StorageSubsystemAttributeSnapshot.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(this.m_SubsystemId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        boolean res = false;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_STORAGE_SUBSYSTEM_ATTRIBUTE_SNAPSHOT", con, this.htWhereClause, null);
            if (DBrs.next()) {
                this.setFields(con, DBrs);
                res = true;
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StorageSubsystemAttributeSnapshot retrieve(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable htWhereClause = new Hashtable();
        StorageSubsystemAttributeSnapshot el = null;
        if (htinput.get(StorageSubsystemAttributeSnapshot.getColumnInfo("SUBSYSTEM_ID")) == null) {
            throw new SQLException(" ERROR: key SUBSYSTEM_ID not found");
        }
        htWhereClause.put(StorageSubsystemAttributeSnapshot.getColumnInfo("SUBSYSTEM_ID"), htinput.get(StorageSubsystemAttributeSnapshot.getColumnInfo("SUBSYSTEM_ID")));
        if (htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_STORAGE_SUBSYSTEM_ATTRIBUTE_SNAPSHOT", con, htWhereClause, null);
            if (DBrs.next()) {
                el = new StorageSubsystemAttributeSnapshot();
                el.setFields(con, DBrs);
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return el;
    }

    public static int update(DBConnection con, Hashtable htinput, Hashtable htWhereClause) throws SQLException {
        if (con == null || htinput == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performUpdate("T_RES_STORAGE_SUBSYSTEM_ATTRIBUTE_SNAPSHOT", con, htinput, htWhereClause);
    }

    public static int deletes(DBConnection con, Hashtable htWhereClause) throws SQLException {
        if (con == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performDelete("T_RES_STORAGE_SUBSYSTEM_ATTRIBUTE_SNAPSHOT", con, htWhereClause);
    }

    protected void setFields(DBConnection con, DBResultSet DBrs) throws SQLException {
        this.setSubsystemId(DBrs.getInt("SUBSYSTEM_ID"));
        this.setCache(DBrs.getLong("CACHE"));
        this.setCodeLevel(DBrs.getString("CODE_LEVEL"));
        this.setAllocatedCapacity(DBrs.getLong("ALLOCATED_CAPACITY"));
        this.setAvailableCapacity(DBrs.getLong("AVAILABLE_CAPACITY"));
        this.setBackendStorageCapacity(DBrs.getLong("BACKEND_STORAGE_CAPACITY"));
        this.setDetectable(DBrs.getShort("DETECTABLE"));
        this.setOperationalStatus(DBrs.getInt("OPERATIONAL_STATUS"));
    }

    public static class StorageSubsystemAttributeSnapshotCursor
    extends DBCursor {
        private StorageSubsystemAttributeSnapshot element = new StorageSubsystemAttributeSnapshot();
        private DBConnection con;

        public StorageSubsystemAttributeSnapshotCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
            super("T_RES_STORAGE_SUBSYSTEM_ATTRIBUTE_SNAPSHOT", con, htWhereClause, columns);
            this.con = con;
        }

        public StorageSubsystemAttributeSnapshot getObject() throws SQLException {
            StorageSubsystemAttributeSnapshot el = null;
            if (this.DBrs != null) {
                el = new StorageSubsystemAttributeSnapshot();
                el.setFields(this.con, this.DBrs);
            }
            return el;
        }

        public StorageSubsystemAttributeSnapshot getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

