/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.Normalizer;
import org.eclipse.aperi.infrastructure.database.tables.TResTapeCartridgeTable;

public class TapeCartridge
extends TResTapeCartridgeTable {
    private String m_CreationClassNameId_str;

    public void setCreationClassName(String el) {
        this.m_CreationClassNameId_str = el;
    }

    public String getCreationClassName() {
        return this.m_CreationClassNameId_str;
    }

    public static TapeCartridgeCursor getCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
        return new TapeCartridgeCursor(con, htWhereClause, columns);
    }

    public TapeCartridge() {
        this.clear();
    }

    public TapeCartridge(String Tag2, short CreationClassNameId, long Capacity, short MediaType, short CleanerMedia, short DualSided, String PhysicalLabel, int LocationId, int TapeLibraryId, String MediaDescription, Timestamp UpdateTimestamp) {
        this.clear();
        this.m_Tag = Tag2;
        this.m_CreationClassNameId = CreationClassNameId;
        this.m_Capacity = Capacity;
        this.m_MediaType = MediaType;
        this.m_CleanerMedia = CleanerMedia;
        this.m_DualSided = DualSided;
        this.m_PhysicalLabel = PhysicalLabel;
        this.m_LocationId = LocationId;
        this.m_TapeLibraryId = TapeLibraryId;
        this.m_MediaDescription = MediaDescription;
        this.m_UpdateTimestamp = UpdateTimestamp;
    }

    private void setNonKeyValues(Hashtable htColsAndValues) {
        if (this.m_CreationClassNameId != Short.MIN_VALUE) {
            htColsAndValues.put(TapeCartridge.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(this.m_CreationClassNameId));
        }
        if (this.m_Capacity != Long.MIN_VALUE) {
            htColsAndValues.put(TapeCartridge.getColumnInfo("CAPACITY"), String.valueOf(this.m_Capacity));
        }
        if (this.m_MediaType != Short.MIN_VALUE) {
            htColsAndValues.put(TapeCartridge.getColumnInfo("MEDIA_TYPE"), String.valueOf(this.m_MediaType));
        }
        if (this.m_CleanerMedia != Short.MIN_VALUE) {
            htColsAndValues.put(TapeCartridge.getColumnInfo("CLEANER_MEDIA"), String.valueOf(this.m_CleanerMedia));
        }
        if (this.m_DualSided != Short.MIN_VALUE) {
            htColsAndValues.put(TapeCartridge.getColumnInfo("DUAL_SIDED"), String.valueOf(this.m_DualSided));
        }
        if (this.m_PhysicalLabel != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(TapeCartridge.getColumnInfo("PHYSICAL_LABEL"), this.m_PhysicalLabel);
        }
        if (this.m_LocationId != Integer.MIN_VALUE) {
            htColsAndValues.put(TapeCartridge.getColumnInfo("LOCATION_ID"), String.valueOf(this.m_LocationId));
        }
        if (this.m_TapeLibraryId != Integer.MIN_VALUE) {
            htColsAndValues.put(TapeCartridge.getColumnInfo("TAPE_LIBRARY_ID"), String.valueOf(this.m_TapeLibraryId));
        }
        if (this.m_MediaDescription != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(TapeCartridge.getColumnInfo("MEDIA_DESCRIPTION"), this.m_MediaDescription);
        }
        if (this.m_UpdateTimestamp != DBConstants.INVALID_TIMESTAMP_VALUE) {
            htColsAndValues.put(TapeCartridge.getColumnInfo("UPDATE_TIMESTAMP"), this.m_UpdateTimestamp);
        }
    }

    public boolean insert(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(con, this.m_CreationClassNameId_str);
        }
        if (this.m_Tag == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key TAG not found");
        }
        this.htColsAndValues.put(TapeCartridge.getColumnInfo("TAG"), this.m_Tag);
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_TAPE_CARTRIDGE", con, this.htColsAndValues);
    }

    public boolean insert(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(TapeCartridge.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(TapeCartridge.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(TapeCartridge.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(TapeCartridge.getColumnInfo("TAG")) == null) {
            throw new SQLException(" ERROR: key TAG not found");
        }
        return DBQueryAssistant.performInsert("T_RES_TAPE_CARTRIDGE", con, htinput);
    }

    public int update(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(con, this.m_CreationClassNameId_str);
        }
        if (this.m_Tag == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key TAG not found");
        }
        this.htWhereClause.put(TapeCartridge.getColumnInfo("TAG"), this.m_Tag);
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_TAPE_CARTRIDGE", con, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(TapeCartridge.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(TapeCartridge.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(TapeCartridge.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(TapeCartridge.getColumnInfo("TAG")) == null) {
            throw new SQLException(" ERROR: key TAG not found");
        }
        this.htWhereClause.put(TapeCartridge.getColumnInfo("TAG"), htinput.get(TapeCartridge.getColumnInfo("TAG")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_TAPE_CARTRIDGE", con, htinput, this.htWhereClause);
    }

    public int delete(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(con, this.m_CreationClassNameId_str);
        }
        if (this.m_Tag == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key TAG not found");
        }
        this.htWhereClause.put(TapeCartridge.getColumnInfo("TAG"), this.m_Tag);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_TAPE_CARTRIDGE", con, this.htWhereClause);
    }

    public int delete(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(TapeCartridge.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(TapeCartridge.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(TapeCartridge.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(TapeCartridge.getColumnInfo("TAG")) == null) {
            throw new SQLException(" ERROR: key TAG not found");
        }
        this.htWhereClause.put(TapeCartridge.getColumnInfo("TAG"), htinput.get(TapeCartridge.getColumnInfo("TAG")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_TAPE_CARTRIDGE", con, this.htWhereClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieve(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(con, this.m_CreationClassNameId_str);
        }
        if (this.m_Tag == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key TAG not found");
        }
        this.htWhereClause.put(TapeCartridge.getColumnInfo("TAG"), this.m_Tag);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        boolean res = false;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_TAPE_CARTRIDGE", con, this.htWhereClause, null);
            if (DBrs.next()) {
                this.setFields(con, DBrs);
                res = true;
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TapeCartridge retrieve(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable htWhereClause = new Hashtable();
        TapeCartridge el = null;
        if (htinput.get(TapeCartridge.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(TapeCartridge.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(TapeCartridge.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(TapeCartridge.getColumnInfo("TAG")) == null) {
            throw new SQLException(" ERROR: key TAG not found");
        }
        htWhereClause.put(TapeCartridge.getColumnInfo("TAG"), htinput.get(TapeCartridge.getColumnInfo("TAG")));
        if (htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_TAPE_CARTRIDGE", con, htWhereClause, null);
            if (DBrs.next()) {
                el = new TapeCartridge();
                el.setFields(con, DBrs);
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return el;
    }

    public static int update(DBConnection con, Hashtable htinput, Hashtable htWhereClause) throws SQLException {
        if (con == null || htinput == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(TapeCartridge.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(TapeCartridge.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(TapeCartridge.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htWhereClause.get(TapeCartridge.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htWhereClause.put(TapeCartridge.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htWhereClause.get(TapeCartridge.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        return DBQueryAssistant.performUpdate("T_RES_TAPE_CARTRIDGE", con, htinput, htWhereClause);
    }

    public static int deletes(DBConnection con, Hashtable htWhereClause) throws SQLException {
        if (con == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htWhereClause.get(TapeCartridge.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htWhereClause.put(TapeCartridge.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htWhereClause.get(TapeCartridge.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        return DBQueryAssistant.performDelete("T_RES_TAPE_CARTRIDGE", con, htWhereClause);
    }

    protected void setFields(DBConnection con, DBResultSet DBrs) throws SQLException {
        this.setTag(DBrs.getString("TAG"));
        this.setCreationClassNameId(DBrs.getShort("CREATION_CLASS_NAME_ID"));
        this.setCreationClassName(Normalizer.CreationClassNameGetName(con, this.m_CreationClassNameId));
        this.setCapacity(DBrs.getLong("CAPACITY"));
        this.setMediaType(DBrs.getShort("MEDIA_TYPE"));
        this.setCleanerMedia(DBrs.getShort("CLEANER_MEDIA"));
        this.setDualSided(DBrs.getShort("DUAL_SIDED"));
        this.setPhysicalLabel(DBrs.getString("PHYSICAL_LABEL"));
        this.setLocationId(DBrs.getInt("LOCATION_ID"));
        this.setTapeLibraryId(DBrs.getInt("TAPE_LIBRARY_ID"));
        this.setMediaDescription(DBrs.getString("MEDIA_DESCRIPTION"));
        this.setUpdateTimestamp(DBrs.getTimestamp("UPDATE_TIMESTAMP"));
    }

    public static class TapeCartridgeCursor
    extends DBCursor {
        private TapeCartridge element = new TapeCartridge();
        private DBConnection con;

        private static Hashtable normalize(DBConnection con, Hashtable htWhereClause) throws SQLException {
            if (htWhereClause == null) {
                return null;
            }
            if (htWhereClause.get(TResTapeCartridgeTable.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
                htWhereClause.put(TResTapeCartridgeTable.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htWhereClause.get(TResTapeCartridgeTable.getColumnInfo("CREATION_CLASS_NAME_ID")))));
            }
            return htWhereClause;
        }

        public TapeCartridgeCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
            super("T_RES_TAPE_CARTRIDGE", con, TapeCartridgeCursor.normalize(con, htWhereClause), columns);
            this.con = con;
        }

        public TapeCartridge getObject() throws SQLException {
            TapeCartridge el = null;
            if (this.DBrs != null) {
                el = new TapeCartridge();
                el.setFields(this.con, this.DBrs);
            }
            return el;
        }

        public TapeCartridge getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

