/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.Normalizer;
import org.eclipse.aperi.infrastructure.database.tables.TResTapeLibraryTable;

public class TapeLibrary
extends TResTapeLibraryTable {
    private String m_CreationClassNameId_str;

    public void setCreationClassName(String el) {
        this.m_CreationClassNameId_str = el;
    }

    public String getCreationClassName() {
        return this.m_CreationClassNameId_str;
    }

    public static TapeLibraryCursor getCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
        return new TapeLibraryCursor(con, htWhereClause, columns);
    }

    public TapeLibrary() {
        this.clear();
    }

    public TapeLibrary(int TapeLibraryId, String Name2, short NameFormat, short CreationClassNameId, String ElementName, String PrimaryOwnerName, String PrimaryOwnerContact, String AccessInfo, String FirmwareVersion, short Detectable, int OperationalStatus, short ConsolidatedStatus, short PropagatedStatus, Timestamp ChangedTimestamp, String DisplayName, int MaxCartridges, String Description, int CollectionStatus, int GroupId, Timestamp UpdateTimestamp, String UserProvidedName, String UserAttrib1, String UserAttrib2, String UserAttrib3) {
        this.clear();
        this.m_TapeLibraryId = TapeLibraryId;
        this.m_Name = Name2;
        this.m_NameFormat = NameFormat;
        this.m_CreationClassNameId = CreationClassNameId;
        this.m_ElementName = ElementName;
        this.m_PrimaryOwnerName = PrimaryOwnerName;
        this.m_PrimaryOwnerContact = PrimaryOwnerContact;
        this.m_AccessInfo = AccessInfo;
        this.m_FirmwareVersion = FirmwareVersion;
        this.m_Detectable = Detectable;
        this.m_OperationalStatus = OperationalStatus;
        this.m_ConsolidatedStatus = ConsolidatedStatus;
        this.m_PropagatedStatus = PropagatedStatus;
        this.m_ChangedTimestamp = ChangedTimestamp;
        this.m_DisplayName = DisplayName;
        this.m_MaxCartridges = MaxCartridges;
        this.m_Description = Description;
        this.m_CollectionStatus = CollectionStatus;
        this.m_GroupId = GroupId;
        this.m_UpdateTimestamp = UpdateTimestamp;
        this.m_UserProvidedName = UserProvidedName;
        this.m_UserAttrib1 = UserAttrib1;
        this.m_UserAttrib2 = UserAttrib2;
        this.m_UserAttrib3 = UserAttrib3;
    }

    private void setNonKeyValues(Hashtable htColsAndValues) {
        if (this.m_TapeLibraryId != Integer.MIN_VALUE) {
            htColsAndValues.put(TapeLibrary.getColumnInfo("TAPE_LIBRARY_ID"), String.valueOf(this.m_TapeLibraryId));
        }
        if (this.m_CreationClassNameId != Short.MIN_VALUE) {
            htColsAndValues.put(TapeLibrary.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(this.m_CreationClassNameId));
        }
        if (this.m_ElementName != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(TapeLibrary.getColumnInfo("ELEMENT_NAME"), this.m_ElementName);
        }
        if (this.m_PrimaryOwnerName != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(TapeLibrary.getColumnInfo("PRIMARY_OWNER_NAME"), this.m_PrimaryOwnerName);
        }
        if (this.m_PrimaryOwnerContact != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(TapeLibrary.getColumnInfo("PRIMARY_OWNER_CONTACT"), this.m_PrimaryOwnerContact);
        }
        if (this.m_AccessInfo != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(TapeLibrary.getColumnInfo("ACCESS_INFO"), this.m_AccessInfo);
        }
        if (this.m_FirmwareVersion != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(TapeLibrary.getColumnInfo("FIRMWARE_VERSION"), this.m_FirmwareVersion);
        }
        if (this.m_Detectable != Short.MIN_VALUE) {
            htColsAndValues.put(TapeLibrary.getColumnInfo("DETECTABLE"), String.valueOf(this.m_Detectable));
        }
        if (this.m_OperationalStatus != Integer.MIN_VALUE) {
            htColsAndValues.put(TapeLibrary.getColumnInfo("OPERATIONAL_STATUS"), String.valueOf(this.m_OperationalStatus));
        }
        if (this.m_ConsolidatedStatus != Short.MIN_VALUE) {
            htColsAndValues.put(TapeLibrary.getColumnInfo("CONSOLIDATED_STATUS"), String.valueOf(this.m_ConsolidatedStatus));
        }
        if (this.m_PropagatedStatus != Short.MIN_VALUE) {
            htColsAndValues.put(TapeLibrary.getColumnInfo("PROPAGATED_STATUS"), String.valueOf(this.m_PropagatedStatus));
        }
        if (this.m_ChangedTimestamp != DBConstants.INVALID_TIMESTAMP_VALUE) {
            htColsAndValues.put(TapeLibrary.getColumnInfo("CHANGED_TIMESTAMP"), this.m_ChangedTimestamp);
        }
        if (this.m_DisplayName != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(TapeLibrary.getColumnInfo("DISPLAY_NAME"), this.m_DisplayName);
        }
        if (this.m_MaxCartridges != Integer.MIN_VALUE) {
            htColsAndValues.put(TapeLibrary.getColumnInfo("MAX_CARTRIDGES"), String.valueOf(this.m_MaxCartridges));
        }
        if (this.m_Description != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(TapeLibrary.getColumnInfo("DESCRIPTION"), this.m_Description);
        }
        if (this.m_CollectionStatus != Integer.MIN_VALUE) {
            htColsAndValues.put(TapeLibrary.getColumnInfo("COLLECTION_STATUS"), String.valueOf(this.m_CollectionStatus));
        }
        if (this.m_GroupId != Integer.MIN_VALUE) {
            htColsAndValues.put(TapeLibrary.getColumnInfo("GROUP_ID"), String.valueOf(this.m_GroupId));
        }
        if (this.m_UpdateTimestamp != DBConstants.INVALID_TIMESTAMP_VALUE) {
            htColsAndValues.put(TapeLibrary.getColumnInfo("UPDATE_TIMESTAMP"), this.m_UpdateTimestamp);
        }
        if (this.m_UserProvidedName != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(TapeLibrary.getColumnInfo("USER_PROVIDED_NAME"), this.m_UserProvidedName);
        }
        if (this.m_UserAttrib1 != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(TapeLibrary.getColumnInfo("USER_ATTRIB1"), this.m_UserAttrib1);
        }
        if (this.m_UserAttrib2 != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(TapeLibrary.getColumnInfo("USER_ATTRIB2"), this.m_UserAttrib2);
        }
        if (this.m_UserAttrib3 != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(TapeLibrary.getColumnInfo("USER_ATTRIB3"), this.m_UserAttrib3);
        }
    }

    public boolean insert(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(con, this.m_CreationClassNameId_str);
        }
        if (this.m_Name == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key NAME not found");
        }
        this.htColsAndValues.put(TapeLibrary.getColumnInfo("NAME"), this.m_Name);
        if (this.m_NameFormat == Short.MIN_VALUE) {
            throw new SQLException("ERROR: key NAME_FORMAT not found");
        }
        this.htColsAndValues.put(TapeLibrary.getColumnInfo("NAME_FORMAT"), String.valueOf(this.m_NameFormat));
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_TAPE_LIBRARY", con, this.htColsAndValues);
    }

    public boolean insert(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(TapeLibrary.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(TapeLibrary.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(TapeLibrary.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(TapeLibrary.getColumnInfo("NAME")) == null) {
            throw new SQLException(" ERROR: key NAME not found");
        }
        if (htinput.get(TapeLibrary.getColumnInfo("NAME_FORMAT")) == null) {
            throw new SQLException(" ERROR: key NAME_FORMAT not found");
        }
        return DBQueryAssistant.performInsert("T_RES_TAPE_LIBRARY", con, htinput);
    }

    public int update(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(con, this.m_CreationClassNameId_str);
        }
        if (this.m_Name == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key NAME not found");
        }
        this.htWhereClause.put(TapeLibrary.getColumnInfo("NAME"), this.m_Name);
        if (this.m_NameFormat == Short.MIN_VALUE) {
            throw new SQLException("ERROR: key NAME_FORMAT not found");
        }
        this.htWhereClause.put(TapeLibrary.getColumnInfo("NAME_FORMAT"), String.valueOf(this.m_NameFormat));
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_TAPE_LIBRARY", con, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(TapeLibrary.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(TapeLibrary.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(TapeLibrary.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(TapeLibrary.getColumnInfo("NAME")) == null) {
            throw new SQLException(" ERROR: key NAME not found");
        }
        this.htWhereClause.put(TapeLibrary.getColumnInfo("NAME"), htinput.get(TapeLibrary.getColumnInfo("NAME")));
        if (htinput.get(TapeLibrary.getColumnInfo("NAME_FORMAT")) == null) {
            throw new SQLException(" ERROR: key NAME_FORMAT not found");
        }
        this.htWhereClause.put(TapeLibrary.getColumnInfo("NAME_FORMAT"), htinput.get(TapeLibrary.getColumnInfo("NAME_FORMAT")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_TAPE_LIBRARY", con, htinput, this.htWhereClause);
    }

    public int delete(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(con, this.m_CreationClassNameId_str);
        }
        if (this.m_Name == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key NAME not found");
        }
        this.htWhereClause.put(TapeLibrary.getColumnInfo("NAME"), this.m_Name);
        if (this.m_NameFormat == Short.MIN_VALUE) {
            throw new SQLException("ERROR: key NAME_FORMAT not found");
        }
        this.htWhereClause.put(TapeLibrary.getColumnInfo("NAME_FORMAT"), String.valueOf(this.m_NameFormat));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_TAPE_LIBRARY", con, this.htWhereClause);
    }

    public int delete(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(TapeLibrary.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(TapeLibrary.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(TapeLibrary.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(TapeLibrary.getColumnInfo("NAME")) == null) {
            throw new SQLException(" ERROR: key NAME not found");
        }
        this.htWhereClause.put(TapeLibrary.getColumnInfo("NAME"), htinput.get(TapeLibrary.getColumnInfo("NAME")));
        if (htinput.get(TapeLibrary.getColumnInfo("NAME_FORMAT")) == null) {
            throw new SQLException(" ERROR: key NAME_FORMAT not found");
        }
        this.htWhereClause.put(TapeLibrary.getColumnInfo("NAME_FORMAT"), htinput.get(TapeLibrary.getColumnInfo("NAME_FORMAT")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_TAPE_LIBRARY", con, this.htWhereClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieve(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(con, this.m_CreationClassNameId_str);
        }
        if (this.m_Name == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key NAME not found");
        }
        this.htWhereClause.put(TapeLibrary.getColumnInfo("NAME"), this.m_Name);
        if (this.m_NameFormat == Short.MIN_VALUE) {
            throw new SQLException("ERROR: key NAME_FORMAT not found");
        }
        this.htWhereClause.put(TapeLibrary.getColumnInfo("NAME_FORMAT"), String.valueOf(this.m_NameFormat));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        boolean res = false;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_TAPE_LIBRARY", con, this.htWhereClause, null);
            if (DBrs.next()) {
                this.setFields(con, DBrs);
                res = true;
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TapeLibrary retrieve(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable htWhereClause = new Hashtable();
        TapeLibrary el = null;
        if (htinput.get(TapeLibrary.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(TapeLibrary.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(TapeLibrary.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(TapeLibrary.getColumnInfo("NAME")) == null) {
            throw new SQLException(" ERROR: key NAME not found");
        }
        htWhereClause.put(TapeLibrary.getColumnInfo("NAME"), htinput.get(TapeLibrary.getColumnInfo("NAME")));
        if (htinput.get(TapeLibrary.getColumnInfo("NAME_FORMAT")) == null) {
            throw new SQLException(" ERROR: key NAME_FORMAT not found");
        }
        htWhereClause.put(TapeLibrary.getColumnInfo("NAME_FORMAT"), htinput.get(TapeLibrary.getColumnInfo("NAME_FORMAT")));
        if (htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_TAPE_LIBRARY", con, htWhereClause, null);
            if (DBrs.next()) {
                el = new TapeLibrary();
                el.setFields(con, DBrs);
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return el;
    }

    public static int update(DBConnection con, Hashtable htinput, Hashtable htWhereClause) throws SQLException {
        if (con == null || htinput == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(TapeLibrary.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(TapeLibrary.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(TapeLibrary.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htWhereClause.get(TapeLibrary.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htWhereClause.put(TapeLibrary.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htWhereClause.get(TapeLibrary.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        return DBQueryAssistant.performUpdate("T_RES_TAPE_LIBRARY", con, htinput, htWhereClause);
    }

    public static int deletes(DBConnection con, Hashtable htWhereClause) throws SQLException {
        if (con == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htWhereClause.get(TapeLibrary.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htWhereClause.put(TapeLibrary.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htWhereClause.get(TapeLibrary.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        return DBQueryAssistant.performDelete("T_RES_TAPE_LIBRARY", con, htWhereClause);
    }

    protected void setFields(DBConnection con, DBResultSet DBrs) throws SQLException {
        this.setTapeLibraryId(DBrs.getInt("TAPE_LIBRARY_ID"));
        this.setName(DBrs.getString("NAME"));
        this.setNameFormat(DBrs.getShort("NAME_FORMAT"));
        this.setCreationClassNameId(DBrs.getShort("CREATION_CLASS_NAME_ID"));
        this.setCreationClassName(Normalizer.CreationClassNameGetName(con, this.m_CreationClassNameId));
        this.setElementName(DBrs.getString("ELEMENT_NAME"));
        this.setPrimaryOwnerName(DBrs.getString("PRIMARY_OWNER_NAME"));
        this.setPrimaryOwnerContact(DBrs.getString("PRIMARY_OWNER_CONTACT"));
        this.setAccessInfo(DBrs.getString("ACCESS_INFO"));
        this.setFirmwareVersion(DBrs.getString("FIRMWARE_VERSION"));
        this.setDetectable(DBrs.getShort("DETECTABLE"));
        this.setOperationalStatus(DBrs.getInt("OPERATIONAL_STATUS"));
        this.setConsolidatedStatus(DBrs.getShort("CONSOLIDATED_STATUS"));
        this.setPropagatedStatus(DBrs.getShort("PROPAGATED_STATUS"));
        this.setChangedTimestamp(DBrs.getTimestamp("CHANGED_TIMESTAMP"));
        this.setDisplayName(DBrs.getString("DISPLAY_NAME"));
        this.setMaxCartridges(DBrs.getInt("MAX_CARTRIDGES"));
        this.setDescription(DBrs.getString("DESCRIPTION"));
        this.setCollectionStatus(DBrs.getInt("COLLECTION_STATUS"));
        this.setGroupId(DBrs.getInt("GROUP_ID"));
        this.setUpdateTimestamp(DBrs.getTimestamp("UPDATE_TIMESTAMP"));
        this.setUserProvidedName(DBrs.getString("USER_PROVIDED_NAME"));
        this.setUserAttrib1(DBrs.getString("USER_ATTRIB1"));
        this.setUserAttrib2(DBrs.getString("USER_ATTRIB2"));
        this.setUserAttrib3(DBrs.getString("USER_ATTRIB3"));
    }

    public static class TapeLibraryCursor
    extends DBCursor {
        private TapeLibrary element = new TapeLibrary();
        private DBConnection con;

        private static Hashtable normalize(DBConnection con, Hashtable htWhereClause) throws SQLException {
            if (htWhereClause == null) {
                return null;
            }
            if (htWhereClause.get(TResTapeLibraryTable.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
                htWhereClause.put(TResTapeLibraryTable.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htWhereClause.get(TResTapeLibraryTable.getColumnInfo("CREATION_CLASS_NAME_ID")))));
            }
            return htWhereClause;
        }

        public TapeLibraryCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
            super("T_RES_TAPE_LIBRARY", con, TapeLibraryCursor.normalize(con, htWhereClause), columns);
            this.con = con;
        }

        public TapeLibrary getObject() throws SQLException {
            TapeLibrary el = null;
            if (this.DBrs != null) {
                el = new TapeLibrary();
                el.setFields(this.con, this.DBrs);
            }
            return el;
        }

        public TapeLibrary getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

