/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.Normalizer;
import org.eclipse.aperi.infrastructure.database.tables.TResVendorSnapshotTable;

public class VendorSnapshot
extends TResVendorSnapshotTable {
    private String m_VendorId_str;

    public void setVendor(String el) {
        this.m_VendorId_str = el;
    }

    public String getVendor() {
        return this.m_VendorId_str;
    }

    public static VendorSnapshotCursor getCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
        return new VendorSnapshotCursor(con, htWhereClause, columns);
    }

    public VendorSnapshot() {
        this.clear();
    }

    public VendorSnapshot(int SnapshotId, short VendorId, String VendorName, String VendorDescription) {
        this.clear();
        this.m_SnapshotId = SnapshotId;
        this.m_VendorId = VendorId;
        this.m_VendorName = VendorName;
        this.m_VendorDescription = VendorDescription;
    }

    private void setNonKeyValues(Hashtable htColsAndValues) {
        if (this.m_VendorId != Short.MIN_VALUE) {
            htColsAndValues.put(VendorSnapshot.getColumnInfo("VENDOR_ID"), String.valueOf(this.m_VendorId));
        }
        if (this.m_VendorDescription != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(VendorSnapshot.getColumnInfo("VENDOR_DESCRIPTION"), this.m_VendorDescription);
        }
    }

    public boolean insert(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(con, this.m_VendorId_str);
        }
        if (this.m_VendorName == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key VENDOR_NAME not found");
        }
        this.htColsAndValues.put(VendorSnapshot.getColumnInfo("VENDOR_NAME"), this.m_VendorName);
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htColsAndValues.put(VendorSnapshot.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_VENDOR_SNAPSHOT", con, this.htColsAndValues);
    }

    public boolean insert(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(VendorSnapshot.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(VendorSnapshot.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(VendorSnapshot.getColumnInfo("VENDOR_ID")))));
        }
        if (htinput.get(VendorSnapshot.getColumnInfo("VENDOR_NAME")) == null) {
            throw new SQLException(" ERROR: key VENDOR_NAME not found");
        }
        if (htinput.get(VendorSnapshot.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        return DBQueryAssistant.performInsert("T_RES_VENDOR_SNAPSHOT", con, htinput);
    }

    public int update(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(con, this.m_VendorId_str);
        }
        if (this.m_VendorName == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key VENDOR_NAME not found");
        }
        this.htWhereClause.put(VendorSnapshot.getColumnInfo("VENDOR_NAME"), this.m_VendorName);
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(VendorSnapshot.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_VENDOR_SNAPSHOT", con, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(VendorSnapshot.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(VendorSnapshot.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(VendorSnapshot.getColumnInfo("VENDOR_ID")))));
        }
        if (htinput.get(VendorSnapshot.getColumnInfo("VENDOR_NAME")) == null) {
            throw new SQLException(" ERROR: key VENDOR_NAME not found");
        }
        this.htWhereClause.put(VendorSnapshot.getColumnInfo("VENDOR_NAME"), htinput.get(VendorSnapshot.getColumnInfo("VENDOR_NAME")));
        if (htinput.get(VendorSnapshot.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(VendorSnapshot.getColumnInfo("SNAPSHOT_ID"), htinput.get(VendorSnapshot.getColumnInfo("SNAPSHOT_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_VENDOR_SNAPSHOT", con, htinput, this.htWhereClause);
    }

    public int delete(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(con, this.m_VendorId_str);
        }
        if (this.m_VendorName == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key VENDOR_NAME not found");
        }
        this.htWhereClause.put(VendorSnapshot.getColumnInfo("VENDOR_NAME"), this.m_VendorName);
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(VendorSnapshot.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_VENDOR_SNAPSHOT", con, this.htWhereClause);
    }

    public int delete(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(VendorSnapshot.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(VendorSnapshot.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(VendorSnapshot.getColumnInfo("VENDOR_ID")))));
        }
        if (htinput.get(VendorSnapshot.getColumnInfo("VENDOR_NAME")) == null) {
            throw new SQLException(" ERROR: key VENDOR_NAME not found");
        }
        this.htWhereClause.put(VendorSnapshot.getColumnInfo("VENDOR_NAME"), htinput.get(VendorSnapshot.getColumnInfo("VENDOR_NAME")));
        if (htinput.get(VendorSnapshot.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(VendorSnapshot.getColumnInfo("SNAPSHOT_ID"), htinput.get(VendorSnapshot.getColumnInfo("SNAPSHOT_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_VENDOR_SNAPSHOT", con, this.htWhereClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieve(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(con, this.m_VendorId_str);
        }
        if (this.m_VendorName == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key VENDOR_NAME not found");
        }
        this.htWhereClause.put(VendorSnapshot.getColumnInfo("VENDOR_NAME"), this.m_VendorName);
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(VendorSnapshot.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        boolean res = false;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_VENDOR_SNAPSHOT", con, this.htWhereClause, null);
            if (DBrs.next()) {
                this.setFields(con, DBrs);
                res = true;
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VendorSnapshot retrieve(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable htWhereClause = new Hashtable();
        VendorSnapshot el = null;
        if (htinput.get(VendorSnapshot.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(VendorSnapshot.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(VendorSnapshot.getColumnInfo("VENDOR_ID")))));
        }
        if (htinput.get(VendorSnapshot.getColumnInfo("VENDOR_NAME")) == null) {
            throw new SQLException(" ERROR: key VENDOR_NAME not found");
        }
        htWhereClause.put(VendorSnapshot.getColumnInfo("VENDOR_NAME"), htinput.get(VendorSnapshot.getColumnInfo("VENDOR_NAME")));
        if (htinput.get(VendorSnapshot.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        htWhereClause.put(VendorSnapshot.getColumnInfo("SNAPSHOT_ID"), htinput.get(VendorSnapshot.getColumnInfo("SNAPSHOT_ID")));
        if (htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_VENDOR_SNAPSHOT", con, htWhereClause, null);
            if (DBrs.next()) {
                el = new VendorSnapshot();
                el.setFields(con, DBrs);
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return el;
    }

    public static int update(DBConnection con, Hashtable htinput, Hashtable htWhereClause) throws SQLException {
        if (con == null || htinput == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(VendorSnapshot.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(VendorSnapshot.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(VendorSnapshot.getColumnInfo("VENDOR_ID")))));
        }
        if (htWhereClause.get(VendorSnapshot.getColumnInfo("VENDOR_ID")) != null) {
            htWhereClause.put(VendorSnapshot.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htWhereClause.get(VendorSnapshot.getColumnInfo("VENDOR_ID")))));
        }
        return DBQueryAssistant.performUpdate("T_RES_VENDOR_SNAPSHOT", con, htinput, htWhereClause);
    }

    public static int deletes(DBConnection con, Hashtable htWhereClause) throws SQLException {
        if (con == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htWhereClause.get(VendorSnapshot.getColumnInfo("VENDOR_ID")) != null) {
            htWhereClause.put(VendorSnapshot.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htWhereClause.get(VendorSnapshot.getColumnInfo("VENDOR_ID")))));
        }
        return DBQueryAssistant.performDelete("T_RES_VENDOR_SNAPSHOT", con, htWhereClause);
    }

    protected void setFields(DBConnection con, DBResultSet DBrs) throws SQLException {
        this.setSnapshotId(DBrs.getInt("SNAPSHOT_ID"));
        this.setVendorId(DBrs.getShort("VENDOR_ID"));
        this.setVendor(Normalizer.VendorGetName(con, this.m_VendorId));
        this.setVendorName(DBrs.getString("VENDOR_NAME"));
        this.setVendorDescription(DBrs.getString("VENDOR_DESCRIPTION"));
    }

    public static class VendorSnapshotCursor
    extends DBCursor {
        private VendorSnapshot element = new VendorSnapshot();
        private DBConnection con;

        private static Hashtable normalize(DBConnection con, Hashtable htWhereClause) throws SQLException {
            if (htWhereClause == null) {
                return null;
            }
            if (htWhereClause.get(TResVendorSnapshotTable.getColumnInfo("VENDOR_ID")) != null) {
                htWhereClause.put(TResVendorSnapshotTable.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htWhereClause.get(TResVendorSnapshotTable.getColumnInfo("VENDOR_ID")))));
            }
            return htWhereClause;
        }

        public VendorSnapshotCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
            super("T_RES_VENDOR_SNAPSHOT", con, VendorSnapshotCursor.normalize(con, htWhereClause), columns);
            this.con = con;
        }

        public VendorSnapshot getObject() throws SQLException {
            VendorSnapshot el = null;
            if (this.DBrs != null) {
                el = new VendorSnapshot();
                el.setFields(this.con, this.DBrs);
            }
            return el;
        }

        public VendorSnapshot getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

