/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.tables.TResVolume2extentSnapshotTable;

public class Volume2extentSnapshot
extends TResVolume2extentSnapshotTable {
    public static Volume2extentSnapshotCursor getCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
        return new Volume2extentSnapshotCursor(con, htWhereClause, columns);
    }

    public Volume2extentSnapshot() {
        this.clear();
    }

    public Volume2extentSnapshot(int SnapshotId, int VolumeId, int StorageExtentId, int TotalNumExtents, Timestamp UpdateTimestamp) {
        this.clear();
        this.m_SnapshotId = SnapshotId;
        this.m_VolumeId = VolumeId;
        this.m_StorageExtentId = StorageExtentId;
        this.m_TotalNumExtents = TotalNumExtents;
        this.m_UpdateTimestamp = UpdateTimestamp;
    }

    private void setNonKeyValues(Hashtable htColsAndValues) {
        if (this.m_TotalNumExtents != Integer.MIN_VALUE) {
            htColsAndValues.put(Volume2extentSnapshot.getColumnInfo("TOTAL_NUM_EXTENTS"), String.valueOf(this.m_TotalNumExtents));
        }
        if (this.m_UpdateTimestamp != DBConstants.INVALID_TIMESTAMP_VALUE) {
            htColsAndValues.put(Volume2extentSnapshot.getColumnInfo("UPDATE_TIMESTAMP"), this.m_UpdateTimestamp);
        }
    }

    public boolean insert(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_VolumeId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key VOLUME_ID not found");
        }
        this.htColsAndValues.put(Volume2extentSnapshot.getColumnInfo("VOLUME_ID"), String.valueOf(this.m_VolumeId));
        if (this.m_StorageExtentId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key STORAGE_EXTENT_ID not found");
        }
        this.htColsAndValues.put(Volume2extentSnapshot.getColumnInfo("STORAGE_EXTENT_ID"), String.valueOf(this.m_StorageExtentId));
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htColsAndValues.put(Volume2extentSnapshot.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_VOLUME2EXTENT_SNAPSHOT", con, this.htColsAndValues);
    }

    public boolean insert(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(Volume2extentSnapshot.getColumnInfo("VOLUME_ID")) == null) {
            throw new SQLException(" ERROR: key VOLUME_ID not found");
        }
        if (htinput.get(Volume2extentSnapshot.getColumnInfo("STORAGE_EXTENT_ID")) == null) {
            throw new SQLException(" ERROR: key STORAGE_EXTENT_ID not found");
        }
        if (htinput.get(Volume2extentSnapshot.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        return DBQueryAssistant.performInsert("T_RES_VOLUME2EXTENT_SNAPSHOT", con, htinput);
    }

    public int update(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_VolumeId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key VOLUME_ID not found");
        }
        this.htWhereClause.put(Volume2extentSnapshot.getColumnInfo("VOLUME_ID"), String.valueOf(this.m_VolumeId));
        if (this.m_StorageExtentId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key STORAGE_EXTENT_ID not found");
        }
        this.htWhereClause.put(Volume2extentSnapshot.getColumnInfo("STORAGE_EXTENT_ID"), String.valueOf(this.m_StorageExtentId));
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(Volume2extentSnapshot.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_VOLUME2EXTENT_SNAPSHOT", con, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(Volume2extentSnapshot.getColumnInfo("VOLUME_ID")) == null) {
            throw new SQLException(" ERROR: key VOLUME_ID not found");
        }
        this.htWhereClause.put(Volume2extentSnapshot.getColumnInfo("VOLUME_ID"), htinput.get(Volume2extentSnapshot.getColumnInfo("VOLUME_ID")));
        if (htinput.get(Volume2extentSnapshot.getColumnInfo("STORAGE_EXTENT_ID")) == null) {
            throw new SQLException(" ERROR: key STORAGE_EXTENT_ID not found");
        }
        this.htWhereClause.put(Volume2extentSnapshot.getColumnInfo("STORAGE_EXTENT_ID"), htinput.get(Volume2extentSnapshot.getColumnInfo("STORAGE_EXTENT_ID")));
        if (htinput.get(Volume2extentSnapshot.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(Volume2extentSnapshot.getColumnInfo("SNAPSHOT_ID"), htinput.get(Volume2extentSnapshot.getColumnInfo("SNAPSHOT_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_VOLUME2EXTENT_SNAPSHOT", con, htinput, this.htWhereClause);
    }

    public int delete(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_VolumeId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key VOLUME_ID not found");
        }
        this.htWhereClause.put(Volume2extentSnapshot.getColumnInfo("VOLUME_ID"), String.valueOf(this.m_VolumeId));
        if (this.m_StorageExtentId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key STORAGE_EXTENT_ID not found");
        }
        this.htWhereClause.put(Volume2extentSnapshot.getColumnInfo("STORAGE_EXTENT_ID"), String.valueOf(this.m_StorageExtentId));
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(Volume2extentSnapshot.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_VOLUME2EXTENT_SNAPSHOT", con, this.htWhereClause);
    }

    public int delete(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(Volume2extentSnapshot.getColumnInfo("VOLUME_ID")) == null) {
            throw new SQLException(" ERROR: key VOLUME_ID not found");
        }
        this.htWhereClause.put(Volume2extentSnapshot.getColumnInfo("VOLUME_ID"), htinput.get(Volume2extentSnapshot.getColumnInfo("VOLUME_ID")));
        if (htinput.get(Volume2extentSnapshot.getColumnInfo("STORAGE_EXTENT_ID")) == null) {
            throw new SQLException(" ERROR: key STORAGE_EXTENT_ID not found");
        }
        this.htWhereClause.put(Volume2extentSnapshot.getColumnInfo("STORAGE_EXTENT_ID"), htinput.get(Volume2extentSnapshot.getColumnInfo("STORAGE_EXTENT_ID")));
        if (htinput.get(Volume2extentSnapshot.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(Volume2extentSnapshot.getColumnInfo("SNAPSHOT_ID"), htinput.get(Volume2extentSnapshot.getColumnInfo("SNAPSHOT_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_VOLUME2EXTENT_SNAPSHOT", con, this.htWhereClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieve(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_VolumeId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key VOLUME_ID not found");
        }
        this.htWhereClause.put(Volume2extentSnapshot.getColumnInfo("VOLUME_ID"), String.valueOf(this.m_VolumeId));
        if (this.m_StorageExtentId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key STORAGE_EXTENT_ID not found");
        }
        this.htWhereClause.put(Volume2extentSnapshot.getColumnInfo("STORAGE_EXTENT_ID"), String.valueOf(this.m_StorageExtentId));
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(Volume2extentSnapshot.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        boolean res = false;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_VOLUME2EXTENT_SNAPSHOT", con, this.htWhereClause, null);
            if (DBrs.next()) {
                this.setFields(con, DBrs);
                res = true;
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Volume2extentSnapshot retrieve(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable htWhereClause = new Hashtable();
        Volume2extentSnapshot el = null;
        if (htinput.get(Volume2extentSnapshot.getColumnInfo("VOLUME_ID")) == null) {
            throw new SQLException(" ERROR: key VOLUME_ID not found");
        }
        htWhereClause.put(Volume2extentSnapshot.getColumnInfo("VOLUME_ID"), htinput.get(Volume2extentSnapshot.getColumnInfo("VOLUME_ID")));
        if (htinput.get(Volume2extentSnapshot.getColumnInfo("STORAGE_EXTENT_ID")) == null) {
            throw new SQLException(" ERROR: key STORAGE_EXTENT_ID not found");
        }
        htWhereClause.put(Volume2extentSnapshot.getColumnInfo("STORAGE_EXTENT_ID"), htinput.get(Volume2extentSnapshot.getColumnInfo("STORAGE_EXTENT_ID")));
        if (htinput.get(Volume2extentSnapshot.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        htWhereClause.put(Volume2extentSnapshot.getColumnInfo("SNAPSHOT_ID"), htinput.get(Volume2extentSnapshot.getColumnInfo("SNAPSHOT_ID")));
        if (htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_VOLUME2EXTENT_SNAPSHOT", con, htWhereClause, null);
            if (DBrs.next()) {
                el = new Volume2extentSnapshot();
                el.setFields(con, DBrs);
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return el;
    }

    public static int update(DBConnection con, Hashtable htinput, Hashtable htWhereClause) throws SQLException {
        if (con == null || htinput == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performUpdate("T_RES_VOLUME2EXTENT_SNAPSHOT", con, htinput, htWhereClause);
    }

    public static int deletes(DBConnection con, Hashtable htWhereClause) throws SQLException {
        if (con == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performDelete("T_RES_VOLUME2EXTENT_SNAPSHOT", con, htWhereClause);
    }

    protected void setFields(DBConnection con, DBResultSet DBrs) throws SQLException {
        this.setSnapshotId(DBrs.getInt("SNAPSHOT_ID"));
        this.setVolumeId(DBrs.getInt("VOLUME_ID"));
        this.setStorageExtentId(DBrs.getInt("STORAGE_EXTENT_ID"));
        this.setTotalNumExtents(DBrs.getInt("TOTAL_NUM_EXTENTS"));
        this.setUpdateTimestamp(DBrs.getTimestamp("UPDATE_TIMESTAMP"));
    }

    public static class Volume2extentSnapshotCursor
    extends DBCursor {
        private Volume2extentSnapshot element = new Volume2extentSnapshot();
        private DBConnection con;

        public Volume2extentSnapshotCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
            super("T_RES_VOLUME2EXTENT_SNAPSHOT", con, htWhereClause, columns);
            this.con = con;
        }

        public Volume2extentSnapshot getObject() throws SQLException {
            Volume2extentSnapshot el = null;
            if (this.DBrs != null) {
                el = new Volume2extentSnapshot();
                el.setFields(this.con, this.DBrs);
            }
            return el;
        }

        public Volume2extentSnapshot getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

