/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.Normalizer;
import org.eclipse.aperi.infrastructure.database.tables.TViewVtapeLibraryTable;

public class VtapeLibrary
extends TViewVtapeLibraryTable {
    private String m_VendorId_str;
    private String m_ModelId_str;

    public void setVendor(String el) {
        this.m_VendorId_str = el;
    }

    public String getVendor() {
        return this.m_VendorId_str;
    }

    public void setModel(String el) {
        this.m_ModelId_str = el;
    }

    public String getModel() {
        return this.m_ModelId_str;
    }

    public static VtapeLibraryCursor getCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
        return new VtapeLibraryCursor(con, htWhereClause, columns);
    }

    public VtapeLibrary() {
        this.clear();
    }

    public VtapeLibrary(String PrefixId, int TapeLibraryId, String DisplayName, String Name2, String FirmwareVersion, int MaxCartridges, short VendorId, short ModelId, String SerialNumber, String AccessInfo, short Detectable, int OperationalStatus, short ConsolidatedStatus, short PropagatedStatus, int TotalDrives, int TotalCartridges, String UserAttrib1, String UserAttrib2, String UserAttrib3) {
        this.clear();
        this.m_PrefixId = PrefixId;
        this.m_TapeLibraryId = TapeLibraryId;
        this.m_DisplayName = DisplayName;
        this.m_Name = Name2;
        this.m_FirmwareVersion = FirmwareVersion;
        this.m_MaxCartridges = MaxCartridges;
        this.m_VendorId = VendorId;
        this.m_ModelId = ModelId;
        this.m_SerialNumber = SerialNumber;
        this.m_AccessInfo = AccessInfo;
        this.m_Detectable = Detectable;
        this.m_OperationalStatus = OperationalStatus;
        this.m_ConsolidatedStatus = ConsolidatedStatus;
        this.m_PropagatedStatus = PropagatedStatus;
        this.m_TotalDrives = TotalDrives;
        this.m_TotalCartridges = TotalCartridges;
        this.m_UserAttrib1 = UserAttrib1;
        this.m_UserAttrib2 = UserAttrib2;
        this.m_UserAttrib3 = UserAttrib3;
    }

    private void setNonKeyValues(Hashtable htColsAndValues) {
        if (this.m_PrefixId != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(VtapeLibrary.getColumnInfo("PREFIX_ID"), this.m_PrefixId);
        }
        if (this.m_TapeLibraryId != Integer.MIN_VALUE) {
            htColsAndValues.put(VtapeLibrary.getColumnInfo("TAPE_LIBRARY_ID"), String.valueOf(this.m_TapeLibraryId));
        }
        if (this.m_DisplayName != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(VtapeLibrary.getColumnInfo("DISPLAY_NAME"), this.m_DisplayName);
        }
        if (this.m_Name != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(VtapeLibrary.getColumnInfo("NAME"), this.m_Name);
        }
        if (this.m_FirmwareVersion != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(VtapeLibrary.getColumnInfo("FIRMWARE_VERSION"), this.m_FirmwareVersion);
        }
        if (this.m_MaxCartridges != Integer.MIN_VALUE) {
            htColsAndValues.put(VtapeLibrary.getColumnInfo("MAX_CARTRIDGES"), String.valueOf(this.m_MaxCartridges));
        }
        if (this.m_VendorId != Short.MIN_VALUE) {
            htColsAndValues.put(VtapeLibrary.getColumnInfo("VENDOR_ID"), String.valueOf(this.m_VendorId));
        }
        if (this.m_ModelId != Short.MIN_VALUE) {
            htColsAndValues.put(VtapeLibrary.getColumnInfo("MODEL_ID"), String.valueOf(this.m_ModelId));
        }
        if (this.m_SerialNumber != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(VtapeLibrary.getColumnInfo("SERIAL_NUMBER"), this.m_SerialNumber);
        }
        if (this.m_AccessInfo != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(VtapeLibrary.getColumnInfo("ACCESS_INFO"), this.m_AccessInfo);
        }
        if (this.m_Detectable != Short.MIN_VALUE) {
            htColsAndValues.put(VtapeLibrary.getColumnInfo("DETECTABLE"), String.valueOf(this.m_Detectable));
        }
        if (this.m_OperationalStatus != Integer.MIN_VALUE) {
            htColsAndValues.put(VtapeLibrary.getColumnInfo("OPERATIONAL_STATUS"), String.valueOf(this.m_OperationalStatus));
        }
        if (this.m_ConsolidatedStatus != Short.MIN_VALUE) {
            htColsAndValues.put(VtapeLibrary.getColumnInfo("CONSOLIDATED_STATUS"), String.valueOf(this.m_ConsolidatedStatus));
        }
        if (this.m_PropagatedStatus != Short.MIN_VALUE) {
            htColsAndValues.put(VtapeLibrary.getColumnInfo("PROPAGATED_STATUS"), String.valueOf(this.m_PropagatedStatus));
        }
        if (this.m_TotalDrives != Integer.MIN_VALUE) {
            htColsAndValues.put(VtapeLibrary.getColumnInfo("TOTAL_DRIVES"), String.valueOf(this.m_TotalDrives));
        }
        if (this.m_TotalCartridges != Integer.MIN_VALUE) {
            htColsAndValues.put(VtapeLibrary.getColumnInfo("TOTAL_CARTRIDGES"), String.valueOf(this.m_TotalCartridges));
        }
        if (this.m_UserAttrib1 != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(VtapeLibrary.getColumnInfo("USER_ATTRIB1"), this.m_UserAttrib1);
        }
        if (this.m_UserAttrib2 != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(VtapeLibrary.getColumnInfo("USER_ATTRIB2"), this.m_UserAttrib2);
        }
        if (this.m_UserAttrib3 != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(VtapeLibrary.getColumnInfo("USER_ATTRIB3"), this.m_UserAttrib3);
        }
    }

    public boolean insert(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(con, this.m_VendorId_str);
        }
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(con, this.m_ModelId_str);
        }
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_VIEW_VTAPE_LIBRARY", con, this.htColsAndValues);
    }

    public boolean insert(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(VtapeLibrary.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(VtapeLibrary.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(VtapeLibrary.getColumnInfo("VENDOR_ID")))));
        }
        if (htinput.get(VtapeLibrary.getColumnInfo("MODEL_ID")) != null) {
            htinput.put(VtapeLibrary.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htinput.get(VtapeLibrary.getColumnInfo("MODEL_ID")))));
        }
        return DBQueryAssistant.performInsert("T_VIEW_VTAPE_LIBRARY", con, htinput);
    }

    public int update(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(con, this.m_VendorId_str);
        }
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(con, this.m_ModelId_str);
        }
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_VIEW_VTAPE_LIBRARY", con, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(VtapeLibrary.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(VtapeLibrary.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(VtapeLibrary.getColumnInfo("VENDOR_ID")))));
        }
        if (htinput.get(VtapeLibrary.getColumnInfo("MODEL_ID")) != null) {
            htinput.put(VtapeLibrary.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htinput.get(VtapeLibrary.getColumnInfo("MODEL_ID")))));
        }
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_VIEW_VTAPE_LIBRARY", con, htinput, this.htWhereClause);
    }

    public int delete(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(con, this.m_VendorId_str);
        }
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(con, this.m_ModelId_str);
        }
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_VIEW_VTAPE_LIBRARY", con, this.htWhereClause);
    }

    public int delete(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(VtapeLibrary.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(VtapeLibrary.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(VtapeLibrary.getColumnInfo("VENDOR_ID")))));
        }
        if (htinput.get(VtapeLibrary.getColumnInfo("MODEL_ID")) != null) {
            htinput.put(VtapeLibrary.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htinput.get(VtapeLibrary.getColumnInfo("MODEL_ID")))));
        }
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_VIEW_VTAPE_LIBRARY", con, this.htWhereClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieve(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(con, this.m_VendorId_str);
        }
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(con, this.m_ModelId_str);
        }
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        boolean res = false;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_VIEW_VTAPE_LIBRARY", con, this.htWhereClause, null);
            if (DBrs.next()) {
                this.setFields(con, DBrs);
                res = true;
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VtapeLibrary retrieve(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable htWhereClause = new Hashtable();
        VtapeLibrary el = null;
        if (htinput.get(VtapeLibrary.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(VtapeLibrary.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(VtapeLibrary.getColumnInfo("VENDOR_ID")))));
        }
        if (htinput.get(VtapeLibrary.getColumnInfo("MODEL_ID")) != null) {
            htinput.put(VtapeLibrary.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htinput.get(VtapeLibrary.getColumnInfo("MODEL_ID")))));
        }
        if (htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_VIEW_VTAPE_LIBRARY", con, htWhereClause, null);
            if (DBrs.next()) {
                el = new VtapeLibrary();
                el.setFields(con, DBrs);
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return el;
    }

    public static int update(DBConnection con, Hashtable htinput, Hashtable htWhereClause) throws SQLException {
        if (con == null || htinput == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(VtapeLibrary.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(VtapeLibrary.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(VtapeLibrary.getColumnInfo("VENDOR_ID")))));
        }
        if (htinput.get(VtapeLibrary.getColumnInfo("MODEL_ID")) != null) {
            htinput.put(VtapeLibrary.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htinput.get(VtapeLibrary.getColumnInfo("MODEL_ID")))));
        }
        if (htWhereClause.get(VtapeLibrary.getColumnInfo("VENDOR_ID")) != null) {
            htWhereClause.put(VtapeLibrary.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htWhereClause.get(VtapeLibrary.getColumnInfo("VENDOR_ID")))));
        }
        if (htWhereClause.get(VtapeLibrary.getColumnInfo("MODEL_ID")) != null) {
            htWhereClause.put(VtapeLibrary.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htWhereClause.get(VtapeLibrary.getColumnInfo("MODEL_ID")))));
        }
        return DBQueryAssistant.performUpdate("T_VIEW_VTAPE_LIBRARY", con, htinput, htWhereClause);
    }

    public static int deletes(DBConnection con, Hashtable htWhereClause) throws SQLException {
        if (con == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htWhereClause.get(VtapeLibrary.getColumnInfo("VENDOR_ID")) != null) {
            htWhereClause.put(VtapeLibrary.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htWhereClause.get(VtapeLibrary.getColumnInfo("VENDOR_ID")))));
        }
        if (htWhereClause.get(VtapeLibrary.getColumnInfo("MODEL_ID")) != null) {
            htWhereClause.put(VtapeLibrary.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htWhereClause.get(VtapeLibrary.getColumnInfo("MODEL_ID")))));
        }
        return DBQueryAssistant.performDelete("T_VIEW_VTAPE_LIBRARY", con, htWhereClause);
    }

    protected void setFields(DBConnection con, DBResultSet DBrs) throws SQLException {
        this.setPrefixId(DBrs.getString("PREFIX_ID"));
        this.setTapeLibraryId(DBrs.getInt("TAPE_LIBRARY_ID"));
        this.setDisplayName(DBrs.getString("DISPLAY_NAME"));
        this.setName(DBrs.getString("NAME"));
        this.setFirmwareVersion(DBrs.getString("FIRMWARE_VERSION"));
        this.setMaxCartridges(DBrs.getInt("MAX_CARTRIDGES"));
        this.setVendorId(DBrs.getShort("VENDOR_ID"));
        this.setVendor(Normalizer.VendorGetName(con, this.m_VendorId));
        this.setModelId(DBrs.getShort("MODEL_ID"));
        this.setModel(Normalizer.ModelGetName(con, this.m_ModelId));
        this.setSerialNumber(DBrs.getString("SERIAL_NUMBER"));
        this.setAccessInfo(DBrs.getString("ACCESS_INFO"));
        this.setDetectable(DBrs.getShort("DETECTABLE"));
        this.setOperationalStatus(DBrs.getInt("OPERATIONAL_STATUS"));
        this.setConsolidatedStatus(DBrs.getShort("CONSOLIDATED_STATUS"));
        this.setPropagatedStatus(DBrs.getShort("PROPAGATED_STATUS"));
        this.setTotalDrives(DBrs.getInt("TOTAL_DRIVES"));
        this.setTotalCartridges(DBrs.getInt("TOTAL_CARTRIDGES"));
        this.setUserAttrib1(DBrs.getString("USER_ATTRIB1"));
        this.setUserAttrib2(DBrs.getString("USER_ATTRIB2"));
        this.setUserAttrib3(DBrs.getString("USER_ATTRIB3"));
    }

    public static class VtapeLibraryCursor
    extends DBCursor {
        private VtapeLibrary element = new VtapeLibrary();
        private DBConnection con;

        private static Hashtable normalize(DBConnection con, Hashtable htWhereClause) throws SQLException {
            if (htWhereClause == null) {
                return null;
            }
            if (htWhereClause.get(TViewVtapeLibraryTable.getColumnInfo("VENDOR_ID")) != null) {
                htWhereClause.put(TViewVtapeLibraryTable.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htWhereClause.get(TViewVtapeLibraryTable.getColumnInfo("VENDOR_ID")))));
            }
            if (htWhereClause.get(TViewVtapeLibraryTable.getColumnInfo("MODEL_ID")) != null) {
                htWhereClause.put(TViewVtapeLibraryTable.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htWhereClause.get(TViewVtapeLibraryTable.getColumnInfo("MODEL_ID")))));
            }
            return htWhereClause;
        }

        public VtapeLibraryCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
            super("T_VIEW_VTAPE_LIBRARY", con, VtapeLibraryCursor.normalize(con, htWhereClause), columns);
            this.con = con;
        }

        public VtapeLibrary getObject() throws SQLException {
            VtapeLibrary el = null;
            if (this.DBrs != null) {
                el = new VtapeLibrary();
                el.setFields(this.con, this.DBrs);
            }
            return el;
        }

        public VtapeLibrary getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

