/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.history.snapshot;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import org.eclipse.aperi.infrastructure.database.AutoIdentifier;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.CurrentTime;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.ParameterizedSql;
import org.eclipse.aperi.infrastructure.database.objects.CimkeyPortSnapshot;
import org.eclipse.aperi.infrastructure.database.objects.CimkeySwitchSnapshot;
import org.eclipse.aperi.infrastructure.database.objects.ModelSnapshot;
import org.eclipse.aperi.infrastructure.database.objects.PortSnapshot;
import org.eclipse.aperi.infrastructure.database.objects.SnapshotMetadata;
import org.eclipse.aperi.infrastructure.database.objects.Switch;
import org.eclipse.aperi.infrastructure.database.objects.Switch2portSnapshot;
import org.eclipse.aperi.infrastructure.database.objects.SwitchSnapshot;
import org.eclipse.aperi.infrastructure.database.objects.VendorSnapshot;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeyPortSnapshotTable;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeySwitchSnapshotTable;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeySwitchTable;
import org.eclipse.aperi.infrastructure.database.tables.TResModelSnapshotTable;
import org.eclipse.aperi.infrastructure.database.tables.TResPortSnapshotTable;
import org.eclipse.aperi.infrastructure.database.tables.TResSnapshotMetadataTable;
import org.eclipse.aperi.infrastructure.database.tables.TResSwitch2portSnapshotTable;
import org.eclipse.aperi.infrastructure.database.tables.TResSwitch2portTable;
import org.eclipse.aperi.infrastructure.database.tables.TResSwitchSnapshotTable;
import org.eclipse.aperi.infrastructure.database.tables.TResSwitchTable;
import org.eclipse.aperi.infrastructure.database.tables.TResVendorSnapshotTable;
import org.eclipse.aperi.infrastructure.history.snapshot.SnapshotUtil;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;

public class SnapshotSwitch {
    private static String SWITCH_TABLE = "T_RES_SWITCH";
    private static String SWITCH2PORT_TABLE = "T_RES_SWITCH2PORT";
    private static String PORT_TABLE = "T_RES_PORT";
    private static String CIMKEY_SWITCH_TABLE = "T_RES_CIMKEY_SWITCH";
    private static String CIMKEY_PORT_TABLE = "T_RES_CIMKEY_PORT";
    private static String VENDOR_TABLE = "T_RES_VENDOR";
    private static String MODEL_TABLE = "T_RES_MODEL";
    private static ILogger traceLogger = null;
    private static String className = SnapshotSwitch.class.getName();
    private static boolean TRACE = false;

    static int create(DBConnection sqlConn, int switchId) throws Exception {
        String methodName = "create(" + switchId + ")";
        int snapshotId = -1;
        Hashtable<ColumnInfo, String> htWhereClause = new Hashtable<ColumnInfo, String>();
        Switch mySwitch = null;
        DBCursor myCursor = null;
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        try {
            htWhereClause.put(TResSwitchTable.getColumnInfo("SWITCH_ID"), String.valueOf(switchId));
            myCursor = Switch.getCursor(sqlConn, htWhereClause, null);
            if (myCursor.next()) {
                mySwitch = ((Switch.SwitchCursor)myCursor).getAttributes();
            }
            if (mySwitch == null) {
                Exception ex = new Exception("Bad system ID: " + switchId);
                if (TRACE) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, ex);
                }
                throw ex;
            }
            snapshotId = AutoIdentifier.getIdentifier(9, 1);
            Timestamp currTs = CurrentTime.getTimestamp(sqlConn);
            SnapshotUtil.createSnapshotMetadata(sqlConn, snapshotId, currTs, switchId, 2, true);
            SnapshotSwitch.createSwitchSnapshot(sqlConn, mySwitch, snapshotId, SWITCH_TABLE);
            SnapshotSwitch.createCimkeySwitchSnapshot(sqlConn, mySwitch, snapshotId, CIMKEY_SWITCH_TABLE);
            SnapshotSwitch.createVendorSnapshot(sqlConn, mySwitch, snapshotId, VENDOR_TABLE);
            SnapshotSwitch.createModelSnapshot(sqlConn, mySwitch, snapshotId, MODEL_TABLE);
            SnapshotSwitch.createPortSnapshot(sqlConn, mySwitch, snapshotId, PORT_TABLE);
            SnapshotSwitch.createSwitch2PortSnapshot(sqlConn, mySwitch, snapshotId, SWITCH2PORT_TABLE);
            SnapshotSwitch.createCimkeyPortSnapshot(sqlConn, mySwitch, snapshotId, CIMKEY_PORT_TABLE);
        }
        catch (SQLException sqlEx) {
            try {
                sqlConn.rollback();
            }
            catch (SQLException sqlEx1) {
                // empty catch block
            }
            if (TRACE) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, sqlEx);
            }
            throw sqlEx;
        }
        finally {
            if (myCursor != null) {
                myCursor.close();
            }
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
        return snapshotId;
    }

    static void delete(DBConnection sqlConn, int snapshotId) throws SQLException {
        String methodName = "delete(" + snapshotId + ")";
        Hashtable<ColumnInfo, String> htWhereClause = new Hashtable<ColumnInfo, String>();
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        try {
            htWhereClause.clear();
            htWhereClause.put(TResCimkeyPortSnapshotTable.getColumnInfo("SNAPSHOT_ID"), String.valueOf(snapshotId));
            CimkeyPortSnapshot.deletes(sqlConn, htWhereClause);
            htWhereClause.clear();
            htWhereClause.put(TResSwitch2portSnapshotTable.getColumnInfo("SNAPSHOT_ID"), String.valueOf(snapshotId));
            Switch2portSnapshot.deletes(sqlConn, htWhereClause);
            htWhereClause.clear();
            htWhereClause.put(TResPortSnapshotTable.getColumnInfo("SNAPSHOT_ID"), String.valueOf(snapshotId));
            PortSnapshot.deletes(sqlConn, htWhereClause);
            htWhereClause.clear();
            htWhereClause.put(TResModelSnapshotTable.getColumnInfo("SNAPSHOT_ID"), String.valueOf(snapshotId));
            ModelSnapshot.deletes(sqlConn, htWhereClause);
            htWhereClause.clear();
            htWhereClause.put(TResVendorSnapshotTable.getColumnInfo("SNAPSHOT_ID"), String.valueOf(snapshotId));
            VendorSnapshot.deletes(sqlConn, htWhereClause);
            htWhereClause.clear();
            htWhereClause.put(TResCimkeySwitchSnapshotTable.getColumnInfo("SNAPSHOT_ID"), String.valueOf(snapshotId));
            CimkeySwitchSnapshot.deletes(sqlConn, htWhereClause);
            htWhereClause.put(TResSwitchSnapshotTable.getColumnInfo("SNAPSHOT_ID"), String.valueOf(snapshotId));
            SwitchSnapshot.deletes(sqlConn, htWhereClause);
            htWhereClause.put(TResSnapshotMetadataTable.getColumnInfo("SNAPSHOT_ID"), String.valueOf(snapshotId));
            SnapshotMetadata.deletes(sqlConn, htWhereClause);
        }
        catch (SQLException sqlEx) {
            try {
                sqlConn.rollback();
            }
            catch (SQLException sqlEx1) {
                // empty catch block
            }
            if (TRACE) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, sqlEx);
            }
            throw sqlEx;
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
    }

    private static void createSwitchSnapshot(DBConnection sqlConn, Switch mySwitch, int snapshotId, String tableName) throws SQLException {
        String methodName = "createSwitchSnapshot(" + snapshotId + ", " + tableName + ")";
        Hashtable<String, String> tokenParams = new Hashtable<String, String>();
        Hashtable<ColumnInfo, String> sqlParams = new Hashtable<ColumnInfo, String>();
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        try {
            String snapCreateSqlStmt = SnapshotUtil.getSnapshotCreationStmt(2, tableName);
            if (snapCreateSqlStmt != null) {
                tokenParams.put("<<SNAPSHOT_ID>>", String.valueOf(snapshotId));
                sqlParams.put(TResSwitchTable.getColumnInfo("SWITCH_WWN"), mySwitch.getSwitchWwn());
                ParameterizedSql.sqlUpdate(sqlConn, snapCreateSqlStmt, tokenParams, sqlParams);
            }
        }
        catch (SQLException sqlEx) {
            if (TRACE) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, sqlEx);
            }
            throw sqlEx;
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
    }

    private static void createSwitch2PortSnapshot(DBConnection sqlConn, Switch mySwitch, int snapshotId, String tableName) throws SQLException {
        String methodName = "createSwitch2PortSnapshot(" + snapshotId + ", " + tableName + ")";
        Hashtable<String, String> tokenParams = new Hashtable<String, String>();
        Hashtable<ColumnInfo, String> sqlParams = new Hashtable<ColumnInfo, String>();
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        try {
            String snapCreateSqlStmt = SnapshotUtil.getSnapshotCreationStmt(2, tableName);
            if (snapCreateSqlStmt != null) {
                tokenParams.put("<<SNAPSHOT_ID>>", String.valueOf(snapshotId));
                sqlParams.put(TResSwitch2portTable.getColumnInfo("SWITCH_WWN"), mySwitch.getSwitchWwn());
                ParameterizedSql.sqlUpdate(sqlConn, snapCreateSqlStmt, tokenParams, sqlParams);
            }
        }
        catch (SQLException sqlEx) {
            if (TRACE) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, sqlEx);
            }
            throw sqlEx;
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
    }

    private static void createPortSnapshot(DBConnection sqlConn, Switch mySwitch, int snapshotId, String tableName) throws SQLException {
        String methodName = "createPortSnapshot(" + snapshotId + ", " + tableName + ")";
        Hashtable<String, String> tokenParams = new Hashtable<String, String>();
        Hashtable<ColumnInfo, String> sqlParams = new Hashtable<ColumnInfo, String>();
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        try {
            String snapCreateSqlStmt = SnapshotUtil.getSnapshotCreationStmt(2, tableName);
            if (snapCreateSqlStmt != null) {
                tokenParams.put("<<SNAPSHOT_ID>>", String.valueOf(snapshotId));
                sqlParams.put(TResSwitch2portTable.getColumnInfo("SWITCH_WWN"), mySwitch.getSwitchWwn());
                ParameterizedSql.sqlUpdate(sqlConn, snapCreateSqlStmt, tokenParams, sqlParams);
            }
        }
        catch (SQLException sqlEx) {
            if (TRACE) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, sqlEx);
            }
            throw sqlEx;
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
    }

    private static void createCimkeySwitchSnapshot(DBConnection sqlConn, Switch mySwitch, int snapshotId, String tableName) throws SQLException {
        String methodName = "createCimkeySwitchSnapshot(" + snapshotId + ", " + tableName + ")";
        Hashtable<String, String> tokenParams = new Hashtable<String, String>();
        Hashtable<ColumnInfo, String> sqlParams = new Hashtable<ColumnInfo, String>();
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        try {
            String snapCreateSqlStmt = SnapshotUtil.getSnapshotCreationStmt(2, tableName);
            if (snapCreateSqlStmt != null) {
                tokenParams.put("<<SNAPSHOT_ID>>", String.valueOf(snapshotId));
                sqlParams.put(TResCimkeySwitchTable.getColumnInfo("SWITCH_WWN"), mySwitch.getSwitchWwn());
                ParameterizedSql.sqlUpdate(sqlConn, snapCreateSqlStmt, tokenParams, sqlParams);
            }
        }
        catch (SQLException sqlEx) {
            if (TRACE) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, sqlEx);
            }
            throw sqlEx;
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
    }

    private static void createCimkeyPortSnapshot(DBConnection sqlConn, Switch mySwitch, int snapshotId, String tableName) throws SQLException {
        String methodName = "createCimkeyPortSnapshot(" + snapshotId + ", " + tableName + ")";
        Hashtable<String, String> tokenParams = new Hashtable<String, String>();
        Hashtable<ColumnInfo, String> sqlParams = new Hashtable<ColumnInfo, String>();
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        try {
            String snapCreateSqlStmt = SnapshotUtil.getSnapshotCreationStmt(2, tableName);
            if (snapCreateSqlStmt != null) {
                tokenParams.put("<<SNAPSHOT_ID>>", String.valueOf(snapshotId));
                sqlParams.put(TResSwitch2portTable.getColumnInfo("SWITCH_WWN"), mySwitch.getSwitchWwn());
                ParameterizedSql.sqlUpdate(sqlConn, snapCreateSqlStmt, tokenParams, sqlParams);
            }
        }
        catch (SQLException sqlEx) {
            if (TRACE) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, sqlEx);
            }
            throw sqlEx;
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
    }

    private static void createVendorSnapshot(DBConnection sqlConn, Switch mySwitch, int snapshotId, String tableName) throws SQLException {
        String methodName = "createVendorSnapshot(" + snapshotId + ", " + tableName + ")";
        Hashtable<String, String> tokenParams = new Hashtable<String, String>();
        Hashtable<ColumnInfo, String> sqlParams = new Hashtable<ColumnInfo, String>();
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        try {
            String snapCreateSqlStmt = SnapshotUtil.getSnapshotCreationStmt(2, tableName);
            if (snapCreateSqlStmt != null) {
                tokenParams.put("<<SNAPSHOT_ID>>", String.valueOf(snapshotId));
                sqlParams.put(TResSwitchTable.getColumnInfo("SWITCH_WWN"), mySwitch.getSwitchWwn());
                ParameterizedSql.sqlUpdate(sqlConn, snapCreateSqlStmt, tokenParams, sqlParams);
            }
        }
        catch (SQLException sqlEx) {
            if (TRACE) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, sqlEx);
            }
            throw sqlEx;
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
    }

    private static void createModelSnapshot(DBConnection sqlConn, Switch mySwitch, int snapshotId, String tableName) throws SQLException {
        String methodName = "createModelSnapshot(" + snapshotId + ", " + tableName + ")";
        Hashtable<String, String> tokenParams = new Hashtable<String, String>();
        Hashtable<ColumnInfo, String> sqlParams = new Hashtable<ColumnInfo, String>();
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        try {
            String snapCreateSqlStmt = SnapshotUtil.getSnapshotCreationStmt(2, tableName);
            if (snapCreateSqlStmt != null) {
                tokenParams.put("<<SNAPSHOT_ID>>", String.valueOf(snapshotId));
                sqlParams.put(TResSwitchTable.getColumnInfo("SWITCH_WWN"), mySwitch.getSwitchWwn());
                ParameterizedSql.sqlUpdate(sqlConn, snapCreateSqlStmt, tokenParams, sqlParams);
            }
        }
        catch (SQLException sqlEx) {
            if (TRACE) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, sqlEx);
            }
            throw sqlEx;
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
    }

    static {
        traceLogger = DBConstants.getLogger();
        if (traceLogger != null) {
            TRACE = traceLogger.isLogging();
        }
    }
}

