/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.history.snapshot;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.aperi.infrastructure.database.ClassHelper;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.objects.SnapshotMetadata;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;

public class SnapshotUtil {
    static final String SNAPSHOT_TABLE_SUFFIX = "_SNAPSHOT";
    static final String SNAPSHOT_ID_COLNAME = "SNAPSHOT_ID";
    static final String SNAPSHOT_ID_TOKEN = "<<SNAPSHOT_ID>>";
    private static String insertStmtTemplate = "INSERT INTO <<BASE_TABLE>>_SNAPSHOT (SNAPSHOT_ID <<COLLIST>>) SELECT <<SNAPSHOT_ID>> <<QUALIFIED_COLLIST>> FROM <<BASE_TABLE>> T1 <<WHERE_CLAUSE>>";
    private static String[][] subsystemSnapshotCreationStmtTemplates = new String[][]{{"T_RES_STORAGE_SUBSYSTEM", "WHERE T1.SUBSYSTEM_ID = ?"}, {"T_RES_STORAGE_POOL", "WHERE T1.SUBSYSTEM_ID = ?"}, {"T_RES_STORAGE_EXTENT", "WHERE T1.SUBSYSTEM_ID = ?"}, {"T_RES_DISK_GROUP", "WHERE T1.SUBSYSTEM_ID = ?"}, {"T_RES_STORAGE_VOLUME", "WHERE T1.POOL_ID = ? AND T1.SUBSYSTEM_ID = ?"}, {"T_RES_VOLUME2EXTENT", ", T_RES_STORAGE_VOLUME T2 WHERE T1.VOLUME_ID = T2.SVID AND T2.POOL_ID = ? AND T2.SUBSYSTEM_ID = ?"}, {"T_RES_PORT", "WHERE T1.SUBSYSTEM_ID = ?"}, {"T_RES_NODE", "WHERE T1.SYSTEM_ID = ?"}, {"T_RES_CIMKEY_SUBSYSTEM", "WHERE T1.SUBSYSTEM_ID = ?"}, {"T_RES_VENDOR", ", T_RES_STORAGE_SUBSYSTEM T2 WHERE T1.VENDOR_ID = T2.VENDOR_ID AND T2.SUBSYSTEM_ID = ?"}, {"T_RES_MODEL", ", T_RES_STORAGE_SUBSYSTEM T2 WHERE T1.MODEL_ID = T2.MODEL_ID AND T2.SUBSYSTEM_ID = ?"}, {"T_RES_CIMKEY_PORT", ", T_RES_PORT T2 WHERE T2.PORT_ID = T1.PORT_ID AND T2.SUBSYSTEM_ID = ?"}, {"T_RES_CIMKEY_VOLUME", ", T_RES_STORAGE_VOLUME T2 WHERE T1.VOLUME_ID = T2.SVID AND T2.POOL_ID = ? AND T2.SUBSYSTEM_ID = ?"}, {"T_RES_IO_GROUP", "WHERE T1.SUBSYSTEM_ID = ?"}};
    private static String[][] switchSnapshotCreationStmtTemplates = new String[][]{{"T_RES_SWITCH", "WHERE T1.SWITCH_WWN = ?"}, {"T_RES_SWITCH2PORT", "WHERE T1.SWITCH_WWN = ?"}, {"T_RES_PORT", ", T_RES_SWITCH2PORT T2 WHERE T1.PORT_ID = T2.PORT_ID AND T2.SWITCH_WWN = ?"}, {"T_RES_CIMKEY_SWITCH", "WHERE T1.SWITCH_WWN = ?"}, {"T_RES_CIMKEY_PORT", ", T_RES_SWITCH2PORT T2 WHERE T1.PORT_ID = T2.PORT_ID AND T2.SWITCH_WWN = ?"}, {"T_RES_VENDOR", ", T_RES_SWITCH T2 WHERE T1.VENDOR_ID = T2.VENDOR_ID AND T2.SWITCH_WWN = ?"}, {"T_RES_MODEL", ", T_RES_SWITCH T2 WHERE T1.MODEL_ID = T2.MODEL_ID AND T2.SWITCH_WWN = ?"}};
    private static String[][] cimomSnapshotCreationStmtTemplates = new String[][]{{"T_RES_REGISTERED_CIMOM", "WHERE T1.REG_CIMOM_ID = ?"}, {"T_RES_CIMOM2NAMESPACE", "WHERE T1.CIMOM_ID = ?"}};
    private static Hashtable subsystemSnapshotSqlHtab = new Hashtable();
    private static Hashtable switchSnapshotSqlHtab = new Hashtable();
    private static Hashtable cimomSnapshotSqlHtab = new Hashtable();
    private static ILogger traceLogger = null;
    private static String className = SnapshotUtil.class.getName();
    private static boolean TRACE = false;

    static SnapshotMetadata createSnapshotMetadata(DBConnection sqlConn, int snapshotId, Timestamp currTs, int systemId, int systemType, boolean consistent) throws SQLException {
        String methodName = "createSnapshotMetadata";
        SnapshotMetadata snapMd = new SnapshotMetadata();
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        snapMd.setSnapshotId(snapshotId);
        snapMd.setSnapshotTime(currTs);
        snapMd.setSystemId(systemId);
        snapMd.setSystemType((short)systemType);
        snapMd.setSnapshotConsistent(consistent ? (short)1 : 0);
        snapMd.setSnapshotType((short)1);
        snapMd.insert(sqlConn);
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
        return snapMd;
    }

    static String getSnapshotCreationStmt(int systemType, String tableName) {
        String methodName = "getSnapshotCreationStmt(" + systemType + ", " + tableName + ")";
        String dbStmtStr = null;
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        if (systemType == 1) {
            dbStmtStr = (String)subsystemSnapshotSqlHtab.get(tableName);
        } else if (systemType == 2) {
            dbStmtStr = (String)switchSnapshotSqlHtab.get(tableName);
        } else if (systemType == 3) {
            dbStmtStr = (String)cimomSnapshotSqlHtab.get(tableName);
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
        return dbStmtStr;
    }

    private static void genSnapshotCreationSqlStmts(Hashtable snapshotSqlHtab, String[][] tablesAndWhereClauses) {
        String methodName = "genSnapshotCreationSqlStmts";
        StringBuffer colList = new StringBuffer(100);
        StringBuffer qualColList = new StringBuffer(100);
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        for (int i = 0; i < tablesAndWhereClauses.length; ++i) {
            if (colList.length() > 0) {
                colList.delete(0, colList.length());
            }
            if (qualColList.length() > 0) {
                qualColList.delete(0, qualColList.length());
            }
            String insertStr = insertStmtTemplate;
            try {
                Class<?> tableClass = ClassHelper.getObject(tablesAndWhereClauses[i][0] + SNAPSHOT_TABLE_SUFFIX).getClass().getSuperclass();
                Hashtable h = (Hashtable)tableClass.getDeclaredMethod("getColumns", null).invoke(tableClass, null);
                Enumeration e = h.elements();
                while (e.hasMoreElements()) {
                    String colName = ((ColumnInfo)e.nextElement()).getName();
                    if (colName.equals(SNAPSHOT_ID_COLNAME)) continue;
                    colList.append(", " + colName);
                    qualColList.append(", T1." + colName);
                }
                insertStr = insertStr.replaceAll("<<BASE_TABLE>>", tablesAndWhereClauses[i][0]);
                insertStr = insertStr.replaceAll("<<COLLIST>>", colList.toString());
                insertStr = insertStr.replaceAll("<<QUALIFIED_COLLIST>>", qualColList.toString());
                insertStr = insertStr.replaceAll("<<WHERE_CLAUSE>>", tablesAndWhereClauses[i][1]);
                snapshotSqlHtab.put(tablesAndWhereClauses[i][0], insertStr);
                continue;
            }
            catch (Exception ex) {
                if (TRACE) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, ex);
                    continue;
                }
                ex.printStackTrace();
            }
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
    }

    static {
        traceLogger = DBConstants.getLogger();
        if (traceLogger != null) {
            TRACE = traceLogger.isLogging();
        }
        SnapshotUtil.genSnapshotCreationSqlStmts(subsystemSnapshotSqlHtab, subsystemSnapshotCreationStmtTemplates);
        SnapshotUtil.genSnapshotCreationSqlStmts(switchSnapshotSqlHtab, switchSnapshotCreationStmtTemplates);
        SnapshotUtil.genSnapshotCreationSqlStmts(cimomSnapshotSqlHtab, cimomSnapshotCreationStmtTemplates);
    }
}

