/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.AutoIdentifier;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.objects.SwitchBlade;
import org.eclipse.aperi.infrastructure.database.objects.SwitchBladeType;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.MapperInfo;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;

public class BladeXmlToDBMapper
extends DBAttributeMapper {
    private static final String VENDOR = "Vendor";
    private static final String SERIALNUMBER = "SerialNumber";
    private static final String TYPE = "Type";
    private static final String STATUS = "Status";
    private static final String CONSTATUS = "ConStatus";
    private static final String SLOT = "Slot";
    private static final String MODEL = "Model";
    private static final String FIRMWAREVERSION = "Firmware Version";
    protected static final String SWITCHWWN = "Switch WWN";

    public static DBAttributeMapper.RegistrationData[] getRegistrationData() {
        String mCIMClass = "BladeXml";
        String mSMIS = null;
        String mDeviceType = null;
        String mAgentVersion = null;
        DBAttributeMapper.RegistrationData mR1 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion);
        return new DBAttributeMapper.RegistrationData[]{mR1};
    }

    public BladeXmlToDBMapper() {
        System.out.println("Constructor of FcBladeXmlToDBMapper");
        this.m_dataConverter.addComplexDataConversion(VENDOR.toLowerCase(), ":", 2);
        this.m_dataConverter.addComplexDataConversion(SERIALNUMBER.toLowerCase(), ":", 3);
        this.m_dataConverter.addComplexDataConversion(SWITCHWWN.toLowerCase(), ":", 2);
        ColumnInfo vendor = SwitchBlade.getColumnInfo("VENDOR_ID");
        vendor.setIsPrimaryKey();
        MapperInfo vendorMap = new MapperInfo(vendor);
        ColumnInfo autoID = SwitchBlade.getColumnInfo("SWITCH_BLADE_ID");
        autoID.setAutoGenerated();
        vendorMap.setDerivedColumn(autoID);
        this.m_htAttribToMapperInfo.put(VENDOR.toLowerCase(), vendorMap);
        ColumnInfo serialnumber = SwitchBlade.getColumnInfo("SERIAL_NUMBER");
        serialnumber.setIsPrimaryKey();
        this.m_htAttribToMapperInfo.put(SERIALNUMBER.toLowerCase(), new MapperInfo(serialnumber));
        ColumnInfo slot = SwitchBlade.getColumnInfo("SLOT");
        this.m_htAttribToMapperInfo.put(SLOT.toLowerCase(), new MapperInfo(slot));
        ColumnInfo type = SwitchBlade.getColumnInfo("SWITCH_BLADE_TYPE_ID");
        this.m_htAttribToMapperInfo.put(TYPE.toLowerCase(), new MapperInfo(type));
        ColumnInfo model = SwitchBlade.getColumnInfo("MODEL_ID");
        this.m_htAttribToMapperInfo.put(MODEL.toLowerCase(), new MapperInfo(model));
        ColumnInfo status = SwitchBlade.getColumnInfo("OPERATIONAL_STATUS");
        this.m_htAttribToMapperInfo.put(STATUS.toLowerCase(), new MapperInfo(status));
        ColumnInfo conStatus = SwitchBlade.getColumnInfo("CONSOLIDATED_STATUS");
        this.m_htAttribToMapperInfo.put(CONSTATUS.toLowerCase(), new MapperInfo(conStatus));
        ColumnInfo version = SwitchBlade.getColumnInfo("FIRMWARE_REVISION");
        this.m_htAttribToMapperInfo.put(FIRMWAREVERSION.toLowerCase(), new MapperInfo(version));
        this.m_htAttribToMapperInfo.put(SWITCHWWN.toLowerCase(), new MapperInfo(SwitchBlade.getColumnInfo("SWITCH_WWN")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private short getTypeID(DBConnection conn, String type) throws SQLException {
        if (type == null || type.length() == 0) {
            type = "unknown";
        }
        short id = Short.MIN_VALUE;
        Vector<String> cols = new Vector<String>();
        Hashtable<ColumnInfo, String> htWhereClause = new Hashtable<ColumnInfo, String>();
        cols.add("SWITCH_BLADE_TYPE_ID");
        htWhereClause.put(SwitchBladeType.getColumnInfo("TYPE_NAME"), type);
        SwitchBladeType.SwitchBladeTypeCursor cursor = null;
        try {
            cursor = SwitchBladeType.getCursor(conn, htWhereClause, cols);
            if (cursor.next()) {
                Object[] retCols = cursor.getAttribute(cols);
                id = (short)((Integer)retCols[0]).intValue();
            } else {
                SwitchBladeType sbt = new SwitchBladeType();
                sbt.setSwitchBladeTypeId((short)AutoIdentifier.getIdentifier(16, 1));
                sbt.setTypeName(type);
                sbt.insert(conn);
                conn.commit();
                id = sbt.getSwitchBladeTypeId();
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        if (id == Short.MIN_VALUE) {
            throw new SQLException("Type value of \"" + type + "\" was not able to be normalized.");
        }
        return id;
    }

    public MapperResult persist(DBConnection conn, Hashtable htValues, String scanID) throws SQLException {
        String methodName = "persist(DBConnection conn, Hashtable htValues, String scanID)";
        this.logEntry(this.myClassname, methodName, new Object[]{conn, htValues, scanID});
        MapperResult mr = null;
        String uniqueXML = (String)htValues.get("UniqueIdXml");
        if (uniqueXML != null) {
            String sniaValStatus = (String)htValues.get(STATUS);
            if (sniaValStatus != null) {
                String[] smisValStatusArr = this.convertSNIAOPStatToBitArrValue(sniaValStatus);
                htValues.put(STATUS, smisValStatusArr[0]);
                Vector<String> vOpStat = new Vector<String>();
                vOpStat.add(smisValStatusArr[1]);
                String conState = DBConstants.convertOperationalstatusArrayToConsolidatedValue(vOpStat);
                if (conState != null) {
                    htValues.put(CONSTATUS, conState);
                }
            }
            htValues.put(VENDOR, uniqueXML);
            htValues.put(SERIALNUMBER, uniqueXML);
            if (htValues.get(TYPE) == null) {
                htValues.put(TYPE, "unknown");
            }
        } else {
            SQLException e = new SQLException("Required field, UniqueIdXml, was not found.");
            this.logException(this.myClassname, methodName, e, "");
            throw e;
        }
        String type = (String)htValues.get(TYPE);
        type = Short.toString(this.getTypeID(conn, type));
        htValues.put(TYPE, type);
        mr = super.persist(conn, htValues, scanID);
        this.logExit(this.myClassname, methodName, mr);
        return mr;
    }
}

