/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import org.eclipse.aperi.build.DbGenerateClasses;
import org.eclipse.aperi.infrastructure.database.AutoIdentifier;
import org.eclipse.aperi.infrastructure.database.ClassHelper;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.CurrentTime;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBTable;
import org.eclipse.aperi.infrastructure.database.Normalizer;
import org.eclipse.aperi.infrastructure.database.SQLExceptionHelper;
import org.eclipse.aperi.infrastructure.history.detectability.DetectabilityService;
import org.eclipse.aperi.infrastructure.mapping.AttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.DataConverter;
import org.eclipse.aperi.infrastructure.mapping.MapperInfo;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;
import org.eclipse.aperi.interfaces.IDBAttributeMapper;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;

public abstract class DBAttributeMapper
extends AttributeMapper
implements IDBAttributeMapper {
    protected Hashtable m_htAttribToMapperInfo = new Hashtable();
    protected DataConverter m_dataConverter = new DataConverter();
    protected ILogger myLogger = null;
    private boolean useLogger = true;
    protected String myClassname = this.getClass().getName();
    protected static Hashtable opStatXMLToSMIS = new Hashtable();

    public DBAttributeMapper() {
        if (this.useLogger) {
            this.myLogger = DBConstants.getLogger();
        }
    }

    protected void logEntry(String classname, String methodname, Object[] params) {
        if (this.useLogger && this.myLogger.isLogging()) {
            this.myLogger.entry(IRecordType.TYPE_ENTRY, (Object)classname, methodname, params);
        } else {
            System.out.println(classname + "." + methodname + ":  entry");
            for (int i = 0; i < params.length; ++i) {
                System.out.println("\t" + params[i]);
            }
        }
    }

    protected void logExit(String classname, String methodname, Object rc) {
        if (this.useLogger && this.myLogger.isLogging()) {
            this.myLogger.exit(IRecordType.TYPE_EXIT, (Object)classname, methodname, rc);
        } else {
            System.out.println(classname + "." + methodname + ":  return code: " + rc);
        }
    }

    protected void logWarning(String classname, String methodname, String msg) {
        if (this.useLogger && this.myLogger.isLogging()) {
            this.myLogger.text(IRecordType.TYPE_WARNING, classname, methodname, msg);
        } else {
            System.out.println(classname + "." + methodname + ":  " + msg);
        }
    }

    protected void logException(String classname, String methodname, Exception e, String msg) {
        if (this.useLogger && this.myLogger.isLogging()) {
            this.myLogger.exception(IRecordType.TYPE_ERROR_EXC, classname, methodname, e, msg);
        } else {
            System.out.println(classname + "." + methodname + ":  " + msg);
            System.out.println(e.toString());
        }
    }

    protected void logInfo(String classname, String methodname, String msg) {
        if (this.useLogger && this.myLogger.isLogging()) {
            this.myLogger.text(IRecordType.TYPE_INFO, classname, methodname, msg);
        } else {
            System.out.println(classname + "." + methodname + ":  " + msg);
        }
    }

    private void printMapperResultTablesAndColumns(MapperResult mr, String methodName) {
        Hashtable allRows = mr.getAllRows();
        Enumeration e1Enum = allRows.keys();
        while (e1Enum.hasMoreElements()) {
            Hashtable e1Table = (Hashtable)allRows.get(e1Enum.nextElement());
            Enumeration e1TableEnum = e1Table.keys();
            while (e1TableEnum.hasMoreElements()) {
                ColumnInfo colinfo = (ColumnInfo)e1TableEnum.nextElement();
                this.logInfo(this.myClassname, methodName, "\tTable:" + colinfo.getTableName() + "\tColumn:" + colinfo.getName());
            }
        }
    }

    protected String[] convertSNIAOPStatToBitArrValue(String sniaOpStat) {
        return this.convertSNIAOPStatToBitArrValue(sniaOpStat, opStatXMLToSMIS);
    }

    protected String[] convertSNIAOPStatToBitArrValue(String sniaOpStat, Hashtable conversion) {
        String fnName = "convertSNIAOPStatToBitArrValue(" + sniaOpStat + ")";
        String[] retArr = new String[2];
        String lcSniaOpStat = null;
        Integer iSMISOpStat = null;
        int bitlength = 19;
        double operationalBitValue = 0.0;
        this.logEntry(this.myClassname, fnName, new Object[]{sniaOpStat});
        if (sniaOpStat == "") {
            this.logWarning(this.myClassname, fnName, "No operational status available, returning unknown = 0");
            int valSMISOpStat = (Integer)conversion.get("unknown");
            retArr[0] = String.valueOf(Math.pow(2.0, valSMISOpStat));
            retArr[0] = retArr[0].substring(0, retArr[0].indexOf("."));
            retArr[1] = String.valueOf(valSMISOpStat);
            return retArr;
        }
        lcSniaOpStat = sniaOpStat.toLowerCase();
        iSMISOpStat = (Integer)conversion.get(lcSniaOpStat);
        if (iSMISOpStat == null) {
            this.logWarning(this.myClassname, fnName, "Unknown SNIA operational status input, returning unknown = 0");
            int valSMISOpStat = (Integer)conversion.get("unknown");
            retArr[0] = String.valueOf(Math.pow(2.0, valSMISOpStat));
            retArr[0] = retArr[0].substring(0, retArr[0].indexOf("."));
            retArr[1] = String.valueOf(valSMISOpStat);
            return retArr;
        }
        int valSMISOpStat = iSMISOpStat;
        if (valSMISOpStat >= 0 && valSMISOpStat < bitlength) {
            operationalBitValue = Math.pow(2.0, valSMISOpStat);
        }
        String returnValue = String.valueOf(operationalBitValue);
        retArr[0] = returnValue.substring(0, returnValue.indexOf("."));
        retArr[1] = String.valueOf(valSMISOpStat);
        this.logExit(this.myClassname, fnName, retArr[0] + ", " + retArr[1]);
        return retArr;
    }

    public MapperResult persist(DBConnection conn, IDBAttributeMapper entity1, Hashtable entity1_htValues, IDBAttributeMapper entity2, Hashtable entity2_htValues, String scanID) throws SQLException {
        TableAndCols t;
        ColumnInfo referencedCol;
        ColumnInfo targetCol;
        String attribute;
        Enumeration attribEnum;
        String methodName = "persist(DBConnection conn, DBAttributeMapper entity1, Hashtable entity1_htValues, DBAttributeMapper entity2, Hashtable entity2_htValues, String scanID)";
        Object[] params = new Object[]{conn, entity1, entity1_htValues, entity2, entity2_htValues, scanID};
        this.logEntry(this.myClassname, methodName, params);
        if (conn == null) {
            throw new SQLException("Mapper layer persist function was passed a null object for the DBConnection");
        }
        if (conn.isClosed()) {
            throw new SQLException("Mapper layer persist function was passed a closed DBConnection object.");
        }
        if (conn.isReadOnly()) {
            throw new SQLException("Mapper layer persist function was passed a read-only DBConnection object.");
        }
        MapperResult mr = new MapperResult();
        MapperResult e1Rs = entity1.persist(conn, entity1_htValues, scanID);
        MapperResult e2Rs = entity2.persist(conn, entity2_htValues, scanID);
        Hashtable e1AllTableRows = e1Rs.getAllRows();
        Hashtable e2AllTableRows = e2Rs.getAllRows();
        if (e1AllTableRows.isEmpty()) {
            throw new SQLException("Entity mapper, " + entity1.getClass().getName() + ", did not return any information -- an error scenario.  Relationship information can not be persisted.");
        }
        if (e2AllTableRows.isEmpty()) {
            throw new SQLException("Entity mapper, " + entity2.getClass().getName() + ", did not return any information -- an error scenario.  Relationship information can not be persisted.");
        }
        mr.addMapperResult(e1Rs);
        mr.addMapperResult(e2Rs);
        this.logInfo(this.myClassname, methodName, "Tables referenced by: " + entity1.getClass().getName());
        this.printMapperResultTablesAndColumns(e1Rs, methodName);
        this.logInfo(this.myClassname, methodName, "Tables referenced by: " + entity2.getClass().getName());
        this.printMapperResultTablesAndColumns(e2Rs, methodName);
        TreeMap<String, TableAndCols> distinctTables = new TreeMap<String, TableAndCols>();
        Hashtable combinedHashTable = new Hashtable();
        combinedHashTable.putAll(e1AllTableRows);
        combinedHashTable.putAll(e2AllTableRows);
        if (combinedHashTable.size() == e1AllTableRows.size()) {
            attribEnum = this.m_htAttribToMapperInfo.keys();
            boolean useE1Table = true;
            while (attribEnum.hasMoreElements()) {
                attribute = (String)attribEnum.nextElement();
                MapperInfo mapInfo = (MapperInfo)this.m_htAttribToMapperInfo.get(attribute);
                if (mapInfo == null) continue;
                targetCol = mapInfo.getTargetColInfo();
                referencedCol = targetCol.getReferencedColumn();
                Hashtable eTable = useE1Table ? (Hashtable)e1AllTableRows.get(referencedCol.getTableName()) : (Hashtable)e2AllTableRows.get(referencedCol.getTableName());
                t = (TableAndCols)distinctTables.get(targetCol.getTableName());
                if (t == null) {
                    t = new TableAndCols(targetCol.getTableName(), new Hashtable());
                    distinctTables.put(targetCol.getTableName(), t);
                }
                t.put(targetCol, eTable.get(referencedCol));
                if (mapInfo.getDerivedColumn() != null) {
                    t.put(mapInfo.getDerivedColumn(), new String("-1"));
                }
                if (referencedCol.isPrimaryKey()) {
                    Hashtable t1;
                    if (useE1Table) {
                        t1 = (Hashtable)e2AllTableRows.get(referencedCol.getTableName());
                        t.put(referencedCol, t1.get(referencedCol));
                    } else {
                        t1 = (Hashtable)e1AllTableRows.get(referencedCol.getTableName());
                        t.put(referencedCol, t1.get(referencedCol));
                    }
                }
                if (useE1Table) {
                    useE1Table = false;
                    continue;
                }
                useE1Table = true;
            }
        } else {
            attribEnum = this.m_htAttribToMapperInfo.keys();
            while (attribEnum.hasMoreElements()) {
                attribute = (String)attribEnum.nextElement();
                MapperInfo mapInfo = (MapperInfo)this.m_htAttribToMapperInfo.get(attribute);
                if (mapInfo == null) continue;
                targetCol = mapInfo.getTargetColInfo();
                referencedCol = targetCol.getReferencedColumn();
                Hashtable e1Table = (Hashtable)e1AllTableRows.get(referencedCol.getTableName());
                if (e1Table == null) {
                    Hashtable e2Table = (Hashtable)e2AllTableRows.get(referencedCol.getTableName());
                    if (e2Table == null) {
                        return mr;
                    }
                    t = (TableAndCols)distinctTables.get(targetCol.getTableName());
                    if (t == null) {
                        t = new TableAndCols(targetCol.getTableName(), new Hashtable());
                        distinctTables.put(targetCol.getTableName(), t);
                    }
                    t.put(targetCol, e2Table.get(referencedCol));
                    if ((referencedCol.isPrimaryKey() || referencedCol.isAutoGenerated()) && referencedCol.getTableName().equals(targetCol.getTableName())) {
                        t.putPrimaryKey(referencedCol, e2Table.get(referencedCol));
                    }
                    if (mapInfo.getDerivedColumn() == null) continue;
                    t.put(mapInfo.getDerivedColumn(), new String("-1"));
                    continue;
                }
                t = (TableAndCols)distinctTables.get(targetCol.getTableName());
                if (t == null) {
                    t = new TableAndCols(targetCol.getTableName(), new Hashtable());
                    distinctTables.put(targetCol.getTableName(), t);
                }
                t.put(targetCol, e1Table.get(referencedCol));
                if ((referencedCol.isPrimaryKey() || referencedCol.isAutoGenerated()) && referencedCol.getTableName().equals(targetCol.getTableName())) {
                    t.putPrimaryKey(referencedCol, e1Table.get(referencedCol));
                }
                if (mapInfo.getDerivedColumn() == null) continue;
                t.put(mapInfo.getDerivedColumn(), new String("-1"));
            }
        }
        for (String tableName : distinctTables.keySet()) {
            TableAndCols t2 = (TableAndCols)distinctTables.get(tableName);
            DBTable helper = t2.getDBHelper();
            int colsUpdated = -1;
            if (t2.getPrimaryKeys().size() > 0) {
                boolean retval;
                block26: {
                    retval = false;
                    try {
                        retval = helper.retrieve(conn);
                    }
                    catch (SQLException e) {
                        this.logInfo(this.myClassname, methodName, "Unable to find existing row for helper, " + helper.getClass().getName() + ", exception was: " + e.getMessage() + ".");
                        if (!SQLExceptionHelper.isDeadlock(conn, e)) break block26;
                        this.logInfo(this.myClassname, methodName, "Above exception was a deadlock exception, throwing back to caller to handle as appropriate.");
                        throw e;
                    }
                }
                if (retval) {
                    this.performUpdate(t2, mr, conn, scanID);
                    return mr;
                }
                this.logInfo(this.myClassname, methodName, "Unable to find existing row for helper, " + helper.getClass().getName() + ".  Will attempt an insert.");
            }
            this.performInsert(t2, mr, conn, scanID);
        }
        this.logExit(this.myClassname, methodName, mr);
        return mr;
    }

    public MapperResult persist(DBConnection conn, Hashtable htValues, String scanID) throws SQLException {
        return this.persist(conn, this.m_htAttribToMapperInfo, htValues, scanID);
    }

    private void performSEPhase1(Hashtable htValues, TreeMap distinctTables, Hashtable htAttribToMapInfo) {
        String methodName = "performSEPhase1(Hashtable htValues, TreeMap distinctTables, Hashtable htAttribToMapInfo)";
        Object[] params = new Object[]{htValues, distinctTables, htAttribToMapInfo};
        this.logEntry(this.myClassname, methodName, params);
        Enumeration attribEnum = htValues.keys();
        while (attribEnum.hasMoreElements()) {
            String attribute = (String)attribEnum.nextElement();
            String lcAttribute = attribute.toLowerCase();
            MapperInfo mapInfo = this.getMapperInfo(htAttribToMapInfo, lcAttribute);
            if (mapInfo == null) continue;
            Object tempCI = null;
            Object tempTableName = null;
            TableAndCols unConstrainedTable = (TableAndCols)distinctTables.get(mapInfo.getTargetColInfo().getTableName());
            if (unConstrainedTable == null) {
                unConstrainedTable = new TableAndCols(mapInfo.getTargetColInfo().getTableName(), new Hashtable());
                distinctTables.put(mapInfo.getTargetColInfo().getTableName(), unConstrainedTable);
            }
            unConstrainedTable.put(mapInfo.getTargetColInfo(), htValues.get(attribute));
            if (mapInfo.getDerivedColumn() != null) {
                unConstrainedTable.put(mapInfo.getDerivedColumn(), new String("-1"));
            }
            if (!mapInfo.getTargetColInfo().getForeignKeyConstraint() || mapInfo.getForeignKeyColInfo() == null) continue;
            ColumnInfo[] foreignKeyCols = mapInfo.getForeignKeyColInfo();
            for (int i = 0; i < foreignKeyCols.length; ++i) {
                TableAndCols constrainedTable = (TableAndCols)distinctTables.get(foreignKeyCols[i].getTableName());
                if (mapInfo.getDerivedColumn() != null) {
                    foreignKeyCols[i].setReferencedColumn(mapInfo.getDerivedColumn());
                } else {
                    foreignKeyCols[i].setReferencedColumn(mapInfo.getTargetColInfo());
                }
                if (constrainedTable == null) {
                    constrainedTable = new TableAndCols(foreignKeyCols[i].getTableName(), new Hashtable());
                    distinctTables.put(constrainedTable.getTableName(), constrainedTable);
                }
                if (unConstrainedTable.getDependentTables().get(constrainedTable.getTableName()) == null) {
                    constrainedTable.setIsDependentTable(true);
                    unConstrainedTable.getDependentTables().put(constrainedTable.getTableName(), constrainedTable);
                }
                constrainedTable.put(foreignKeyCols[i], new String("-1"));
            }
        }
        this.logExit(this.myClassname, methodName, null);
    }

    private void performSEPhase2(TreeMap distinctTables, MapperResult mr, String scanID, DBConnection conn) throws SQLException {
        String methodName = "performSEPhase2(TreeMap distinctTables, MapperResult mr, String scanID, DBConnection conn)";
        Object[] params = new Object[]{distinctTables, mr, scanID, conn};
        this.logEntry(this.myClassname, methodName, params);
        for (String primaryTableName : distinctTables.keySet()) {
            Hashtable depHashTables;
            TableAndCols target = (TableAndCols)distinctTables.get(primaryTableName);
            if (target.isDependentTable()) continue;
            int colsUpdated = -1;
            if (target.getPrimaryKeys().size() > 0) {
                boolean retval;
                DBTable helper;
                block14: {
                    helper = target.getDBHelper();
                    retval = false;
                    try {
                        retval = helper.retrieve(conn);
                    }
                    catch (SQLException e) {
                        this.logInfo(this.myClassname, methodName, "Unable to find existing row for helper, " + helper.getClass().getName() + ", exception was: " + e.getMessage() + ".");
                        if (!SQLExceptionHelper.isDeadlock(conn, e)) break block14;
                        this.logInfo(this.myClassname, methodName, "Above exception was a deadlock exception, throwing back to caller to handle as appropriate.");
                        throw e;
                    }
                }
                if (retval) {
                    colsUpdated = this.performUpdate(target, mr, conn, scanID);
                } else {
                    this.logInfo(this.myClassname, methodName, "Unable to find existing row for helper, " + helper.getClass().getName() + ".  Will attempt an insert.");
                }
            }
            if (colsUpdated <= 0) {
                try {
                    this.performInsert(target, mr, conn, scanID);
                }
                catch (SQLException e) {
                    if (e.getErrorCode() == -803) {
                        this.logWarning(this.myClassname, methodName, "Get a dublicate row exception inserting new row into " + target.getTableName() + ".  Will attempt an update instead of insert.");
                        colsUpdated = this.performUpdate(target, mr, conn, scanID);
                    }
                    throw e;
                }
            }
            if ((depHashTables = target.getDependentTables()) == null || depHashTables.size() <= 0) continue;
            for (String depTableName : depHashTables.keySet()) {
                DBTable helper;
                boolean retval;
                Vector<ColumnInfo> colInfo = new Vector<ColumnInfo>();
                Vector<ColumnInfo> refColInfo = new Vector<ColumnInfo>();
                TableAndCols depTable = (TableAndCols)depHashTables.get(depTableName);
                Hashtable depTableCols = depTable.getAllColsAndValues();
                for (ColumnInfo col : depTableCols.keySet()) {
                    if (col.getReferencedColumn() == null || !col.getReferencedColumn().getTableName().equals(primaryTableName)) continue;
                    if (colsUpdated <= 0 && col.getReferencedColumn().isAutoGenerated()) {
                        Object obj = target.get(col.getReferencedColumn());
                        if (obj == null) continue;
                        depTable.put(col, obj.toString());
                        continue;
                    }
                    colInfo.add(col);
                    refColInfo.add(col.getReferencedColumn());
                }
                if (colInfo.size() <= 0 || !(retval = (helper = target.getDBHelper()).retrieve(conn))) continue;
                for (int i = 0; i < refColInfo.size(); ++i) {
                    ColumnInfo cc = (ColumnInfo)refColInfo.elementAt(i);
                    ColumnInfo actualCol = (ColumnInfo)colInfo.elementAt(i);
                    depTable.put(actualCol, target.get(cc).toString());
                }
            }
        }
        this.logExit(this.myClassname, methodName, mr);
    }

    private void performSEPhase3(TreeMap distinctTables, MapperResult mr, String scanID, DBConnection conn) throws SQLException {
        String methodName = "performSEPhase3(TreeMap distinctTables, MapperResult mr, String scanID, DBConnection conn)";
        Object[] params = new Object[]{distinctTables, mr, scanID, conn};
        this.logEntry(this.myClassname, methodName, params);
        for (String depTableName : distinctTables.keySet()) {
            TableAndCols target = (TableAndCols)distinctTables.get(depTableName);
            if (!target.isDependentTable()) continue;
            int colsUpdated = -1;
            if (target.getPrimaryKeys().size() > 0) {
                DBTable helper = target.getDBHelper();
                boolean retval = helper.retrieve(conn);
                if (retval) {
                    colsUpdated = this.performUpdate(target, mr, conn, scanID);
                } else {
                    this.logInfo(this.myClassname, methodName, "Unable to find existing row for helper, " + helper.getClass().getName() + ".  Will attempt an insert.");
                }
            }
            if (colsUpdated > 0) continue;
            try {
                this.performInsert(target, mr, conn, scanID);
            }
            catch (SQLException e) {
                this.logException(this.myClassname, methodName, e, "Thrown by performInsert for table: " + depTableName);
            }
        }
        this.logExit(this.myClassname, methodName, mr);
    }

    protected MapperResult persist(DBConnection conn, Hashtable htAttribToMapInfo, Hashtable htValues, String scanID) throws SQLException {
        String methodName = "persist(DBConnection conn, Hashtable htAttribToMapInfo, Hashtable htValues, String scanID)";
        Object[] params = new Object[]{conn, htAttribToMapInfo, htValues, scanID};
        this.logEntry(this.myClassname, methodName, params);
        if (conn == null) {
            throw new SQLException("Mapper layer persist function was passed a null object for the DBConnection");
        }
        if (conn.isClosed()) {
            throw new SQLException("Mapper layer persist function was passed a closed DBConnection object.");
        }
        if (conn.isReadOnly()) {
            throw new SQLException("Mapper layer persist function was passed a read-only DBConnection object.");
        }
        this.m_dataConverter.performDataConversion(htValues);
        if (htValues.isEmpty()) {
            throw new SQLException("After performing data conversion, there was no information for the " + this.myClassname + " to persist!");
        }
        MapperResult mr = new MapperResult();
        TreeMap distinctTables = new TreeMap();
        this.performSEPhase1(htValues, distinctTables, htAttribToMapInfo);
        this.performSEPhase2(distinctTables, mr, scanID, conn);
        this.performSEPhase3(distinctTables, mr, scanID, conn);
        this.logExit(this.myClassname, methodName, mr);
        return mr;
    }

    private int performUpdate(TableAndCols target, MapperResult mr, DBConnection conn, String scanID) throws SQLException {
        String methodName = "performUpdate( TableAndCols target, MapperResult mr, DBConnection conn, String scanID )";
        Object[] params = new Object[]{target, mr, conn, scanID};
        this.logEntry(this.myClassname, methodName, params);
        DBTable helper = target.getDBHelper();
        Hashtable updateTarget = target.getNonAutoGeneratedColsAndValues();
        this.addDetectable(helper, updateTarget);
        this.addUpdateTimestamp(helper, updateTarget, this.getCurrentTime(conn));
        int colsUpdated = helper.update(conn, updateTarget);
        Hashtable tmp = target.getAllColsAndValues();
        for (ColumnInfo col : tmp.keySet()) {
            short id;
            String val;
            if (col.isAutoGenerated()) {
                val = target.get(col).toString();
                target.put(col, val);
                continue;
            }
            if (col.getDataType() != 5) continue;
            if (col.getName().equals("SYSTEM_CREATION_CLASS_NAME_ID")) {
                val = tmp.get(col).toString();
                id = Normalizer.SystemCreationClassNameGetID(conn, val);
                if (id <= 0) continue;
                target.put(col, String.valueOf(id));
                continue;
            }
            if (col.getName().equals("CREATION_CLASS_NAME_ID")) {
                val = tmp.get(col).toString();
                id = Normalizer.CreationClassNameGetID(conn, val);
                if (id <= 0) continue;
                target.put(col, String.valueOf(id));
                continue;
            }
            if (col.getName().equals("CLASS_NAME_ID")) {
                val = tmp.get(col).toString();
                id = Normalizer.ClassNameGetID(conn, val);
                if (id <= 0) continue;
                target.put(col, String.valueOf(id));
                continue;
            }
            if (col.getName().equals("SYSTEM_NAMES_ID")) {
                val = tmp.get(col).toString();
                id = Normalizer.SystemNamesGetID(conn, val);
                if (id <= 0) continue;
                target.put(col, String.valueOf(id));
                continue;
            }
            if (col.getName().equals("VENDOR_ID")) {
                val = tmp.get(col).toString();
                id = Normalizer.VendorGetID(conn, val);
                if (id <= 0) continue;
                target.put(col, String.valueOf(id));
                continue;
            }
            if (!col.getName().equals("MODEL_ID") || (id = Normalizer.ModelGetID(conn, val = tmp.get(col).toString())) <= 0) continue;
            target.put(col, String.valueOf(id));
        }
        if (colsUpdated > 0) {
            mr.addUpdatedRow(target.getTableName(), target.getAllColsAndValues());
        } else {
            mr.addNonModifiedRow(target.getTableName(), target.getAllColsAndValues());
            colsUpdated = 1;
        }
        conn.commit();
        try {
            DetectabilityService.tableUpdated(scanID, target.getTableName(), target.getAutoGeneratedColsAndValues());
        }
        catch (Exception e) {
            this.logException(this.myClassname, methodName, e, "Detectability Layer's \"tableUpdated\" function threw an exception, will attempt to continue.");
        }
        this.logExit(this.myClassname, methodName, new Integer(colsUpdated));
        return colsUpdated;
    }

    private void performInsert(TableAndCols target, MapperResult mr, DBConnection conn, String scanID) throws SQLException {
        String methodName = "performInsert( TableAndCols target, MapperResult mr, DBConnection conn, String scanID )";
        Object[] params = new Object[]{target, mr, conn, scanID};
        this.logEntry(this.myClassname, methodName, params);
        Vector<ColumnInfo> colsWithAutoIds = new Vector<ColumnInfo>();
        boolean numOfAutoIds = false;
        if (target.getAllColsAndValues().size() > 0) {
            Hashtable allColsAndVals = target.getAllColsAndValues();
            for (ColumnInfo col : allColsAndVals.keySet()) {
                if (!col.isAutoGenerated()) continue;
                colsWithAutoIds.add(col);
            }
        }
        int autoIdRange = -1;
        if (colsWithAutoIds.size() > 0) {
            autoIdRange = AutoIdentifier.getIdentifier(1, colsWithAutoIds.size());
            for (int i = 0; i < colsWithAutoIds.size(); ++i) {
                ColumnInfo col;
                col = (ColumnInfo)colsWithAutoIds.get(i);
                target.put(col, String.valueOf(autoIdRange++));
            }
        }
        DBTable helper = target.getDBHelper();
        Hashtable insertTarget = target.getAllColsAndValues();
        this.addDetectable(helper, insertTarget);
        Timestamp time = this.getCurrentTime(conn);
        this.addUpdateTimestamp(helper, insertTarget, time);
        this.addDiscoveredTimestamp(helper, insertTarget, time);
        for (ColumnInfo key : insertTarget.keySet()) {
            String value = insertTarget.get(key).toString();
            this.logInfo(this.myClassname, methodName, "key=" + key.getName() + " value=" + value);
        }
        helper.insert(conn, insertTarget);
        conn.commit();
        try {
            DetectabilityService.tableUpdated(scanID, target.getTableName(), target.getAutoGeneratedColsAndValues());
        }
        catch (Exception e) {
            this.logException(this.myClassname, methodName, e, "Detectability Layer's \"tableUpdated\" function threw an exception, will attempt to continue.");
        }
        mr.addInsertedRow(target.getTableName(), target.getAllColsAndValues());
        this.logExit(this.myClassname, methodName, new Boolean(true));
    }

    private boolean addDetectable(DBTable processor, Hashtable aAddonTable) {
        Object[] parameters = null;
        Method ourMethod = null;
        ColumnInfo colInfo = null;
        try {
            Class[] c = new Class[]{String.class};
            ourMethod = processor.getClass().getMethod("getColumnInfo", c);
            parameters = new Object[ourMethod.getParameterTypes().length];
            parameters[0] = new String("DETECTABLE");
            colInfo = (ColumnInfo)ourMethod.invoke((Object)processor, parameters);
        }
        catch (Exception e) {
            return false;
        }
        if (colInfo == null) {
            return false;
        }
        aAddonTable.put(colInfo, "1");
        return true;
    }

    private Timestamp getCurrentTime(DBConnection conn) throws SQLException {
        return CurrentTime.getTimestamp(conn);
    }

    private boolean addUpdateTimestamp(DBTable processor, Hashtable aAddonTable, Timestamp time) throws SQLException {
        Object[] parameters = null;
        Method ourMethod = null;
        ColumnInfo colInfo = null;
        try {
            Class[] c = new Class[]{String.class};
            ourMethod = processor.getClass().getMethod("getColumnInfo", c);
            parameters = new Object[ourMethod.getParameterTypes().length];
            parameters[0] = new String("UPDATE_TIMESTAMP");
            colInfo = (ColumnInfo)ourMethod.invoke((Object)processor, parameters);
        }
        catch (Exception e) {
            return false;
        }
        if (colInfo == null) {
            return false;
        }
        aAddonTable.put(colInfo, time);
        return true;
    }

    private boolean addDiscoveredTimestamp(DBTable processor, Hashtable aAddonTable, Timestamp time) throws SQLException {
        Object[] parameters = null;
        Method ourMethod = null;
        ColumnInfo colInfo = null;
        try {
            Class[] c = new Class[]{String.class};
            ourMethod = processor.getClass().getMethod("getColumnInfo", c);
            parameters = new Object[ourMethod.getParameterTypes().length];
            parameters[0] = new String("DISCOVERED_TIME");
            colInfo = (ColumnInfo)ourMethod.invoke((Object)processor, parameters);
        }
        catch (Exception e) {
            return false;
        }
        if (colInfo == null) {
            return false;
        }
        aAddonTable.put(colInfo, time);
        return true;
    }

    protected Hashtable generateValuesHashtable(Hashtable htValues) {
        Hashtable mappings = new Hashtable();
        for (String key : htValues.keySet()) {
            MapperInfo mapping = (MapperInfo)this.m_htAttribToMapperInfo.get(key.toLowerCase());
            if (mapping == null) continue;
            mappings.put(mapping.getTargetColInfo(), htValues.get(key));
        }
        return mappings;
    }

    protected static Vector processArrayvalues(String value) {
        Vector<String> result = new Vector<String>();
        try {
            int lastBracket = value.indexOf("]");
            if (lastBracket == -1) {
                lastBracket = value.length();
            }
            value = value.substring(value.indexOf("[") + 1, lastBracket);
            StringTokenizer tokens = new StringTokenizer(value, ",");
            while (tokens.hasMoreTokens()) {
                result.add(tokens.nextToken().trim());
            }
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected static void setPreparedStatementParameter(PreparedStatement stmt, ColumnInfo colInfo, int paramNum, Hashtable htValues) throws SQLException {
        DBAttributeMapper.setPreparedStatementParameter(stmt, colInfo, paramNum, htValues.get(colInfo));
    }

    protected static void setPreparedStatementParameter(PreparedStatement stmt, ColumnInfo colInfo, int paramNum, Object value) throws SQLException {
        if (value != null) {
            try {
                switch (colInfo.getDataType()) {
                    case -1: 
                    case 1: 
                    case 12: {
                        String str1 = (String)value;
                        stmt.setString(paramNum, str1);
                        break;
                    }
                    case 2005: {
                        Clob cb1 = (Clob)value;
                        stmt.setClob(paramNum, cb1);
                        break;
                    }
                    case 3: {
                        BigDecimal setVal5 = DBConstants.INVALID_BIGDECIMAL_VALUE;
                        if (value instanceof Float) {
                            setVal5 = (BigDecimal)value;
                        } else if (value instanceof String) {
                            setVal5 = new BigDecimal((String)value);
                        } else {
                            throw new SQLException("Error - unable to convert " + value.getClass() + " to a Java bigdecimal");
                        }
                        stmt.setBigDecimal(paramNum, setVal5);
                        break;
                    }
                    case 8: {
                        double setVal4 = Double.MIN_VALUE;
                        if (value instanceof Double) {
                            setVal4 = (Double)value;
                        } else if (value instanceof String) {
                            setVal4 = Double.parseDouble((String)value);
                        } else {
                            throw new SQLException("Error - unable to conver " + value.getClass() + " to a Java double");
                        }
                        stmt.setDouble(paramNum, setVal4);
                        break;
                    }
                    case 6: 
                    case 7: {
                        float setVal3 = Float.MIN_VALUE;
                        if (value instanceof Float) {
                            setVal3 = ((Float)value).floatValue();
                        } else if (value instanceof String) {
                            setVal3 = Float.parseFloat((String)value);
                        } else {
                            throw new SQLException("Error - unable to convert " + value.getClass() + " to a Java float");
                        }
                        stmt.setFloat(paramNum, setVal3);
                        break;
                    }
                    case 4: {
                        int setVal1 = Integer.MIN_VALUE;
                        if (value instanceof Integer) {
                            setVal1 = (Integer)value;
                        } else if (value instanceof String) {
                            setVal1 = Integer.parseInt((String)value);
                        } else {
                            throw new SQLException("Error - unable to convert " + value.getClass() + " to a Java int");
                        }
                        stmt.setInt(paramNum, setVal1);
                        break;
                    }
                    case 2: {
                        throw new SQLException("Error - Unsupported type - NUMERIC");
                    }
                    case 5: {
                        int setVal2 = Short.MIN_VALUE;
                        if (value instanceof Short) {
                            setVal2 = ((Short)value).shortValue();
                        } else if (value instanceof String) {
                            setVal2 = Short.parseShort((String)value);
                        } else {
                            throw new SQLException("Error - unable to convert " + value.getClass() + " to a Java short");
                        }
                        stmt.setInt(paramNum, setVal2);
                        break;
                    }
                    case 16: {
                        String str = (String)value;
                        short val = str.equalsIgnoreCase("true") ? (short)1 : 0;
                        stmt.setShort(paramNum, val);
                        break;
                    }
                    case -6: {
                        throw new SQLException("Error - Unsupported type - TINYINT");
                    }
                    case 93: {
                        Timestamp ts1 = DBConstants.INVALID_TIMESTAMP_VALUE;
                        if (value instanceof Timestamp) {
                            ts1 = (Timestamp)value;
                        } else if (value instanceof String) {
                            ts1 = Timestamp.valueOf((String)value);
                        } else {
                            throw new SQLException("Error - unable to convert " + value.getClass() + " to a Java timestamp");
                        }
                        stmt.setTimestamp(paramNum, ts1);
                        break;
                    }
                    case 2003: {
                        throw new SQLException("Error - Unsupported type - ARRAY");
                    }
                    case 2004: {
                        throw new SQLException("Error - Unsupported type - BLOB");
                    }
                    case -7: {
                        throw new SQLException("Error - Unsupported type - BIT");
                    }
                    case -4: 
                    case -3: 
                    case -2: {
                        byte[] ba1 = ((String)value).getBytes();
                        stmt.setBytes(paramNum, ba1);
                        break;
                    }
                    case 70: {
                        throw new SQLException("Error - Unsupported type - DATALINK");
                    }
                    case 91: {
                        Date dt1 = (Date)value;
                        stmt.setDate(paramNum, dt1);
                        break;
                    }
                    case 92: {
                        Time tm1 = (Time)value;
                        stmt.setTime(paramNum, tm1);
                        break;
                    }
                    case -5: {
                        long setVal = Long.MIN_VALUE;
                        if (value instanceof BigInteger) {
                            setVal = ((BigInteger)value).longValue();
                        } else if (value instanceof Long) {
                            setVal = (Long)value;
                        } else if (value instanceof String) {
                            setVal = Long.parseLong((String)value);
                        } else {
                            throw new SQLException("Error - unable to convert " + value.getClass() + " to a Java long");
                        }
                        stmt.setLong(paramNum, setVal);
                        break;
                    }
                    default: {
                        throw new SQLException("Error - Unknown type encountered - " + colInfo.getDataType());
                    }
                }
            }
            catch (NumberFormatException e) {
                String emsg = "Number Format exception on " + value + " and field " + colInfo.getName();
                System.out.println(emsg);
                throw new SQLException(emsg);
            }
        } else {
            stmt.setNull(paramNum, colInfo.getDataType());
        }
    }

    static {
        opStatXMLToSMIS.put(new String("up"), new Integer(2));
        opStatXMLToSMIS.put(new String("down"), new Integer(10));
        opStatXMLToSMIS.put(new String("testing"), new Integer(11));
        opStatXMLToSMIS.put(new String("unknown"), new Integer(0));
        opStatXMLToSMIS.put(new String("dormant"), new Integer(10));
        opStatXMLToSMIS.put(new String("notpresent"), new Integer(6));
        opStatXMLToSMIS.put(new String("lowerlayerdown"), new Integer(6));
        opStatXMLToSMIS.put(new String("online"), new Integer(2));
        opStatXMLToSMIS.put(new String("offline"), new Integer(2));
        opStatXMLToSMIS.put(new String("faulty"), new Integer(2));
        opStatXMLToSMIS.put(new String("failed"), new Integer(6));
        opStatXMLToSMIS.put(new String("bypassed"), new Integer(10));
        opStatXMLToSMIS.put(new String("reserved"), new Integer(10));
        opStatXMLToSMIS.put(new String("diagnostics"), new Integer(10));
        opStatXMLToSMIS.put(new String("portoperdown"), new Integer(10));
        opStatXMLToSMIS.put(new String("ok"), new Integer(2));
        opStatXMLToSMIS.put(new String("disabled"), new Integer(10));
        opStatXMLToSMIS.put(new String("okbutdiagfailed"), new Integer(3));
        opStatXMLToSMIS.put(new String("boot"), new Integer(8));
        opStatXMLToSMIS.put(new String("selftest"), new Integer(11));
        opStatXMLToSMIS.put(new String("missing"), new Integer(13));
        opStatXMLToSMIS.put(new String("mismatchwithparent"), new Integer(6));
        opStatXMLToSMIS.put(new String("mismatchconfig"), new Integer(6));
        opStatXMLToSMIS.put(new String("diagfailed"), new Integer(6));
        opStatXMLToSMIS.put(new String("dormant"), new Integer(10));
        opStatXMLToSMIS.put(new String("outofserviceadmin"), new Integer(1));
        opStatXMLToSMIS.put(new String("outofserviceenvtemp"), new Integer(11));
        opStatXMLToSMIS.put(new String("powereddown"), new Integer(10));
        opStatXMLToSMIS.put(new String("poweredup"), new Integer(8));
        opStatXMLToSMIS.put(new String("powerdenied"), new Integer(6));
        opStatXMLToSMIS.put(new String("powercycled"), new Integer(8));
    }

    public static class RegistrationData {
        private String mCIMClassName;
        private String mSmisVersion;
        private String mDeviceType;
        private String mInstrumentationVersion;
        private String mDedicated;

        public RegistrationData(String pCIMClassnName, String pSMISVersion, String pDeviceType, String pInstrumentationVersion, String pDedicated) {
            if (pCIMClassnName == null || pCIMClassnName.trim().length() == 0) {
                throw new NullPointerException("Name must be neither null nor whitespace only.");
            }
            this.mCIMClassName = pCIMClassnName;
            this.mSmisVersion = pSMISVersion;
            this.mDeviceType = pDeviceType;
            this.mInstrumentationVersion = pInstrumentationVersion;
            this.mDedicated = pDedicated;
        }

        public RegistrationData(String pCIMClassnName, String pSMISVersion, String pDeviceType, String pInstrumentationVersion) {
            this(pCIMClassnName, pSMISVersion, pDeviceType, pInstrumentationVersion, null);
        }

        public boolean equals(Object aObj) {
            if (aObj instanceof RegistrationData) {
                RegistrationData rhs = (RegistrationData)aObj;
                return this.mCIMClassName.equals(rhs.mCIMClassName) && this.mSmisVersion.equals(rhs.mSmisVersion) && this.mDeviceType.equals(rhs.mDeviceType) && this.mInstrumentationVersion.equals(rhs.mInstrumentationVersion) && this.mDedicated.equals(rhs.mDedicated);
            }
            return false;
        }

        public String getCIMClassName() {
            return this.mCIMClassName;
        }

        public String getDeviceType() {
            return this.mDeviceType;
        }

        public String getInstrumentationVersion() {
            return this.mInstrumentationVersion;
        }

        public String getSmisVersion() {
            return this.mSmisVersion;
        }

        public String getDedicated() {
            return this.mDedicated;
        }
    }

    class TableAndCols {
        String m_tableName;
        DBTable m_dbHelper;
        Hashtable m_colsAndValues;
        Hashtable m_primaryKeyColsAndValues;
        Hashtable m_derivedCols;
        Hashtable m_nonAutoGeneratedKeys;
        Hashtable m_allKvPairs;
        boolean m_isDependentTable;
        Hashtable m_depTables;

        public TableAndCols(String tableName, Hashtable colsAndVals) {
            this.m_tableName = tableName;
            this.m_colsAndValues = colsAndVals;
            this.m_allKvPairs = new Hashtable();
            this.m_depTables = new Hashtable();
            this.m_primaryKeyColsAndValues = new Hashtable();
            this.m_derivedCols = new Hashtable();
            this.m_nonAutoGeneratedKeys = new Hashtable();
            this.m_isDependentTable = false;
            this.m_dbHelper = ClassHelper.getObject(tableName);
        }

        public String getTableName() {
            return this.m_tableName;
        }

        public DBTable getDBHelper() {
            return this.m_dbHelper;
        }

        public boolean isDependentTable() {
            return this.m_isDependentTable;
        }

        public void setIsDependentTable(boolean val) {
            this.m_isDependentTable = val;
        }

        public void addDependentTable(TableAndCols t) {
            this.m_depTables.put(t.getTableName(), t);
        }

        public Hashtable getDependentTables() {
            return this.m_depTables;
        }

        public Hashtable getTargetColsAndValues() {
            return this.m_colsAndValues;
        }

        public Hashtable getPrimaryKeys() {
            return this.m_primaryKeyColsAndValues;
        }

        public Hashtable getNonAutoGeneratedColsAndValues() {
            return this.m_nonAutoGeneratedKeys;
        }

        public Hashtable getAutoGeneratedColsAndValues() {
            return this.m_derivedCols;
        }

        public Hashtable getAllColsAndValues() {
            return this.m_allKvPairs;
        }

        public Object get(ColumnInfo c) {
            try {
                Method method = this.getMethod("get", DbGenerateClasses.columnNameToMemberName(c.getName()), c, new Class[0]);
                return method.invoke((Object)this.m_dbHelper, new Object[0]);
            }
            catch (NoSuchMethodException e) {
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        public void putPrimaryKey(ColumnInfo c, Object val) {
            this.m_allKvPairs.put(c, val.toString());
            this.m_primaryKeyColsAndValues.put(c, val);
            if (c.isAutoGenerated()) {
                this.m_derivedCols.put(c, val);
            }
        }

        public void put(ColumnInfo c, Object val) {
            this.m_allKvPairs.put(c, val.toString());
            if (c.isPrimaryKey()) {
                this.m_primaryKeyColsAndValues.put(c, val);
                this.m_nonAutoGeneratedKeys.put(c, val);
            } else if (c.isAutoGenerated()) {
                this.m_derivedCols.put(c, val);
            } else {
                this.m_colsAndValues.put(c, val);
                this.m_nonAutoGeneratedKeys.put(c, val);
            }
            this.setHelperValue(c, val);
        }

        private Method getMethod(String prepend, String memberName, ColumnInfo c, Class[] params) throws NoSuchMethodException {
            String methodName = new String(prepend + memberName);
            Class<?> helperClass = this.m_dbHelper.getClass();
            NoSuchMethodException mex = null;
            Method m = null;
            try {
                m = helperClass.getDeclaredMethod(methodName, params);
            }
            catch (NoSuchMethodException e) {
                mex = e;
                m = helperClass.getSuperclass().getDeclaredMethod(methodName, params);
            }
            return m;
        }

        private void setHelperValue(ColumnInfo c, Object val) {
            String classname = DBAttributeMapper.this.myClassname + ".TableAndCols";
            String methodname = "setHelperValue(ColumnInfo c, Object val)";
            String memberName = DbGenerateClasses.columnNameToMemberName(c.getName());
            try {
                Class[] params = new Class[]{val.getClass()};
                Object[] args = new Object[]{val};
                switch (c.getDataType()) {
                    case -1: 
                    case 1: 
                    case 12: {
                        args[0] = val.toString();
                        params[0] = String.class;
                        break;
                    }
                    case 3: {
                        args[0] = new BigDecimal((String)val);
                        params[0] = args[0].getClass();
                        break;
                    }
                    case 8: {
                        args[0] = new Double((String)val);
                        params[0] = Double.TYPE;
                        break;
                    }
                    case 6: {
                        args[0] = new Float((String)val);
                        params[0] = Float.TYPE;
                        break;
                    }
                    case 4: {
                        try {
                            args[0] = new Integer((String)val);
                        }
                        catch (ClassCastException e) {
                            args[0] = val;
                        }
                        params[0] = Integer.TYPE;
                        break;
                    }
                    case 2: {
                        DBAttributeMapper.this.logWarning(classname, "setHelperValue(ColumnInfo c, Object val)", "Warning: Attempt to set value for column: " + c.getName() + " which is of unsupported type Numeric.");
                        break;
                    }
                    case 7: {
                        args[0] = new Float((String)val);
                        params[0] = Float.TYPE;
                        break;
                    }
                    case 5: {
                        params[0] = Short.TYPE;
                        if (!(val instanceof String)) break;
                        try {
                            args[0] = new Short((String)val);
                        }
                        catch (NumberFormatException e) {
                            if (memberName.endsWith("SystemNamesId") || memberName.endsWith("CreationClassNameId") || memberName.endsWith("ClassNameId") || memberName.endsWith("SystemCreationClassNameId") || memberName.endsWith("VendorId") || memberName.endsWith("ModelId")) {
                                memberName = memberName.substring(0, memberName.length() - 2);
                                params[0] = String.class;
                                break;
                            }
                            DBAttributeMapper.this.logInfo(classname, methodname, "Attempt to set a field, " + memberName + ", of type SHORT with a string value not representing a short, will try to find a normalizing function in helper class.");
                            if (!memberName.endsWith("Id")) break;
                            memberName = memberName.substring(0, memberName.length() - 2);
                            params[0] = String.class;
                        }
                        break;
                    }
                    case 16: {
                        String val1 = (String)val;
                        short val2 = val1.equalsIgnoreCase("true") ? (short)1 : 0;
                        args[0] = new Short(val2);
                        params[0] = Short.TYPE;
                        break;
                    }
                    case -6: {
                        DBAttributeMapper.this.logWarning(classname, "setHelperValue(ColumnInfo c, Object val)", "Warning: Attempt to set value for column: " + c.getName() + " which is of unsupported type TINYINT.");
                        break;
                    }
                    case 93: {
                        args[0] = Timestamp.valueOf((String)val);
                        params[0] = Timestamp.class;
                        break;
                    }
                    case 2003: {
                        DBAttributeMapper.this.logWarning(classname, "setHelperValue(ColumnInfo c, Object val)", "Warning: Attempt to set value for column: " + c.getName() + " which is of unsupported type ARRAY.");
                        break;
                    }
                    case 2005: {
                        DBAttributeMapper.this.logWarning(classname, "setHelperValue(ColumnInfo c, Object val)", "Warning: Attempt to set value for column: " + c.getName() + " which is of unsupported type CLOB.");
                        break;
                    }
                    case 2004: {
                        DBAttributeMapper.this.logWarning(classname, "setHelperValue(ColumnInfo c, Object val)", "Warning: Attempt to set value for column: " + c.getName() + " which is of unsupported type BLOB.");
                        break;
                    }
                    case -7: {
                        DBAttributeMapper.this.logWarning(classname, "setHelperValue(ColumnInfo c, Object val)", "Warning: Attempt to set value for column: " + c.getName() + " which is of unsupported type BIT.");
                        break;
                    }
                    case -4: 
                    case -3: 
                    case -2: {
                        break;
                    }
                    case 70: {
                        DBAttributeMapper.this.logWarning(classname, "setHelperValue(ColumnInfo c, Object val)", "Warning: Attempt to set value for column: " + c.getName() + " which is of unsupported type DATALINK.");
                        break;
                    }
                    case 91: 
                    case 92: {
                        args[0] = val;
                        break;
                    }
                    case -5: {
                        if (val instanceof BigInteger) {
                            args[0] = new BigInteger((String)val);
                            params[0] = BigInteger.class;
                            break;
                        }
                        if (val instanceof Long) {
                            args[0] = new Long((String)val);
                            params[0] = Long.TYPE;
                            break;
                        }
                        if (val instanceof String) {
                            args[0] = new Long((String)val);
                            params[0] = Long.TYPE;
                            break;
                        }
                        DBAttributeMapper.this.logWarning(classname, methodname, "Unable to convert " + val.getClass() + " to a Java long.");
                        break;
                    }
                    default: {
                        DBAttributeMapper.this.logWarning(classname, methodname, "Warning: Attempt to set value for column: " + c.getName() + " which is of an unknown type: " + c.getDataType());
                    }
                }
                Method method = this.getMethod("set", memberName, c, params);
                method.invoke((Object)this.m_dbHelper, args);
            }
            catch (NoSuchMethodException e) {
                DBAttributeMapper.this.logException(classname, methodname, e, "Could not find set method for column, " + c.getName() + ", and member, " + memberName + " in helper: " + this.m_dbHelper.getClass().getSuperclass().getName());
            }
            catch (InvocationTargetException e) {
                DBAttributeMapper.this.logException(classname, methodname, e, "");
            }
            catch (IllegalAccessException e) {
                DBAttributeMapper.this.logException(classname, methodname, e, "");
            }
            catch (NumberFormatException e) {
                DBAttributeMapper.this.logException(classname, methodname, e, "Number Format exception on " + val + " and field " + c.getName());
            }
        }
    }
}

