/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.mapping.Dedicated;
import org.sblim.wbem.cim.CIMValue;

public class DBTableMapper {
    private static final String DEFAULT_NAMESPACE = "DEFAULT";
    private static Hashtable myDiscoveredMappings = new Hashtable();
    private static Properties myMappings;
    private static Properties myDedicated;

    private DBTableMapper() {
    }

    public static void addDiscoveredMapping(String subClass, String superClass, String namespace) {
        if (subClass != null && superClass != null && namespace != null) {
            Hashtable<String, String> nsMappings = (Hashtable<String, String>)myDiscoveredMappings.get(namespace);
            if (nsMappings == null) {
                nsMappings = new Hashtable<String, String>();
            }
            nsMappings.put(subClass, superClass);
            myDiscoveredMappings.put(namespace, nsMappings);
        }
    }

    public static void addDiscoveredMapping(String subClass, String superClass) {
        DBTableMapper.addDiscoveredMapping(subClass, superClass, DEFAULT_NAMESPACE);
    }

    public static String getLookup(String name, Hashtable params) {
        String mapping = null;
        while (mapping == null && name != null) {
            mapping = (String)myMappings.get(name);
            if (mapping != null && mapping.equals("***")) {
                name = DBTableMapper.generateComplexName(name, params);
                mapping = null;
                continue;
            }
            name = (String)myDiscoveredMappings.get(name);
        }
        return mapping;
    }

    public static String getLookup(String name, String dedicated) {
        return DBTableMapper.getLookup(name, dedicated, DEFAULT_NAMESPACE);
    }

    public static String getLookup(String name, String dedicated, String namespace) {
        Hashtable mappings = (Hashtable)myDiscoveredMappings.get(namespace);
        String mapping = null;
        if (mappings != null && (mapping = (String)mappings.get(name)) == null && (mapping = (String)myMappings.get(name)) != null && mapping.equals("***")) {
            name = name + ":" + dedicated;
            mapping = (String)myMappings.get(name);
        }
        return mapping;
    }

    public static String getObjectParentName(String name) {
        return myMappings.getProperty(name);
    }

    private static String generateComplexName(String name, String dedicated) {
        Hashtable<String, String> params = new Hashtable<String, String>();
        if (dedicated != null) {
            params.put("Dedicated", dedicated);
            return DBTableMapper.generateComplexName(name, params);
        }
        return null;
    }

    private static String generateComplexName(String name, Hashtable params) {
        String[] value = null;
        String mapping = null;
        Object dedicated = params.get("Dedicated");
        if (dedicated != null) {
            if (dedicated instanceof String) {
                mapping = name + ":" + dedicated;
            } else {
                if (dedicated instanceof CIMValue) {
                    CIMValue cimValue = (CIMValue)dedicated;
                    if (cimValue.isArrayValue()) {
                        ArrayList<String> values = new ArrayList<String>();
                        Vector v = (Vector)cimValue.getValue();
                        for (int i = 0; i < cimValue.getSize(); ++i) {
                            values.add(v.elementAt(i).toString());
                        }
                        value = values.toArray(new String[0]);
                    } else {
                        value = new String[]{cimValue.toString()};
                    }
                } else if (dedicated instanceof Vector) {
                    value = ((Vector)dedicated).toArray(new String[0]);
                } else if (dedicated instanceof ArrayList) {
                    value = ((ArrayList)dedicated).toArray(new String[0]);
                } else {
                    try {
                        value = (String[])dedicated;
                    }
                    catch (ClassCastException e) {
                        value = new String[]{};
                    }
                }
                mapping = name + ":" + DBTableMapper.normalize(value);
            }
        }
        return mapping;
    }

    private static String normalize(String[] parameters) {
        StringBuffer response = new StringBuffer();
        if (parameters.length > 0) {
            response.append(parameters[0]);
        }
        for (int i = 1; i < parameters.length; ++i) {
            response.append(":");
            response.append(parameters[i]);
        }
        return response.toString();
    }

    public static void printHierarchy() {
        System.out.println("Known Class Hierarchy Mappings: ");
        for (String string : myMappings.keySet()) {
            System.out.println("\t" + string + " -> " + myMappings.get(string));
        }
        System.out.println("Discovered Class Hierarchy Mappings: ");
        for (String string : myDiscoveredMappings.keySet()) {
            System.out.println("\tNamespace: " + string);
            Hashtable nsMap = (Hashtable)myDiscoveredMappings.get(string);
            for (String key : nsMap.keySet()) {
                System.out.println("\t\t" + key + " -> " + nsMap.get(key));
            }
        }
    }

    static {
        myDedicated = new Properties();
        myDedicated.putAll((Map<?, ?>)Dedicated.getMap());
        myMappings = new Properties();
        myMappings.put("Class", "CIMClass");
        myMappings.put("ClassAssociation", "CIMClass");
        myMappings.put("CIM_AllocatedFromStoragePool", "Volume");
        myMappings.put("CIM_AdminDomain", "Fabric");
        myMappings.put("CIM_ContainedDomain", "Fabric");
        myMappings.put("CIM_DeviceSAPImplementation", "Port");
        myMappings.put("CIM_FCPort", "Port");
        myMappings.put("CIM_HostedStoragePool", "Pool");
        myMappings.put("CIM_ProtocolEndPoint", "ProtocolEndpoint");
        myMappings.put("CIM_StorageVolume", "Volume");
        myMappings.put("CIM_StoragePool", "Pool");
        myMappings.put("CIM_SystemDevice", "Port");
        myMappings.put("CIM_ComputerSystem", "***");
        myMappings.put("Brocade_SwitchFCPort", "CIM_FCPort");
        myMappings.put("CIM_ComputerSystem:" + Dedicated.getValue(Dedicated.STORAGE) + ":" + Dedicated.getValue(Dedicated.BLOCK_SERVER), "StorageSubsystem");
        myMappings.put("CIM_ComputerSystem:" + Dedicated.getValue(Dedicated.SWITCH), "Switch");
    }
}

