/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.objects.Switch;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.MapperInfo;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;

public class InterconnectElementXmlToDBMapper
extends DBAttributeMapper {
    private static final String STATE = "State";
    private static final String CONSTATE = "conState";
    private static final String SERIALNUMBER = "Serial Number";
    private static final String DESCRIPTION = "Description";
    private static final String CONTACT = "Contact";
    private static final String LOCATION = "Location";
    private static final String IPADDRESS = "IP Address";
    private static final String DOMAIN = "Domain";
    private static final String MGMTID = "Management ID";
    private static final String MGMTTELNETADDR = "Management Telnet Address";
    private static final String MGMTSNMPADDR = "Management Snmp Address";
    private static final String MGMTURLADDR = "Management URL Address";
    private static final String RELEASECODE = "Release Code";
    private static final String VENDORID = "Vendor ID";
    private static final String MODEL = "Model";
    private static final String LOGICALNAME = "Logical Name";
    private static final String NAME = "Name";
    private static Hashtable switchSNIAtoSMIS = new Hashtable();

    public static DBAttributeMapper.RegistrationData[] getRegistrationData() {
        String mCIMClass = "InterconnectElementXml";
        String mSMIS = null;
        String mDeviceType = null;
        String mAgentVersion = null;
        DBAttributeMapper.RegistrationData mR1 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion);
        return new DBAttributeMapper.RegistrationData[]{mR1};
    }

    public InterconnectElementXmlToDBMapper() {
        this.m_dataConverter.addComplexDataConversion("UniqueIdXml", ":", 2);
        this.m_htAttribToMapperInfo.put(SERIALNUMBER.toLowerCase(), new MapperInfo(Switch.getColumnInfo("SERIAL_NUMBER")));
        this.m_htAttribToMapperInfo.put(DESCRIPTION.toLowerCase(), new MapperInfo(Switch.getColumnInfo("DESCRIPTION")));
        this.m_htAttribToMapperInfo.put(CONTACT.toLowerCase(), new MapperInfo(Switch.getColumnInfo("CONTACT")));
        this.m_htAttribToMapperInfo.put(LOCATION.toLowerCase(), new MapperInfo(Switch.getColumnInfo("LOCATION")));
        this.m_htAttribToMapperInfo.put(IPADDRESS.toLowerCase(), new MapperInfo(Switch.getColumnInfo("IP_ADDRESS")));
        this.m_htAttribToMapperInfo.put(NAME.toLowerCase(), new MapperInfo(Switch.getColumnInfo("LOGICAL_NAME")));
        this.m_htAttribToMapperInfo.put(LOGICALNAME.toLowerCase(), new MapperInfo(Switch.getColumnInfo("LOGICAL_NAME")));
        this.m_htAttribToMapperInfo.put(DOMAIN.toLowerCase(), new MapperInfo(Switch.getColumnInfo("DOMAIN")));
        this.m_htAttribToMapperInfo.put(MGMTID.toLowerCase(), new MapperInfo(Switch.getColumnInfo("MANAGEMENT_ID")));
        this.m_htAttribToMapperInfo.put(MGMTTELNETADDR.toLowerCase(), new MapperInfo(Switch.getColumnInfo("MGMT_TEL_ADDR")));
        this.m_htAttribToMapperInfo.put(MGMTSNMPADDR.toLowerCase(), new MapperInfo(Switch.getColumnInfo("MGMT_SNMP_ADDR")));
        this.m_htAttribToMapperInfo.put(MGMTURLADDR.toLowerCase(), new MapperInfo(Switch.getColumnInfo("MGMT_URL_ADDR")));
        this.m_htAttribToMapperInfo.put(STATE.toLowerCase(), new MapperInfo(Switch.getColumnInfo("OPERATIONAL_STATUS")));
        this.m_htAttribToMapperInfo.put(CONSTATE.toLowerCase(), new MapperInfo(Switch.getColumnInfo("CONSOLIDATED_STATUS")));
        this.m_htAttribToMapperInfo.put(RELEASECODE.toLowerCase(), new MapperInfo(Switch.getColumnInfo("VERSION")));
        ColumnInfo wwnColInfo = Switch.getColumnInfo("SWITCH_WWN");
        wwnColInfo.setIsPrimaryKey();
        MapperInfo wwnMapperInfo = new MapperInfo(wwnColInfo);
        ColumnInfo switchId = Switch.getColumnInfo("SWITCH_ID");
        switchId.setAutoGenerated();
        wwnMapperInfo.setDerivedColumn(switchId);
        this.m_htAttribToMapperInfo.put("UniqueIdXml".toLowerCase(), wwnMapperInfo);
        this.m_htAttribToMapperInfo.put(VENDORID.toLowerCase(), new MapperInfo(Switch.getColumnInfo("VENDOR_ID")));
        this.m_htAttribToMapperInfo.put(MODEL.toLowerCase(), new MapperInfo(Switch.getColumnInfo("MODEL_ID")));
    }

    public MapperResult persist(DBConnection conn, Hashtable htValues, String scanID) throws SQLException {
        String methodName = "persist(DBConnection conn, Hashtable htValues, String scanID)";
        this.logEntry(this.myClassname, methodName, new Object[]{conn, htValues, scanID});
        String sniaVal = (String)htValues.get(STATE);
        if (sniaVal != null) {
            String[] smisValArr = this.convertSNIAOPStatToBitArrValue(sniaVal, switchSNIAtoSMIS);
            htValues.put(STATE, smisValArr[0]);
            Vector<String> vOpStat = new Vector<String>();
            vOpStat.add(smisValArr[1]);
            String conState = DBConstants.convertOperationalstatusArrayToConsolidatedValue(vOpStat);
            if (conState != null) {
                htValues.put(CONSTATE, conState);
            }
        }
        MapperResult mr = super.persist(conn, htValues, scanID);
        this.logExit(this.myClassname, methodName, mr);
        return mr;
    }

    static {
        switchSNIAtoSMIS.put(new String("up"), new Integer(2));
        switchSNIAtoSMIS.put(new String("down"), new Integer(10));
        switchSNIAtoSMIS.put(new String("testing"), new Integer(11));
        switchSNIAtoSMIS.put(new String("unknown"), new Integer(0));
        switchSNIAtoSMIS.put(new String("dormant"), new Integer(10));
        switchSNIAtoSMIS.put(new String("notpresent"), new Integer(6));
        switchSNIAtoSMIS.put(new String("lowerlayerdown"), new Integer(6));
        switchSNIAtoSMIS.put(new String("online"), new Integer(2));
        switchSNIAtoSMIS.put(new String("offline"), new Integer(10));
        switchSNIAtoSMIS.put(new String("faulty"), new Integer(2));
        switchSNIAtoSMIS.put(new String("failed"), new Integer(6));
        switchSNIAtoSMIS.put(new String("bypassed"), new Integer(10));
        switchSNIAtoSMIS.put(new String("reserved"), new Integer(10));
        switchSNIAtoSMIS.put(new String("diagnostics"), new Integer(10));
        switchSNIAtoSMIS.put(new String("portoperdown"), new Integer(10));
        switchSNIAtoSMIS.put(new String("ok"), new Integer(2));
        switchSNIAtoSMIS.put(new String("disabled"), new Integer(10));
        switchSNIAtoSMIS.put(new String("okbutdiagfailed"), new Integer(3));
        switchSNIAtoSMIS.put(new String("boot"), new Integer(8));
        switchSNIAtoSMIS.put(new String("selftest"), new Integer(11));
        switchSNIAtoSMIS.put(new String("missing"), new Integer(13));
        switchSNIAtoSMIS.put(new String("mismatchwithparent"), new Integer(6));
        switchSNIAtoSMIS.put(new String("mismatchconfig"), new Integer(6));
        switchSNIAtoSMIS.put(new String("diagfailed"), new Integer(6));
        switchSNIAtoSMIS.put(new String("dormant"), new Integer(10));
        switchSNIAtoSMIS.put(new String("outofserviceadmin"), new Integer(1));
        switchSNIAtoSMIS.put(new String("outofserviceenvtemp"), new Integer(11));
        switchSNIAtoSMIS.put(new String("powereddown"), new Integer(10));
        switchSNIAtoSMIS.put(new String("poweredup"), new Integer(8));
        switchSNIAtoSMIS.put(new String("powerdenied"), new Integer(6));
        switchSNIAtoSMIS.put(new String("powercycled"), new Integer(8));
    }
}

