/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConstants;

public class MapperResult {
    Hashtable m_insertedRows = new Hashtable();
    Hashtable m_updatedRows = new Hashtable();
    Hashtable m_allNonModifiedRows = new Hashtable();
    Hashtable m_keyReferences = new Hashtable();

    public MapperResult addMapperResult(MapperResult aMapperResult) {
        this.m_insertedRows.putAll(aMapperResult.m_insertedRows);
        this.m_updatedRows.putAll(aMapperResult.m_updatedRows);
        this.m_allNonModifiedRows.putAll(aMapperResult.m_allNonModifiedRows);
        this.m_keyReferences.putAll(aMapperResult.m_keyReferences);
        return this;
    }

    void addInsertedRow(String tableName, Hashtable insertedRow) {
        this.m_insertedRows.put(tableName, insertedRow);
    }

    void addUpdatedRow(String tableName, Hashtable updatedRow) {
        this.m_updatedRows.put(tableName, updatedRow);
    }

    void addNonModifiedRow(String tableName, Hashtable row) {
        this.m_allNonModifiedRows.put(tableName, row);
    }

    void addKeyReference(String paramKey, ColumnInfo column) {
        Hashtable mColumns = (Hashtable)this.getAllRows().get(column.getTableName());
        String paramValue = (String)mColumns.get(column);
        this.m_keyReferences.put(paramKey, paramValue);
    }

    void addKeyReference(String paramKey, String paramValue) {
        this.m_keyReferences.put(paramKey, paramValue);
    }

    public Hashtable getInsertedRows() {
        return this.m_insertedRows;
    }

    public Hashtable getUpdatedRows() {
        return this.m_updatedRows;
    }

    public Hashtable getModifiedRows() {
        Hashtable mReturn = new Hashtable();
        mReturn.putAll(this.m_insertedRows);
        mReturn.putAll(this.m_updatedRows);
        return mReturn;
    }

    public Hashtable getAllRows() {
        Hashtable mReturn = new Hashtable();
        mReturn.putAll(this.m_insertedRows);
        mReturn.putAll(this.m_updatedRows);
        mReturn.putAll(this.m_allNonModifiedRows);
        return mReturn;
    }

    public Hashtable getKeyReferences() {
        return this.m_keyReferences;
    }

    public int getNoOfRowsAffected() {
        return this.getModifiedRows().size();
    }

    public static Map convertRowsToIdentifiers(Map pRowMap) {
        HashMap<String, String> mResult = new HashMap<String, String>();
        for (Map.Entry mEntry : pRowMap.entrySet()) {
            String mTableName = (String)mEntry.getKey();
            Map mRow = (Map)mEntry.getValue();
            ColumnInfo mIdColumn = DBConstants.getAutoIdColumn(mTableName);
            if (mIdColumn == null) continue;
            String mId = (String)mRow.get(mIdColumn);
            mResult.put(mTableName, mId);
        }
        return mResult;
    }
}

