/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.objects.TapeMediaChanger;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.MapperInfo;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;

public class SMIS11CIM_ChangerDeviceToDBMapper
extends DBAttributeMapper {
    public static final String sDEVICEID = "deviceid";
    public static final String sOPERATIONALSTATUS = "operationalstatus";
    public static final String sCONSOLIDATEDSTATUS = "consolidatedstatus";
    public static final String sELEMENTNAME = "elementname";
    public static final String sMEDIAFLIPSUPPORTED = "mediaflipsupported";
    public static final String sCAPTION = "caption";
    public static final String sDESCRIPTION = "description";
    public static final String sSYSTEMNAME = "systemname";
    public static final String sCREATIONCLASSNAME = "creationclassname";
    public static final String sSYSTEMCREATIONCLASSNAME = "systemcreationclassname";
    public static final String sDISPLAYNAME = "displayname";
    public static final String sFIRMWARE_VERSION = "firmware_version";
    public static final String sNODE_ID = "ref_node_id";
    public static final String sLIBRARYID = "ref_toplevelsystem_id";
    public static final String sLOCATIONID = "ref_tape_location_id";

    public static DBAttributeMapper.RegistrationData[] getRegistrationData() {
        String mCIMClass = "CIM_ChangerDevice";
        String mSMIS = "1.1.0";
        String mDeviceType = "GENERIC_TAPE_LIBRARY";
        String mAgentVersion = null;
        DBAttributeMapper.RegistrationData mR1 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion);
        return new DBAttributeMapper.RegistrationData[]{mR1};
    }

    public SMIS11CIM_ChangerDeviceToDBMapper() {
        ColumnInfo mLibraryIDInfo = TapeMediaChanger.getColumnInfo("TAPE_LIBRARY_ID");
        mLibraryIDInfo.setIsPrimaryKey();
        this.m_htAttribToMapperInfo.put(sLIBRARYID, new MapperInfo(mLibraryIDInfo));
        ColumnInfo mDeviceInfo = TapeMediaChanger.getColumnInfo("DEVICE_ID");
        mDeviceInfo.setIsPrimaryKey();
        MapperInfo mIDMapperInfo = new MapperInfo(mDeviceInfo);
        ColumnInfo mChangerIdColumn = TapeMediaChanger.getColumnInfo("TAPE_MEDIA_CHANGER_ID");
        mChangerIdColumn.setAutoGenerated();
        mIDMapperInfo.setDerivedColumn(mChangerIdColumn);
        this.m_htAttribToMapperInfo.put(sDEVICEID, mIDMapperInfo);
        this.m_htAttribToMapperInfo.put(sCONSOLIDATEDSTATUS, new MapperInfo(TapeMediaChanger.getColumnInfo("CONSOLIDATED_STATUS")));
        this.m_htAttribToMapperInfo.put(sOPERATIONALSTATUS, new MapperInfo(TapeMediaChanger.getColumnInfo("OPERATIONAL_STATUS")));
        this.m_htAttribToMapperInfo.put(sCAPTION, new MapperInfo(TapeMediaChanger.getColumnInfo("CAPTION")));
        this.m_htAttribToMapperInfo.put(sDESCRIPTION, new MapperInfo(TapeMediaChanger.getColumnInfo("DESCRIPTION")));
        this.m_htAttribToMapperInfo.put(sELEMENTNAME, new MapperInfo(TapeMediaChanger.getColumnInfo("ELEMENT_NAME")));
        this.m_htAttribToMapperInfo.put(sCREATIONCLASSNAME, new MapperInfo(TapeMediaChanger.getColumnInfo("CREATION_CLASS_NAME_ID")));
        this.m_htAttribToMapperInfo.put(sSYSTEMCREATIONCLASSNAME, new MapperInfo(TapeMediaChanger.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")));
        this.m_htAttribToMapperInfo.put(sLOCATIONID, new MapperInfo(TapeMediaChanger.getColumnInfo("LOCATION_ID")));
        this.m_htAttribToMapperInfo.put(sSYSTEMNAME, new MapperInfo(TapeMediaChanger.getColumnInfo("SYSTEM_NAMES_ID")));
        this.m_htAttribToMapperInfo.put(sNODE_ID, new MapperInfo(TapeMediaChanger.getColumnInfo("NODE_ID")));
        this.m_htAttribToMapperInfo.put(sDISPLAYNAME, new MapperInfo(TapeMediaChanger.getColumnInfo("DISPLAY_NAME")));
        this.m_htAttribToMapperInfo.put(sFIRMWARE_VERSION, new MapperInfo(TapeMediaChanger.getColumnInfo("FIRMWARE_VERSION")));
        this.m_dataConverter.addSimpleDataConversion(sMEDIAFLIPSUPPORTED, "Boolean");
        this.m_htAttribToMapperInfo.put(sMEDIAFLIPSUPPORTED, new MapperInfo(TapeMediaChanger.getColumnInfo("MEDIA_FLIP_SUPPORTED")));
    }

    public MapperResult persist(DBConnection pConn, Hashtable pParams, String pScanID) throws SQLException {
        String mElementName;
        this.logEntry(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", new Object[]{pConn, pParams, pScanID});
        String mCaption = (String)pParams.get(sCAPTION);
        String mDescription = (String)pParams.get(sDESCRIPTION);
        if ((mDescription == null || mDescription.trim().length() == 0) && mCaption != null) {
            pParams.put(sDESCRIPTION, mCaption);
        }
        if ((mElementName = (String)pParams.get(sELEMENTNAME)) != null && mDescription.trim().length() > 0) {
            pParams.put(sDISPLAYNAME, mElementName);
        } else if (mCaption != null) {
            pParams.put(sELEMENTNAME, mCaption);
            pParams.put(sDISPLAYNAME, mCaption);
        }
        String opstatus = (String)pParams.get(sOPERATIONALSTATUS);
        if (opstatus != null) {
            Vector opArray = SMIS11CIM_ChangerDeviceToDBMapper.processArrayvalues(opstatus);
            if ((opstatus = DBConstants.convertOperationalstatusArrayToBitValue(opArray)) != null) {
                pParams.put(sOPERATIONALSTATUS, opstatus);
            } else {
                pParams.remove(sOPERATIONALSTATUS);
            }
            opstatus = DBConstants.convertOperationalstatusArrayToConsolidatedValue(opArray);
            if (opstatus != null) {
                pParams.put(sCONSOLIDATEDSTATUS, opstatus);
            }
        }
        if (pParams.get(sNODE_ID) == null) {
            pParams.put(sNODE_ID, "0");
        }
        MapperResult mSMLResult = super.persist(pConn, pParams, pScanID);
        mSMLResult.addKeyReference("ref_device_id", TapeMediaChanger.getColumnInfo("DEVICE_ID"));
        mSMLResult.addKeyReference("ref_system_names_id", TapeMediaChanger.getColumnInfo("SYSTEM_NAMES_ID"));
        this.logExit(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", mSMLResult);
        return mSMLResult;
    }
}

