/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.SQLException;
import java.util.Hashtable;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.Node;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.MapperInfo;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;
import org.eclipse.aperi.infrastructure.mapping.SMIS11CIM_TapeDriveToDBMapper;

public class SMIS11IBMTSSML3584_TapeDriveToDBMapper
extends SMIS11CIM_TapeDriveToDBMapper {
    public static final String sPERMANENTADDRESS = "permanentaddress";
    public static final String sNAME = "name";
    public static final String sNAMEFORMAT = "nameformat";
    public static final String sDISPLAYNAME = "displayname";
    public static final String sDISPLAYICONNAME = "displayiconname";
    public static final String sOPERATIONALSTATUS = "operationalstatus";
    public static final String sDEVICEID = "deviceid";
    public static final String sSYSTEMNAME = "systemname";
    public static final String sNODEID = "ref_node_id";
    public static final String sSCSISUPPORTED = "scsisupported";
    public static final String sPLATFORMTYPE = "platformtype";
    public static final String sRNIDTYPE = "rnidtype";
    public static final String sTAPELIBRARYID = "ref_toplevelsystem_id";

    public static DBAttributeMapper.RegistrationData[] getRegistrationData() {
        String mCIMClass = "IBMTSSML3584_TapeDrive";
        String mSMIS = "1.1.0";
        String mDeviceType = "3584";
        String mAgentVersion = null;
        DBAttributeMapper.RegistrationData mR1 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion);
        return new DBAttributeMapper.RegistrationData[]{mR1};
    }

    public MapperResult persist(DBConnection pConn, Hashtable pParams, String pScanID) throws SQLException {
        String bSCSI;
        this.logEntry(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", new Object[]{pConn, pParams, pScanID});
        String mDeviceID = (String)pParams.get(sDEVICEID);
        String mWWNN = this.extractWWPNFromName(mDeviceID);
        String mDN = this.createDisplayName(mWWNN);
        boolean mCreateNode = true;
        if (pParams.get("SCSI") != null && (bSCSI = (String)pParams.get("SCSI")).equalsIgnoreCase("true")) {
            mDN = mDN + " (SCSI)";
            mCreateNode = false;
            mWWNN = "0000000000000000";
        }
        pParams.put(sDISPLAYNAME, mDN);
        MapperResult mNodeMapperResult = null;
        NodeMapper mNodeMapper = new NodeMapper();
        Hashtable<String, String> mNodeHT = new Hashtable<String, String>();
        mNodeHT.put(sPERMANENTADDRESS, mWWNN);
        mNodeHT.put(sDISPLAYNAME, mDN);
        mNodeHT.put(sTAPELIBRARYID, (String)pParams.get(sTAPELIBRARYID));
        mNodeMapperResult = mNodeMapper.persist(pConn, mNodeHT, pScanID);
        Hashtable mNodeResultHT = mNodeMapperResult.getKeyReferences();
        String mNodeID = (String)mNodeResultHT.get(sNODEID);
        pParams.put(sNODEID, mNodeID);
        MapperResult mLibraryResult = super.persist(pConn, pParams, pScanID);
        mLibraryResult.addMapperResult(mNodeMapperResult);
        this.logExit(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", mLibraryResult);
        return mLibraryResult;
    }

    private String createDisplayName(String pWWNN) {
        if (pWWNN != null && pWWNN.length() > 0) {
            int bLength = pWWNN.length();
            pWWNN = pWWNN.substring(7, bLength);
            return pWWNN;
        }
        return "";
    }

    private String extractWWPNFromName(String pUniqueID) {
        if (pUniqueID != null && pUniqueID.length() > 0) {
            String bWWPN = pUniqueID.substring(pUniqueID.indexOf(":") + 1, pUniqueID.length());
            bWWPN = bWWPN.replaceAll(" ", "");
            return bWWPN;
        }
        return "";
    }

    private class NodeMapper
    extends DBAttributeMapper {
        public NodeMapper() {
            ColumnInfo mNameFormatInfo = Node.getColumnInfo("NAME_FORMAT");
            mNameFormatInfo.setIsPrimaryKey();
            this.m_dataConverter.addSimpleDataConversion(SMIS11IBMTSSML3584_TapeDriveToDBMapper.sNAMEFORMAT, "Name_Format");
            this.m_htAttribToMapperInfo.put(SMIS11IBMTSSML3584_TapeDriveToDBMapper.sNAMEFORMAT, new MapperInfo(mNameFormatInfo));
            this.m_htAttribToMapperInfo.put(SMIS11IBMTSSML3584_TapeDriveToDBMapper.sDISPLAYNAME, new MapperInfo(Node.getColumnInfo("DISPLAY_NAME")));
            this.m_htAttribToMapperInfo.put(SMIS11IBMTSSML3584_TapeDriveToDBMapper.sDISPLAYICONNAME, new MapperInfo(Node.getColumnInfo("DISPLAY_ICON_TYPE")));
            this.m_htAttribToMapperInfo.put(SMIS11IBMTSSML3584_TapeDriveToDBMapper.sOPERATIONALSTATUS, new MapperInfo(Node.getColumnInfo("OPERATIONAL_STATUS")));
            this.m_htAttribToMapperInfo.put("CONSOLIDATED_STATUS".toLowerCase(), new MapperInfo(Node.getColumnInfo("CONSOLIDATED_STATUS")));
            this.m_htAttribToMapperInfo.put(SMIS11IBMTSSML3584_TapeDriveToDBMapper.sTAPELIBRARYID, new MapperInfo(Node.getColumnInfo("TAPE_LIBRARY_ID")));
            ColumnInfo mNameColumn = Node.getColumnInfo("NAME");
            mNameColumn.setIsPrimaryKey();
            MapperInfo mNameMapperInfo = new MapperInfo(mNameColumn);
            ColumnInfo mNodeIdColumn = Node.getColumnInfo("NODE_ID");
            mNodeIdColumn.setAutoGenerated();
            mNameMapperInfo.setDerivedColumn(mNodeIdColumn);
            this.m_htAttribToMapperInfo.put(SMIS11IBMTSSML3584_TapeDriveToDBMapper.sPERMANENTADDRESS, mNameMapperInfo);
        }

        public MapperResult persist(DBConnection pConn, Hashtable pParams, String pScanID) throws SQLException {
            String nameFormat;
            String rnidType;
            String platformType;
            this.logEntry(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", new Object[]{pConn, pParams, pScanID});
            String scsiSupported = (String)pParams.get(SMIS11IBMTSSML3584_TapeDriveToDBMapper.sSCSISUPPORTED);
            if (scsiSupported == null) {
                pParams.put(SMIS11IBMTSSML3584_TapeDriveToDBMapper.sSCSISUPPORTED, "1");
            }
            if ((platformType = (String)pParams.get(SMIS11IBMTSSML3584_TapeDriveToDBMapper.sPLATFORMTYPE)) == null) {
                pParams.put(SMIS11IBMTSSML3584_TapeDriveToDBMapper.sPLATFORMTYPE, "1");
            }
            if ((rnidType = (String)pParams.get(SMIS11IBMTSSML3584_TapeDriveToDBMapper.sRNIDTYPE)) == null) {
                pParams.put(SMIS11IBMTSSML3584_TapeDriveToDBMapper.sRNIDTYPE, "1");
            }
            if ((nameFormat = (String)pParams.get(SMIS11IBMTSSML3584_TapeDriveToDBMapper.sNAMEFORMAT)) == null) {
                pParams.put(SMIS11IBMTSSML3584_TapeDriveToDBMapper.sNAMEFORMAT, "FC_WWN");
            }
            MapperResult mNodeMapperResult = super.persist(pConn, pParams, pScanID);
            mNodeMapperResult.addKeyReference(SMIS11IBMTSSML3584_TapeDriveToDBMapper.sNODEID, Node.getColumnInfo("NODE_ID"));
            this.logExit(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", mNodeMapperResult);
            return mNodeMapperResult;
        }
    }
}

