/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.TapeLibrary;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.Dedicated;
import org.eclipse.aperi.infrastructure.mapping.MapperInfo;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;
import org.eclipse.aperi.infrastructure.mapping.SMIS11CIM_TapeLibraryToDBMapper;

public class SMIS11IBMTSSML3584_TapeLibraryToDBMapper
extends SMIS11CIM_TapeLibraryToDBMapper {
    public static final String sDISPLAYNAME_SPECIALISED = "displaynamespecsialised";

    public static DBAttributeMapper.RegistrationData[] getRegistrationData() {
        String mCIMClass = "IBMTSSML3584_TapeLibrary";
        String mSMIS = "1.1.0";
        String mDeviceType = null;
        String mAgentVersion = null;
        String mDedicated = Dedicated.getValue(Dedicated.MEDIA_LIBRARY);
        DBAttributeMapper.RegistrationData mR1 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion, mDedicated);
        return new DBAttributeMapper.RegistrationData[]{mR1};
    }

    public SMIS11IBMTSSML3584_TapeLibraryToDBMapper() {
        this.m_htAttribToMapperInfo.remove("displayname");
        this.m_htAttribToMapperInfo.put(sDISPLAYNAME_SPECIALISED, new MapperInfo(TapeLibrary.getColumnInfo("DISPLAY_NAME")));
    }

    public String toString() {
        return this.getClass().toString();
    }

    public MapperResult persist(DBConnection pConn, Hashtable pParams, String pScanID) throws SQLException {
        this.logEntry(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", new Object[]{pConn, pParams, pScanID});
        String mName = (String)pParams.get("name");
        if (mName != null) {
            pParams.put(sDISPLAYNAME_SPECIALISED, this.createDisplayName(mName));
        }
        MapperResult mLibraryResult = super.persist(pConn, pParams, pScanID);
        this.logExit(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", mLibraryResult);
        return mLibraryResult;
    }

    private String createDisplayName(String pUniqueID) {
        if (pUniqueID != null && pUniqueID.length() > 0) {
            StringTokenizer bTokenizer = new StringTokenizer(pUniqueID);
            try {
                bTokenizer.nextToken();
                bTokenizer.nextToken();
                String bSN = bTokenizer.nextToken().trim();
                if (bSN.indexOf("+") == 0) {
                    bSN = bSN.substring(1);
                }
                return "Tape-3584-" + bSN + "-IBM";
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "";
    }
}

